/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.QueryInterpretor;
import irc.QueryListener;
import irc.ReplyServerListener;
import java.util.Locale;

public class Query
extends IRCSource
implements ReplyServerListener {
    private String _nick;
    private String _whois;
    private ListenerGroup _listeners;

    public Query(IRCConfiguration iRCConfiguration, String string, IRCServer iRCServer) {
        super(iRCConfiguration, iRCServer);
        iRCServer.addReplyServerListener(this);
        this._listeners = new ListenerGroup();
        this._nick = string;
        this._whois = "";
        if (this._ircConfiguration.getASLMaster()) {
            this.getIRCServer().execute("WHOIS " + this._nick);
        }
        this.setInterpretor(new QueryInterpretor(iRCConfiguration));
    }

    @Override
    public void release() {
        ((IRCServer)this._server).removeReplyServerListener(this);
        super.release();
    }

    public void addQueryListener(QueryListener queryListener) {
        this._listeners.addListener(queryListener);
    }

    public void removeQueryListeners(QueryListener queryListener) {
        this._listeners.removeListener(queryListener);
    }

    @Override
    public String getType() {
        return "Query";
    }

    @Override
    public String getName() {
        return this._nick;
    }

    public String getWhois() {
        return this._whois;
    }

    @Override
    public boolean talkable() {
        return true;
    }

    @Override
    public void leave() {
        this.getIRCServer().leaveQuery(this.getName());
    }

    public void changeNick(String string) {
        this._nick = string;
        this._listeners.sendEvent("nickChanged", string, this);
    }

    @Override
    public Boolean replyReceived(String string, String string2, String[] stringArray, IRCServer iRCServer) {
        if (string2.equals("311") && stringArray[1].toLowerCase(Locale.ENGLISH).equals(this._nick.toLowerCase(Locale.ENGLISH))) {
            String string3;
            this._whois = string3 = stringArray[stringArray.length - 1];
            this._listeners.sendEvent("whoisChanged", this._whois, this);
        }
        return Boolean.FALSE;
    }
}

