/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.ReplyServerListener;
import irc.StatusInterpretor;
import irc.StatusListener;

public class Status
extends IRCSource
implements ReplyServerListener {
    private ListenerGroup _listeners;

    public Status(IRCConfiguration iRCConfiguration, IRCServer iRCServer) {
        super(iRCConfiguration, iRCServer);
        iRCServer.addReplyServerListener(this);
        this._listeners = new ListenerGroup();
        this.setInterpretor(new StatusInterpretor(iRCConfiguration));
    }

    @Override
    public void release() {
        ((IRCServer)this._server).removeReplyServerListener(this);
        super.release();
    }

    @Override
    public String getType() {
        return "Status";
    }

    @Override
    public String getName() {
        return this.getServerName();
    }

    public String getServerName() {
        return this.getIRCServer().getServerName();
    }

    @Override
    public boolean talkable() {
        return false;
    }

    @Override
    public void leave() {
        if (!this._ircConfiguration.getB("multiserver")) {
            return;
        }
        this.getIRCServer().leaveStatus(this.getName());
    }

    public String getNick() {
        return this._server.getNick();
    }

    public String getMode() {
        return this.getIRCServer().getMode();
    }

    public void addStatusListener(StatusListener statusListener) {
        this._listeners.addListener(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this._listeners.removeListener(statusListener);
    }

    public void nickChanged(String string) {
        this._listeners.sendEvent("nickChanged", string, this);
    }

    public void modeChanged(String string) {
        this._listeners.sendEvent("modeChanged", string, this);
    }

    public void invited(String string, String string2) {
        this._listeners.sendEvent("invited", string, string2, this);
    }

    @Override
    public Boolean replyReceived(String string, String string2, String[] stringArray, IRCServer iRCServer) {
        int n;
        if (string2.equals("322")) {
            return Boolean.FALSE;
        }
        if (this._ircConfiguration.getB("useinfo") && (n = new Integer(string2).intValue()) >= 300 && n != 372) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }
}

