/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.common;

import irc.EventDispatcher;
import irc.ListenerGroup;
import irc.gui.common.DockablePanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DockablePanel
extends JPanel
implements WindowListener,
Runnable {
    private static final long serialVersionUID = -6724784129208410791L;
    private Component _comp;
    private boolean _docked;
    private JFrame _frame;
    private int _behaviour;
    private ListenerGroup _listeners;
    public static final int DOCK_ON_CLOSE = 0;
    public static final int DO_NOTHING_ON_CLOSE = 1;

    public DockablePanel(Component component, Color color) {
        this.setBackground(color);
        this.setLayout(new BorderLayout());
        this._comp = component;
        this._docked = true;
        this.add(this._comp, "Center");
        this.validate();
        this._frame = new JFrame();
        this._frame.setLayout(new BorderLayout());
        this._frame.addWindowListener(this);
        this._behaviour = 0;
        this._listeners = new ListenerGroup();
    }

    public void addDockablePanelListener(DockablePanelListener dockablePanelListener) {
        this._listeners.addListener(dockablePanelListener);
    }

    public void removeDockablePanelListener(DockablePanelListener dockablePanelListener) {
        this._listeners.removeListener(dockablePanelListener);
    }

    public void setClosingBehaviour(int n) {
        this._behaviour = n;
    }

    public int getClosingBehaviour() {
        return this._behaviour;
    }

    public Component getComponent() {
        return this._comp;
    }

    public void undock(String string) {
        if (this._comp == null) {
            return;
        }
        if (!this._docked) {
            return;
        }
        this._docked = false;
        this._comp.setVisible(true);
        this.remove(this._comp);
        this.validate();
        this._frame.add(this._comp, "Center");
        this._frame.pack();
        this._frame.setTitle(string);
        this._frame.setVisible(true);
    }

    public void dock() {
        if (this._comp == null) {
            return;
        }
        if (this._docked) {
            return;
        }
        this._docked = true;
        this._comp.setVisible(false);
        this._frame.setVisible(false);
        this._frame.remove(this._comp);
        this.add(this._comp, "Center");
        this._comp.setVisible(this.isVisible());
        this.validate();
    }

    public boolean isDocked() {
        return this._docked;
    }

    public void bring() {
        this._frame.toFront();
    }

    @Override
    public void run() {
        if (this._frame != null) {
            this._frame.dispose();
        }
        this._frame = null;
    }

    public void release() {
        if (this._frame == null) {
            return;
        }
        this.dock();
        this._frame.removeAll();
        this.removeAll();
        this._frame.removeWindowListener(this);
        Thread thread = new Thread((Runnable)this, "Frame disposal thread");
        thread.start();
        this._comp = null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this._comp == null) {
            return;
        }
        if (this._docked) {
            this._comp.setVisible(bl);
        }
        super.setVisible(bl);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this._listeners.sendEventAsync("DockablePanelWindowClosed", this);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this._listeners.sendEventAsync("DockablePanelWindowClosing", this);
        if (this._behaviour == 0) {
            EventDispatcher.dispatchEventAsync(this, "dock", new Object[0]);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

