/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.dcc.DCCFile;
import irc.dcc.DCCFileListener;
import irc.gui.pixx.AWTProgressBar;
import irc.gui.pixx.PixxConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class AWTDCCFile
implements DCCFileListener,
WindowListener {
    protected DCCFile _file;
    protected JFrame _frame;
    protected AWTProgressBar _bar;
    private PixxConfiguration _pixxConfiguration;

    public AWTDCCFile(PixxConfiguration pixxConfiguration, DCCFile dCCFile) {
        this._pixxConfiguration = pixxConfiguration;
        this._file = dCCFile;
        this._file.addDCCFileListener(this);
        String string = "";
        string = dCCFile.isDownloading() ? this._pixxConfiguration.getText(34574, this._file.getSize() + "") : this._pixxConfiguration.getText(34575, this._file.getSize() + "");
        JLabel jLabel = new JLabel(string);
        this._frame = new JFrame();
        this._frame.setBackground(Color.white);
        this._frame.setLayout(new BorderLayout());
        this._frame.addWindowListener(this);
        this._bar = new AWTProgressBar();
        this._frame.add((Component)jLabel, "North");
        this._frame.add((Component)this._bar, "Center");
        this._frame.setTitle(this._file.getName());
        this._frame.setSize(400, 80);
        this._frame.setVisible(true);
    }

    public void release() {
        this._frame.removeAll();
        this._file.removeDCCFileListener(this);
        this._file = null;
        this._frame.removeWindowListener(this);
        this._frame.dispose();
        this._frame = null;
    }

    public DCCFile getFile() {
        return this._file;
    }

    public void close() {
        this._frame.setVisible(false);
    }

    @Override
    public void transmitted(Integer n, DCCFile dCCFile) {
        int n2 = n;
        if ((n2 & Short.MAX_VALUE) == 0) {
            double d = n2;
            this._bar.setColor(Color.blue);
            this._bar.setValue(d /= (double)this._file.getSize());
            this._bar.repaint();
        }
    }

    @Override
    public void finished(DCCFile dCCFile) {
        this._frame.setTitle(this._pixxConfiguration.getText(34576, this._file.getName()));
        this._bar.setColor(Color.green);
        this._bar.setValue(1.0);
        this._bar.repaint();
    }

    @Override
    public void failed(DCCFile dCCFile) {
        this._frame.setTitle(this._pixxConfiguration.getText(34577, this._file.getName()));
        this._bar.setColor(Color.red);
        this._bar.repaint();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        EventDispatcher.dispatchEventAsync(this._file, "leave", new Object[0]);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

