/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.StyleContext;
import irc.gui.pixx.PixxConfiguration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class AWTStyleSelector
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -5179213192361559478L;
    private PixxConfiguration _pixxConfiguration;
    private StyleContext _ct;
    private int _color;
    private int _backColor;
    private boolean _bold;
    private boolean _underline;

    public AWTStyleSelector(PixxConfiguration pixxConfiguration) {
        this._pixxConfiguration = pixxConfiguration;
        this._color = 1;
        this._backColor = 0;
        this._bold = false;
        this._underline = false;
        this.addMouseListener(this);
        this._ct = this._pixxConfiguration.getIRCConfiguration().getDefaultStyleContext();
    }

    public void release() {
        this.removeMouseListener(this);
        this._pixxConfiguration = null;
    }

    public void setStyleContext(StyleContext styleContext) {
        this._ct = styleContext;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    private void drawSelect(Graphics graphics, int n, int n2) {
        int n3 = (int)((double)n * this.getItemWidth());
        int n4 = (int)((double)n2 * this.getItemHeight());
        int n5 = (int)this.getItemWidth();
        int n6 = (int)this.getItemHeight();
        graphics.setColor(Color.black);
        graphics.drawRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
        graphics.setColor(Color.white);
        graphics.drawRect(n3, n4, n5 - 2, n6 - 2);
    }

    private void drawColor(Graphics graphics, int n, int n2, Color color) {
        int n3 = (int)((double)n * this.getItemWidth());
        int n4 = (int)((double)n2 * this.getItemHeight());
        int n5 = (int)this.getItemWidth();
        int n6 = (int)this.getItemHeight();
        graphics.setColor(color);
        graphics.fillRect(n3, n4, n5, n6);
    }

    private void drawBold(Graphics graphics, int n, int n2) {
        int n3 = (int)((double)n * this.getItemWidth());
        int n4 = (int)((double)n2 * this.getItemHeight());
        int n5 = (int)this.getItemWidth();
        int n6 = (int)this.getItemHeight();
        int n7 = graphics.getFontMetrics().stringWidth("a");
        graphics.drawString("a", n3 + (n5 - n7) / 2, n4 + n6 - (n6 - graphics.getFont().getSize()) / 2 - 2);
        graphics.drawString("a", n3 + (n5 - n7) / 2 + 1, n4 + n6 - (n6 - graphics.getFont().getSize()) / 2 - 2);
    }

    private void drawUnderline(Graphics graphics, int n, int n2) {
        int n3 = (int)((double)n * this.getItemWidth());
        int n4 = (int)((double)n2 * this.getItemHeight());
        int n5 = (int)this.getItemWidth();
        int n6 = (int)this.getItemHeight();
        int n7 = graphics.getFontMetrics().stringWidth("a");
        graphics.drawString("a", n3 + (n5 - n7) / 2, n4 + n6 - (n6 - graphics.getFont().getSize()) / 2 - 2);
        graphics.drawLine(n3 + n5 / 2 - n7 / 2, n4 + n6 - 1, n3 + n5 / 2 + n7 / 2, n4 + n6 - 1);
    }

    @Override
    public void update(Graphics graphics) {
        Graphics graphics2;
        Image image;
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        try {
            image = this.createImage(n, n2);
            graphics2 = image.getGraphics();
        }
        catch (Throwable throwable) {
            return;
        }
        Color[] colorArray = this._pixxConfiguration.getIRCConfiguration().getStyleColors(this._ct);
        int n3 = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 1; j < 9; ++j) {
                this.drawColor(graphics2, j, i, colorArray[n3]);
                if (n3 == this._color) {
                    this.drawSelect(graphics2, j, i);
                }
                ++n3;
            }
        }
        graphics2.setColor(colorArray[this._backColor]);
        graphics2.fillRect(0, 0, (int)this.getItemWidth(), n2);
        graphics2.setColor(colorArray[this._color]);
        this.drawBold(graphics2, 0, 0);
        this.drawUnderline(graphics2, 0, 1);
        if (this._bold) {
            this.drawSelect(graphics2, 0, 0);
        }
        if (this._underline) {
            this.drawSelect(graphics2, 0, 1);
        }
        graphics.drawImage(image, 0, 0, this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(90, 10);
    }

    private double getItemWidth() {
        return (double)this.getSize().width / 9.0;
    }

    private double getItemHeight() {
        return (double)this.getSize().height / 2.0;
    }

    public void setFrontColor(int n) {
        this._color = n;
        this.repaint();
    }

    public void setBackColor(int n) {
        this._backColor = n;
        this.repaint();
    }

    public void setBold(boolean bl) {
        this._bold = bl;
        this.repaint();
    }

    public void setUnderline(boolean bl) {
        this._underline = bl;
        this.repaint();
    }

    public String getPrefix() {
        String string = "";
        if (this._color != 1 || this._backColor != 0) {
            String string2 = "";
            if (this._color != 1) {
                string2 = string2 + this._color;
                if (this._color < 10) {
                    string2 = "0" + string2;
                }
            }
            String string3 = "";
            if (this._backColor != 0) {
                string3 = "" + this._backColor;
                if (this._backColor < 10) {
                    string3 = "0" + string3;
                }
                string3 = "," + string3;
            }
            if (string3.length() > 0 && string2.length() == 0) {
                string2 = "1";
            }
            string = string + '\u0003' + string2 + string3;
        }
        if (this._bold) {
            string = string + '\u0002';
        }
        if (this._underline) {
            string = string + '\u001f';
        }
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = (int)((double)mouseEvent.getX() / this.getItemWidth());
        int n2 = (int)((double)mouseEvent.getY() / this.getItemHeight());
        if (n == 0) {
            if (n2 == 0) {
                boolean bl = this._bold = !this._bold;
            }
            if (n2 == 1) {
                this._underline = !this._underline;
            }
        } else {
            --n;
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                this._color = n + n2 * 8;
            } else {
                this._backColor = n + n2 * 8;
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

