/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import com.limegroup.gnutella.gui.GUIMediator;
import irc.AudioConfiguration;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.Source;
import irc.SourceListener;
import irc.StringParser;
import irc.StyleContext;
import irc.gui.GUISource;
import irc.gui.common.AWTIrcTextField;
import irc.gui.common.MouseWheelPanelListener;
import irc.gui.common.MouseWheelPanelWrapper;
import irc.gui.pixx.AWTStyleSelectorEx;
import irc.gui.pixx.AWTStyleSelectorExListener;
import irc.gui.pixx.BaseAWTSourceListener;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxScrollBar;
import irc.gui.pixx.PixxScrollBarListener;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.PixxVerticalScrollBar;
import irc.style.FormattedStringDrawer;
import irc.style.StyledList;
import irc.style.StyledListListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JPanel;

public class BaseAWTSource
extends JPanel
implements GUISource,
SourceListener,
ActionListener,
PixxScrollBarListener,
FocusListener,
StyledListListener,
WindowListener,
MouseWheelPanelListener,
AWTStyleSelectorExListener {
    private static final long serialVersionUID = 3685469382360871848L;
    protected Source _source;
    protected PixxVerticalScrollBar _scroll;
    protected JPanel _panel;
    protected StyledList _list;
    protected AWTIrcTextField _textField;
    protected FormattedStringDrawer _styler;
    protected String _title;
    protected String _strippedTitle;
    private ListenerGroup _listeners;
    protected PixxConfiguration _pixxConfiguration;
    protected AWTStyleSelectorEx _selector;
    protected boolean _topToBottom;
    private MouseWheelPanelWrapper _wrapper;

    public BaseAWTSource(PixxConfiguration pixxConfiguration, Source source) {
        this(pixxConfiguration, source, false);
    }

    public BaseAWTSource(PixxConfiguration pixxConfiguration, Source source, boolean bl) {
        this._topToBottom = bl;
        this._pixxConfiguration = pixxConfiguration;
        this._listeners = new ListenerGroup();
        this._source = source;
        this.addFocusListener(this);
        this._source.addSourceListener(this);
        this._panel = new JPanel();
        this._panel.addFocusListener(this);
        this._panel.setBackground(Color.white);
        this._scroll = new PixxVerticalScrollBar(this._pixxConfiguration, 0, 0, 0.1);
        this._scroll.addPixxScrollBarListener(this);
        this.setLayout(new BorderLayout());
        IRCConfiguration iRCConfiguration = this._pixxConfiguration.getIRCConfiguration();
        Color color = this._pixxConfiguration.getColor(13);
        Color color2 = this._pixxConfiguration.getColor(14);
        Color color3 = this._pixxConfiguration.getColor(15);
        this._list = new StyledList(iRCConfiguration, true, iRCConfiguration.getStyleContext(source.getType(), source.getName()), color, color2, color3);
        this._list.addFocusListener(this);
        this._list.addStyledListListener(this);
        this._styler = new FormattedStringDrawer(iRCConfiguration, this.getStyleContext());
        this._textField = new AWTIrcTextField();
        boolean bl2 = this._pixxConfiguration.getB("displayentertexthere");
        if (bl2) {
            this._textField.setEnterTextHere(true, "Enter text here...");
        }
        Color[] colorArray = iRCConfiguration.getStyleColors(this.getStyleContext());
        this._textField.setBackground(colorArray[0]);
        this._textField.setForeground(colorArray[1]);
        this._textField.addFocusListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._wrapper = new MouseWheelPanelWrapper(this._panel);
        this._wrapper.addMouseWheelPanelListener(this);
        jPanel.add((Component)this._wrapper, "Center");
        jPanel.add((Component)new PixxSeparator(2), "West");
        jPanel.add((Component)new PixxSeparator(3), "East");
        jPanel.add((Component)new PixxSeparator(0), "North");
        jPanel.add((Component)new PixxSeparator(1), "South");
        this.add((Component)jPanel, "Center");
        this._panel.setLayout(new BorderLayout());
        this._panel.add((Component)this._scroll, "East");
        this._selector = new AWTStyleSelectorEx(this._pixxConfiguration);
        this._selector.setStyleContext(this.getStyleContext());
        this._selector.addAWTStyleSelectorExListener(this);
        if (this._pixxConfiguration.getB("styleselector")) {
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this._textField, "Center");
            jPanel.add((Component)this._selector, "East");
            this.add((Component)jPanel, "South");
        } else {
            this.add((Component)this._textField, "South");
        }
        if (this._topToBottom) {
            this._list.setFirst(0);
        } else {
            this._list.setLast(0);
        }
        this._textField.addActionListener(this);
        this.setTitle(this._source.getName());
        this._panel.add((Component)this._list, "Center");
    }

    public void release() {
        this._wrapper.removeMouseWheelPanelListener(this);
        this._source.removeSourceListener(this);
        this._panel.removeFocusListener(this);
        this._scroll.removePixxScrollBarListener(this);
        this._scroll.release();
        this._list.removeFocusListener(this);
        this._list.removeStyledListListener(this);
        this._textField.removeFocusListener(this);
        this._selector.removeAWTStyleSelectorExListener(this);
        this._selector.release();
        this._textField.removeActionListener(this);
        this._textField.release();
        this._list.release();
        this.removeAll();
    }

    public void setFrontColor(int n) {
        this._selector.getStyleSelector().setFrontColor(n);
    }

    public void setBackColor(int n) {
        this._selector.getStyleSelector().setBackColor(n);
    }

    public void setBold(boolean bl) {
        this._selector.getStyleSelector().setBold(bl);
    }

    public void setUnderline(boolean bl) {
        this._selector.getStyleSelector().setUnderline(bl);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 300);
    }

    @Override
    public void setFieldText(String string) {
        this._textField.setText(string);
        this._textField.setCaretPosition(string.length());
    }

    @Override
    public String getFieldText() {
        return this._textField.getText();
    }

    @Override
    public void validateText() {
        this._textField.validateText();
    }

    public StyleContext getStyleContext() {
        return this._pixxConfiguration.getIRCConfiguration().getStyleContext(this._source.getType(), this._source.getName());
    }

    public String getText(int n) {
        return this._pixxConfiguration.getText(n);
    }

    public String getText(int n, String string) {
        return this._pixxConfiguration.getText(n, string);
    }

    public String getText(int n, String string, String string2) {
        return this._pixxConfiguration.getText(n, string, string2);
    }

    public String getText(int n, String string, String string2, String string3) {
        return this._pixxConfiguration.getText(n, string, string2, string3);
    }

    public void addBaseAWTSourceListener(BaseAWTSourceListener baseAWTSourceListener) {
        this._listeners.addListener(baseAWTSourceListener);
    }

    public void removeBaseAWTSourceListener(BaseAWTSourceListener baseAWTSourceListener) {
        this._listeners.removeListener(baseAWTSourceListener);
    }

    public void setTitle(String string) {
        if (string.equals(this._title)) {
            return;
        }
        this._title = string;
        this._strippedTitle = this._styler.getStripped(string);
        this._listeners.sendEvent("titleChanged", this);
    }

    public String getStrippedTitle() {
        return this._strippedTitle;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    public String getShortTitle() {
        return this._source.getName();
    }

    @Override
    public Source getSource() {
        return this._source;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        EventDispatcher.dispatchEventAsync(this, "actionPerformedEff", new Object[]{actionEvent});
    }

    public void actionPerformedEff(ActionEvent actionEvent) {
        if (this._textField.getText().length() == 0) {
            return;
        }
        String string = "";
        string = this._selector.getPrefix();
        if (!this._textField.getText().startsWith("/")) {
            this._source.sendUserString(string + this._textField.getText());
        } else {
            StringParser stringParser = new StringParser();
            String[] stringArray = stringParser.parseString(StringParser.trim(this._textField.getText()));
            if (stringArray.length >= 2 && stringArray[0].toLowerCase(Locale.ENGLISH).equals("/join")) {
                this._source.sendString("/focus Channel " + stringArray[1]);
            }
            this._source.sendUserString(this._textField.getText());
        }
        if (this._textField != null) {
            this._textField.setText("");
        }
    }

    @Override
    public void fontSelected(Font font) {
        this._list.setFont(font);
    }

    @Override
    public void clear(Source source) {
        this._list.clear();
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._listeners.sendEvent("eventOccured", this);
    }

    protected boolean needHighLight(String string) {
        Object object;
        string = string.toLowerCase(Locale.ENGLISH);
        if (this._pixxConfiguration.highLightNick() && string.indexOf((String)(object = this._source.getServer().getNick().toLowerCase(Locale.ENGLISH))) != -1) {
            return true;
        }
        object = this._pixxConfiguration.getHighLightWords();
        while (object.hasMoreElements()) {
            String string2 = ((String)object.nextElement()).toLowerCase(Locale.ENGLISH);
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    protected void checkSound(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        AudioConfiguration audioConfiguration = this._pixxConfiguration.getIRCConfiguration().getAudioConfiguration();
        Enumeration<String> enumeration = audioConfiguration.getSoundWords();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toLowerCase(Locale.ENGLISH);
            if (string.indexOf(string2) == -1) continue;
            audioConfiguration.onWord(string2);
        }
    }

    protected void print(String string, int n, boolean bl, boolean bl2) {
        if (n != 1) {
            string = "\u0003" + n + string;
        }
        if (bl) {
            string = "\u0002" + string;
        }
        if (bl2) {
            string = '\u001f' + string;
        }
        if (this._pixxConfiguration.getB("timestamp")) {
            String string2;
            Calendar calendar = Calendar.getInstance();
            String string3 = "" + calendar.get(11);
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            if ((string2 = "" + calendar.get(12)).length() == 1) {
                string2 = "0" + string2;
            }
            string = "(" + string3 + ":" + string2 + ") " + string;
        }
        this._list.addLine(string);
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._listeners.sendEvent("eventOccured", this);
    }

    protected void print(String string, int n) {
        this.print(string, n, false, false);
    }

    protected void print(String string) {
        this.print(string, 1, false, false);
    }

    private String formatNick(String string) {
        return " \u00032" + string + " \u0003: ";
    }

    private String formatMyNick(String string) {
        return " \u0002\u00032" + string + " \u0003\u0002: ";
    }

    @Override
    public void messageReceived(String string, String string2, Source source) {
        this.checkSound(string2);
        if (this.needHighLight(string2)) {
            this.print(this.formatNick(string) + string2, this._pixxConfiguration.getI("highlightcolor"));
        } else if (!string.equals(this._source.getServer().getNick())) {
            this.print(this.formatNick(string) + string2);
        } else if (string.equals(this._source.getServer().getNick())) {
            this.print(this.formatMyNick(string) + string2);
        }
    }

    @Override
    public void reportReceived(String string, Source source) {
        this.print(string);
    }

    @Override
    public void noticeReceived(String string, String string2, Source source) {
        if (string.equals("Global")) {
            this.print("  \u0002\u00034Global broadcast message:\u0003\u0002 " + string2);
        } else {
            this.print("      *** Whisper from " + string + ": " + string2, 6);
        }
    }

    @Override
    public void action(String string, String string2, Source source) {
        this.print(" * " + string + " " + string2, 6);
    }

    public void leave() {
        this._source.leave();
    }

    @Override
    public void mouseWheelMoved(Integer n) {
        int n2 = n;
        this._scroll.setValue(this._scroll.getValue() + n2);
        if (this._topToBottom) {
            this._list.setFirst(this._scroll.getValue());
        } else {
            this._list.setLast(this._scroll.getValue());
        }
    }

    @Override
    public void valueChanged(PixxScrollBar pixxScrollBar) {
        if (this._topToBottom) {
            this._list.setFirst(this._scroll.getValue());
        } else {
            this._list.setLast(this._scroll.getValue());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() != this._textField) {
            this._textField.requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void channelEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._pixxConfiguration.matchMouseConfiguration("channeljoin", mouseEvent)) {
            this._source.sendString("/focus Channel " + string);
            this._source.sendString("/join " + string);
        }
    }

    @Override
    public void URLEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        GUIMediator.openURL(string);
        if (this._pixxConfiguration.matchMouseConfiguration("urlopen", mouseEvent)) {
            this._source.sendString("/url " + string);
        }
    }

    @Override
    public void nickEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickquery", mouseEvent)) {
            if (string.equals(this.getSource().getServer().getNick())) {
                return;
            }
            if (this._pixxConfiguration.getB("automaticqueries")) {
                this._source.sendString("/focus Query " + string);
                this._source.sendString("/query " + string);
            }
        }
    }

    @Override
    public String toString() {
        return "AWTSource : " + this.getStrippedTitle();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this._list.dispose();
        }
    }

    @Override
    public void copyEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
    }

    @Override
    public void virtualSizeChanged(StyledList styledList) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        windowEvent.getWindow().setVisible(false);
        windowEvent.getWindow().dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

