/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.gui.pixx.FontSelectorListener;
import irc.gui.pixx.PixxConfiguration;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontSelector
implements WindowListener,
ActionListener,
Runnable {
    private Choice _name;
    private JTextField _size;
    private JButton _ok;
    private JFrame _f = new JFrame();
    private FontSelectorListener _lis;

    public FontSelector(PixxConfiguration pixxConfiguration) {
        this._f.setTitle("Select font");
        this._name = new Choice();
        this._name.add("Monospaced");
        this._name.add("Serif");
        this._name.add("SansSerif");
        this._name.add("Dialog");
        this._name.add("DialogInput");
        this._size = new JTextField("12");
        this._ok = new JButton("OK");
        this._ok.addActionListener(this);
        JPanel jPanel = new JPanel();
        this._f.add(jPanel);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this._name);
        jPanel.add(this._size);
        jPanel.add(this._ok);
        this._f.setSize(200, 80);
        this._f.addWindowListener(this);
    }

    @Override
    public void run() {
        if (this._f != null) {
            this._f.dispose();
        }
        this._f = null;
    }

    public void release() {
        this._ok.removeActionListener(this);
        this._f.removeWindowListener(this);
        this._f.removeAll();
        Thread thread = new Thread((Runnable)this, "Frame disposal thread");
        thread.start();
        this._lis = null;
    }

    public void selectFont(FontSelectorListener fontSelectorListener) {
        this._lis = fontSelectorListener;
        this._f.setVisible(true);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this._f.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private Font getResult() {
        String string = this._name.getSelectedItem();
        int n = 12;
        try {
            n = new Integer(this._size.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Font(string, 0, n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this._f.setVisible(false);
        Font font = this.getResult();
        if (this._lis != null) {
            EventDispatcher.dispatchEventAsync(this._lis, "fontSelected", new Object[]{font});
        }
    }
}

