/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import java.awt.Color;

public class PixxColorModel {
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_WHITE = 1;
    public static final int COLOR_DARK_GRAY = 2;
    public static final int COLOR_GRAY = 3;
    public static final int COLOR_LIGHT_GRAY = 4;
    public static final int COLOR_FRONT = 5;
    public static final int COLOR_BACK = 6;
    public static final int COLOR_SELECTED = 7;
    public static final int COLOR_EVENT = 8;
    public static final int COLOR_CLOSE = 9;
    public static final int COLOR_VOICE = 10;
    public static final int COLOR_OP = 11;
    public static final int COLOR_SEMIOP = 12;
    public static final int COLOR_MALE = 13;
    public static final int COLOR_FEMEALE = 14;
    public static final int COLOR_UNDEF = 15;
    private Color[] _colors;

    public PixxColorModel() {
        Color[] colorArray = new Color[]{new Color(5477077), new Color(0xFFFFFF), new Color(10864361), new Color(12178414), new Color(12178414), new Color(10864361), new Color(12178414), new Color(9484772), new Color(12178414), new Color(12178414), new Color(10864361), new Color(10864361), new Color(10864361), new Color(10864361), new Color(10864361), new Color(10864361)};
        this.init(colorArray);
    }

    public void setColor(int n, Color color) {
        if (n >= 0 && n < this._colors.length) {
            this._colors[n] = color;
        }
    }

    public int getColorCount() {
        return this._colors.length;
    }

    private Color computeColor(int n, int n2, int n3, int n4) {
        n *= n4;
        n2 *= n4;
        n3 *= n4;
        n2 /= 256;
        n3 /= 256;
        if ((n /= 256) > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public PixxColorModel(int n, int n2, int n3) {
        Color[] colorArray = new Color[16];
        colorArray[0] = Color.black;
        colorArray[1] = Color.white;
        colorArray[2] = new Color(0x868686);
        colorArray[3] = Color.gray;
        colorArray[4] = new Color(0xD0D0D0);
        colorArray[8] = new Color(0xA40000);
        colorArray[10] = new Color(32768);
        colorArray[13] = new Color(0x4040FF);
        colorArray[14] = new Color(0xFF40FF);
        colorArray[5] = this.computeColor(n, n2, n3, 102);
        colorArray[6] = this.computeColor(n, n2, n3, 85);
        colorArray[7] = this.computeColor(n, n2, n3, 75);
        colorArray[9] = this.computeColor(n, n2, n3, 128);
        colorArray[11] = this.computeColor(n, n2, n3, 102);
        colorArray[12] = this.computeColor(n, n2, n3, 102);
        colorArray[15] = this.computeColor(n, n2, n3, 102);
        this.init(colorArray);
    }

    public PixxColorModel(Color[] colorArray) {
        this.init(colorArray);
    }

    private void init(Color[] colorArray) {
        this._colors = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            this._colors[i] = colorArray[i];
        }
    }

    public Color getColor(int n) {
        return this._colors[n];
    }
}

