/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import com.frostwire.gui.ChatMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import irc.ChanList;
import irc.Channel;
import irc.DefaultSource;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.Interpretor;
import irc.Query;
import irc.Server;
import irc.Source;
import irc.Status;
import irc.StyleContext;
import irc.dcc.DCCChat;
import irc.dcc.DCCFile;
import irc.gui.GUISource;
import irc.gui.IRCInterface;
import irc.gui.common.DockablePanel;
import irc.gui.common.DockablePanelListener;
import irc.gui.common.MouseWheelPanelListener;
import irc.gui.pixx.AWTChanList;
import irc.gui.pixx.AWTChannel;
import irc.gui.pixx.AWTDCCChat;
import irc.gui.pixx.AWTDCCFile;
import irc.gui.pixx.AWTDefaultSource;
import irc.gui.pixx.AWTInterpretor;
import irc.gui.pixx.AWTQuery;
import irc.gui.pixx.AWTStatus;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.BaseAWTSourceListener;
import irc.gui.pixx.MDILayout;
import irc.gui.pixx.NonFocusableTextField;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxConfigurationLoader;
import irc.gui.pixx.PixxMenuBar;
import irc.gui.pixx.PixxMenuBarListener;
import irc.gui.pixx.PixxPanel;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.PixxTaskBar;
import irc.gui.pixx.PixxTaskBarListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PixxMDIInterface
extends IRCInterface
implements PixxTaskBarListener,
PixxMenuBarListener,
ActionListener,
MouseWheelPanelListener,
BaseAWTSourceListener,
DockablePanelListener {
    private static final Log LOG = LogFactory.getLog(PixxMDIInterface.class);
    private PixxPanel _panel;
    private PixxMenuBar _menu;
    private PixxTaskBar _task;
    private JPanel _mdi;
    private PopupMenu _popMenu;
    private JTextField _nickField;
    private Hashtable<BaseAWTSource, DockablePanel> _awt2Dock;
    private AWTInterpretor _interpretor;
    private PixxConfiguration _pixxConfiguration;
    private Hashtable<Status, AWTStatus> _status;
    private Hashtable<Channel, AWTChannel> _channels;
    private Hashtable<Query, AWTQuery> _queries;
    private Hashtable<DCCChat, AWTDCCChat> _dccChats;
    private Hashtable<DCCFile, AWTDCCFile> _dccFiles;
    private Hashtable<ChanList, AWTChanList> _lists;
    private DefaultSource _defaultSource;
    private AWTDefaultSource _awtDefaultSource;

    public PixxMDIInterface(IRCConfiguration iRCConfiguration) throws Exception {
        super(iRCConfiguration);
    }

    @Override
    public void load() {
        super.load();
        try {
            this._ircConfiguration.setGUIInfoString("Pixx's designed interface");
            this._pixxConfiguration = new PixxConfigurationLoader(this._ircConfiguration).loadPixxConfiguration();
            this._panel = new PixxPanel(this._pixxConfiguration);
            this._defaultSource = null;
            this._task = new PixxTaskBar(this._pixxConfiguration);
            this._interpretor = new AWTInterpretor(this._pixxConfiguration, this);
            this._awt2Dock = new Hashtable();
            this._popMenu = new PopupMenu();
            this._panel.setLayout(new BorderLayout());
            this._mdi = new JPanel();
            this._mdi.setLayout(new MDILayout());
            this._mdi.setBackground(Color.white);
            this._task.add(this._popMenu);
            this._popMenu.addActionListener(this);
            this._task.addPixxTaskBarListener(this);
            this._menu = new PixxMenuBar(this._pixxConfiguration, true);
            this._menu.addPixxMenuBarListener(this);
            this._panel.add((Component)this._menu, "North");
            this._panel.add((Component)this._mdi, "Center");
            this._nickField = new NonFocusableTextField("");
            this._nickField.addActionListener(this);
            this._nickField.setBackground(this._pixxConfiguration.getColor(1));
            if (!this._pixxConfiguration.getB("nickfield")) {
                this._panel.add((Component)this._task, "South");
            } else {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)this._task, "Center");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel("Change nickname to:");
                jLabel.setBackground(this._pixxConfiguration.getColor(6));
                jLabel.setForeground(this._pixxConfiguration.getColor(1));
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new BorderLayout());
                jPanel3.add((Component)jLabel, "Center");
                jPanel3.add((Component)new PixxSeparator(2), "West");
                jPanel3.add((Component)new PixxSeparator(3), "East");
                jPanel3.add((Component)new PixxSeparator(0), "North");
                jPanel3.add((Component)new PixxSeparator(1), "South");
                jPanel2.add((Component)jPanel3, "North");
                jPanel2.add((Component)this._nickField, "Center");
                jPanel.add((Component)jPanel2, "East");
                this._panel.add((Component)jPanel, "South");
            }
            this._channels = new Hashtable();
            this._queries = new Hashtable();
            this._dccChats = new Hashtable();
            this._dccFiles = new Hashtable();
            this._lists = new Hashtable();
            this._status = new Hashtable();
            this._panel.validate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error(exception.getMessage());
        }
    }

    @Override
    public Component getComponent() {
        return this._panel;
    }

    @Override
    public void unload() {
        this.removeAWTDefault();
        this._popMenu.removeActionListener(this);
        this._task.removePixxTaskBarListener(this);
        this._menu.removePixxMenuBarListener(this);
        this._nickField.removeActionListener(this);
        this._task = null;
        this._menu = null;
        this._popMenu = null;
        this._awt2Dock = null;
        this._panel.release();
        this._panel = null;
        this._pixxConfiguration = null;
        super.unload();
    }

    private void addAWTDefault() {
        if (this._defaultSource == null) {
            return;
        }
        if (this._awtDefaultSource == null) {
            this._awtDefaultSource = new AWTDefaultSource(this._pixxConfiguration, this._defaultSource);
            this._task.addDefaultSource(this._awtDefaultSource, true);
        }
    }

    private void removeAWTDefault() {
        if (this._awtDefaultSource == null) {
            return;
        }
        this._task.removeDefaultSource(this._awtDefaultSource);
        this._awtDefaultSource.release();
        this._awtDefaultSource = null;
    }

    private void channelCreated(final Channel channel, final Boolean bl) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                AWTChannel aWTChannel = new AWTChannel(PixxMDIInterface.this._pixxConfiguration, channel);
                aWTChannel.addBaseAWTSourceListener(PixxMDIInterface.this);
                PixxMDIInterface.this._task.addChannel(aWTChannel, bl);
                PixxMDIInterface.this._channels.put(channel, aWTChannel);
            }
        });
    }

    private void channelRemoved(final Channel channel) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                AWTChannel aWTChannel = (AWTChannel)PixxMDIInterface.this._channels.get(channel);
                aWTChannel.removeBaseAWTSourceListener(PixxMDIInterface.this);
                PixxMDIInterface.this._task.removeChannel(aWTChannel);
                PixxMDIInterface.this._channels.remove(channel);
            }
        });
    }

    private void queryCreated(final Query query, final Boolean bl) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                AWTQuery aWTQuery = new AWTQuery(PixxMDIInterface.this._pixxConfiguration, query);
                aWTQuery.addBaseAWTSourceListener(PixxMDIInterface.this);
                PixxMDIInterface.this._task.addQuery(aWTQuery, bl);
                PixxMDIInterface.this._queries.put(query, aWTQuery);
                if (!bl.booleanValue()) {
                    PixxMDIInterface.this._pixxConfiguration.getIRCConfiguration().getAudioConfiguration().onQuery();
                }
            }
        });
    }

    private void queryRemoved(Query query) {
        AWTQuery aWTQuery = this._queries.get(query);
        aWTQuery.removeBaseAWTSourceListener(this);
        this._task.removeQuery(aWTQuery);
        this._queries.remove(query);
    }

    private void statusCreated(final Status status, final Boolean bl) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                AWTStatus aWTStatus = new AWTStatus(PixxMDIInterface.this._pixxConfiguration, status);
                PixxMDIInterface.this._task.addStatus(aWTStatus, bl);
                aWTStatus.addBaseAWTSourceListener(PixxMDIInterface.this);
                PixxMDIInterface.this._status.put(status, aWTStatus);
            }
        });
    }

    private void statusRemoved(Status status) {
        AWTStatus aWTStatus = this._status.get(status);
        aWTStatus.removeBaseAWTSourceListener(this);
        this._task.removeStatus(aWTStatus);
        this._status.remove(status);
    }

    private void chanListCreated(final ChanList chanList, final Boolean bl) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                AWTChanList aWTChanList = new AWTChanList(PixxMDIInterface.this._pixxConfiguration, chanList);
                PixxMDIInterface.this._task.addChanList(aWTChanList, bl);
                aWTChanList.addBaseAWTSourceListener(PixxMDIInterface.this);
                PixxMDIInterface.this._lists.put(chanList, aWTChanList);
            }
        });
    }

    private void chanListRemoved(ChanList chanList) {
        AWTChanList aWTChanList = this._lists.get(chanList);
        aWTChanList.removeBaseAWTSourceListener(this);
        this._task.removeChanList(aWTChanList);
        this._lists.remove(chanList);
    }

    private void DCCChatCreated(final DCCChat dCCChat, final Boolean bl) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                boolean bl2 = bl;
                AWTDCCChat aWTDCCChat = new AWTDCCChat(PixxMDIInterface.this._pixxConfiguration, dCCChat);
                aWTDCCChat.addBaseAWTSourceListener(PixxMDIInterface.this);
                PixxMDIInterface.this._task.addDCCChat(aWTDCCChat, bl2);
                PixxMDIInterface.this._dccChats.put(dCCChat, aWTDCCChat);
            }
        });
    }

    private void DCCChatRemoved(DCCChat dCCChat) {
        AWTDCCChat aWTDCCChat = this._dccChats.get(dCCChat);
        aWTDCCChat.removeBaseAWTSourceListener(this);
        this._task.removeDCCChat(aWTDCCChat);
        this._dccChats.remove(dCCChat);
    }

    public void DCCFileCreated(DCCFile dCCFile, Boolean bl) {
        this._dccFiles.put(dCCFile, new AWTDCCFile(this._pixxConfiguration, dCCFile));
    }

    public void DCCFileRemoved(DCCFile dCCFile) {
        AWTDCCFile aWTDCCFile = this._dccFiles.get(dCCFile);
        this._dccFiles.remove(dCCFile);
        aWTDCCFile.close();
        aWTDCCFile.release();
    }

    @Override
    public void sourceCreated(Source source, Boolean bl) {
        if (source instanceof DefaultSource) {
            this._defaultSource = (DefaultSource)source;
            if (this._pixxConfiguration.getIRCConfiguration().getB("multiserver")) {
                this.addAWTDefault();
            }
        }
        if (source instanceof Channel) {
            this.channelCreated((Channel)source, bl);
        }
        if (source instanceof Query) {
            this.queryCreated((Query)source, bl);
        }
        if (source instanceof Status && this._pixxConfiguration.getB("showstatus")) {
            this.statusCreated((Status)source, bl);
        }
        if (source instanceof ChanList) {
            this.chanListCreated((ChanList)source, bl);
        }
        if (source instanceof DCCChat) {
            this.DCCChatCreated((DCCChat)source, bl);
        }
        if (source instanceof DCCFile) {
            this.DCCFileCreated((DCCFile)source, bl);
        }
    }

    @Override
    public void sourceRemoved(Source source) {
        if (source instanceof DefaultSource) {
            this._defaultSource = null;
            this.removeAWTDefault();
        }
        if (source instanceof Channel) {
            this.channelRemoved((Channel)source);
        }
        if (source instanceof Query) {
            this.queryRemoved((Query)source);
        }
        if (source instanceof Status && this._pixxConfiguration.getB("showstatus")) {
            this.statusRemoved((Status)source);
        }
        if (source instanceof ChanList) {
            this.chanListRemoved((ChanList)source);
        }
        if (source instanceof DCCChat) {
            this.DCCChatRemoved((DCCChat)source);
        }
        if (source instanceof DCCFile) {
            this.DCCFileRemoved((DCCFile)source);
        }
    }

    @Override
    public void serverCreated(Server server) {
    }

    @Override
    public void serverConnected(Server server) {
        this.updateConnect();
    }

    @Override
    public void serverDisconnected(Server server) {
        this.updateConnect();
    }

    @Override
    public void serverRemoved(Server server) {
    }

    public void setTitle(String string, StyleContext styleContext) {
        this._menu.setTitle(string, styleContext);
    }

    public void setConnected(boolean bl) {
        this._menu.setConnected(bl);
    }

    private void test() {
        this.updateConnect();
        if (this._task.getActive() != null) {
            this.setTitle(this._task.getActive().getTitle(), this._task.getActive().getStyleContext());
        } else {
            this.setTitle("", this._pixxConfiguration.getIRCConfiguration().getDefaultStyleContext());
        }
        this.triggerActiveChanged(this._task.getActive());
    }

    @Override
    public GUISource getActive() {
        return this._task.getActive();
    }

    @Override
    public void setActive(GUISource gUISource) {
        this._task.activate((BaseAWTSource)gUISource);
    }

    @Override
    public GUISource getGUISource(Source source) {
        if (source instanceof DefaultSource) {
            return this._awtDefaultSource;
        }
        if (source instanceof Channel) {
            return this._channels.get(source);
        }
        if (source instanceof Query) {
            return this._queries.get(source);
        }
        if (source instanceof Status) {
            return this._status.get(source);
        }
        if (source instanceof ChanList) {
            return this._lists.get(source);
        }
        if (source instanceof DCCChat) {
            return this._dccChats.get(source);
        }
        if (source instanceof DCCFile) {
            return (GUISource)((Object)this._dccFiles.get(source));
        }
        return null;
    }

    private DockablePanel createSource(BaseAWTSource baseAWTSource) {
        DockablePanel dockablePanel = new DockablePanel(baseAWTSource, this._panel.getColor(6));
        dockablePanel.addDockablePanelListener(this);
        dockablePanel.setClosingBehaviour(1);
        this._awt2Dock.put(baseAWTSource, dockablePanel);
        return dockablePanel;
    }

    private DockablePanel getSource(BaseAWTSource baseAWTSource) {
        return this._awt2Dock.get(baseAWTSource);
    }

    private void deleteSource(BaseAWTSource baseAWTSource) {
        DockablePanel dockablePanel = this.getSource(baseAWTSource);
        if (dockablePanel != null) {
            dockablePanel.removeDockablePanelListener(this);
        }
        this._awt2Dock.remove(baseAWTSource);
    }

    public void dock(BaseAWTSource baseAWTSource) {
        this.getSource(baseAWTSource).dock();
        baseAWTSource.requestFocus();
        if (this._pixxConfiguration.getB("hideundockedsources")) {
            this._task.show(baseAWTSource);
        }
    }

    public void undock(BaseAWTSource baseAWTSource) {
        DockablePanel dockablePanel = this.getSource(baseAWTSource);
        BaseAWTSource[] baseAWTSourceArray = this._task.getZOrderedSources();
        for (int i = 0; i < baseAWTSourceArray.length; ++i) {
            DockablePanel dockablePanel2 = this.getSource(baseAWTSourceArray[i]);
            if (!dockablePanel2.isDocked() || dockablePanel2 == dockablePanel) continue;
            this._task.activate(baseAWTSourceArray[i]);
            break;
        }
        dockablePanel.undock(baseAWTSource.getShortTitle());
        baseAWTSource.requestFocus();
        if (this._pixxConfiguration.getB("hideundockedsources")) {
            this._task.hide(baseAWTSource);
        }
    }

    public boolean isDocked(BaseAWTSource baseAWTSource) {
        return this.getSource(baseAWTSource).isDocked();
    }

    @Override
    public Interpretor getInterpretor() {
        return this._interpretor;
    }

    public BaseAWTSource findBaseAWTSource(Source source) {
        Enumeration<BaseAWTSource> enumeration = this._awt2Dock.keys();
        while (enumeration.hasMoreElements()) {
            BaseAWTSource baseAWTSource = enumeration.nextElement();
            if (baseAWTSource.getSource() != source) continue;
            return baseAWTSource;
        }
        return null;
    }

    @Override
    public void AWTSourceAdded(PixxTaskBar pixxTaskBar, BaseAWTSource baseAWTSource) {
        DockablePanel dockablePanel = this.createSource(baseAWTSource);
        this._mdi.add(dockablePanel);
        dockablePanel.setVisible(false);
        this._panel.validate();
        this.test();
        if (this._pixxConfiguration.getDockingPolicy(baseAWTSource.getSource().getType().toLowerCase(Locale.ENGLISH), baseAWTSource.getSource().getName().toLowerCase(Locale.ENGLISH))) {
            this.undock(baseAWTSource);
        }
    }

    @Override
    public void AWTSourceRemoved(PixxTaskBar pixxTaskBar, BaseAWTSource baseAWTSource) {
        DockablePanel dockablePanel = this.getSource(baseAWTSource);
        dockablePanel.dock();
        this.deleteSource(baseAWTSource);
        this._mdi.remove(dockablePanel);
        dockablePanel.release();
        this._panel.validate();
        this.test();
    }

    @Override
    public void AWTSourceDesactivated(PixxTaskBar pixxTaskBar, BaseAWTSource baseAWTSource) {
        try {
            DockablePanel dockablePanel = this.getSource(baseAWTSource);
            this._panel.setBackground(this._ircConfiguration.getStyleColors(baseAWTSource.getStyleContext())[0]);
            dockablePanel.setVisible(false);
            this._panel.validate();
            this.test();
        }
        catch (Throwable throwable) {
            LOG.error("Error in chat GUI framework", throwable);
        }
    }

    @Override
    public void AWTSourceActivated(PixxTaskBar pixxTaskBar, BaseAWTSource baseAWTSource) {
        if (baseAWTSource != null) {
            DockablePanel dockablePanel = this.getSource(baseAWTSource);
            dockablePanel.setVisible(true);
            this._panel.validate();
            dockablePanel.requestFocus();
            dockablePanel.bring();
        }
        this.test();
    }

    @Override
    public void eventOccured(PixxTaskBar pixxTaskBar, BaseAWTSource baseAWTSource, MouseEvent mouseEvent) {
        DockablePanel dockablePanel = this.getSource(baseAWTSource);
        if (this._pixxConfiguration.matchMouseConfiguration("taskbarpopup", mouseEvent)) {
            pixxTaskBar.activate(baseAWTSource);
            this._popMenu.removeAll();
            this._popMenu.add(new MenuItem("Close"));
            this._popMenu.show(this._task, mouseEvent.getX(), mouseEvent.getY());
        }
        dockablePanel.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        EventDispatcher.dispatchEventAsync(this, "actionPerformedEff", new Object[]{actionEvent});
    }

    public void actionPerformedEff(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Close")) {
            BaseAWTSource baseAWTSource = this._task.getActive();
            if (baseAWTSource != null) {
                baseAWTSource.leave();
            }
        } else if (actionEvent.getSource() == this._nickField) {
            BaseAWTSource baseAWTSource = this._task.getActive();
            if (baseAWTSource == null) {
                return;
            }
            baseAWTSource.getSource().sendString("/nick " + this._nickField.getText());
        }
    }

    @Override
    public void connectionClicked(PixxMenuBar pixxMenuBar) {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        Server server = gUISource.getSource().getServer();
        if (server == null) {
            return;
        }
        if (server.isConnected()) {
            server.disconnect();
        } else {
            try {
                ChatMediator.instance().ensureValidNickname();
                server.connect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void chanListClicked(PixxMenuBar pixxMenuBar) {
        BaseAWTSource baseAWTSource = this._task.getActive();
        if (baseAWTSource == null) {
            return;
        }
        baseAWTSource.getSource().sendString("/list");
    }

    @Override
    public void aboutClicked(PixxMenuBar pixxMenuBar) {
        this._pixxConfiguration.getIRCConfiguration().displayAboutPage();
    }

    @Override
    public void helpClicked(PixxMenuBar pixxMenuBar) {
        IRCConfiguration iRCConfiguration = this._pixxConfiguration.getIRCConfiguration();
        if (this._pixxConfiguration.getS("helppage") != null) {
            iRCConfiguration.getURLHandler().openURL(this._pixxConfiguration.getS("helppage"));
        }
    }

    @Override
    public void closeClicked(PixxMenuBar pixxMenuBar) {
        BaseAWTSource baseAWTSource = this._task.getActive();
        if (baseAWTSource == null) {
            return;
        }
        baseAWTSource.leave();
    }

    @Override
    public void dockClicked(PixxMenuBar pixxMenuBar) {
        BaseAWTSource baseAWTSource = this._task.getActive();
        if (baseAWTSource == null) {
            return;
        }
        if (this.isDocked(baseAWTSource)) {
            this.undock(baseAWTSource);
        } else {
            this.dock(baseAWTSource);
        }
    }

    @Override
    public void mouseWheelMoved(Integer n) {
        BaseAWTSource baseAWTSource = this._task.getActive();
        if (baseAWTSource == null) {
            return;
        }
        baseAWTSource.mouseWheelMoved(n);
    }

    private void updateConnect() {
        BaseAWTSource baseAWTSource = this._task.getActive();
        if (baseAWTSource == null) {
            return;
        }
        Server server = baseAWTSource.getSource().getServer();
        this.setConnected(server.isConnected());
    }

    public GUISource getActiveSource() {
        return this._task.getActive();
    }

    @Override
    public void titleChanged(BaseAWTSource baseAWTSource) {
        if (baseAWTSource != this.getActive()) {
            return;
        }
        this.setTitle(baseAWTSource.getTitle(), baseAWTSource.getStyleContext());
    }

    @Override
    public void eventOccured(BaseAWTSource baseAWTSource) {
    }

    @Override
    public void DockablePanelWindowClosing(DockablePanel dockablePanel) {
        Enumeration<BaseAWTSource> enumeration = this._awt2Dock.keys();
        while (enumeration.hasMoreElements()) {
            BaseAWTSource baseAWTSource = enumeration.nextElement();
            if (this._awt2Dock.get(baseAWTSource) != dockablePanel) continue;
            if (this._pixxConfiguration.getB("leaveonundockedwindowclose")) {
                baseAWTSource.leave();
            } else {
                dockablePanel.dock();
            }
            this._task.show(baseAWTSource);
        }
    }

    @Override
    public void DockablePanelWindowClosed(DockablePanel dockablePanel) {
    }
}

