/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.ListenerGroup;
import irc.gui.pixx.AWTChanList;
import irc.gui.pixx.AWTChannel;
import irc.gui.pixx.AWTDCCChat;
import irc.gui.pixx.AWTDefaultSource;
import irc.gui.pixx.AWTQuery;
import irc.gui.pixx.AWTStatus;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.BaseAWTSourceListener;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxPanel;
import irc.gui.pixx.PixxTaskBarListener;
import irc.gui.pixx.TaskBarItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class PixxTaskBar
extends PixxPanel
implements MouseListener,
MouseMotionListener,
BaseAWTSourceListener {
    private static final long serialVersionUID = -9081050062448414641L;
    private ListenerGroup _listeners;
    private TaskBarItem _active = null;
    private TaskBarItem _pressed = null;
    private Vector<TaskBarItem> _items;
    private int[] _itemCount;
    private int[] _visibleItemCount;
    private Font _font = new Font("", 0, 12);
    private Image _buffer;
    private int _iwidth;
    private int _ileft;
    private int _zorder;
    private boolean _handCursor;
    private int _overX;
    private int _overY;
    private int _maxWidth;

    public PixxTaskBar(PixxConfiguration pixxConfiguration) {
        super(pixxConfiguration);
        this._listeners = new ListenerGroup();
        this._items = new Vector();
        this._itemCount = new int[2];
        this._visibleItemCount = new int[2];
        this._itemCount[0] = 0;
        this._itemCount[1] = 0;
        this._visibleItemCount[0] = 0;
        this._visibleItemCount[1] = 0;
        this._ileft = 60;
        this._zorder = 0;
        this._handCursor = false;
        this._overX = -1;
        this._overY = -1;
        this.computeWidth();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._maxWidth = pixxConfiguration.getI("taskbaritemwidth");
    }

    @Override
    public void release() {
        this._buffer = null;
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        super.release();
    }

    public void addPixxTaskBarListener(PixxTaskBarListener pixxTaskBarListener) {
        this._listeners.addListener(pixxTaskBarListener);
    }

    public void removePixxTaskBarListener(PixxTaskBarListener pixxTaskBarListener) {
        this._listeners.removeListener(pixxTaskBarListener);
    }

    private TaskBarItem findItem(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            return null;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            if (this._items.elementAt((int)i).source != baseAWTSource) continue;
            return this._items.elementAt(i);
        }
        return null;
    }

    private void removeFromVector(Vector<TaskBarItem> vector, Object object) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) != object) continue;
            vector.removeElementAt(i);
        }
    }

    private synchronized void enter(BaseAWTSource baseAWTSource, int n, boolean bl) {
        TaskBarItem taskBarItem = new TaskBarItem(baseAWTSource, n, bl);
        baseAWTSource.addBaseAWTSourceListener(this);
        this._items.insertElementAt(taskBarItem, this._items.size());
        int n2 = n;
        this._itemCount[n2] = this._itemCount[n2] + 1;
        int n3 = n;
        this._visibleItemCount[n3] = this._visibleItemCount[n3] + 1;
        this._listeners.sendEvent("AWTSourceAdded", this, baseAWTSource);
        if (bl) {
            this.activate(baseAWTSource);
        }
        this._buffer = null;
        this.repaint();
    }

    private synchronized void leave(BaseAWTSource baseAWTSource, int n) {
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        baseAWTSource.removeBaseAWTSourceListener(this);
        int n2 = n;
        this._itemCount[n2] = this._itemCount[n2] - 1;
        int n3 = n;
        this._visibleItemCount[n3] = this._visibleItemCount[n3] - 1;
        boolean bl = this.getActive() == baseAWTSource;
        this.removeFromVector(this._items, taskBarItem);
        if (bl) {
            this.activate(null);
        }
        this._listeners.sendEvent("AWTSourceRemoved", this, baseAWTSource);
        this._buffer = null;
        this.repaint();
    }

    public int getCount() {
        return this._itemCount[0] + this._itemCount[1];
    }

    public void addChannel(AWTChannel aWTChannel, boolean bl) {
        this.enter(aWTChannel, 0, bl);
    }

    public void removeChannel(AWTChannel aWTChannel) {
        this.leave(aWTChannel, 0);
    }

    public void addStatus(AWTStatus aWTStatus, boolean bl) {
        this.enter(aWTStatus, 1, bl);
    }

    public void removeStatus(AWTStatus aWTStatus) {
        this.leave(aWTStatus, 1);
    }

    public void addDefaultSource(AWTDefaultSource aWTDefaultSource, boolean bl) {
        this.enter(aWTDefaultSource, 1, bl);
    }

    public void removeDefaultSource(AWTDefaultSource aWTDefaultSource) {
        this.leave(aWTDefaultSource, 1);
    }

    public void addQuery(AWTQuery aWTQuery, boolean bl) {
        this.enter(aWTQuery, 1, bl);
    }

    public void removeQuery(AWTQuery aWTQuery) {
        this.leave(aWTQuery, 1);
    }

    public void addChanList(AWTChanList aWTChanList, boolean bl) {
        this.enter(aWTChanList, 1, bl);
    }

    public void removeChanList(AWTChanList aWTChanList) {
        this.leave(aWTChanList, 1);
    }

    public void addDCCChat(AWTDCCChat aWTDCCChat, boolean bl) {
        this.enter(aWTDCCChat, 1, bl);
    }

    public void removeDCCChat(AWTDCCChat aWTDCCChat) {
        this.leave(aWTDCCChat, 1);
    }

    private BaseAWTSource findFirst() {
        TaskBarItem taskBarItem = null;
        int n = -1;
        for (int i = 0; i < this._items.size(); ++i) {
            TaskBarItem taskBarItem2 = this._items.elementAt(i);
            if (taskBarItem2.zorder <= n) continue;
            n = taskBarItem2.zorder;
            taskBarItem = taskBarItem2;
        }
        if (taskBarItem == null) {
            return null;
        }
        return taskBarItem.source;
    }

    public BaseAWTSource[] getZOrderedSources() {
        int n;
        TaskBarItem[] taskBarItemArray = new TaskBarItem[this._items.size()];
        for (n = 0; n < taskBarItemArray.length; ++n) {
            taskBarItemArray[n] = this._items.elementAt(n);
        }
        for (n = 0; n < taskBarItemArray.length - 1; ++n) {
            TaskBarItem taskBarItem = taskBarItemArray[n];
            int n2 = taskBarItem.zorder;
            int n3 = n;
            for (int i = n + 1; i < taskBarItemArray.length; ++i) {
                taskBarItem = taskBarItemArray[i];
                if (taskBarItem.zorder <= n2) continue;
                n2 = taskBarItem.zorder;
                n3 = i;
            }
            TaskBarItem taskBarItem2 = taskBarItemArray[n];
            taskBarItemArray[n] = taskBarItemArray[n3];
            taskBarItemArray[n3] = taskBarItem2;
        }
        BaseAWTSource[] baseAWTSourceArray = new BaseAWTSource[taskBarItemArray.length];
        for (int i = 0; i < baseAWTSourceArray.length; ++i) {
            baseAWTSourceArray[i] = taskBarItemArray[i].source;
        }
        return baseAWTSourceArray;
    }

    public void show(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            return;
        }
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (taskBarItem.visible) {
            return;
        }
        taskBarItem.visible = true;
        int n = taskBarItem.row;
        this._visibleItemCount[n] = this._visibleItemCount[n] + 1;
        this._buffer = null;
        this.repaint();
    }

    public void hide(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            return;
        }
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (!taskBarItem.visible) {
            return;
        }
        taskBarItem.visible = false;
        int n = taskBarItem.row;
        this._visibleItemCount[n] = this._visibleItemCount[n] - 1;
        this._buffer = null;
        this.repaint();
    }

    public void activate(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            baseAWTSource = this.findFirst();
        }
        if (baseAWTSource == null) {
            return;
        }
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (taskBarItem == this._active) {
            return;
        }
        if (!taskBarItem.visible) {
            return;
        }
        if (this._active != null) {
            this._listeners.sendEvent("AWTSourceDesactivated", this, this._active.source);
        }
        this._active = taskBarItem;
        if (this._active != null) {
            this._active.zorder = this._zorder++;
            this._active.eventWaiting = false;
            this._listeners.sendEvent("AWTSourceActivated", this, this._active.source);
        } else {
            this._listeners.sendEvent("AWTSourceActivated", this, null);
        }
        baseAWTSource.requestFocus();
        this._buffer = null;
        this.repaint();
    }

    public BaseAWTSource getActive() {
        if (this._active == null) {
            return null;
        }
        return this._active.source;
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16, 2 * this.getItemHeight() + 16);
    }

    private int getItemWidth() {
        return this._iwidth;
    }

    private int getItemHeight() {
        return this._font.getSize() + 4;
    }

    private void computeWidth() {
        int n = this.getSize().width - 63;
        int n2 = Math.max(this._visibleItemCount[0], this._visibleItemCount[1]);
        this._iwidth = n2 != 0 ? Math.min(this._maxWidth, (n -= 9 * n2) / n2) : this._maxWidth;
    }

    private int getX(int n) {
        return n * (this.getItemWidth() + 9) + this._ileft;
    }

    private int getCol(int n) {
        return (n - this._ileft) / (9 + this.getItemWidth());
    }

    private int getY(int n) {
        return 4 + (this.getItemHeight() + 8) * n;
    }

    private int getRow(int n) {
        return (n - 4) / (8 + this.getItemHeight());
    }

    private void drawItem(Graphics graphics, int n, int n2, Color color, String string) {
        int n3 = this.getX(n);
        int n4 = this.getY(n2);
        int n5 = this.getItemWidth();
        int n6 = this.getItemHeight();
        graphics.setClip(n3 + 1, n4 + 1, n5 - 1, n6 - 1);
        graphics.setColor(color);
        graphics.fillRect(n3, n4, n5, n6);
        graphics.setColor(this.getColor(0));
        graphics.drawRect(n3, n4, n5, n6);
        graphics.setColor(this.getColor(1));
        graphics.drawRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
        n4 += n6;
        int n7 = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, n3 + (n5 - n7) / 2, (n4 -= (n6 - this._font.getSize()) / 2) - 1);
        graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
    }

    private void drawItem(Graphics graphics, TaskBarItem taskBarItem, int n) {
        int n2 = taskBarItem.row;
        Color color = this.getColor(5);
        if (taskBarItem == this._active || taskBarItem == this._pressed) {
            color = this.getColor(7);
        }
        if (taskBarItem != this._active && taskBarItem.eventWaiting) {
            color = this.getColor(8);
        }
        this.drawItem(graphics, n++, n2, color, taskBarItem.source.getShortTitle());
    }

    @Override
    public void update(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        if (this._buffer != null && (this._buffer.getWidth(this) != n4 || this._buffer.getHeight(this) != n5)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            try {
                this._buffer = this.createImage(n4, n5);
                object = this._buffer.getGraphics();
            }
            catch (Throwable throwable) {
                return;
            }
            ((Graphics)object).setFont(new Font("", 0, 12));
            int n6 = Math.max(((Graphics)object).getFontMetrics().stringWidth("Private Msg's   "), ((Graphics)object).getFontMetrics().stringWidth("Chat Rooms"));
            this._ileft = 25 + n6;
            this.computeWidth();
            ((Graphics)object).setColor(this.getColor(6));
            ((Graphics)object).fillRect(0, 0, n4, n5);
            n3 = 0;
            n2 = 0;
            Enumeration<TaskBarItem> enumeration = this._items.elements();
            while (enumeration.hasMoreElements()) {
                TaskBarItem taskBarItem = enumeration.nextElement();
                if (!taskBarItem.visible) continue;
                if (taskBarItem.row == 0) {
                    this.drawItem((Graphics)object, taskBarItem, n3++);
                    continue;
                }
                this.drawItem((Graphics)object, taskBarItem, n2++);
            }
            ((Graphics)object).setColor(this.getColor(5));
            ((Graphics)object).fillRect(4, 5, n6 + 2, n5 - 9);
            for (n = 3; n < n5 / 4; ++n) {
                ((Graphics)object).drawLine(n6 + 3 + n, n + 3, n6 + 3 + n, n5 / 2 + 2 - n);
                ((Graphics)object).drawLine(n6 + 3 + n, n5 - 3 - n, n6 + 3 + n, n5 / 2 - 1 + n);
            }
            ((Graphics)object).setColor(this.getColor(0));
            ((Graphics)object).drawLine(4, n5 / 2 - 1, n4 - 1, n5 / 2 - 1);
            ((Graphics)object).drawLine(4, n5 / 2 + 1, n4 - 1, n5 / 2 + 1);
            ((Graphics)object).setColor(this.getColor(1));
            ((Graphics)object).drawLine(4, n5 / 2, n4 - 1, n5 / 2);
            n = this.getY(0) + this.getItemHeight();
            ((Graphics)object).drawString("Chat Rooms", 8, (n -= (this.getItemHeight() - this._font.getSize()) / 2) + 1);
            n = this.getY(1) + this.getItemHeight();
            ((Graphics)object).drawString("Private Msg's   ", 8, (n -= (this.getItemHeight() - this._font.getSize()) / 2) - 4);
            ((Graphics)object).setColor(this.getColor(0));
            ((Graphics)object).drawLine(4, 5, 4, n5 - 5);
            ((Graphics)object).drawLine(4, 5, n6 + 6, 5);
            ((Graphics)object).drawLine(4, n5 - 5, n6 + 6, n5 - 5);
            ((Graphics)object).drawLine(n6 + 6, 5, n6 + 3 + n5 / 4, n5 / 4 + 2);
            ((Graphics)object).drawLine(n6 + 3 + n5 / 4, n5 / 4 + 2, n6 + 6, n5 / 2 - 1);
            ((Graphics)object).drawLine(n6 + 6, n5 - 5, n6 + 3 + n5 / 4, n5 - 1 - n5 / 4 - 1);
            ((Graphics)object).drawLine(n6 + 3 + n5 / 4, n5 - n5 / 4 - 2, n6 + 6, n5 - 3 - n5 / 2 + 4);
            ((Graphics)object).setColor(this.getColor(1));
            ((Graphics)object).drawLine(5, 6, 5, n5 - 6);
            ((Graphics)object).drawLine(5, 6, n6 + 5, 6);
            ((Graphics)object).drawLine(5, n5 - 6, n6 + 5, n5 - 6);
            ((Graphics)object).drawLine(n6 + 6, 6, n6 + 2 + n5 / 4, n5 / 4 + 2);
            ((Graphics)object).drawLine(n6 + 2 + n5 / 4, n5 / 4 + 2, n6 + 5, n5 / 2 - 1);
            ((Graphics)object).drawLine(n6 + 6, n5 - 6, n6 + 2 + n5 / 4, n5 - 1 - n5 / 4 - 1);
            ((Graphics)object).drawLine(n6 + 2 + n5 / 4, n5 - 2 - n5 / 4, n6 + 5, n5 - 1 - n5 / 2 + 2);
        }
        if (this._buffer != null) {
            graphics.drawImage(this._buffer, 0, 0, this);
        }
        if ((object = this.getItemAt(this._overX, this._overY)) != null) {
            String string = ((TaskBarItem)object).source.getShortTitle();
            n3 = graphics.getFontMetrics().stringWidth(string);
            n2 = this.getX(this.getCol(this._overX)) + (this.getItemWidth() - n3) / 2 - 2;
            int n7 = this.getY(this.getRow(this._overY)) - (this.getItemHeight() - this._font.getSize()) / 2 - 1;
            n = this.getItemHeight();
            if (string.length() > 0 && n3 >= this.getItemWidth()) {
                if (n2 + n3 + 5 >= n4) {
                    n2 = n4 - n3 - 5;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                graphics.setColor(this.getAlphaColor(this.getColor(5), 200));
                graphics.fillRect(n2, n7, n3 + 4, n + 4);
                graphics.setColor(this.getColor(1));
                graphics.drawRect(n2, n7, n3 + 4, n + 4);
                graphics.drawString(string, n2 + 2, n7 + n);
            }
        }
    }

    private Color getAlphaColor(Color color, int n) {
        try {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }
        catch (Throwable throwable) {
            return color;
        }
    }

    private TaskBarItem getItemAt(int n, int n2) {
        int n3;
        int n4 = this.getRow(n2);
        if ((n -= this.getX(n3 = this.getCol(n))) >= this.getItemWidth() || (n2 -= this.getY(n4)) >= this.getItemHeight()) {
            return null;
        }
        if (n < 0 || n2 < 0) {
            return null;
        }
        int n5 = 0;
        Enumeration<TaskBarItem> enumeration = this._items.elements();
        while (enumeration.hasMoreElements()) {
            TaskBarItem taskBarItem = enumeration.nextElement();
            if (!taskBarItem.visible || taskBarItem.row != n4) continue;
            if (n5 == n3) {
                return taskBarItem;
            }
            ++n5;
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        TaskBarItem taskBarItem;
        TaskBarItem taskBarItem2 = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        if (taskBarItem2 != null) {
            if (!this._handCursor) {
                this.setCursor(new Cursor(12));
                this._handCursor = true;
            }
        } else if (this._handCursor) {
            this.setCursor(new Cursor(0));
            this._handCursor = false;
        }
        if ((taskBarItem = this.getItemAt(this._overX, this._overY)) != taskBarItem2) {
            this._overX = mouseEvent.getX();
            this._overY = mouseEvent.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TaskBarItem taskBarItem;
        this._pressed = taskBarItem = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        this._buffer = null;
        this.repaint();
        if (this._pressed != null) {
            this._listeners.sendEventAsync("eventOccured", this, this._pressed.source, mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._pressed = null;
        TaskBarItem taskBarItem = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        try {
            if ((mouseEvent.getModifiers() & 0x10) != 0 && taskBarItem != null) {
                EventDispatcher.dispatchEventAsyncAndWaitEx(this, "activate", new Object[]{taskBarItem.source});
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._buffer = null;
        this.repaint();
    }

    @Override
    public void titleChanged(BaseAWTSource baseAWTSource) {
        this._buffer = null;
        this.repaint();
    }

    @Override
    public void eventOccured(BaseAWTSource baseAWTSource) {
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (taskBarItem == null) {
            return;
        }
        if (taskBarItem == this._active) {
            return;
        }
        taskBarItem.eventWaiting = true;
        this._buffer = null;
        this.repaint();
    }
}

