/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxNickList;
import irc.gui.pixx.PixxNickListListener;
import irc.gui.pixx.PixxPanel;
import irc.gui.pixx.PixxScrollBar;
import irc.gui.pixx.PixxScrollBarListener;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.PixxVerticalScrollBar;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class ScrollablePixxNickList
extends PixxPanel
implements PixxScrollBarListener {
    private static final long serialVersionUID = 4546462702612938581L;
    private PixxNickList _list;
    private PixxVerticalScrollBar _scroll;

    public ScrollablePixxNickList(PixxConfiguration pixxConfiguration, char[] cArray) {
        super(pixxConfiguration);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._list = new PixxNickList(pixxConfiguration, cArray);
        this._scroll = new PixxVerticalScrollBar(pixxConfiguration, 0, 0, 0.1);
        this._scroll.addPixxScrollBarListener(this);
        jPanel.add((Component)this._list, "Center");
        jPanel.add((Component)this._scroll, "East");
        this.add((Component)jPanel, "Center");
        this.add((Component)new PixxSeparator(2), "West");
        this.add((Component)new PixxSeparator(3), "East");
        this.add((Component)new PixxSeparator(0), "North");
        this.add((Component)new PixxSeparator(1), "South");
    }

    @Override
    public void release() {
        this._scroll.removePixxScrollBarListener(this);
        this._list.release();
        this._scroll.release();
        this._list = null;
        this._scroll = null;
        super.release();
    }

    public void addPixxNickListListener(PixxNickListListener pixxNickListListener) {
        this._list.addPixxNickListListener(pixxNickListListener);
    }

    public void removePixxNickListListener(PixxNickListListener pixxNickListListener) {
        this._list.removePixxNickListListener(pixxNickListListener);
    }

    public void set(String[] stringArray) {
        this._list.set(stringArray);
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    public void add(String string) {
        this._list.add(string);
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    @Override
    public void removeAll() {
        this._list.removeAll();
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    @Override
    public void valueChanged(PixxScrollBar pixxScrollBar) {
        this._list.setBase(pixxScrollBar.getValue());
    }

    public void dispose() {
        this._list.dispose();
    }
}

