/*
 * Decompiled with CFR 0.152.
 */
package irc.ident.prv;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.ident.IdentListener;
import irc.ident.prv.LocalInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public class IdentServer
extends IRCObject
implements Runnable {
    private Thread _thread;
    private boolean _running;
    private Hashtable<Integer, LocalInfo> _table;
    private ServerSocket _serverSocket;
    private boolean _defaultUser;
    private String _system;
    private String _id;
    private ListenerGroup _listeners;
    private int _port;

    public IdentServer(IRCConfiguration iRCConfiguration) {
        super(iRCConfiguration);
        this.resetDefaultUser();
        this._table = new Hashtable();
        this._listeners = new ListenerGroup();
        this._thread = null;
    }

    public void start() throws Exception {
        this.start(113);
    }

    public void resetDefaultUser() {
        this._defaultUser = false;
    }

    public void setDefaultUser(String string, String string2) {
        this._defaultUser = true;
        this._system = string;
        this._id = string2;
    }

    public void start(int n) throws Exception {
        this._port = n;
        this._running = false;
        this._serverSocket = this._ircConfiguration.getSecurityProvider().getServerSocket(this._port);
        this._thread = new Thread((Runnable)this, "IDENT server");
        this._thread.start();
        while (!this._running) {
            Thread.yield();
        }
    }

    public void stop() {
        if (this._thread == null) {
            return;
        }
        try {
            this._serverSocket.close();
            this._thread.join();
            this._thread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void registerLocalConnection(int n, String string, String string2) {
        this._table.put(new Integer(n), new LocalInfo(n, string, string2));
    }

    public synchronized void unregisterLocalConnection(int n) {
        this._table.remove(new Integer(n));
    }

    private synchronized LocalInfo processRequest(int n) {
        return this._table.get(new Integer(n));
    }

    public synchronized void addIdentListener(IdentListener identListener) {
        this._listeners.addListener(identListener);
    }

    public synchronized void removeIdentListener(IdentListener identListener) {
        this._listeners.removeListener(identListener);
    }

    @Override
    public void run() {
        boolean bl = false;
        this._running = true;
        this._listeners.sendEventAsync("identRunning", new Integer(this._port));
        while (!bl) {
            try {
                Socket socket = this._serverSocket.accept();
                String string = this.getText(522);
                int n = -1;
                String string2 = this.getText(521);
                try {
                    try {
                        string = this._ircConfiguration.getSecurityProvider().resolve(socket.getInetAddress());
                    }
                    catch (Exception exception) {
                        string = socket.getInetAddress().getHostAddress();
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    String string3 = bufferedReader.readLine();
                    int n2 = string3.indexOf(44);
                    String string4 = string3.substring(0, n2).trim();
                    String string5 = string3.substring(n2 + 1).trim();
                    LocalInfo localInfo = this.processRequest(new Integer(string4));
                    string2 = string4 + " , " + string5 + " : ";
                    if (localInfo == null) {
                        if (!this._defaultUser) {
                            n = 2;
                            string2 = string2 + "ERROR : NO-USER";
                        } else {
                            n = 1;
                            string2 = string2 + "USERID : " + this._system + " : " + this._id;
                        }
                    } else {
                        n = 0;
                        string2 = string2 + "USERID : " + localInfo.system + " : " + localInfo.id;
                    }
                    bufferedWriter.write(string2 + "\n");
                    bufferedWriter.flush();
                    bufferedReader.close();
                    bufferedWriter.close();
                    socket.close();
                    this._listeners.sendEventAsync("identRequested", string, new Integer(n), string2);
                }
                catch (Exception exception) {
                    this._listeners.sendEventAsync("identRequested", string, new Integer(-1), exception.getMessage());
                }
            }
            catch (Exception exception) {
                this._listeners.sendEventAsync("identLeaving", exception.getMessage());
                bl = true;
            }
        }
    }
}

