/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import irc.IRCApplication;
import irc.plugin.buttons.SmileyGrayFilter;
import irc.plugin.buttons.SmileyLabel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class SmileyButton
extends SmileyLabel
implements MouseListener {
    private static final long serialVersionUID = -7569595727938929374L;
    protected static final int defaultBorderWidth = 4;
    protected ActionListener actionListener = null;
    private String _smileyID;
    private IRCApplication _appl;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private int darkness = -5263441;
    private Image graySmiley = null;

    public SmileyButton() {
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(String string) {
        super(string);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(URL uRL) {
        super(uRL);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(URL uRL, String string) {
        super(uRL, string);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(Image image) {
        super(image);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.graySmiley == null) {
            this.createGraySmiley(graphics);
        }
        this.drawBorder(true);
    }

    public void addActionListener(ActionListener actionListener2) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener2);
    }

    public void removeActionListener(ActionListener actionListener2) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener2);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        System.out.println("SmileyButton.processMouseEvent()");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("SmileyButton.mouseClicked()");
        this.getIRCApplication().setFieldText(this._appl.getFieldText() + ":)");
        ActionEvent actionEvent = new ActionEvent(this, 0, this.getSmileyID());
        if (this.actionListener != null) {
            System.out.println("it did have an action listener\n");
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        System.out.println("SmileyButton.mouseEntered");
        this.paint(this.getGraphics());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        System.out.println("SmileyButton.mouseExited");
        this.paint(this.getGraphics());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        System.out.println("SmileyButton.mousePressed");
        Graphics graphics = this.getGraphics();
        int n = this.getBorder();
        if (this.hasExplicitSize()) {
            graphics.drawImage(this.graySmiley, n, n, this.getWidth() - 2 * n, this.getHeight() - 2 * n, this);
        } else {
            graphics.drawImage(this.graySmiley, n, n, this);
        }
        this.drawBorder(false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        System.out.println("SmileyButton.mouseReleased()");
        this.paint(this.getGraphics());
    }

    public String getSmileyID() {
        return this._smileyID;
    }

    public void setSmileyID(String string) {
        this._smileyID = string;
    }

    public IRCApplication getIRCApplication() {
        return this._appl;
    }

    public void setIRCApplication(IRCApplication iRCApplication) {
        this._appl = iRCApplication;
    }

    public int getDarkness() {
        return this.darkness;
    }

    public void setDarkness(int n) {
        this.darkness = n;
    }

    public Image getGraySmiley() {
        return this.graySmiley;
    }

    public void setGraySmiley(Image image) {
        this.graySmiley = image;
    }

    private void drawBorder(boolean bl) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(this.getBorderColor());
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.getBorder();
        for (int i = 0; i < n5; ++i) {
            graphics.draw3DRect(n, n2, n3, n4, bl);
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
        }
    }

    private void setBorders() {
        this.setBorder(4);
        this.setBorderColor(defaultBorderColor);
    }

    private void createGraySmiley(Graphics graphics) {
        SmileyGrayFilter smileyGrayFilter = new SmileyGrayFilter(this.darkness);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getSmiley().getSource(), smileyGrayFilter);
        this.graySmiley = this.createImage(filteredImageSource);
        int n = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.graySmiley, this.getWidth() - 2 * n, this.getHeight() - 2 * n, this);
        } else {
            this.prepareImage(this.graySmiley, this);
        }
        super.paint(graphics);
    }
}

