/*
 * Decompiled with CFR 0.152.
 */
package irc.security;

import irc.EventDispatcher;
import irc.security.DefaultSecuredProvider;
import irc.security.SecuredProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SecurityProvider
implements ActionListener {
    private SecuredProvider _provider = new DefaultSecuredProvider();
    private boolean _answer;

    public String getProviderName() {
        return this._provider.getName();
    }

    public Socket getSocket(String string, int n) throws UnknownHostException, IOException {
        try {
            Socket socket = (Socket)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSocket", new Object[]{string, new Integer(n)});
            return socket;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getClass().getName() + " : " + throwable.getMessage());
        }
    }

    public ServerSocket getServerSocket(int n) throws IOException {
        try {
            return (ServerSocket)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getServerSocket", new Object[]{new Integer(n)});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getClass().getName() + " : " + throwable.getMessage());
        }
    }

    public boolean confirm(JFrame jFrame, String string, String string2) {
        JDialog jDialog;
        JFrame jFrame2 = null;
        if (jFrame == null) {
            jFrame2 = new JFrame();
            jDialog = new JDialog(jFrame2, string, true);
        } else {
            jDialog = new JDialog(jFrame, string, true);
        }
        jDialog.setLayout(new BorderLayout());
        jDialog.add((Component)new JLabel(string2), "Center");
        JButton jButton = new JButton("Yes");
        JButton jButton2 = new JButton("No");
        JPanel jPanel = new JPanel();
        jDialog.setResizable(false);
        jDialog.add((Component)jPanel, "South");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jDialog.pack();
        this._answer = false;
        jDialog.setVisible(true);
        jButton.removeActionListener(this);
        jButton2.removeActionListener(this);
        jDialog.setVisible(false);
        jDialog.dispose();
        jDialog = null;
        if (jFrame2 != null) {
            jFrame2.setVisible(false);
            jFrame2.dispose();
            jFrame2 = null;
        }
        return this._answer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        this._answer = false;
        if (jButton.getText().equals("Yes")) {
            this._answer = true;
        }
        ((Window)jButton.getParent().getParent()).setVisible(false);
    }

    public FileInputStream getFileInputStream(File file) throws IOException {
        if (!this.confirm(null, "Security warning", "Authorize file read action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileInputStream)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileInputStream", new Object[]{file});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public FileOutputStream getFileOutputStream(File file) throws IOException {
        if (!this.confirm(null, "Security warning", "Authorize file write action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileOutputStream)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileOutputStream", new Object[]{file});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public int getFileSize(File file) {
        try {
            return (Integer)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileSize", new Object[]{file});
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public File getLoadFile(String string) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getLoadFile", new Object[]{string});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public File getSaveFile(String string) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSaveFile", new Object[]{string});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public File getSaveFile(String string, String string2) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSaveFile", new Object[]{string, string2});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        try {
            return (InetAddress)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getLocalHost", new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            throw new UnknownHostException("Unable to resolve");
        }
        catch (Throwable throwable) {
            throw new UnknownHostException(throwable.getMessage());
        }
    }

    public String resolve(InetAddress inetAddress) {
        try {
            return (String)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "resolve", new Object[]{inetAddress});
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

