/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.StyleContext;
import irc.style.CharacterGroupItem;
import irc.style.CharacterInfo;
import irc.style.CharactersDrawer;
import irc.style.DecodedLine;
import irc.style.DecodedLineInternal;
import irc.style.DrawResult;
import irc.style.DrawResultItem;
import irc.style.FormattedStringDrawerListener;
import irc.style.LineItem;
import irc.style.StyledRectangle;
import irc.style.WordItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class FormattedStringDrawer
implements ImageObserver {
    private Font _font;
    private Font _fontPlain;
    private Font _fontBold;
    private Color[] _cols;
    private CharactersDrawer _drawer;
    private IRCConfiguration _config;
    private Dimension _tmp;
    private LineItem[] _lines;
    private int _vdirection;
    private int _hdirection;
    private FormattedStringDrawerListener _listener;
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;

    public FormattedStringDrawer(IRCConfiguration iRCConfiguration, StyleContext styleContext, FormattedStringDrawerListener formattedStringDrawerListener) {
        this._listener = formattedStringDrawerListener;
        this._tmp = new Dimension();
        this._lines = new LineItem[8];
        for (int i = 0; i < this._lines.length; ++i) {
            this._lines[i] = new LineItem();
        }
        this._config = iRCConfiguration;
        this.setFont(iRCConfiguration.getStyleFont(styleContext));
        this._drawer = new CharactersDrawer(this._config);
        this.setStyleContext(styleContext);
        this._vdirection = 0;
        this._hdirection = 0;
        if (iRCConfiguration.getB("style:righttoleft")) {
            this.setHorizontalDirection(1);
        }
    }

    public FormattedStringDrawer(IRCConfiguration iRCConfiguration, StyleContext styleContext) {
        this(iRCConfiguration, styleContext, null);
    }

    public void setVerticalDirection(int n) {
        this._vdirection = n;
    }

    public int getVerticalDirection() {
        return this._vdirection;
    }

    public void setHorizontalDirection(int n) {
        this._hdirection = n;
    }

    public int getHorizontalDirection() {
        return this._hdirection;
    }

    public void setStyleContext(StyleContext styleContext) {
        this._cols = this._config.getStyleColors(styleContext);
    }

    public DecodedLine decodeLine(String string) {
        String string2;
        DecodedLineInternal decodedLineInternal = new DecodedLineInternal();
        decodedLineInternal.original = string;
        string = string + '\u000f';
        decodedLineInternal.decoded = string2 = this._drawer.decodeLine(string);
        decodedLineInternal.decoded_stripped = this.getStripped(string2);
        Vector<WordItem> vector = this.doWords(string, string2);
        decodedLineInternal.words = new WordItem[vector.size()];
        for (int i = 0; i < decodedLineInternal.words.length; ++i) {
            decodedLineInternal.words[i] = vector.elementAt(i);
        }
        return decodedLineInternal;
    }

    private Vector<WordItem> doWords(String string, String string2) {
        Vector<WordItem> vector = new Vector<WordItem>();
        CharacterInfo characterInfo = new CharacterInfo();
        characterInfo.frontColor = this._cols[1];
        characterInfo.backColor = this._cols[0];
        characterInfo.isTransparent = true;
        while (string2.length() > 0) {
            WordItem wordItem;
            int n = string.indexOf(32);
            int n2 = string2.indexOf(32);
            if (n2 == -1) {
                wordItem = this.decodeWord(characterInfo, string2 + " ", this._cols);
                wordItem.originalword = string + " ";
                wordItem.originalstrippedword = this.getStripped(string + " ");
                string2 = "";
            } else {
                String string3 = string.substring(0, n);
                String string4 = string2.substring(0, n2);
                wordItem = this.decodeWord(characterInfo, string4 + " ", this._cols);
                wordItem.originalword = string3 + " ";
                wordItem.originalstrippedword = this.getStripped(string3 + " ");
                string = string.substring(n + 1);
                string2 = string2.substring(n2 + 1);
            }
            vector.insertElementAt(wordItem, vector.size());
            characterInfo = wordItem.lastInfo;
        }
        return vector;
    }

    public int getHeight(DecodedLine decodedLine, FontMetrics fontMetrics) {
        return this._drawer.getHeight(decodedLine.decoded_stripped, fontMetrics, this);
    }

    public int getWidth(DecodedLine decodedLine, FontMetrics fontMetrics) {
        return this._drawer.getWidth(decodedLine.decoded_stripped, fontMetrics, this);
    }

    private Font deriveFont(Font font, int n) {
        return new Font(font.getName(), n, font.getSize());
    }

    public void setColors(Color[] colorArray) {
        this._cols = colorArray;
    }

    public Color getColor(int n) {
        return this._cols[n];
    }

    public void setFont(Font font) {
        this._font = font;
        this._fontPlain = this.deriveFont(this._font, 0);
        this._fontBold = this.deriveFont(this._font, 1);
    }

    public Font getFont() {
        return this._font;
    }

    private WordItem decodeWord(CharacterInfo characterInfo, String string, Color[] colorArray) {
        int n;
        Vector<CharacterGroupItem> vector = new Vector<CharacterGroupItem>();
        CharacterInfo characterInfo2 = new CharacterInfo(characterInfo);
        CharacterGroupItem characterGroupItem = new CharacterGroupItem(new CharacterInfo(characterInfo2));
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n < 32) {
                int n3 = n;
                if (n3 == 15) {
                    characterInfo2.isBold = false;
                    characterInfo2.isUnderline = false;
                    characterInfo2.isReverse = false;
                    characterInfo2.frontColor = colorArray[1];
                    characterInfo2.backColor = colorArray[0];
                    characterInfo2.isTransparent = true;
                } else if (n3 == 2) {
                    characterInfo2.isBold = !characterInfo2.isBold;
                } else if (n3 == 31) {
                    characterInfo2.isUnderline = !characterInfo2.isUnderline;
                } else if (n3 == 22) {
                    boolean bl = characterInfo2.isReverse = !characterInfo2.isReverse;
                    if (characterInfo2.isReverse) {
                        characterInfo2.frontColor = colorArray[0];
                        characterInfo2.backColor = colorArray[1];
                        characterInfo2.isTransparent = false;
                    } else {
                        characterInfo2.frontColor = colorArray[1];
                        characterInfo2.backColor = colorArray[0];
                        characterInfo2.isTransparent = true;
                    }
                } else if (n3 == 3) {
                    char c;
                    boolean bl = true;
                    String string2 = "";
                    String string3 = "";
                    ++i;
                    while (i < n2) {
                        c = string.charAt(i);
                        if (c >= '0' && c <= '9') {
                            if (bl) {
                                if (string2.length() == 2) {
                                    --i;
                                    break;
                                }
                                string2 = string2 + c;
                            } else {
                                if (string3.length() == 2) {
                                    --i;
                                    break;
                                }
                                string3 = string3 + c;
                            }
                            ++i;
                            continue;
                        }
                        if (c == ',') {
                            if (bl) {
                                bl = false;
                                ++i;
                                continue;
                            }
                            --i;
                            break;
                        }
                        --i;
                        break;
                    }
                    if (string2.length() == 0) {
                        string3 = "";
                    }
                    if (string2.length() > 0) {
                        c = Integer.parseInt(string2);
                        characterInfo2.frontColor = colorArray[c %= this._cols.length];
                    }
                    if (string3.length() > 0) {
                        c = Integer.parseInt(string3);
                        characterInfo2.backColor = colorArray[c %= this._cols.length];
                        boolean bl2 = characterInfo2.isTransparent = c == '\u0000';
                    }
                    if (string2.length() == 0 && string3.length() == 0) {
                        characterInfo2.frontColor = colorArray[1];
                        characterInfo2.backColor = colorArray[0];
                        characterInfo2.isTransparent = true;
                    }
                }
                if (characterInfo2.equals(characterGroupItem.info)) continue;
                vector.insertElementAt(characterGroupItem, vector.size());
                characterGroupItem = new CharacterGroupItem(new CharacterInfo(characterInfo2));
                continue;
            }
            characterGroupItem.s = characterGroupItem.s + (char)n;
        }
        vector.insertElementAt(characterGroupItem, vector.size());
        CharacterGroupItem[] characterGroupItemArray = new CharacterGroupItem[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            characterGroupItemArray[n] = (CharacterGroupItem)vector.elementAt(n);
        }
        return new WordItem(characterGroupItemArray, characterInfo2);
    }

    private FontMetrics getFontMetrics(Graphics graphics, CharacterInfo characterInfo) {
        Font font = graphics.getFont();
        if (characterInfo.isBold) {
            graphics.setFont(this._fontBold);
        } else {
            graphics.setFont(this._fontPlain);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setFont(font);
        return fontMetrics;
    }

    private int drawPart(Graphics graphics, CharacterInfo characterInfo, String string, int n, int n2, FontMetrics fontMetrics, int n3, int n4, ImageObserver imageObserver, Vector<Object> vector) {
        FontMetrics fontMetrics2 = fontMetrics;
        int n5 = fontMetrics.getDescent();
        if (characterInfo.isBold) {
            graphics.setFont(this._fontBold);
        }
        fontMetrics2 = graphics.getFontMetrics();
        int n6 = this._drawer.getWidth(string, fontMetrics2, this);
        if (n <= n4 && n + n6 > n3) {
            int n7 = this._drawer.getHeight(string, fontMetrics2, this);
            Rectangle rectangle = graphics.getClipBounds();
            int n8 = n3;
            int n9 = n2 - n7;
            int n10 = n4 - n3 + 1;
            int n11 = n7;
            graphics.clipRect(n8, n9, n10, n11);
            graphics.setColor(characterInfo.backColor);
            if (!characterInfo.isTransparent) {
                graphics.fillRect(n, n2 - n7, n6, n7);
            }
            graphics.setColor(characterInfo.frontColor);
            this._drawer.draw(string, graphics, fontMetrics2, n, n2 -= n5, imageObserver, vector);
            if (characterInfo.isUnderline) {
                graphics.drawLine(n, n2 + 1, n + n6 - 1, n2 + 1);
            }
            if (rectangle != null) {
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setClip(null);
            }
        }
        if (characterInfo.isBold) {
            graphics.setFont(this._fontPlain);
        }
        return n6;
    }

    private void drawWord(Graphics graphics, WordItem wordItem, int n, int n2, boolean bl, FontMetrics fontMetrics, int n3, int n4, ImageObserver imageObserver, Vector<Object> vector) {
        for (int i = 0; i < wordItem.items.length; ++i) {
            CharacterGroupItem characterGroupItem = wordItem.items[i];
            n += this.drawPart(graphics, characterGroupItem.info, characterGroupItem.s, n, n2, fontMetrics, n3, n4, imageObserver, vector);
        }
    }

    public String getStripped(String string) {
        CharacterInfo characterInfo = new CharacterInfo();
        characterInfo.frontColor = this._cols[1];
        characterInfo.backColor = this._cols[0];
        characterInfo.isTransparent = true;
        String string2 = "";
        while (string.length() > 0) {
            WordItem wordItem;
            int n = string.indexOf(32);
            if (n == -1) {
                wordItem = this.decodeWord(characterInfo, string, this._cols);
                string = "";
            } else {
                String string3 = string.substring(0, n);
                wordItem = this.decodeWord(characterInfo, string3 + " ", this._cols);
                string = string.substring(n + 1);
            }
            if (string2.length() > 0) {
                string2 = string2 + " " + wordItem.originalword;
                continue;
            }
            string2 = string2 + wordItem.originalword;
        }
        return string2;
    }

    private boolean isAlphaNum(char c) {
        if (c == '(' || c == ')') {
            return false;
        }
        if (c == '<' || c == '>') {
            return false;
        }
        if (c == '\"' || c == '\"') {
            return false;
        }
        if (c == '{' || c == '}') {
            return false;
        }
        if (c == '.' || c == ',') {
            return false;
        }
        return c != ':';
    }

    private String trimAlphaNum(String string) {
        int n;
        for (n = 0; n < string.length() && !this.isAlphaNum(string.charAt(n)); ++n) {
        }
        if (n == string.length()) {
            return "";
        }
        string = string.substring(n);
        for (n = string.length() - 1; n >= 0 && !this.isAlphaNum(string.charAt(n)); --n) {
        }
        if (n == -1) {
            return "";
        }
        string = string.substring(0, n + 1);
        return string;
    }

    private void getWordItemWidthHeight(Graphics graphics, WordItem wordItem, Dimension dimension) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < wordItem.items.length; ++i) {
            FontMetrics fontMetrics = this.getFontMetrics(graphics, wordItem.items[i].info);
            this._drawer.getWidthHeight(wordItem.items[i].s, fontMetrics, dimension, this);
            n += dimension.width;
            int n3 = dimension.height;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        dimension.width = n;
        dimension.height = n2;
    }

    private void expandLines() {
        LineItem[] lineItemArray = new LineItem[this._lines.length * 2];
        System.arraycopy(this._lines, 0, lineItemArray, 0, this._lines.length);
        for (int i = this._lines.length; i < lineItemArray.length; ++i) {
            lineItemArray[i] = new LineItem();
        }
        this._lines = lineItemArray;
    }

    public int getHeight(DecodedLine decodedLine, Graphics graphics, int n, int n2, boolean bl) {
        WordItem[] wordItemArray = ((DecodedLineInternal)decodedLine).words;
        Font font = this._fontPlain;
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < wordItemArray.length; ++i) {
            WordItem wordItem = wordItemArray[i];
            this.getWordItemWidthHeight(graphics, wordItem, this._tmp);
            int n7 = this._tmp.width;
            if (n4 + n7 > n2 && n3 > 0 && bl) {
                n4 = this._drawer.getWidth("  ", fontMetrics, this);
                n3 = 0;
                n5 += n6;
                n6 = 0;
            }
            if (this._tmp.height > n6) {
                n6 = this._tmp.height;
            }
            ++n3;
            n4 += n7;
        }
        if (n3 > 0) {
            n5 += n6;
        }
        return n5;
    }

    public void draw(DecodedLine decodedLine, Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, DrawResult drawResult) {
        Object object;
        String string;
        String string2;
        String string3;
        int n6;
        int n7;
        int n8;
        int n9;
        LineItem lineItem;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        WordItem[] wordItemArray = ((DecodedLineInternal)decodedLine).words;
        if (drawResult.updateHandles == null) {
            drawResult.updateHandles = new Vector();
        } else if (drawResult.updateHandles.size() > 0) {
            drawResult.updateHandles.removeAllElements();
        }
        Font font = this._fontPlain;
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = n2 - n + 1;
        if (bl2) {
            n14 = 0;
            for (int i = 0; i < wordItemArray.length; ++i) {
                WordItem wordItem = wordItemArray[i];
                this.getWordItemWidthHeight(graphics, wordItem, this._tmp);
                n13 = this._tmp.width;
                if (n14 + n13 > n18 && n17 > 0) {
                    n14 = this._drawer.getWidth("  ", fontMetrics, this);
                    LineItem lineItem2 = this._lines[n15++];
                    if (n15 == this._lines.length) {
                        this.expandLines();
                    }
                    lineItem2.first = n16;
                    lineItem2.count = n17;
                    n16 = i;
                    n17 = 0;
                }
                ++n17;
                n14 += n13;
            }
            if (n17 != 0) {
                LineItem lineItem3 = this._lines[n15++];
                if (n15 == this._lines.length) {
                    this.expandLines();
                }
                lineItem3.first = n16;
                lineItem3.count = n17;
            }
        } else {
            LineItem lineItem4 = this._lines[n15++];
            lineItem4.first = 0;
            lineItem4.count = wordItemArray.length;
        }
        n14 = 0;
        if (bl) {
            n14 = wordItemArray.length;
        }
        if (drawResult.items == null || drawResult.items.length != n14) {
            drawResult.items = new DrawResultItem[n14];
        }
        DrawResultItem[] drawResultItemArray = drawResult.items;
        int n19 = n2;
        n13 = n;
        int n20 = 0;
        int n21 = 0;
        int n22 = this._drawer.getWidth("  ", fontMetrics, this);
        int n23 = 1;
        if (this._hdirection == 1) {
            n23 = -1;
        }
        if (this._vdirection == 0) {
            for (n12 = n15 - 1; n12 >= 0; --n12) {
                n11 = n;
                if (n23 == -1) {
                    n11 = n2;
                }
                n10 = 0;
                if (n12 != 0) {
                    n11 += n23 * n22;
                }
                lineItem = this._lines[n12];
                for (n9 = lineItem.first; n9 < lineItem.first + lineItem.count; ++n9) {
                    this.getWordItemWidthHeight(graphics, wordItemArray[n9], this._tmp);
                    n8 = this._tmp.width;
                    n7 = this._tmp.height;
                    if (n23 == -1) {
                        n11 -= n8;
                    }
                    n6 = n8;
                    if (n10 < n7) {
                        n10 = n7;
                    }
                    if (n11 + n8 > n4 && n11 <= n5) {
                        this.drawWord(graphics, wordItemArray[n9], n11, n3, n9 == lineItem.first + lineItem.count - 1, fontMetrics, n4, n5, this, drawResult.updateHandles);
                    }
                    if (bl) {
                        string3 = wordItemArray[n9].originalword;
                        string2 = wordItemArray[n9].originalstrippedword;
                        string = this.trimAlphaNum(string2.trim());
                        if (drawResultItemArray[n9] == null) {
                            drawResultItemArray[n9] = new DrawResultItem();
                        }
                        object = drawResultItemArray[n9];
                        ((DrawResultItem)object).parent = drawResult;
                        ((DrawResultItem)object).item = string;
                        ((DrawResultItem)object).originalword = string3;
                        ((DrawResultItem)object).originalstrippedword = string2;
                        ((DrawResultItem)object).rectangle = new StyledRectangle(n11, n21 - n7, n6, n7);
                    }
                    if (n23 == 1) {
                        n11 += n8;
                    }
                    if (n11 > n13) {
                        n13 = n11;
                    }
                    if (n11 >= n19) continue;
                    n19 = n11;
                }
                n3 -= n10;
                n21 -= n10;
                n20 += n10;
            }
            if (bl) {
                for (n12 = 0; n12 < drawResultItemArray.length; ++n12) {
                    drawResultItemArray[n12].rectangle.y += n20;
                }
            }
        } else if (this._vdirection == 1) {
            for (n12 = 0; n12 < n15; ++n12) {
                n11 = n;
                if (n23 == -1) {
                    n11 = n2;
                }
                n10 = 0;
                if (n12 != 0) {
                    n11 += n23 * n22;
                }
                lineItem = this._lines[n12];
                for (n9 = lineItem.first; n9 < lineItem.first + lineItem.count; ++n9) {
                    this.getWordItemWidthHeight(graphics, wordItemArray[n9], this._tmp);
                    n8 = this._tmp.width;
                    n7 = this._tmp.height;
                    if (n23 == -1) {
                        n11 -= n8;
                    }
                    n6 = n8;
                    if (n10 < n7) {
                        n10 = n7;
                    }
                    if (n11 + n8 > n4 && n11 <= n5) {
                        this.drawWord(graphics, wordItemArray[n9], n11, n3 + n7, n9 == lineItem.first + lineItem.count - 1, fontMetrics, n4, n5, this, drawResult.updateHandles);
                    }
                    if (bl) {
                        string3 = wordItemArray[n9].decodedword;
                        string2 = wordItemArray[n9].originalword;
                        string = wordItemArray[n9].originalstrippedword;
                        object = this.trimAlphaNum(string3.trim());
                        if (drawResultItemArray[n9] == null) {
                            drawResultItemArray[n9] = new DrawResultItem();
                        }
                        DrawResultItem drawResultItem = drawResultItemArray[n9];
                        drawResultItem.parent = drawResult;
                        drawResultItem.item = object;
                        drawResultItem.originalword = string2;
                        drawResultItem.originalstrippedword = string;
                        drawResultItem.rectangle = new StyledRectangle(n11, n21, n6, n7);
                    }
                    if (n23 == 1) {
                        n11 += n8;
                    }
                    if (n11 > n13) {
                        n13 = n11;
                    }
                    if (n11 >= n19) continue;
                    n19 = n11;
                }
                n3 += n10;
                n21 += n10;
                n20 += n10;
            }
            n3 -= n20;
        }
        n12 = n;
        n11 = n13;
        if (n23 == -1) {
            n12 = n19;
            n11 = n2;
        }
        if (bl) {
            for (n10 = 0; n10 < drawResult.items.length; ++n10) {
                drawResult.items[n10].rectangle.x -= n12;
            }
        }
        if (drawResult.rectangle == null) {
            drawResult.rectangle = new StyledRectangle(n12, n3, n11 - n12 + 1, n20);
        } else {
            drawResult.rectangle.x = n12;
            drawResult.rectangle.y = n3;
            drawResult.rectangle.width = n11 - n12 + 1;
            drawResult.rectangle.height = n20;
        }
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x40) != 0) {
            return false;
        }
        if ((n & 0x80) != 0) {
            return false;
        }
        if ((n & 4) != 0) {
            return true;
        }
        if (this._listener != null) {
            int n6 = 0;
            if ((n & 1) != 0) {
                n6 |= 2;
            }
            if ((n & 2) != 0) {
                n6 |= 2;
            }
            if ((n & 0x20) != 0) {
                n6 |= 1;
            }
            if ((n & 0x10) != 0) {
                n6 |= 4;
            }
            if ((n & 8) != 0) {
                n6 |= 1;
            }
            try {
                Boolean bl = (Boolean)EventDispatcher.dispatchEventAsyncAndWaitEx(this._listener, "displayUpdated", new Object[]{image, new Integer(n6)});
                return bl;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

