/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import org.jdesktop.swingx.AbstractLayoutManager;
import org.jdesktop.swingx.util.Separator;

public class HorizontalLayout
extends AbstractLayoutManager {
    private static final long serialVersionUID = 8640046926840737487L;
    private int gap;

    public HorizontalLayout() {
        this(0);
    }

    public HorizontalLayout(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.height - insets.top - insets.bottom;
        int n2 = insets.left;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            component.setBounds(n2, insets.top, component.getPreferredSize().width, n);
            n2 += component.getSize().width + this.gap;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Separator<Integer> separator = new Separator<Integer>(0, this.gap);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = container.getComponent(i).getPreferredSize();
            dimension.height = Math.max(dimension.height, dimension2.height);
            dimension.width += dimension2.width + separator.get();
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

