/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jdesktop.swingx.AlphaPaintable;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class JXCollapsiblePane
extends JPanel {
    private static final long serialVersionUID = 3039665720460053394L;
    @Deprecated
    public static final String ANIMATION_STATE_KEY = "animationState";
    public static final String TOGGLE_ACTION = "toggle";
    public static final String COLLAPSE_ICON = "collapseIcon";
    public static final String EXPAND_ICON = "expandIcon";
    private boolean collapsed = false;
    private Direction direction = Direction.UP;
    private Timer animateTimer;
    private AnimationListener animator;
    private int currentDimension = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;
    private boolean collapseFiringState;

    public JXCollapsiblePane() {
        this(Direction.UP, new BorderLayout(0, 0));
    }

    public JXCollapsiblePane(Direction direction) {
        this(direction, new BorderLayout(0, 0));
    }

    public JXCollapsiblePane(LayoutManager layoutManager) {
        this(Direction.UP, layoutManager);
    }

    public JXCollapsiblePane(Direction direction, LayoutManager layoutManager) {
        super.setLayout(layoutManager);
        this.direction = direction;
        this.animator = new AnimationListener();
        this.setAnimationParams(new AnimationParams(30, 8, 0.01f, 1.0f));
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        this.setDirection(direction);
        this.getActionMap().put(TOGGLE_ACTION, new ToggleAction());
    }

    public void setContentPane(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            assert (super.getComponent(0) == this.wrapper);
            super.remove(0);
        }
        this.wrapper = new WrapperContainer(container);
        this.wrapper.collapsedState = this.isCollapsed();
        this.wrapper.getView().setVisible(!this.wrapper.collapsedState);
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        if (this.wrapper == null) {
            return null;
        }
        return (Container)this.wrapper.getView();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(layoutManager);
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        this.getContentPane().add(component, object, n);
    }

    @Override
    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    @Override
    public void remove(int n) {
        this.getContentPane().remove(n);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean bl) {
        if (bl != this.useAnimation) {
            this.useAnimation = bl;
            if (!bl) {
                if (this.animateTimer.isRunning()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JXCollapsiblePane.this.currentDimension = -1;
                        }
                    });
                } else {
                    this.currentDimension = -1;
                }
            }
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (this.animateTimer.isRunning()) {
            throw new IllegalStateException("cannot be change component orientation while collapsing.");
        }
        super.setComponentOrientation(componentOrientation);
    }

    public void setDirection(Direction direction) {
        if (this.animateTimer.isRunning()) {
            throw new IllegalStateException("cannot be change direction while collapsing.");
        }
        Direction direction2 = this.getDirection();
        this.direction = direction;
        if (direction.isVertical()) {
            this.getContentPane().setLayout(new VerticalLayout(2));
        } else {
            this.getContentPane().setLayout(new HorizontalLayout(2));
        }
        this.firePropertyChange("direction", (Object)direction2, (Object)this.getDirection());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean bl) {
        boolean bl2 = this.isCollapsed();
        this.collapsed = bl;
        if (this.isAnimated() && this.isShowing()) {
            if (bl2 == this.isCollapsed()) {
                return;
            }
            if (!this.animateTimer.isRunning()) {
                this.collapseFiringState = bl2;
            }
            if (bl2) {
                int n = this.direction.isVertical() ? this.wrapper.getHeight() : this.wrapper.getWidth();
                int n2 = this.direction.isVertical() ? this.getContentPane().getPreferredSize().height : this.getContentPane().getPreferredSize().width;
                int n3 = Math.max(8, n2 / 10);
                this.setAnimationParams(new AnimationParams(30, n3, 0.01f, 1.0f));
                this.animator.reinit(n, n2);
                this.wrapper.getView().setVisible(true);
            } else {
                int n = this.direction.isVertical() ? this.wrapper.getHeight() : this.wrapper.getWidth();
                this.setAnimationParams(new AnimationParams(30, Math.max(8, n / 10), 1.0f, 0.01f));
                this.animator.reinit(n, 0);
            }
            this.animateTimer.start();
        } else {
            this.wrapper.collapsedState = this.isCollapsed();
            this.wrapper.getView().setVisible(!this.isCollapsed());
            this.revalidate();
            this.repaint();
            this.firePropertyChange("collapsed", bl2, this.isCollapsed());
        }
    }

    @Override
    public Border getBorder() {
        if (this.getContentPane() instanceof JComponent) {
            return ((JComponent)this.getContentPane()).getBorder();
        }
        return null;
    }

    @Override
    public void setBorder(Border border) {
        if (this.getContentPane() instanceof JComponent) {
            ((JComponent)this.getContentPane()).setBorder(border);
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.wrapper != null) {
            this.wrapper.setOpaque(bl);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.getContentPane().setMinimumSize(dimension);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getContentPane().getPreferredSize();
        if (this.currentDimension != -1) {
            if (this.direction.isVertical()) {
                dimension.height = this.currentDimension;
            } else {
                dimension.width = this.currentDimension;
            }
        } else if (this.wrapper.collapsedState) {
            if (this.direction.isVertical()) {
                dimension.height = 0;
            } else {
                dimension.width = 0;
            }
        }
        return dimension;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.getContentPane().setPreferredSize(dimension);
    }

    private void setAnimationParams(AnimationParams animationParams) {
        if (animationParams == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = animationParams;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class WrapperContainer
    extends JViewport
    implements AlphaPaintable {
        private static final long serialVersionUID = -2262485900408769978L;
        boolean collapsedState = false;
        private float alpha = 1.0f;
        private boolean oldOpaque;

        public WrapperContainer(Container container) {
            this.setView(container);
            if (container instanceof JComponent && !container.isOpaque()) {
                ((JComponent)container).setOpaque(true);
            }
        }

        @Override
        public void scrollRectToVisible(Rectangle rectangle) {
            JXCollapsiblePane.this.scrollRectToVisible(rectangle);
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public void setAlpha(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException("invalid alpha value " + f);
            }
            float f2 = this.getAlpha();
            this.alpha = f;
            if (this.getAlpha() < 1.0f) {
                if (f2 == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
            } else if (this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", f2, this.getAlpha());
            this.repaint();
        }

        @Override
        public boolean isInheritAlpha() {
            return false;
        }

        @Override
        public void setInheritAlpha(boolean bl) {
        }

        @Override
        public float getEffectiveAlpha() {
            return this.getAlpha();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            if (this.getAlpha() == 1.0f) {
                super.paint(graphics);
            } else {
                BufferedImage bufferedImage = GraphicsUtilities.createCompatibleTranslucentImage(this.getWidth(), this.getHeight());
                Graphics2D graphics2D = bufferedImage.createGraphics();
                try {
                    super.paint(graphics2D);
                }
                finally {
                    graphics2D.dispose();
                }
                Graphics2D graphics2D2 = (Graphics2D)graphics;
                Composite composite = graphics2D2.getComposite();
                try {
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.getEffectiveAlpha());
                    graphics2D2.setComposite(alphaComposite);
                    graphics2D2.drawImage(bufferedImage, null, 0, 0);
                }
                finally {
                    graphics2D2.setComposite(composite);
                }
            }
        }
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object ANIMATION_MUTEX = "Animation Synchronization Mutex";
        private int startDimension = 0;
        private int finalDimension = 0;
        private float animateAlpha = 1.0f;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                if (this.startDimension == this.finalDimension) {
                    JXCollapsiblePane.this.animateTimer.stop();
                    this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    if (this.finalDimension > 0) {
                        JXCollapsiblePane.this.currentDimension = -1;
                        ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.collapsedState = false;
                        this.validate();
                        JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "expanded");
                        JXCollapsiblePane.this.firePropertyChange("collapsed", JXCollapsiblePane.this.collapseFiringState, false);
                        return;
                    }
                    ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.collapsedState = true;
                    JXCollapsiblePane.this.wrapper.getView().setVisible(false);
                    JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "collapsed");
                    JXCollapsiblePane.this.firePropertyChange("collapsed", JXCollapsiblePane.this.collapseFiringState, true);
                }
                boolean bl = this.startDimension > this.finalDimension;
                int n = bl ? -1 * ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.delta : ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.delta;
                int n2 = JXCollapsiblePane.this.direction.isVertical() ? JXCollapsiblePane.this.wrapper.getHeight() + n : JXCollapsiblePane.this.wrapper.getWidth() + n;
                if (bl) {
                    if (n2 < this.finalDimension) {
                        n2 = this.finalDimension;
                    }
                } else if (n2 > this.finalDimension) {
                    n2 = this.finalDimension;
                }
                int n3 = JXCollapsiblePane.this.direction.isVertical() ? ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().height : ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().width;
                this.animateAlpha = (float)n2 / (float)n3;
                Rectangle rectangle = JXCollapsiblePane.this.wrapper.getBounds();
                if (JXCollapsiblePane.this.direction.isVertical()) {
                    int n4 = rectangle.height;
                    rectangle.height = n2;
                    JXCollapsiblePane.this.wrapper.setBounds(rectangle);
                    if (JXCollapsiblePane.this.direction.getFixedDirection(JXCollapsiblePane.this.getComponentOrientation()) == Direction.DOWN) {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(0, ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().height - n2));
                    } else {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(0, n2));
                    }
                    rectangle = JXCollapsiblePane.this.getBounds();
                    rectangle.height = rectangle.height - n4 + n2;
                    JXCollapsiblePane.this.currentDimension = rectangle.height;
                } else {
                    int n5 = rectangle.width;
                    rectangle.width = n2;
                    JXCollapsiblePane.this.wrapper.setBounds(rectangle);
                    if (JXCollapsiblePane.this.direction.getFixedDirection(JXCollapsiblePane.this.getComponentOrientation()) == Direction.RIGHT) {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().width - n2, 0));
                    } else {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(n2, 0));
                    }
                    rectangle = JXCollapsiblePane.this.getBounds();
                    rectangle.width = rectangle.width - n5 + n2;
                    JXCollapsiblePane.this.currentDimension = rectangle.width;
                }
                JXCollapsiblePane.this.setBounds(rectangle);
                this.startDimension = n2;
                if (bl) {
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                JXCollapsiblePane.this.wrapper.setAlpha(this.animateAlpha);
                this.validate();
            }
        }

        void validate() {
            Container container = SwingUtilities.getAncestorOfClass(CollapsiblePaneContainer.class, JXCollapsiblePane.this);
            container = container != null ? ((CollapsiblePaneContainer)((Object)container)).getValidatingContainer() : JXCollapsiblePane.this.getParent();
            if (container != null) {
                if (container instanceof JComponent) {
                    ((JComponent)container).revalidate();
                } else {
                    container.invalidate();
                }
                container.doLayout();
                container.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int n, int n2) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                JXCollapsiblePane.this.firePropertyChange(JXCollapsiblePane.ANIMATION_STATE_KEY, null, "reinit");
                this.startDimension = n;
                this.finalDimension = n2;
                this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                JXCollapsiblePane.this.currentDimension = -1;
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int delta;
        final float alphaStart;
        final float alphaEnd;

        public AnimationParams(int n, int n2, float f, float f2) {
            this.waitTime = n;
            this.delta = n2;
            this.alphaStart = f;
            this.alphaEnd = f2;
        }
    }

    public static interface CollapsiblePaneContainer {
        public Container getValidatingContainer();
    }

    private class ToggleAction
    extends AbstractAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = -3917511031133382497L;

        public ToggleAction() {
            super(JXCollapsiblePane.TOGGLE_ACTION);
            JXCollapsiblePane.this.addPropertyChangeListener("collapsed", this);
        }

        @Override
        public void putValue(String string, Object object) {
            super.putValue(string, object);
            if (JXCollapsiblePane.EXPAND_ICON.equals(string) || JXCollapsiblePane.COLLAPSE_ICON.equals(string)) {
                this.updateIcon();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JXCollapsiblePane.this.setCollapsed(!JXCollapsiblePane.this.isCollapsed());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateIcon();
        }

        void updateIcon() {
            if (JXCollapsiblePane.this.isCollapsed()) {
                this.putValue("SmallIcon", this.getValue(JXCollapsiblePane.EXPAND_ICON));
            } else {
                this.putValue("SmallIcon", this.getValue(JXCollapsiblePane.COLLAPSE_ICON));
            }
        }
    }

    public static enum Direction {
        LEFT(false),
        RIGHT(false),
        UP(true),
        DOWN(true),
        LEADING(false){

            @Override
            Direction getFixedDirection(ComponentOrientation componentOrientation) {
                return componentOrientation.isLeftToRight() ? LEFT : RIGHT;
            }
        }
        ,
        TRAILING(false){

            @Override
            Direction getFixedDirection(ComponentOrientation componentOrientation) {
                return componentOrientation.isLeftToRight() ? RIGHT : LEFT;
            }
        }
        ,
        START(true){

            @Override
            Direction getFixedDirection(ComponentOrientation componentOrientation) {
                return UP;
            }
        }
        ,
        END(true){

            @Override
            Direction getFixedDirection(ComponentOrientation componentOrientation) {
                return DOWN;
            }
        };

        private final boolean vertical;

        private Direction(boolean bl) {
            this.vertical = bl;
        }

        public boolean isVertical() {
            return this.vertical;
        }

        Direction getFixedDirection(ComponentOrientation componentOrientation) {
            return this;
        }
    }
}

