/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import org.jdesktop.swingx.AbstractLayoutManager;
import org.jdesktop.swingx.util.Separator;

public class VerticalLayout
extends AbstractLayoutManager {
    private static final long serialVersionUID = 5342270033773736441L;
    private int gap;

    public VerticalLayout() {
        this(0);
    }

    public VerticalLayout(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Separator<Integer> separator = new Separator<Integer>(0, this.gap);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = container.getComponent(i).getPreferredSize();
            dimension.height += dimension2.height + separator.get();
            dimension.width = Math.max(dimension.width, dimension2.width);
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.width - insets.left - insets.right;
        int n2 = insets.top;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            component.setBounds(insets.left, n2, n, component.getPreferredSize().height);
            n2 += component.getSize().height + this.gap;
        }
    }
}

