/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public final class ShapeUtils {
    private ShapeUtils() {
    }

    public static Shape generatePolygon(int n, int n2, boolean bl) {
        return ShapeUtils.generatePolygon(n, n2, 0, bl);
    }

    public static Shape generatePolygon(int n, int n2, int n3, boolean bl) {
        Shape shape = ShapeUtils.generatePolygon(n, n2, n3);
        if (bl) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            GeneralPath generalPath = new GeneralPath(shape);
            shape = generalPath.createTransformedShape(AffineTransform.getTranslateInstance(-rectangle2D.getX(), -rectangle2D.getY()));
        }
        return shape;
    }

    public static Shape generatePolygon(int n, int n2, int n3) {
        if (n < 3) {
            return new Ellipse2D.Float(0.0f, 0.0f, 10.0f, 10.0f);
        }
        AffineTransform affineTransform = new AffineTransform();
        Polygon polygon = new Polygon();
        for (int i = 0; i < n; ++i) {
            affineTransform.rotate(Math.PI * 2 / (double)n / 2.0);
            Point2D point2D = affineTransform.transform(new Point2D.Float(0.0f, n2), null);
            polygon.addPoint((int)point2D.getX(), (int)point2D.getY());
            affineTransform.rotate(Math.PI * 2 / (double)n / 2.0);
            if (n3 <= 0) continue;
            Point2D point2D2 = affineTransform.transform(new Point2D.Float(0.0f, n3), null);
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
        }
        return polygon;
    }

    public static Shape generateShapeFromText(Font font, char c) {
        return ShapeUtils.generateShapeFromText(font, String.valueOf(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shape generateShapeFromText(Font font, String string) {
        BufferedImage bufferedImage = GraphicsUtilities.createCompatibleTranslucentImage(1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            Shape shape;
            GlyphVector glyphVector = font.createGlyphVector(graphics2D.getFontRenderContext(), string);
            Shape shape2 = shape = glyphVector.getOutline(0.0f, (float)(-glyphVector.getVisualBounds().getY()));
            return shape2;
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static Shape mergeClip(Graphics graphics, Shape shape) {
        Shape shape2 = graphics.getClip();
        if (shape2 == null) {
            graphics.setClip(shape);
            return null;
        }
        Area area = new Area(shape2);
        area.intersect(new Area(shape));
        graphics.setClip(area);
        return shape2;
    }
}

