/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.Coordinates;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.HeightCoordinatesImpl;
import java.io.DataOutputStream;
import java.io.IOException;

public class VivaldiPositionImpl
implements VivaldiPosition {
    private static final float cc = 0.25f;
    private static final float ce = 0.5f;
    private static final float initial_error = 10.0f;
    private HeightCoordinatesImpl coordinates;
    private float error;
    private int nbUpdates;

    public VivaldiPositionImpl(HeightCoordinatesImpl heightCoordinatesImpl) {
        this.coordinates = heightCoordinatesImpl;
        this.error = 10.0f;
    }

    @Override
    public byte getPositionType() {
        return 1;
    }

    @Override
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public double[] getLocation() {
        Coordinates coordinates = this.getCoordinates();
        return coordinates.getCoordinates();
    }

    @Override
    public float getErrorEstimate() {
        return this.error;
    }

    @Override
    public void setErrorEstimate(float f) {
        this.error = f;
    }

    @Override
    public void update(float f, Coordinates coordinates, float f2) {
        if (this.valid(f) && this.valid(f2) && coordinates.isValid()) {
            if (f <= 0.0f || f > 300000.0f) {
                return;
            }
            if (this.error + f2 == 0.0f) {
                return;
            }
            float f3 = this.error / (f2 + this.error);
            float f4 = f - this.coordinates.distance(coordinates);
            float f5 = Math.abs(f4) / f;
            float f6 = f5 * 0.5f * f3 + this.error * (1.0f - 0.5f * f3);
            float f7 = 0.25f * f3;
            float f8 = f7 * f4;
            HeightCoordinatesImpl heightCoordinatesImpl = new HeightCoordinatesImpl((float)Math.random() / 10.0f, (float)Math.random() / 10.0f, 0.0f);
            HeightCoordinatesImpl heightCoordinatesImpl2 = (HeightCoordinatesImpl)this.coordinates.add(this.coordinates.sub(coordinates.add(heightCoordinatesImpl)).unity().scale(f8));
            if (this.valid(f6) && heightCoordinatesImpl2.isValid()) {
                this.coordinates = heightCoordinatesImpl2;
                this.error = f6 > 0.1f ? f6 : 0.1f;
            } else {
                this.coordinates = new HeightCoordinatesImpl(0.0f, 0.0f, 0.0f);
                this.error = 10.0f;
            }
            if (!coordinates.atOrigin()) {
                ++this.nbUpdates;
            }
            if (this.nbUpdates > 5) {
                this.nbUpdates = 0;
                this.update(10.0f, new HeightCoordinatesImpl(0.0f, 0.0f, 0.0f), 50.0f);
            }
        }
    }

    @Override
    public boolean isValid() {
        return !Float.isNaN(this.getErrorEstimate()) && this.getCoordinates().isValid();
    }

    private boolean valid(float f) {
        return !Float.isInfinite(f) && !Float.isNaN(f);
    }

    @Override
    public void update(float f, float[] fArray) {
        this.update(f, new HeightCoordinatesImpl(fArray[0], fArray[1], fArray[2]), fArray[3]);
    }

    @Override
    public float estimateRTT(Coordinates coordinates) {
        return this.coordinates.distance(coordinates);
    }

    @Override
    public float[] toFloatArray() {
        return new float[]{this.coordinates.getX(), this.coordinates.getY(), this.coordinates.getH(), this.error};
    }

    @Override
    public void fromFloatArray(float[] fArray) {
        this.coordinates = new HeightCoordinatesImpl(fArray[0], fArray[1], fArray[2]);
        this.error = fArray[3];
    }

    public String toString() {
        return this.coordinates + " : " + this.error;
    }

    public boolean equals(Object object) {
        if (object instanceof VivaldiPositionImpl) {
            VivaldiPositionImpl vivaldiPositionImpl = (VivaldiPositionImpl)object;
            if (vivaldiPositionImpl.error != this.error) {
                return false;
            }
            return vivaldiPositionImpl.coordinates.equals(this.coordinates);
        }
        return false;
    }

    @Override
    public float estimateRTT(DHTNetworkPosition dHTNetworkPosition) {
        VivaldiPosition vivaldiPosition = (VivaldiPosition)dHTNetworkPosition;
        Coordinates coordinates = vivaldiPosition.getCoordinates();
        if (this.coordinates.atOrigin() || coordinates.atOrigin()) {
            return Float.NaN;
        }
        return this.estimateRTT(coordinates);
    }

    @Override
    public void update(byte[] byArray, DHTNetworkPosition dHTNetworkPosition, float f) {
        VivaldiPositionImpl vivaldiPositionImpl = (VivaldiPositionImpl)dHTNetworkPosition;
        Coordinates coordinates = vivaldiPositionImpl.getCoordinates();
        this.update(f, coordinates, vivaldiPositionImpl.getErrorEstimate());
    }

    @Override
    public int getSerialisedSize() {
        return 16;
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        float[] fArray = this.toFloatArray();
        for (int i = 0; i < fArray.length; ++i) {
            dataOutputStream.writeFloat(fArray[i]);
        }
    }
}

