/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestFindNode
extends DHTUDPPacketRequest {
    private byte[] id;
    private int node_status;
    private int estimated_dht_size;

    public DHTUDPPacketRequestFindNode(DHTTransportUDPImpl dHTTransportUDPImpl, long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportUDPContactImpl dHTTransportUDPContactImpl2) {
        super(dHTTransportUDPImpl, 1028, l, dHTTransportUDPContactImpl, dHTTransportUDPContactImpl2);
    }

    protected DHTUDPPacketRequestFindNode(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, DataInputStream dataInputStream, long l, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, dataInputStream, 1028, l, n);
        this.id = DHTUDPUtils.deserialiseByteArray(dataInputStream, 64);
        if (this.getProtocolVersion() >= 22) {
            this.node_status = dataInputStream.readInt();
            this.estimated_dht_size = dataInputStream.readInt();
        }
        super.postDeserialise(dataInputStream);
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        DHTUDPUtils.serialiseByteArray(dataOutputStream, this.id, 64);
        if (this.getProtocolVersion() >= 22) {
            dataOutputStream.writeInt(this.node_status);
            dataOutputStream.writeInt(this.estimated_dht_size);
        }
        super.postSerialise(dataOutputStream);
    }

    protected void setID(byte[] byArray) {
        this.id = byArray;
    }

    protected byte[] getID() {
        return this.id;
    }

    protected void setNodeStatus(int n) {
        this.node_status = n;
    }

    protected int getNodeStatus() {
        return this.node_status;
    }

    protected void setEstimatedDHTSize(int n) {
        this.estimated_dht_size = n;
    }

    protected int getEstimatedDHTSize() {
        return this.estimated_dht_size;
    }

    @Override
    public String getString() {
        return super.getString();
    }
}

