/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestKeyBlock
extends DHTUDPPacketRequest {
    private int random_id;
    private byte[] key_block_request;
    private byte[] key_block_signature;

    public DHTUDPPacketRequestKeyBlock(DHTTransportUDPImpl dHTTransportUDPImpl, long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportUDPContactImpl dHTTransportUDPContactImpl2) {
        super(dHTTransportUDPImpl, 1036, l, dHTTransportUDPContactImpl, dHTTransportUDPContactImpl2);
    }

    protected DHTUDPPacketRequestKeyBlock(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, DataInputStream dataInputStream, long l, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, dataInputStream, 1036, l, n);
        this.random_id = dataInputStream.readInt();
        this.key_block_request = DHTUDPUtils.deserialiseByteArray(dataInputStream, 255);
        this.key_block_signature = DHTUDPUtils.deserialiseByteArray(dataInputStream, 65535);
        super.postDeserialise(dataInputStream);
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.writeInt(this.random_id);
        DHTUDPUtils.serialiseByteArray(dataOutputStream, this.key_block_request, 255);
        DHTUDPUtils.serialiseByteArray(dataOutputStream, this.key_block_signature, 65535);
        super.postSerialise(dataOutputStream);
    }

    public void setKeyBlockDetails(byte[] byArray, byte[] byArray2) {
        this.key_block_request = byArray;
        this.key_block_signature = byArray2;
    }

    protected void setRandomID(int n) {
        this.random_id = n;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    public byte[] getKeyBlockRequest() {
        return this.key_block_request;
    }

    public byte[] getKeyBlockSignature() {
        return this.key_block_signature;
    }

    @Override
    public String getString() {
        return super.getString();
    }
}

