/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.ClientMessageContextImpl;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.MapUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;

public class PlatformMessenger {
    private static final boolean DEBUG_URL = System.getProperty("platform.messenger.debug.url", "0").equals("1");
    private static final String URL_PLATFORM_MESSAGE = "?service=rpc";
    private static final String URL_POST_PLATFORM_DATA = "service=rpc";
    private static final int MAX_POST_LENGTH = 0x180000;
    private static boolean USE_HTTP_POST = true;
    public static String REPLY_EXCEPTION = "exception";
    public static String REPLY_ACTION = "action";
    public static String REPLY_RESULT = "response";
    private static Map<String, Map> mapQueues = new HashMap<String, Map>();
    private static final String QUEUE_NOAZID = "noazid.";
    private static final String QUEUE_NORMAL = "msg.";
    private static AEMonitor queue_mon = new AEMonitor("v3.PlatformMessenger.queue");
    private static Timer timerProcess = new Timer("v3.PlatformMessenger.queue");
    private static Map<String, TimerEvent> mapTimerEvents = new HashMap<String, TimerEvent>();
    private static AEMonitor mon_mapTimerEvents = new AEMonitor("mapTimerEvents");
    private static boolean initialized;
    private static fakeContext context;
    private static boolean allowMulti;
    private static AsyncDispatcher dispatcher;
    private static Map<String, Object> mapExtra;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        context = new fakeContext();
    }

    public static ClientMessageContext getClientMessageContext() {
        if (!initialized) {
            PlatformMessenger.init();
        }
        return context;
    }

    public static void queueMessage(PlatformMessage platformMessage, PlatformMessengerListener platformMessengerListener) {
        PlatformMessenger.queueMessage(platformMessage, platformMessengerListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueMessage(PlatformMessage platformMessage, PlatformMessengerListener platformMessengerListener, boolean bl) {
        block16: {
            if (!initialized) {
                PlatformMessenger.init();
            }
            if (platformMessage == null) {
                PlatformMessenger.debug("fire timerevent");
            }
            queue_mon.enter();
            try {
                long l;
                String string = null;
                if (platformMessage != null) {
                    long l2 = platformMessage.getContentNetworkID();
                    if (l2 <= 0L) {
                        PlatformMessenger.debug("Content Network invalid for " + platformMessage);
                        return;
                    }
                    string = !platformMessage.sendAZID() ? QUEUE_NOAZID : QUEUE_NORMAL;
                    LinkedHashMap<PlatformMessage, PlatformMessengerListener> linkedHashMap = mapQueues.get(string = string + l2);
                    if (linkedHashMap == null) {
                        linkedHashMap = new LinkedHashMap<PlatformMessage, PlatformMessengerListener>();
                        mapQueues.put(string, linkedHashMap);
                    }
                    linkedHashMap.put(platformMessage, platformMessengerListener);
                    PlatformMessenger.debug("q " + string + "(" + linkedHashMap.size() + ") " + platformMessage.toShortString() + ": " + platformMessage + " @ " + new Date(platformMessage.getFireBefore()) + "; in " + (platformMessage.getFireBefore() - SystemTime.getCurrentTime()) + "ms");
                    l = platformMessage.getFireBefore();
                } else {
                    l = SystemTime.getCurrentTime();
                }
                if (string == null) break block16;
                try {
                    mon_mapTimerEvents.enter();
                    TimerEvent timerEvent2 = mapTimerEvents.get(string);
                    if (timerEvent2 == null || timerEvent2.hasRun() || l < timerEvent2.getWhen()) {
                        if (timerEvent2 != null) {
                            mapTimerEvents.remove(timerEvent2);
                            timerEvent2.cancel();
                        }
                        final String string2 = string;
                        timerEvent2 = timerProcess.addEvent(l, new TimerEventPerformer(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform(TimerEvent timerEvent2) {
                                try {
                                    mon_mapTimerEvents.enter();
                                    mapTimerEvents.remove(timerEvent2);
                                }
                                finally {
                                    mon_mapTimerEvents.exit();
                                }
                                Map map = (Map)mapQueues.get(string2);
                                while (map != null && map.size() > 0) {
                                    PlatformMessenger.processQueue(string2, map);
                                }
                            }
                        });
                        mapTimerEvents.put(string, timerEvent2);
                    }
                    if (timerEvent2 != null) {
                        PlatformMessenger.debug(" next q process for  " + string + " in " + (timerEvent2.getWhen() - SystemTime.getCurrentTime()));
                    }
                }
                finally {
                    mon_mapTimerEvents.exit();
                }
            }
            finally {
                queue_mon.exit();
            }
        }
    }

    public static void debug(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.PMsgr");
        aEDiagnosticsLogger.log(string);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    protected static void debug(String string, Throwable throwable) {
        PlatformMessenger.debug(string + "\n\t" + throwable.getClass().getName() + ": " + throwable.getMessage() + ", " + Debug.getCompressedStackTrace(throwable, 1, 80));
    }

    public static void pushMessageNow(PlatformMessage platformMessage, PlatformMessengerListener platformMessengerListener) {
        PlatformMessenger.debug("push " + platformMessage.toShortString() + ": " + platformMessage);
        HashMap<PlatformMessage, PlatformMessengerListener> hashMap = new HashMap<PlatformMessage, PlatformMessengerListener>(1);
        hashMap.put(platformMessage, platformMessengerListener);
        PlatformMessenger.processQueue(null, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processQueue(String string, Map map) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (!initialized) {
            PlatformMessenger.init();
        }
        HashMap hashMap = new HashMap();
        boolean bl = true;
        long l = 1L;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("azid", ConstantsVuze.AZID);
        hashMap2.put("azv", "4.5.0.4");
        hashMap2.putAll(mapExtra);
        ArrayList arrayList = new ArrayList();
        hashMap2.put("commands", arrayList);
        queue_mon.enter();
        try {
            object6 = null;
            boolean bl3 = true;
            object5 = map.keySet().iterator();
            while (object5.hasNext()) {
                object4 = (PlatformMessage)object5.next();
                object3 = map.get(object4);
                object2 = new HashMap<String, Object>();
                if (bl3) {
                    bl = ((PlatformMessage)object4).sendAZID();
                    l = ((PlatformMessage)object4).getContentNetworkID();
                    bl3 = false;
                }
                ((PlatformMessage)object4).setSequenceNo(l2);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('&');
                }
                object = ((PlatformMessage)object4).getListenerID();
                String string2 = ((PlatformMessage)object4).getMessageID();
                Map map2 = ((PlatformMessage)object4).getParameters();
                try {
                    stringBuffer.append("msg=");
                    stringBuffer.append(URLEncoder.encode((String)object, "UTF-8"));
                    stringBuffer.append(":");
                    stringBuffer.append(URLEncoder.encode(((PlatformMessage)object4).getOperationID(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                object2.put("seq-id", l2);
                object2.put("listener-id", object);
                object2.put("op-id", ((PlatformMessage)object4).getOperationID());
                if (map2 != null) {
                    object2.put("values", map2);
                }
                arrayList.add(object2);
                if (l2 > 10L) {
                    PlatformMessenger.debug("breaking up batch at " + l2 + " because max limit would be exceeded");
                } else {
                    String string3 = string2 + "-" + (String)object;
                    if (object6 != null && !((String)object6).equals(string3)) {
                        bl2 = true;
                    }
                    object6 = string3;
                    PlatformMessengerListener platformMessengerListener = (PlatformMessengerListener)hashMap.get(object4);
                    if (platformMessengerListener != null) {
                        platformMessengerListener.messageSent((PlatformMessage)object4);
                    }
                    ++l2;
                    hashMap.put(object4, object3);
                    object5.remove();
                    if (PlatformMessenger.getAllowMulti()) continue;
                }
                break;
            }
        }
        finally {
            queue_mon.exit();
        }
        if (hashMap.size() == 0) {
            return;
        }
        object6 = ContentNetworkManagerFactory.getSingleton().getContentNetwork(l);
        if (object6 == null) {
            object6 = ConstantsVuze.getDefaultContentNetwork();
        }
        String string4 = ContentNetworkUtils.getUrl((ContentNetwork)object6, 3) + "&" + stringBuffer.toString();
        object4 = null;
        object3 = UrlUtils.encode(JSONUtils.encodeToJSON(hashMap2));
        if (USE_HTTP_POST) {
            object5 = string4;
            object4 = "service=rpc&payload=" + object3;
            object4 = object6.appendURLSuffix((String)object4, true, bl);
            if (DEBUG_URL) {
                PlatformMessenger.debug("POST for " + hashMap.size() + ": " + (String)object5 + "\n   DATA: " + (String)object4);
            } else {
                PlatformMessenger.debug("POST for " + hashMap.size() + ": " + (String)object5);
            }
        } else {
            object5 = string4 + URL_PLATFORM_MESSAGE + "&payload=" + object3;
            object5 = object6.appendURLSuffix((String)object5, false, bl);
            if (DEBUG_URL) {
                PlatformMessenger.debug("GET: " + (String)object5);
            } else {
                PlatformMessenger.debug("GET: " + string4 + URL_PLATFORM_MESSAGE);
            }
        }
        object2 = object5;
        object = object4;
        dispatcher.dispatch(new AERunnable((String)object2, (String)object, hashMap){
            final /* synthetic */ String val$fURL;
            final /* synthetic */ String val$fPostData;
            final /* synthetic */ Map val$mapProcessing;
            {
                this.val$fURL = string;
                this.val$fPostData = string2;
                this.val$mapProcessing = map;
            }

            @Override
            public void runSupport() {
                try {
                    PlatformMessenger.processQueueAsync(this.val$fURL, this.val$fPostData, this.val$mapProcessing);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ResourceDownloaderException) {
                        PlatformMessenger.debug("Error while sending message(s) to Platform: " + throwable.toString());
                    } else {
                        PlatformMessenger.debug("Error while sending message(s) to Platform", throwable);
                    }
                    for (PlatformMessage platformMessage : this.val$mapProcessing.keySet()) {
                        PlatformMessengerListener platformMessengerListener = (PlatformMessengerListener)this.val$mapProcessing.get(platformMessage);
                        if (platformMessengerListener == null) continue;
                        try {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("text", throwable.toString());
                            hashMap.put("Throwable", throwable);
                            platformMessengerListener.replyReceived(platformMessage, REPLY_EXCEPTION, hashMap);
                        }
                        catch (Throwable throwable2) {
                            PlatformMessenger.debug("Error while sending replyReceived", throwable2);
                        }
                    }
                }
            }
        });
    }

    protected static void processQueueAsync(String string, String string2, Map map) throws Exception {
        URL uRL = new URL(string);
        byte[] byArray = PlatformMessenger.downloadURL(uRL, string2);
        String string3 = new String(byArray, "UTF8");
        Map map2 = JSONUtils.decodeJSON(string3);
        List list = MapUtils.getMapList(map2, "replies", null);
        if (map2 == null || list == null || list.isEmpty()) {
            PlatformMessenger.debug("Error while sending message(s) to Platform: reply: " + string3 + "\nurl: " + string + "\nPostData: " + string2);
            for (PlatformMessage platformMessage : map.keySet()) {
                PlatformMessengerListener platformMessengerListener = (PlatformMessengerListener)map.get(platformMessage);
                if (platformMessengerListener == null) continue;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("text", "result was " + string3);
                    platformMessengerListener.replyReceived(platformMessage, REPLY_EXCEPTION, hashMap);
                }
                catch (Throwable throwable) {
                    PlatformMessenger.debug("Error while sending replyReceived\nurl: " + string + "\nPostData: " + string2, throwable);
                }
            }
            return;
        }
        HashMap<Long, Map> hashMap = new HashMap<Long, Map>();
        for (Object object : list) {
            if (!(object instanceof Map)) continue;
            hashMap.put(MapUtils.getMapLong((Map)object, "seq-id", -1L), (Map)object);
        }
        for (Object object : map.keySet()) {
            Map<String, String> map3;
            String string4;
            PlatformMessengerListener platformMessengerListener = (PlatformMessengerListener)map.get(object);
            if (platformMessengerListener == null) continue;
            Map map4 = (Map)hashMap.get(new Long(((PlatformMessage)object).getSequenceNo()));
            if (map4 == null) {
                PlatformMessenger.debug("No reply for " + ((PlatformMessage)object).toShortString());
            }
            if ((string4 = MapUtils.getMapString(map4, "type", "payload")).equalsIgnoreCase("payload")) {
                map3 = MapUtils.getMapMap(map4, "payload", Collections.EMPTY_MAP);
            } else {
                map3 = new HashMap();
                map3.put("message", MapUtils.getMapString(map4, "message", "?"));
            }
            if (map4 != null) {
                String string5 = JSONUtils.encodeToJSON(map3);
                PlatformMessenger.debug("Got a reply for " + ((PlatformMessage)object).toShortString() + "\n\t" + string5.substring(0, Math.min(8192, string5.length())));
            }
            try {
                platformMessengerListener.replyReceived((PlatformMessage)object, string4, map3);
            }
            catch (Exception exception) {
                PlatformMessenger.debug("Error while sending replyReceived", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] downloadURL(URL uRL, String string) throws Exception {
        byte[] byArray;
        ResourceDownloaderFactory resourceDownloaderFactory = StaticUtilities.getResourceDownloaderFactory();
        ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(uRL, string);
        resourceDownloader.setProperty("URL_Connection", "Keep-Alive");
        resourceDownloader = resourceDownloaderFactory.getRetryDownloader(resourceDownloader, 3);
        InputStream inputStream = resourceDownloader.download();
        try {
            int n = inputStream.available();
            byArray = new byte[n];
            inputStream.read(byArray);
        }
        finally {
            inputStream.close();
        }
        return byArray;
    }

    public static void setAllowMulti(boolean bl) {
        allowMulti = bl;
    }

    public static boolean getAllowMulti() {
        return allowMulti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtraParam(String string, Object object) {
        Map<String, Object> map = mapExtra;
        synchronized (map) {
            mapExtra.put(string, object);
        }
    }

    static {
        allowMulti = false;
        dispatcher = new AsyncDispatcher(5000);
        mapExtra = new HashMap<String, Object>();
    }

    private static class fakeContext
    extends ClientMessageContextImpl {
        private long contentNetworkID = 1L;

        private void log(String string) {
            if (System.getProperty("browser.route.all.external.stimuli.for.testing", "false").equalsIgnoreCase("true")) {
                System.err.println(string);
            }
            this.debug(string);
        }

        public fakeContext() {
            super("fakeContext", null);
        }

        public void deregisterBrowser() {
            this.log("deregisterBrowser");
        }

        public void displayBrowserMessage(String string) {
            this.log("displayBrowserMessage - " + string);
        }

        @Override
        public boolean executeInBrowser(String string) {
            this.log("executeInBrowser - " + string);
            return false;
        }

        @Override
        public Object getBrowserData(String string) {
            this.log("getBrowserData - " + string);
            return null;
        }

        @Override
        public boolean sendBrowserMessage(String string, String string2) {
            this.log("sendBrowserMessage - " + string + "/" + string2);
            return false;
        }

        @Override
        public boolean sendBrowserMessage(String string, String string2, Map map) {
            this.log("sendBrowserMessage - " + string + "/" + string2 + "/" + map);
            return false;
        }

        @Override
        public void setBrowserData(String string, Object object) {
            this.log("setBrowserData - " + string + "/" + object);
        }

        @Override
        public boolean sendBrowserMessage(String string, String string2, Collection collection) {
            this.log("sendBrowserMessage - " + string + "/" + string2 + "/" + collection);
            return false;
        }

        @Override
        public void setTorrentURLHandler(ClientMessageContext.torrentURLHandler torrentURLHandler2) {
            this.log("setTorrentURLHandler - " + torrentURLHandler2);
        }

        @Override
        public long getContentNetworkID() {
            return this.contentNetworkID;
        }

        @Override
        public void setContentNetworkID(long l) {
            this.contentNetworkID = l;
        }
    }
}

