/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.net.InetAddress;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminNATDeviceImpl
implements NetworkAdminNATDevice {
    private UPnPPluginService service;
    private InetAddress external_address;
    private long address_time;

    protected NetworkAdminNATDeviceImpl(UPnPPluginService uPnPPluginService) {
        this.service = uPnPPluginService;
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.service.getAddress());
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    @Override
    public int getPort() {
        return this.service.getPort();
    }

    @Override
    public InetAddress getExternalAddress() {
        long l = SystemTime.getCurrentTime();
        if (this.external_address != null && l > this.address_time && l - this.address_time < 60000L) {
            return this.external_address;
        }
        try {
            this.external_address = InetAddress.getByName(this.service.getExternalAddress());
            this.address_time = l;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return this.external_address;
    }

    protected boolean sameAs(NetworkAdminNATDeviceImpl networkAdminNATDeviceImpl) {
        if (!this.getAddress().equals(networkAdminNATDeviceImpl.getAddress()) || this.getPort() != networkAdminNATDeviceImpl.getPort()) {
            return false;
        }
        InetAddress inetAddress = this.getExternalAddress();
        InetAddress inetAddress2 = networkAdminNATDeviceImpl.getExternalAddress();
        if (inetAddress == null && inetAddress2 == null) {
            return true;
        }
        if (inetAddress == null || inetAddress2 == null) {
            return false;
        }
        return inetAddress.equals(inetAddress2);
    }

    @Override
    public String getString() {
        String string = this.getName();
        string = string + ": address=" + this.service.getAddress() + ":" + this.service.getPort();
        InetAddress inetAddress = this.getExternalAddress();
        string = inetAddress == null ? string + ", no public address available" : string + ", public address=" + inetAddress.getHostAddress();
        return string;
    }
}

