/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderInitial;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import java.nio.ByteBuffer;

public class TransportCryptoManager {
    private static final TransportCryptoManager instance = new TransportCryptoManager();

    public static TransportCryptoManager getSingleton() {
        return instance;
    }

    public void manageCrypto(TransportHelper transportHelper, byte[][] byArray, boolean bl, ByteBuffer byteBuffer, final HandshakeListener handshakeListener) {
        try {
            new ProtocolDecoderInitial(transportHelper, byArray, !bl, byteBuffer, new ProtocolDecoderAdapter(){

                @Override
                public int getMaximumPlainHeaderLength() {
                    return handshakeListener.getMaximumPlainHeaderLength();
                }

                @Override
                public int matchPlainHeader(ByteBuffer byteBuffer) {
                    return handshakeListener.matchPlainHeader(byteBuffer);
                }

                @Override
                public void gotSecret(byte[] byArray) {
                    handshakeListener.gotSecret(byArray);
                }

                @Override
                public void decodeComplete(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer) {
                    handshakeListener.handshakeSuccess(protocolDecoder, byteBuffer);
                }

                @Override
                public void decodeFailed(ProtocolDecoder protocolDecoder, Throwable throwable) {
                    handshakeListener.handshakeFailure(throwable);
                }
            });
        }
        catch (Throwable throwable) {
            handshakeListener.handshakeFailure(throwable);
        }
    }

    public static interface HandshakeListener {
        public static final int MATCH_NONE = 1;
        public static final int MATCH_CRYPTO_NO_AUTO_FALLBACK = 2;
        public static final int MATCH_CRYPTO_AUTO_FALLBACK = 3;

        public void handshakeSuccess(ProtocolDecoder var1, ByteBuffer var2);

        public void handshakeFailure(Throwable var1);

        public void gotSecret(byte[] var1);

        public int getMaximumPlainHeaderLength();

        public int matchPlainHeader(ByteBuffer var1);
    }
}

