/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessage;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageEncoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class HTTPNetworkConnection {
    protected static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int MAX_OUTSTANDING_BT_REQUESTS = 16;
    protected static final String NL = "\r\n";
    private static final String HDR_SERVER = "Server: Azureus 4.5.0.4\r\n";
    private static final String HDR_KEEP_ALIVE_TIMEOUT = "Keep-Alive: timeout=30\r\n";
    private static final String HDR_CACHE_CONTROL = "Cache-Control: public, max-age=86400\r\n";
    private static final String DEFAULT_CONTENT_TYPE = HTTPUtils.guessContentTypeFromFileType(null);
    private static int max_read_block_size;
    private static final int TIMEOUT_CHECK_PERIOD = 15000;
    private static final int DEAD_CONNECTION_TIMEOUT_PERIOD = 30000;
    private static final int MAX_CON_PER_ENDPOINT = 5000;
    private static Map<networkConnectionKey, List<HTTPNetworkConnection>> http_connection_map;
    private HTTPNetworkManager manager;
    private NetworkConnection connection;
    private PEPeerTransport peer;
    private HTTPMessageDecoder decoder;
    private HTTPMessageEncoder encoder;
    private boolean sent_handshake = false;
    private byte[] peer_id = PeerUtils.createWebSeedPeerID();
    private boolean choked = true;
    private List<httpRequest> http_requests = new ArrayList<httpRequest>();
    private List<BTRequest> choked_requests = new ArrayList<BTRequest>();
    private List<pendingRequest> outstanding_requests = new ArrayList<pendingRequest>();
    private BitSet piece_map = new BitSet();
    private long last_http_activity_time;
    private networkConnectionKey network_connection_key;
    private boolean closing;
    private boolean destroyed;
    private String last_modified_date;
    private String content_type = DEFAULT_CONTENT_TYPE;
    private CopyOnWriteList<requestListener> request_listeners = null;

    protected static boolean checkConnections(List<HTTPNetworkConnection> list) {
        boolean bl = false;
        HTTPNetworkConnection hTTPNetworkConnection = null;
        long l = -1L;
        Iterator<HTTPNetworkConnection> iterator = list.iterator();
        ArrayList<HTTPNetworkConnection> arrayList = new ArrayList<HTTPNetworkConnection>();
        while (iterator.hasNext()) {
            HTTPNetworkConnection hTTPNetworkConnection2 = iterator.next();
            long l2 = hTTPNetworkConnection2.getTimeSinceLastActivity();
            if (l2 > 30000L && hTTPNetworkConnection2.getRequestCount() == 0) {
                arrayList.add(hTTPNetworkConnection2);
                continue;
            }
            if (l2 <= l || hTTPNetworkConnection2.isClosing()) continue;
            l = l2;
            hTTPNetworkConnection = hTTPNetworkConnection2;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((HTTPNetworkConnection)arrayList.get(i)).close("Timeout");
            bl = true;
        }
        if (list.size() - arrayList.size() > 5000) {
            hTTPNetworkConnection.close("Too many connections from initiator");
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPNetworkConnection(HTTPNetworkManager hTTPNetworkManager, NetworkConnection networkConnection, PEPeerTransport pEPeerTransport) {
        this.manager = hTTPNetworkManager;
        this.connection = networkConnection;
        this.peer = pEPeerTransport;
        DiskManager diskManager = this.peer.getManager().getDiskManager();
        long l = 0L;
        try {
            l = diskManager.getFiles()[0].getFile(true).lastModified();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.last_modified_date = TimeFormatter.getHTTPDate(l);
        this.network_connection_key = new networkConnectionKey();
        this.last_http_activity_time = SystemTime.getCurrentTime();
        this.decoder = (HTTPMessageDecoder)this.connection.getIncomingMessageQueue().getDecoder();
        this.encoder = (HTTPMessageEncoder)this.connection.getOutgoingMessageQueue().getEncoder();
        Map<networkConnectionKey, List<HTTPNetworkConnection>> map = http_connection_map;
        synchronized (map) {
            List<HTTPNetworkConnection> list = http_connection_map.get(this.network_connection_key);
            if (list == null) {
                list = new ArrayList<HTTPNetworkConnection>();
                http_connection_map.put(this.network_connection_key, list);
            }
            list.add(this);
            if (list.size() > 5000) {
                HTTPNetworkConnection.checkConnections(list);
            }
        }
        this.encoder.setConnection(this);
        this.decoder.setConnection(this);
    }

    protected boolean isSeed() {
        if (!this.peer.getControl().isSeeding() || this.peer.getControl().getHiddenBytes() > 0L) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.peer, LOGID, "Download is not seeding"));
            }
            this.sendAndClose(this.manager.getNotFound());
            return false;
        }
        return true;
    }

    protected void setContentType(String string) {
        this.content_type = string;
    }

    protected HTTPNetworkManager getManager() {
        return this.manager;
    }

    protected NetworkConnection getConnection() {
        return this.connection;
    }

    protected PEPeerTransport getPeer() {
        return this.peer;
    }

    protected PEPeerControl getPeerControl() {
        return this.peer.getControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage encodeChoke() {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            this.choked = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage encodeUnchoke() {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            this.choked = false;
            for (int i = 0; i < this.choked_requests.size(); ++i) {
                this.decoder.addMessage(this.choked_requests.get(i));
            }
            this.choked_requests.clear();
        }
        return null;
    }

    protected RawMessage encodeBitField() {
        this.decoder.addMessage(new BTInterested(1));
        return null;
    }

    protected void readWakeup() {
        this.connection.getTransport().setReadyForRead();
    }

    protected RawMessage encodeHandShake(Message message) {
        return null;
    }

    protected abstract void decodeHeader(HTTPMessageDecoder var1, String var2) throws IOException;

    protected String encodeHeader(httpRequest httpRequest2) {
        String string = TimeFormatter.getHTTPDate(SystemTime.getCurrentTime());
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl = httpRequest2.isPartialContent();
        stringBuffer.append("HTTP/1.1 ");
        stringBuffer.append(bl ? "206 Partial Content" : "200 OK");
        stringBuffer.append(NL);
        stringBuffer.append("Content-Type: ");
        stringBuffer.append(this.content_type);
        stringBuffer.append(NL);
        stringBuffer.append("Date: ");
        stringBuffer.append(string);
        stringBuffer.append(NL);
        stringBuffer.append("Last-Modified: ");
        stringBuffer.append(this.last_modified_date);
        stringBuffer.append(NL);
        stringBuffer.append(HDR_CACHE_CONTROL);
        stringBuffer.append(HDR_SERVER);
        if (bl) {
            long[] lArray = httpRequest2.getOriginalOffsets();
            long[] lArray2 = httpRequest2.getOriginalLengths();
            long l = httpRequest2.getContentLength();
            if (lArray.length == 1 && l > 0L) {
                stringBuffer.append("Content-Range: bytes " + lArray[0] + "-" + (lArray[0] + lArray2[0] - 1L) + "/" + l);
                stringBuffer.append(NL);
            }
        }
        stringBuffer.append("Connection: ");
        stringBuffer.append(httpRequest2.keepAlive() ? "Keep-Alive" : "Close");
        stringBuffer.append(NL);
        if (httpRequest2.keepAlive()) {
            stringBuffer.append(HDR_KEEP_ALIVE_TIMEOUT);
        }
        stringBuffer.append("Content-Length: ");
        stringBuffer.append(httpRequest2.getTotalLength());
        stringBuffer.append(NL);
        stringBuffer.append(NL);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequest(httpRequest httpRequest2) throws IOException {
        Object object;
        this.last_http_activity_time = SystemTime.getCurrentTime();
        PEPeerControl pEPeerControl = this.getPeerControl();
        if (!this.sent_handshake) {
            this.sent_handshake = true;
            this.decoder.addMessage(new BTHandshake(pEPeerControl.getHash(), this.peer_id, false, 1));
            object = new byte[(pEPeerControl.getPieces().length + 7) / 8];
            DirectByteBuffer directByteBuffer = new DirectByteBuffer(ByteBuffer.wrap((byte[])object));
            this.decoder.addMessage(new BTBitfield(directByteBuffer, 1));
        }
        object = this.outstanding_requests;
        synchronized (object) {
            this.http_requests.add(httpRequest2);
        }
        this.submitBTRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitBTRequests() throws IOException {
        PEPeerControl pEPeerControl = this.getPeerControl();
        long l = pEPeerControl.getPieceLength(0);
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            while (this.outstanding_requests.size() < 16 && this.http_requests.size() > 0) {
                httpRequest httpRequest2 = this.http_requests.get(0);
                long[] lArray = httpRequest2.getModifiableOffsets();
                long[] lArray2 = httpRequest2.getModifiableLengths();
                int n = httpRequest2.getIndex();
                long l2 = lArray[n];
                long l3 = lArray2[n];
                int n2 = (int)(l2 / l);
                int n3 = pEPeerControl.getPieceLength(n2);
                int n4 = (int)(l2 - (long)n2 * l);
                int n5 = n3 - n4;
                int n6 = (int)Math.min(l3, (long)n5);
                n6 = Math.min(n6, max_read_block_size);
                this.addBTRequest(new BTRequest(n2, n4, n6, 1), httpRequest2);
                if ((long)n6 == l3) {
                    if (n == lArray.length - 1) {
                        this.http_requests.remove(0);
                        continue;
                    }
                    httpRequest2.setIndex(n + 1);
                    continue;
                }
                int n7 = n;
                lArray[n7] = lArray[n7] + (long)n6;
                int n8 = n;
                lArray2[n8] = lArray2[n8] - (long)n6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBTRequest(BTRequest bTRequest, httpRequest httpRequest2) throws IOException {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            if (this.destroyed) {
                throw new IOException("HTTP connection destroyed");
            }
            this.outstanding_requests.add(new pendingRequest(bTRequest, httpRequest2));
            if (this.choked) {
                if (this.choked_requests.size() > 1024) {
                    Debug.out("pending request limit exceeded");
                } else {
                    this.choked_requests.add(bTRequest);
                }
            } else {
                this.decoder.addMessage(bTRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage[] encodePiece(Message message) {
        Object object;
        Object object2;
        Object object3;
        this.last_http_activity_time = SystemTime.getCurrentTime();
        BTPiece bTPiece = (BTPiece)message;
        ArrayList<pendingRequest> arrayList = new ArrayList<pendingRequest>();
        boolean bl = false;
        Object object4 = this.outstanding_requests;
        synchronized (object4) {
            if (this.destroyed) {
                return new RawMessage[]{this.getEmptyRawMessage(message)};
            }
            for (int i = 0; i < this.outstanding_requests.size(); ++i) {
                pendingRequest pendingRequest2;
                object3 = this.outstanding_requests.get(i);
                if (((pendingRequest)object3).getPieceNumber() != bTPiece.getPieceNumber() || ((pendingRequest)object3).getStart() != bTPiece.getPieceOffset() || ((pendingRequest)object3).getLength() != bTPiece.getPieceData().remaining((byte)5) || ((pendingRequest)object3).getBTPiece() != null) continue;
                ((pendingRequest)object3).setBTPiece(bTPiece);
                bl = true;
                if (i != 0) break;
                object2 = this.outstanding_requests.iterator();
                while (object2.hasNext() && (object = (pendingRequest2 = (pendingRequest)object2.next()).getBTPiece()) != null) {
                    object2.remove();
                    arrayList.add(pendingRequest2);
                }
                break;
            }
        }
        if (!bl) {
            Debug.out("request not matched");
            return new RawMessage[]{this.getEmptyRawMessage(message)};
        }
        if (arrayList.size() == 0) {
            return new RawMessage[]{this.getEmptyRawMessage(message)};
        }
        try {
            this.submitBTRequests();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object4 = (pendingRequest)arrayList.get(0);
        object3 = ((pendingRequest)object4).getHTTPRequest();
        object2 = new RawMessage[arrayList.size()];
        for (int i = 0; i < ((RawMessage[])object2).length; ++i) {
            DirectByteBuffer[] directByteBufferArray = new DirectByteBuffer[2];
            if (!((httpRequest)object3).hasSentFirstReply()) {
                ((httpRequest)object3).setSentFirstReply();
                object = this.encodeHeader((httpRequest)object3);
                directByteBufferArray[0] = new DirectByteBuffer(ByteBuffer.wrap(((String)object).getBytes()));
            } else {
                directByteBufferArray[0] = new DirectByteBuffer(ByteBuffer.allocate(0));
            }
            object4 = (pendingRequest)arrayList.get(i);
            object = ((pendingRequest)object4).getBTPiece();
            int n = ((BTPiece)object).getPieceNumber();
            if (!this.piece_map.get(n)) {
                this.piece_map.set(n);
                this.decoder.addMessage(new BTHave(n, 1));
            }
            directByteBufferArray[1] = ((BTPiece)object).getPieceData();
            ((pendingRequest)object4).logQueued();
            if (this.request_listeners != null) {
                Iterator<requestListener> iterator = this.request_listeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().requestComplete((pendingRequest)object4);
                }
            }
            object2[i] = new RawMessageImpl((Message)object, directByteBufferArray, 2, true, new Message[0]);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRequestCount() {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            return this.http_requests.size();
        }
    }

    protected boolean isClosing() {
        return this.closing;
    }

    protected void close(String string) {
        this.closing = true;
        this.peer.getControl().removePeer(this.peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = http_connection_map;
        synchronized (object) {
            List<HTTPNetworkConnection> list = http_connection_map.get(this.network_connection_key);
            if (list != null) {
                list.remove(this);
                if (list.size() == 0) {
                    http_connection_map.remove(this.network_connection_key);
                }
            }
        }
        object = this.outstanding_requests;
        synchronized (object) {
            Object object2;
            int n;
            this.destroyed = true;
            for (n = 0; n < this.outstanding_requests.size(); ++n) {
                object2 = this.outstanding_requests.get(n);
                BTPiece bTPiece = ((pendingRequest)object2).getBTPiece();
                if (bTPiece == null) continue;
                bTPiece.destroy();
            }
            this.outstanding_requests.clear();
            for (n = 0; n < this.choked_requests.size(); ++n) {
                object2 = this.choked_requests.get(n);
                ((BTRequest)object2).destroy();
            }
            this.choked_requests.clear();
        }
    }

    protected long getTimeSinceLastActivity() {
        long l = SystemTime.getCurrentTime();
        if (l < this.last_http_activity_time) {
            this.last_http_activity_time = l;
        }
        return l - this.last_http_activity_time;
    }

    protected void log(String string) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getPeer(), LOGID, string));
        }
    }

    protected RawMessage getEmptyRawMessage(Message message) {
        return new RawMessageImpl(message, new DirectByteBuffer[]{new DirectByteBuffer(ByteBuffer.allocate(0))}, 2, true, new Message[0]);
    }

    protected void sendAndClose(String string) {
        final HTTPMessage hTTPMessage = new HTTPMessage(string);
        this.getConnection().getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageAdded(Message message) {
                return true;
            }

            @Override
            public void messageQueued(Message message) {
            }

            @Override
            public void messageRemoved(Message message) {
            }

            @Override
            public void messageSent(Message message) {
                if (message == hTTPMessage) {
                    HTTPNetworkConnection.this.close("Close after message send complete");
                }
            }

            @Override
            public void protocolBytesSent(int n) {
            }

            @Override
            public void dataBytesSent(int n) {
            }

            @Override
            public void flush() {
            }
        });
        this.getConnection().getOutgoingMessageQueue().addMessage(hTTPMessage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushRequests(final flushListener flushListener2) {
        boolean bl = false;
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            final int n = this.outstanding_requests.size();
            if (n == 0) {
                bl = true;
            } else {
                if (this.request_listeners == null) {
                    this.request_listeners = new CopyOnWriteList();
                }
                this.request_listeners.add(new requestListener(){
                    int num_to_go;
                    {
                        this.num_to_go = n;
                    }

                    @Override
                    public void requestComplete(pendingRequest pendingRequest2) {
                        --this.num_to_go;
                        if (this.num_to_go == 0) {
                            HTTPNetworkConnection.this.request_listeners.remove(this);
                            HTTPNetworkConnection.this.flushRequestsSupport(flushListener2);
                        }
                    }
                });
            }
        }
        if (bl) {
            this.flushRequestsSupport(flushListener2);
        }
    }

    protected void flushRequestsSupport(final flushListener flushListener2) {
        OutgoingMessageQueue outgoingMessageQueue = this.getConnection().getOutgoingMessageQueue();
        final HTTPMessage hTTPMessage = new HTTPMessage(new byte[0]);
        outgoingMessageQueue.registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageAdded(Message message) {
                return true;
            }

            @Override
            public void messageQueued(Message message) {
            }

            @Override
            public void messageRemoved(Message message) {
            }

            @Override
            public void messageSent(Message message) {
                if (message == hTTPMessage) {
                    flushListener2.flushed();
                }
            }

            @Override
            public void protocolBytesSent(int n) {
            }

            @Override
            public void dataBytesSent(int n) {
            }

            @Override
            public void flush() {
            }
        });
        outgoingMessageQueue.addMessage(hTTPMessage, false);
        if (outgoingMessageQueue.getTotalSize() == 0) {
            flushListener2.flushed();
        }
    }

    static {
        ParameterListener parameterListener = new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", parameterListener);
        http_connection_map = new HashMap<networkConnectionKey, List<HTTPNetworkConnection>>();
        SimpleTimer.addPeriodicEvent("HTTPNetworkConnection:timer", 15000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                Map map = http_connection_map;
                synchronized (map) {
                    boolean bl = true;
                    block3: while (bl) {
                        bl = false;
                        for (Map.Entry entry : http_connection_map.entrySet()) {
                            networkConnectionKey networkConnectionKey2 = (networkConnectionKey)entry.getKey();
                            List list = (List)entry.getValue();
                            if (!HTTPNetworkConnection.checkConnections(list) || http_connection_map.containsKey(networkConnectionKey2)) continue;
                            bl = true;
                            continue block3;
                        }
                    }
                }
            }
        });
    }

    protected class networkConnectionKey {
        protected networkConnectionKey() {
        }

        public boolean equals(Object object) {
            networkConnectionKey networkConnectionKey2 = (networkConnectionKey)object;
            return Arrays.equals(this.getAddress(), networkConnectionKey2.getAddress()) && Arrays.equals(this.getHash(), networkConnectionKey2.getHash());
        }

        protected String getName() {
            return HTTPNetworkConnection.this.peer.getControl().getDisplayName() + ": " + HTTPNetworkConnection.this.connection.getEndpoint().getNotionalAddress().getAddress().getHostAddress();
        }

        protected byte[] getAddress() {
            return HTTPNetworkConnection.this.connection.getEndpoint().getNotionalAddress().getAddress().getAddress();
        }

        protected byte[] getHash() {
            return HTTPNetworkConnection.this.peer.getControl().getHash();
        }

        public int hashCode() {
            return HTTPNetworkConnection.this.peer.getControl().hashCode();
        }
    }

    protected class pendingRequest {
        private int piece;
        private int start;
        private int length;
        private httpRequest http_request;
        private BTPiece bt_piece;

        protected pendingRequest(BTRequest bTRequest, httpRequest httpRequest2) {
            this.piece = bTRequest.getPieceNumber();
            this.start = bTRequest.getPieceOffset();
            this.length = bTRequest.getLength();
            this.http_request = httpRequest2;
        }

        protected int getPieceNumber() {
            return this.piece;
        }

        protected int getStart() {
            return this.start;
        }

        protected int getLength() {
            return this.length;
        }

        protected httpRequest getHTTPRequest() {
            return this.http_request;
        }

        protected BTPiece getBTPiece() {
            return this.bt_piece;
        }

        protected void setBTPiece(BTPiece bTPiece) {
            this.bt_piece = bTPiece;
        }

        protected void logQueued() {
        }
    }

    protected static interface requestListener {
        public void requestComplete(pendingRequest var1);
    }

    protected static interface flushListener {
        public void flushed();
    }

    protected class httpRequest {
        private final long[] orig_offsets;
        private final long[] orig_lengths;
        private final long content_length;
        private final boolean partial_content;
        private final boolean keep_alive;
        private final long[] mod_offsets;
        private final long[] mod_lengths;
        private int index;
        private long total_length;
        private boolean sent_first_reply;

        protected httpRequest(long[] lArray, long[] lArray2, long l, boolean bl, boolean bl2) {
            this.orig_offsets = lArray;
            this.orig_lengths = lArray2;
            this.content_length = l;
            this.partial_content = bl;
            this.keep_alive = bl2;
            this.mod_offsets = (long[])this.orig_offsets.clone();
            this.mod_lengths = (long[])this.orig_lengths.clone();
            for (int i = 0; i < this.orig_lengths.length; ++i) {
                this.total_length += this.orig_lengths[i];
            }
        }

        protected boolean isPartialContent() {
            return this.partial_content;
        }

        protected long getContentLength() {
            return this.content_length;
        }

        protected boolean hasSentFirstReply() {
            return this.sent_first_reply;
        }

        protected void setSentFirstReply() {
            this.sent_first_reply = true;
        }

        protected long[] getOriginalOffsets() {
            return this.orig_offsets;
        }

        protected long[] getOriginalLengths() {
            return this.orig_lengths;
        }

        protected long[] getModifiableOffsets() {
            return this.mod_offsets;
        }

        protected long[] getModifiableLengths() {
            return this.mod_lengths;
        }

        protected int getIndex() {
            return this.index;
        }

        protected void setIndex(int n) {
            this.index = n;
        }

        protected long getTotalLength() {
            return this.total_length;
        }

        protected boolean keepAlive() {
            return this.keep_alive;
        }
    }
}

