/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.neuronal;

import com.aelitis.azureus.core.neuronal.ActivationFunction;
import com.aelitis.azureus.core.neuronal.NeuralNetworkLayer;

public class NeuralNetwork {
    NeuralNetworkLayer inputLayer;
    NeuralNetworkLayer hiddenLayer;
    NeuralNetworkLayer outputLayer;

    public NeuralNetwork(int n, int n2, int n3) {
        this.inputLayer = new NeuralNetworkLayer(n);
        this.hiddenLayer = new NeuralNetworkLayer(n2);
        this.outputLayer = new NeuralNetworkLayer(n3);
        this.inputLayer.initialize(null, this.hiddenLayer);
        this.inputLayer.randomizeWeights();
        this.hiddenLayer.initialize(this.inputLayer, this.outputLayer);
        this.hiddenLayer.randomizeWeights();
        this.outputLayer.initialize(this.hiddenLayer, null);
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.inputLayer.setActivationFunction(activationFunction);
        this.hiddenLayer.setActivationFunction(activationFunction);
        this.outputLayer.setActivationFunction(activationFunction);
    }

    public void setInput(int n, double d) {
        if (n >= 0 && n < this.inputLayer.getNumberOfNodes()) {
            this.inputLayer.neuronValues[n] = d;
        }
    }

    public double getOutput(int n) {
        if (n >= 0 && n < this.outputLayer.getNumberOfNodes()) {
            return this.outputLayer.neuronValues[n];
        }
        return Double.NaN;
    }

    public void setDesiredOutput(int n, double d) {
        if (n >= 0 && n < this.outputLayer.getNumberOfNodes()) {
            this.outputLayer.desiredValues[n] = d;
        }
    }

    public void setMomentum(boolean bl, double d) {
        this.inputLayer.setMomentum(bl, d);
        this.hiddenLayer.setMomentum(bl, d);
        this.outputLayer.setMomentum(bl, d);
    }

    public void setLearningRate(double d) {
        this.inputLayer.setLearningRate(d);
        this.hiddenLayer.setLearningRate(d);
        this.outputLayer.setLearningRate(d);
    }

    public void feedForward() {
        this.inputLayer.calculateNeuronValues();
        this.hiddenLayer.calculateNeuronValues();
        this.outputLayer.calculateNeuronValues();
    }

    public void backPropagate() {
        this.outputLayer.calculateErrors();
        this.hiddenLayer.calculateErrors();
        this.hiddenLayer.adjustWeights();
        this.inputLayer.adjustWeights();
    }

    public double calculateError() {
        double d = 0.0;
        for (int i = 0; i < this.outputLayer.numberOfNodes; ++i) {
            d += Math.pow(this.outputLayer.neuronValues[i] - this.outputLayer.desiredValues[i], 2.0);
        }
        return d /= (double)this.outputLayer.numberOfNodes;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input Layer :\n");
        stringBuffer.append(this.inputLayer.toString());
        stringBuffer.append("\n\n");
        stringBuffer.append("Hidden Layer :\n");
        stringBuffer.append(this.hiddenLayer.toString());
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }
}

