/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.neuronal;

import com.aelitis.azureus.core.neuronal.ActivationFunction;

public class NeuralNetworkLayer {
    int numberOfNodes;
    double[][] weights;
    double[][] weightChanges;
    double[] neuronValues;
    double[] desiredValues;
    double[] errors;
    double[] biasWeights;
    double[] biasValues;
    double learningRate;
    boolean linearOutput;
    boolean useMomentum;
    double momentumFactor;
    NeuralNetworkLayer parentLayer;
    NeuralNetworkLayer childLayer;
    ActivationFunction activationFunction;

    public NeuralNetworkLayer(int n) {
        this.numberOfNodes = n;
        this.linearOutput = false;
        this.useMomentum = false;
        this.momentumFactor = 0.9;
    }

    public void initialize(NeuralNetworkLayer neuralNetworkLayer, NeuralNetworkLayer neuralNetworkLayer2) {
        this.neuronValues = new double[this.numberOfNodes];
        this.desiredValues = new double[this.numberOfNodes];
        this.errors = new double[this.numberOfNodes];
        this.parentLayer = neuralNetworkLayer;
        if (neuralNetworkLayer2 != null) {
            this.childLayer = neuralNetworkLayer2;
            this.weights = new double[this.numberOfNodes][neuralNetworkLayer2.getNumberOfNodes()];
            this.weightChanges = new double[this.numberOfNodes][neuralNetworkLayer2.getNumberOfNodes()];
            this.biasValues = new double[neuralNetworkLayer2.getNumberOfNodes()];
            this.biasWeights = new double[neuralNetworkLayer2.getNumberOfNodes()];
            for (int i = 0; i < neuralNetworkLayer2.getNumberOfNodes(); ++i) {
                this.biasValues[i] = -1.0;
                this.biasWeights[i] = 0.0;
            }
        }
    }

    public void randomizeWeights() {
        int n;
        for (n = 0; n < this.numberOfNodes; ++n) {
            for (int i = 0; i < this.childLayer.getNumberOfNodes(); ++i) {
                this.weights[n][i] = Math.random() * 2.0 - 1.0;
            }
        }
        for (n = 0; n < this.childLayer.getNumberOfNodes(); ++n) {
            this.biasWeights[n] = Math.random() * 2.0 - 1.0;
        }
    }

    public void calculateNeuronValues() {
        if (this.parentLayer != null) {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                double d = 0.0;
                for (int j = 0; j < this.parentLayer.getNumberOfNodes(); ++j) {
                    d += this.parentLayer.neuronValues[j] * this.parentLayer.weights[j][i];
                }
                this.neuronValues[i] = this.childLayer == null && this.linearOutput ? d : this.activationFunction.getValueFor(d += this.parentLayer.biasValues[i] * this.parentLayer.biasWeights[i]);
            }
        }
    }

    public void calculateErrors() {
        if (this.childLayer == null) {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                this.errors[i] = (this.desiredValues[i] - this.neuronValues[i]) * this.activationFunction.getDerivedFunctionValueFor(this.neuronValues[i]);
            }
        } else if (this.parentLayer == null) {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                this.errors[i] = 0.0;
            }
        } else {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                double d = 0.0;
                for (int j = 0; j < this.childLayer.getNumberOfNodes(); ++j) {
                    d += this.childLayer.errors[j] * this.weights[i][j];
                }
                this.errors[i] = d * this.activationFunction.getDerivedFunctionValueFor(this.neuronValues[i]);
            }
        }
    }

    public void adjustWeights() {
        if (this.childLayer != null) {
            int n;
            for (n = 0; n < this.numberOfNodes; ++n) {
                for (int i = 0; i < this.childLayer.getNumberOfNodes(); ++i) {
                    double d = this.learningRate * this.childLayer.errors[i] * this.neuronValues[n];
                    if (this.useMomentum) {
                        double[] dArray = this.weights[n];
                        int n2 = i;
                        dArray[n2] = dArray[n2] + (d + this.momentumFactor * this.weightChanges[n][i]);
                        this.weightChanges[n][i] = d;
                        continue;
                    }
                    double[] dArray = this.weights[n];
                    int n3 = i;
                    dArray[n3] = dArray[n3] + d;
                }
            }
            for (n = 0; n < this.childLayer.getNumberOfNodes(); ++n) {
                int n4 = n;
                this.biasWeights[n4] = this.biasWeights[n4] + this.learningRate * this.childLayer.errors[n] * this.biasValues[n];
            }
        }
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setMomentum(boolean bl, double d) {
        this.useMomentum = bl;
        this.momentumFactor = d;
    }

    public void setLearningRate(double d) {
        this.learningRate = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.childLayer != null) {
            for (int i = 0; i < this.childLayer.getNumberOfNodes(); ++i) {
                stringBuffer.append(i);
                stringBuffer.append("\t> ");
                for (int j = 0; j < this.numberOfNodes; ++j) {
                    stringBuffer.append(j);
                    stringBuffer.append(":");
                    stringBuffer.append(this.weights[j][i]);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

