/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.neuronal;

import com.aelitis.azureus.core.neuronal.LogisticActivationFunction;
import com.aelitis.azureus.core.neuronal.NeuralNetwork;

public class NeuralSpeedLimiter {
    long maxDlSpeed;
    long maxUlSpeed;
    long ulSpeed;
    long dlSpeed;
    long minLatency;
    long maxLatency;
    long latency;
    NeuralNetwork neuralNetwork;
    private boolean dirty;
    private double currentULTarget = 0.6;
    double[][] trainingSet = new double[][]{{0.0, 0.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {0.0, 1.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {1.0, 0.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {1.0, 1.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {0.0, 1.0, 1.0, 0.9, 0.9, 0.1, 0.1}, {0.0, 1.0, 0.3, 0.9, 0.9, 0.1, 0.1}, {0.0, 1.0, 0.1, 0.9, 0.9, 0.1, 0.8}, {0.0, 1.0, 0.2, 0.9, 0.9, 0.1, 0.6}, {1.0, 0.0, 1.0, 0.1, 0.5, 0.9, 0.9}, {1.0, 0.0, 0.3, 0.1, 0.6, 0.9, 0.9}, {1.0, 0.0, 0.1, 0.1, 0.9, 0.9, 0.9}, {1.0, 0.0, 0.2, 0.1, 0.8, 0.9, 0.9}};

    public NeuralSpeedLimiter() {
        this.neuralNetwork = new NeuralNetwork(3, 4, 4);
        this.neuralNetwork.setLearningRate(0.05);
        this.neuralNetwork.setMomentum(true, 0.9);
        this.neuralNetwork.setActivationFunction(new LogisticActivationFunction());
        this.train();
        this.dirty = false;
    }

    private void train() {
        double d = 1.0;
        for (int i = 0; d > 0.002 && i < 200000; d /= (double)this.trainingSet.length, ++i) {
            d = 0.0;
            for (int j = 0; j < this.trainingSet.length; ++j) {
                this.neuralNetwork.setInput(0, this.trainingSet[j][0]);
                this.neuralNetwork.setInput(1, this.trainingSet[j][1]);
                this.neuralNetwork.setInput(2, this.trainingSet[j][2]);
                this.neuralNetwork.setDesiredOutput(0, this.trainingSet[j][3]);
                this.neuralNetwork.setDesiredOutput(1, this.trainingSet[j][4]);
                this.neuralNetwork.setDesiredOutput(2, this.trainingSet[j][5]);
                this.neuralNetwork.setDesiredOutput(3, this.trainingSet[j][6]);
                this.neuralNetwork.feedForward();
                d += this.neuralNetwork.calculateError();
                this.neuralNetwork.backPropagate();
            }
        }
    }

    private void resetInput() {
        try {
            if (this.ulSpeed > this.maxUlSpeed) {
                this.maxUlSpeed = this.ulSpeed;
            }
            if (this.dlSpeed > this.maxDlSpeed) {
                this.maxDlSpeed = this.dlSpeed;
            }
            if (this.latency > this.maxLatency) {
                this.maxLatency = this.latency;
            }
            if (this.latency < this.minLatency) {
                this.minLatency = this.latency;
            }
            double d = (double)this.dlSpeed / (double)this.maxDlSpeed;
            double d2 = (double)this.ulSpeed / (double)this.maxUlSpeed;
            double d3 = ((double)this.latency - (double)this.minLatency) / (double)this.maxLatency;
            this.neuralNetwork.setInput(0, d);
            this.neuralNetwork.setInput(1, d2);
            this.neuralNetwork.setInput(2, d3);
            this.dirty = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void retrain(double d) {
        this.resetInput();
        this.neuralNetwork.feedForward();
        double d2 = this.neuralNetwork.getOutput(0);
        double d3 = this.neuralNetwork.getOutput(1);
        double d4 = (double)this.dlSpeed / (double)this.maxDlSpeed;
        double d5 = (double)this.ulSpeed / (double)this.maxUlSpeed;
        double d6 = ((double)this.latency - (double)this.minLatency) / (double)this.maxLatency;
        double d7 = 1.0;
        for (int i = 0; d7 > 0.002 && i < 400; ++i) {
            this.neuralNetwork.setInput(0, d4);
            this.neuralNetwork.setInput(1, d5);
            this.neuralNetwork.setInput(2, d6);
            this.neuralNetwork.setDesiredOutput(0, d2);
            this.neuralNetwork.setDesiredOutput(1, d3);
            this.neuralNetwork.setDesiredOutput(2, 0.9);
            this.neuralNetwork.setDesiredOutput(3, d);
            this.neuralNetwork.feedForward();
            d7 = this.neuralNetwork.calculateError();
            this.neuralNetwork.backPropagate();
        }
    }

    private void feedForward() {
        this.neuralNetwork.feedForward();
        this.dirty = false;
        double d = ((double)this.latency - (double)this.minLatency) / (double)this.maxLatency;
        if (d >= 0.15) {
            this.currentULTarget *= 0.97;
            this.retrain(this.currentULTarget);
        } else if (d < 0.05) {
            this.currentULTarget *= 1.02;
            this.retrain(this.currentULTarget);
        }
    }

    public void setMaxDlSpeed(long l) {
        if (l > 0L) {
            this.maxDlSpeed = l;
        }
        this.resetInput();
    }

    public void setMaxUlSpeed(long l) {
        if (l > 0L) {
            this.maxUlSpeed = l;
        }
        this.resetInput();
    }

    public void setMinLatency(long l) {
        if (l >= 0L) {
            this.minLatency = l;
        }
        this.resetInput();
    }

    public void setUlSpeed(long l) {
        if (l >= 0L) {
            this.ulSpeed = l;
        }
        this.resetInput();
    }

    public void setDlSpeed(long l) {
        if (l >= 0L) {
            this.dlSpeed = l;
        }
        this.resetInput();
    }

    public void setLatency(long l) {
        if (l >= 0L) {
            this.latency = l;
        }
        this.resetInput();
    }

    public void setMaxLatency(long l) {
        if (l > 0L) {
            this.maxLatency = l;
        }
        this.resetInput();
    }

    public boolean shouldLimitDownload() {
        if (this.dirty) {
            this.feedForward();
        }
        return this.neuralNetwork.getOutput(0) < 0.5;
    }

    public long getDownloadLimit() {
        if (this.dirty) {
            this.feedForward();
        }
        return (long)(1.2 * (double)this.maxDlSpeed * this.neuralNetwork.getOutput(1));
    }

    public boolean shouldLimitUpload() {
        if (this.dirty) {
            this.feedForward();
        }
        return this.neuralNetwork.getOutput(2) < 0.5;
    }

    public long getUploadLimit() {
        if (this.dirty) {
            this.feedForward();
        }
        return (long)(1.2 * (double)this.maxUlSpeed * this.neuralNetwork.getOutput(3));
    }

    public static void main(String[] stringArray) {
        new NeuralSpeedLimiter();
    }
}

