/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.peermanager.control.impl.PeerControlSchedulerImpl;
import com.aelitis.azureus.core.peermanager.control.impl.SpeedTokenDispenserPrioritised;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerControlSchedulerPrioritised
extends PeerControlSchedulerImpl
implements AzureusCoreStatsProvider {
    private Map instance_map = new HashMap();
    private List pending_registrations = new ArrayList();
    private volatile boolean registrations_changed;
    private volatile long latest_time;
    protected AEMonitor this_mon = new AEMonitor("PeerControlSchedulerPrioritised");
    private final SpeedTokenDispenserPrioritised tokenDispenser = new SpeedTokenDispenserPrioritised();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void schedule() {
        this.latest_time = SystemTime.getMonotonousTime();
        SystemTime.registerMonotonousConsumer(new SystemTime.TickConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(long l) {
                PeerControlSchedulerPrioritised peerControlSchedulerPrioritised = PeerControlSchedulerPrioritised.this;
                synchronized (peerControlSchedulerPrioritised) {
                    PeerControlSchedulerPrioritised.this.latest_time = l;
                    PeerControlSchedulerPrioritised.this.notify();
                }
            }
        });
        ArrayList arrayList = new ArrayList();
        long l = 0L;
        int n = 0;
        long l2 = this.latest_time;
        long l3 = this.latest_time;
        while (true) {
            instanceWrapper instanceWrapper2;
            if (this.registrations_changed) {
                try {
                    int n2;
                    this.this_mon.enter();
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        if (!((instanceWrapper)iterator.next()).isUnregistered()) continue;
                        iterator.remove();
                    }
                    for (n2 = 0; n2 < this.pending_registrations.size(); ++n2) {
                        arrayList.add(this.pending_registrations.get(n2));
                    }
                    this.pending_registrations.clear();
                    Collections.sort(arrayList);
                    if (arrayList.size() > 0) {
                        for (n2 = 0; n2 < arrayList.size(); ++n2) {
                            ((instanceWrapper)arrayList.get(n2)).setScheduleOffset(SCHEDULE_PERIOD_MILLIS * n2 / arrayList.size());
                        }
                    }
                    n = 0;
                    l2 = this.latest_time;
                    this.registrations_changed = false;
                }
                finally {
                    this.this_mon.exit();
                }
            }
            this.tokenDispenser.update(this.latest_time);
            for (int i = n; i < arrayList.size() && l2 + (instanceWrapper2 = (instanceWrapper)arrayList.get(i)).getScheduleOffset() <= l; ++i) {
                if (i == 0 || !this.useWeights) {
                    this.tokenDispenser.refill();
                }
                instanceWrapper2.schedule();
                ++this.schedule_count;
                if (++n < arrayList.size()) continue;
                n = 0;
                if (l - (l2 += (long)SCHEDULE_PERIOD_MILLIS) <= (long)SCHEDULE_PERIOD_MAX_CATCHUP) continue;
                l2 = l + (long)SCHEDULE_PERIOD_MILLIS;
            }
            PeerControlSchedulerPrioritised peerControlSchedulerPrioritised = this;
            synchronized (peerControlSchedulerPrioritised) {
                if (this.latest_time == l) {
                    ++this.wait_count;
                    try {
                        long l4 = SystemTime.getHighPrecisionCounter();
                        this.wait();
                        long l5 = SystemTime.getHighPrecisionCounter() - l4;
                        this.total_wait_time += l5;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                } else {
                    ++this.yield_count;
                    Thread.yield();
                }
                l = this.latest_time;
            }
            long l6 = l - l3;
            if (l6 <= 10000L) continue;
            l3 = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(PeerControlInstance peerControlInstance) {
        instanceWrapper instanceWrapper2 = new instanceWrapper(peerControlInstance);
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> hashMap = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            hashMap.put(peerControlInstance, instanceWrapper2);
            this.instance_map = hashMap;
            this.pending_registrations.add(instanceWrapper2);
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(PeerControlInstance peerControlInstance) {
        try {
            this.this_mon.enter();
            HashMap hashMap = new HashMap(this.instance_map);
            instanceWrapper instanceWrapper2 = (instanceWrapper)hashMap.remove(peerControlInstance);
            if (instanceWrapper2 == null) {
                Debug.out("instance wrapper not found");
                return;
            }
            instanceWrapper2.unregister();
            this.instance_map = hashMap;
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public SpeedTokenDispenser getSpeedTokenDispenser() {
        return this.tokenDispenser;
    }

    @Override
    public void updateScheduleOrdering() {
        this.registrations_changed = true;
    }

    protected static class instanceWrapper
    implements Comparable {
        private PeerControlInstance instance;
        private boolean unregistered;
        private long offset;

        protected instanceWrapper(PeerControlInstance peerControlInstance) {
            this.instance = peerControlInstance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setScheduleOffset(long l) {
            this.offset = l;
        }

        protected long getScheduleOffset() {
            return this.offset;
        }

        protected PeerControlInstance getInstance() {
            return this.instance;
        }

        protected void schedule() {
            try {
                this.instance.schedule();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }

        public int compareTo(Object object) {
            return this.instance.getSchedulePriority() - ((instanceWrapper)object).instance.getSchedulePriority();
        }
    }
}

