/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZBadPiece
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private int piece_number;

    public AZBadPiece(int n, byte by) {
        this.piece_number = n;
        this.version = by;
    }

    @Override
    public String getID() {
        return "AZ_BAD_PIECE";
    }

    @Override
    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_BAD_PIECE_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "AZ1";
    }

    @Override
    public int getFeatureSubID() {
        return 5;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.getID() + " " + this.piece_number;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("piece", new Long(this.piece_number));
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        Map map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 1, this.getID());
        int n = ((Long)map.get("piece")).intValue();
        AZBadPiece aZBadPiece = new AZBadPiece(n, by);
        return aZBadPiece;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

