/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTHave
implements BTMessage {
    private byte version;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int piece_number;

    public BTHave(int n, byte by) {
        this.piece_number = n;
        this.version = by;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    @Override
    public String getID() {
        return "BT_HAVE";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_HAVE_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "BT1";
    }

    @Override
    public int getFeatureSubID() {
        return 4;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = "BT_HAVE piece #" + this.piece_number;
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)17, 4);
            this.buffer.putInt((byte)11, this.piece_number);
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        if (directByteBuffer == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (directByteBuffer.remaining((byte)11) != 4) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + directByteBuffer.remaining((byte)11) + "] != 4");
        }
        int n = directByteBuffer.getInt((byte)11);
        if (n < 0) {
            throw new MessageException("[" + this.getID() + "] decode error: number < 0");
        }
        directByteBuffer.returnToPool();
        return new BTHave(n, by);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

