/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.proxy.AEProxyAddressMapper;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;

public class AEProxyAddressMapperImpl
implements AEProxyAddressMapper {
    protected static AEProxyAddressMapper singleton = new AEProxyAddressMapperImpl();
    protected boolean enabled;
    protected String prefix;
    protected long next_value;
    protected Map map = new HashMap();
    protected Map reverse_map = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("AEProxyAddressMapper");

    public static AEProxyAddressMapper getSingleton() {
        return singleton;
    }

    protected AEProxyAddressMapperImpl() {
        if (COConfigurationManager.getBooleanParameter("Enable.Proxy") && COConfigurationManager.getBooleanParameter("Enable.SOCKS")) {
            String string = COConfigurationManager.getStringParameter("Proxy.Host");
            try {
                if (string.length() > 0 && InetAddress.getByName(string).isLoopbackAddress()) {
                    this.enabled = true;
                    byte[] byArray = new byte[120];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)(Math.random() * 256.0);
                    }
                    this.prefix = ByteFormatter.encodeString(byArray);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String internalise(String string) {
        String string2;
        if (!this.enabled) {
            return string;
        }
        if (string.length() < 256) {
            return string;
        }
        try {
            this.this_mon.enter();
            string2 = (String)this.reverse_map.get(string);
            if (string2 == null) {
                string2 = this.prefix + this.next_value++;
                while (string2.length() < 255) {
                    string2 = string2 + "0";
                }
                this.map.put(string2, string);
                this.reverse_map.put(string, string2);
            }
        }
        finally {
            this.this_mon.exit();
        }
        return string2;
    }

    @Override
    public String externalise(String string) {
        if (!this.enabled || string.length() < 255) {
            return string;
        }
        String string2 = (String)this.map.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public URL internalise(URL uRL) {
        if (!this.enabled) {
            return uRL;
        }
        String string = uRL.getHost();
        if (string.length() < 256) {
            return uRL;
        }
        String string2 = this.internalise(string);
        String string3 = uRL.toString();
        int n = string3.indexOf(string);
        if (n == -1) {
            Debug.out("inconsistent url '" + string3 + "' / '" + string + "'");
            return uRL;
        }
        String string4 = string3.substring(0, n) + string2 + string3.substring(n + string.length());
        try {
            return new URL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
            return uRL;
        }
    }

    @Override
    public URL externalise(URL uRL) {
        if (!this.enabled) {
            return uRL;
        }
        String string = uRL.getHost();
        if (string.length() < 255) {
            return uRL;
        }
        String string2 = this.externalise(string);
        String string3 = uRL.toString();
        int n = string3.indexOf(string);
        if (n == -1) {
            Debug.out("inconsistent url '" + string3 + "' / '" + string + "'");
            return uRL;
        }
        String string4 = string3.substring(0, n) + string2 + string3.substring(n + string.length());
        try {
            return new URL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
            return uRL;
        }
    }
}

