/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.impl.v2.PingSpaceMapper;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;
import org.gudy.azureus2.core3.util.SystemTime;

public class PingSpaceMonitor {
    PingSpaceMapper pingMap;
    long startTime;
    private static final long INTERVAL = 300000L;
    int maxGoodPing;
    int minBadPing;
    int nBadPings;
    int nGoodPings;
    int nNeutralPings = 0;
    int upNone;
    int upLow;
    int upMed;
    int upHigh;
    int upAtLimit = 0;
    int downNone;
    int downLow;
    int downMed;
    int downHigh;
    int downAtLimit = 0;
    TransferMode transferMode;
    public static final int UPLOAD = 88;
    public static final int DOWNLOAD = 89;
    public static final int NONE = 0;
    boolean hasNewLimit = false;
    int newLimit = -2;
    int limitType = 0;

    public PingSpaceMonitor(int n, int n2, TransferMode transferMode) {
        this.maxGoodPing = n;
        this.minBadPing = n2;
        this.reset(transferMode);
    }

    public void setCurrentTransferRates(int n, int n2) {
        this.pingMap.setCurrentTransferRates(n, n2);
    }

    public boolean addToPingMapData(int n, TransferMode transferMode) {
        if (this.transferMode == null) {
            this.transferMode = transferMode;
        }
        if (!this.transferMode.equals(transferMode)) {
            this.reset(transferMode);
            this.transferMode = transferMode;
            return false;
        }
        this.transferMode = transferMode;
        if (n < this.maxGoodPing) {
            ++this.nGoodPings;
        } else if (n > this.minBadPing) {
            ++this.nBadPings;
        } else {
            ++this.nNeutralPings;
        }
        this.pingMap.addMetricToMap(n);
        long l = SystemTime.getCurrentTime();
        if (l > this.startTime + 300000L) {
            boolean bl = this.checkForLowerLimits();
            if (bl) {
                if (this.transferMode.isConfTestingLimits()) {
                    this.reset(transferMode);
                    return false;
                }
                if (this.transferMode.isDownloadMode()) {
                    this.newLimit = this.pingMap.guessDownloadLimit();
                    SpeedManagerLogger.trace("PingSpaceMonitor -> guessDownloadLimit: newLimit=" + this.newLimit);
                    int n2 = this.pingMap.guessUploadLimit();
                    SpeedManagerLogger.trace("PingSpaceMonitor -> guessUploadLimit: guessUploadLimit=" + n2);
                    if (this.newLimit < 40960) {
                        this.newLimit = 40960;
                    }
                    this.hasNewLimit = true;
                    this.limitType = 89;
                    this.reset(transferMode);
                    return true;
                }
                this.newLimit = this.pingMap.guessUploadLimit();
                if (this.newLimit < 20480) {
                    this.newLimit = 20480;
                }
                this.hasNewLimit = true;
                this.limitType = 88;
                this.reset(transferMode);
                return true;
            }
            this.reset(transferMode);
        }
        return false;
    }

    private boolean checkForLowerLimits() {
        int n = this.nGoodPings + this.nBadPings + this.nNeutralPings;
        float f = (float)this.nBadPings / (float)n;
        return f > 0.15f;
    }

    public void reset(TransferMode transferMode) {
        StringBuffer stringBuffer = new StringBuffer("ping-monitor:");
        stringBuffer.append("good=").append(this.nGoodPings).append(":");
        stringBuffer.append("bad=").append(this.nBadPings).append(":");
        stringBuffer.append("neutral=").append(this.nNeutralPings);
        SpeedManagerLogger.log(stringBuffer.toString());
        this.nNeutralPings = 0;
        this.nGoodPings = 0;
        this.nBadPings = 0;
        this.upAtLimit = 0;
        this.upHigh = 0;
        this.upMed = 0;
        this.upLow = 0;
        this.upNone = 0;
        this.downAtLimit = 0;
        this.downHigh = 0;
        this.downMed = 0;
        this.downLow = 0;
        this.downNone = 0;
        this.pingMap = new PingSpaceMapper(this.maxGoodPing, this.minBadPing);
        this.startTime = SystemTime.getCurrentTime();
        this.transferMode = transferMode;
    }

    boolean hasNewLimit() {
        return this.hasNewLimit;
    }

    public int getNewLimit() {
        return this.newLimit;
    }

    public int limitType() {
        return this.limitType;
    }

    public void resetNewLimit() {
        this.hasNewLimit = false;
        this.newLimit = -2;
        this.limitType = 0;
    }
}

