/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloaderRange
implements ExternalSeedHTTPDownloader,
SEPasswordListener {
    public static final String NL = "\r\n";
    private URL original_url;
    private String user_agent;
    private URL redirected_url;
    private int consec_redirect_fails;
    private int last_response;
    private int last_response_retry_after_secs;

    public ExternalSeedHTTPDownloaderRange(URL uRL, String string) {
        this.original_url = uRL;
        this.user_agent = string;
    }

    public URL getURL() {
        return this.original_url;
    }

    @Override
    public void download(int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        this.download(new String[0], new String[0], n, externalSeedHTTPDownloaderListener, bl);
    }

    @Override
    public void downloadRange(long l, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        this.download(new String[]{"Range"}, new String[]{"bytes=" + l + "-" + (l + (long)n - 1L)}, n, externalSeedHTTPDownloaderListener, bl);
    }

    public void download(String[] stringArray, String[] stringArray2, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        block33: {
            boolean bl2 = false;
            InputStream inputStream = null;
            String string = "";
            try {
                int n2;
                HttpURLConnection httpURLConnection;
                URL uRL;
                SESecurityManager.setThreadPasswordHandler(this);
                while (true) {
                    int n3;
                    uRL = this.redirected_url == null ? this.original_url : this.redirected_url;
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                    httpURLConnection.setRequestProperty("User-Agent", this.user_agent);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        httpURLConnection.setRequestProperty(stringArray[n3], stringArray2[n3]);
                    }
                    n3 = externalSeedHTTPDownloaderListener.getPermittedTime();
                    if (n3 > 0) {
                        Java15Utils.setConnectTimeout(httpURLConnection, n3);
                    }
                    httpURLConnection.connect();
                    n3 = externalSeedHTTPDownloaderListener.getPermittedTime();
                    if (n3 < 0) {
                        throw new IOException("Timeout during connect");
                    }
                    Java15Utils.setReadTimeout(httpURLConnection, n3);
                    bl2 = true;
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 == 202 || n2 == 200 || n2 == 206) {
                        if (this.redirected_url == null) break;
                        this.consec_redirect_fails = 0;
                        break;
                    }
                    if (this.redirected_url == null) break;
                    ++this.consec_redirect_fails;
                    this.redirected_url = null;
                }
                uRL = httpURLConnection.getURL();
                if (this.consec_redirect_fails < 10 && !this.original_url.toExternalForm().equals(uRL.toExternalForm())) {
                    this.redirected_url = uRL;
                }
                this.last_response = n2;
                this.last_response_retry_after_secs = -1;
                if (n2 == 503) {
                    long l = new Long(httpURLConnection.getHeaderFieldDate("Retry-After", -1L));
                    if (l <= -1L) {
                        this.last_response_retry_after_secs = httpURLConnection.getHeaderFieldInt("Retry-After", -1);
                    } else {
                        this.last_response_retry_after_secs = (int)((l - System.currentTimeMillis()) / 1000L);
                        if (this.last_response_retry_after_secs < 0) {
                            this.last_response_retry_after_secs = -1;
                        }
                    }
                }
                inputStream = httpURLConnection.getInputStream();
                if (n2 == 202 || n2 == 200 || n2 == 206) {
                    int n4;
                    int n5;
                    byte[] byArray = null;
                    int n6 = 0;
                    int n7 = 0;
                    for (n4 = 0; n4 < n; n4 += n5) {
                        if (byArray == null) {
                            byArray = externalSeedHTTPDownloaderListener.getBuffer();
                            n6 = externalSeedHTTPDownloaderListener.getBufferPosition();
                            n7 = externalSeedHTTPDownloaderListener.getBufferLength();
                        }
                        externalSeedHTTPDownloaderListener.setBufferPosition(n6);
                        int n8 = n7 - n6;
                        int n9 = externalSeedHTTPDownloaderListener.getPermittedBytes();
                        if (n9 < n8) {
                            n8 = n9;
                        }
                        if ((n5 = inputStream.read(byArray, n6, n8)) < 0) break;
                        externalSeedHTTPDownloaderListener.reportBytesRead(n5);
                        if ((n6 += n5) != n7) continue;
                        externalSeedHTTPDownloaderListener.done();
                        byArray = null;
                        n6 = 0;
                    }
                    if (n4 != n) {
                        String string2;
                        if (byArray == null) {
                            string2 = "No buffer assigned";
                        } else {
                            string2 = new String(byArray, 0, n);
                            if (string2.length() > 64) {
                                string2 = string2.substring(0, 64);
                            }
                        }
                        string = "Connection failed: data too short - " + n + "/" + n4 + " [" + string2 + "]";
                        throw new ExternalSeedException(string);
                    }
                    string = "read " + n4 + " bytes";
                    break block33;
                }
                string = "Connection failed: " + httpURLConnection.getResponseMessage();
                ExternalSeedException externalSeedException = new ExternalSeedException(string);
                externalSeedException.setPermanentFailure(true);
                throw externalSeedException;
            }
            catch (IOException iOException) {
                if (bl && !bl2) {
                    string = "Connection failed: " + iOException.getMessage();
                    ExternalSeedException externalSeedException = new ExternalSeedException(string);
                    externalSeedException.setPermanentFailure(true);
                    throw externalSeedException;
                }
                string = "Connection failed: " + Debug.getNestedExceptionMessage(iOException);
                if (this.last_response_retry_after_secs >= 0) {
                    string = string + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                }
                ExternalSeedException externalSeedException = new ExternalSeedException(string, iOException);
                if (iOException instanceof FileNotFoundException) {
                    externalSeedException.setPermanentFailure(true);
                }
                throw externalSeedException;
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExternalSeedException) {
                    throw (ExternalSeedException)throwable;
                }
                string = "Connection failed: " + Debug.getNestedExceptionMessage(throwable);
                throw new ExternalSeedException("Connection failed", throwable);
            }
            finally {
                SESecurityManager.unsetThreadPasswordHandler();
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public void downloadSocket(int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        this.downloadSocket(new String[0], new String[0], n, externalSeedHTTPDownloaderListener, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadSocket(String[] stringArray, String[] stringArray2, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        block31: {
            Socket socket = null;
            boolean bl2 = false;
            try {
                int n2;
                String string = "GET " + this.original_url.getPath() + "?" + this.original_url.getQuery() + " HTTP/1.1" + NL + "Host: " + this.original_url.getHost() + (this.original_url.getPort() == -1 ? "" : ":" + this.original_url.getPort()) + NL + "Accept: */*" + NL + "Connection: Close" + NL + "User-Agent: " + this.user_agent + NL;
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    string = string + stringArray[n2] + ":" + stringArray2[n2] + NL;
                }
                string = string + NL;
                n2 = externalSeedHTTPDownloaderListener.getPermittedTime();
                if (n2 > 0) {
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(this.original_url.getHost(), this.original_url.getPort() == -1 ? this.original_url.getDefaultPort() : this.original_url.getPort()), n2);
                } else {
                    socket = new Socket(this.original_url.getHost(), this.original_url.getPort() == -1 ? this.original_url.getDefaultPort() : this.original_url.getPort());
                }
                bl2 = true;
                n2 = externalSeedHTTPDownloaderListener.getPermittedTime();
                if (n2 < 0) {
                    throw new IOException("Timeout during connect");
                }
                if (n2 > 0) {
                    socket.setSoTimeout(n2);
                }
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(string.getBytes("ISO-8859-1"));
                outputStream.flush();
                InputStream inputStream = socket.getInputStream();
                try {
                    int n3;
                    byte[] byArray;
                    String string2 = "";
                    do {
                        int n4;
                        if ((n4 = inputStream.read(byArray = new byte[1])) >= 0) continue;
                        throw new IOException("input too short reading header");
                    } while (!(string2 = string2 + (char)byArray[0]).endsWith("\r\n\r\n"));
                    int n5 = string2.indexOf(NL);
                    if (n5 == -1) {
                        throw new IOException("header too short");
                    }
                    String string3 = string2.substring(0, n5);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                    stringTokenizer.nextToken();
                    this.last_response = n3 = Integer.parseInt(stringTokenizer.nextToken());
                    this.last_response_retry_after_secs = -1;
                    String string4 = stringTokenizer.nextToken();
                    if (n3 == 202 || n3 == 200 || n3 == 206) {
                        int n6;
                        int n7;
                        byte[] byArray2 = null;
                        int n8 = 0;
                        int n9 = 0;
                        for (n6 = 0; n6 < n; n6 += n7) {
                            if (byArray2 == null) {
                                byArray2 = externalSeedHTTPDownloaderListener.getBuffer();
                                n8 = externalSeedHTTPDownloaderListener.getBufferPosition();
                                n9 = externalSeedHTTPDownloaderListener.getBufferLength();
                            }
                            int n10 = n9 - n8;
                            int n11 = externalSeedHTTPDownloaderListener.getPermittedBytes();
                            if (n11 < n10) {
                                n10 = n11;
                            }
                            if ((n7 = inputStream.read(byArray2, n8, n10)) < 0) break;
                            externalSeedHTTPDownloaderListener.reportBytesRead(n7);
                            if ((n8 += n7) != n9) continue;
                            externalSeedHTTPDownloaderListener.done();
                            byArray2 = null;
                            n8 = 0;
                        }
                        if (n6 != n) {
                            String string5 = byArray2 == null ? "No buffer assigned" : new String(byArray2, 0, n8 > 64 ? 64 : n8);
                            throw new ExternalSeedException("Connection failed: data too short - " + n + "/" + n6 + " [last=" + string5 + "]");
                        }
                        break block31;
                    }
                    if (n3 == 503) {
                        byte[] byArray3;
                        int n12;
                        String string6 = "";
                        while ((n12 = inputStream.read(byArray3 = new byte[1])) >= 0) {
                            string6 = string6 + (char)byArray3[0];
                        }
                        this.last_response_retry_after_secs = Integer.parseInt(string6);
                        throw new IOException("Server overloaded");
                    }
                    ExternalSeedException externalSeedException = new ExternalSeedException("Connection failed: " + string4);
                    externalSeedException.setPermanentFailure(true);
                    throw externalSeedException;
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                if (bl && !bl2) {
                    ExternalSeedException externalSeedException = new ExternalSeedException("Connection failed: " + iOException.getMessage());
                    externalSeedException.setPermanentFailure(true);
                    throw externalSeedException;
                }
                String string = "Connection failed: " + Debug.getNestedExceptionMessage(iOException);
                if (this.last_response_retry_after_secs >= 0) {
                    string = string + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                }
                throw new ExternalSeedException(string, iOException);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExternalSeedException) {
                    throw (ExternalSeedException)throwable;
                }
                throw new ExternalSeedException("Connection failed", throwable);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public void deactivate() {
    }

    @Override
    public PasswordAuthentication getAuthentication(String string, URL uRL) {
        return null;
    }

    @Override
    public void setAuthenticationOutcome(String string, URL uRL, boolean bl) {
    }

    @Override
    public void clearPasswords() {
    }

    @Override
    public int getLastResponse() {
        return this.last_response;
    }

    @Override
    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "";
            ExternalSeedHTTPDownloaderRange externalSeedHTTPDownloaderRange = new ExternalSeedHTTPDownloaderRange(new URL(string), "Azureus");
            externalSeedHTTPDownloaderRange.downloadRange(0L, 1, new ExternalSeedHTTPDownloaderListener(){
                private int position;

                @Override
                public byte[] getBuffer() throws ExternalSeedException {
                    return new byte[1024];
                }

                @Override
                public void setBufferPosition(int n) {
                    this.position = n;
                }

                @Override
                public int getBufferPosition() {
                    return this.position;
                }

                @Override
                public int getBufferLength() {
                    return 1024;
                }

                @Override
                public int getPermittedBytes() throws ExternalSeedException {
                    return 1024;
                }

                @Override
                public int getPermittedTime() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public void reportBytesRead(int n) {
                    System.out.println("read " + n);
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public void done() {
                    System.out.println("done");
                }
            }, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

