/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet.metadata;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class ByteUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] reverse(byte[] byArray) {
        int n = byArray.length;
        if (n > 0) {
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            int n3 = n - 1;
            while (n3 >= 0) {
                byArray2[n2++] = byArray[n3--];
            }
            return byArray2;
        }
        return byArray;
    }

    public static short leb2short(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF | byArray[n + 1] << 8);
    }

    public static short beb2short(byte[] byArray, int n) {
        return (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
    }

    public static short leb2short(InputStream inputStream) throws IOException {
        return (short)(ByteUtils.readByte(inputStream) & 0xFF | ByteUtils.readByte(inputStream) << 8);
    }

    public static short beb2short(InputStream inputStream) throws IOException {
        return (short)(ByteUtils.readByte(inputStream) << 8 | ByteUtils.readByte(inputStream) & 0xFF);
    }

    public static int leb2int(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    public static int beb2int(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static int leb2int(InputStream inputStream) throws IOException {
        return ByteUtils.readByte(inputStream) & 0xFF | (ByteUtils.readByte(inputStream) & 0xFF) << 8 | (ByteUtils.readByte(inputStream) & 0xFF) << 16 | ByteUtils.readByte(inputStream) << 24;
    }

    public static int beb2int(InputStream inputStream) throws IOException {
        return ByteUtils.readByte(inputStream) << 24 | (ByteUtils.readByte(inputStream) & 0xFF) << 16 | (ByteUtils.readByte(inputStream) & 0xFF) << 8 | ByteUtils.readByte(inputStream) & 0xFF;
    }

    public static int leb2int(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n2) {
            case 1: {
                return byArray[n] & 0xFF;
            }
            case 2: {
                return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
            }
            case 3: {
                return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16;
            }
            case 4: {
                return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static long leb2long(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n2) {
            case 1: {
                return (long)byArray[n] & 0xFFL;
            }
            case 2: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8;
            }
            case 3: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16;
            }
            case 4: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24;
            }
            case 5: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32;
            }
            case 6: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40;
            }
            case 7: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48;
            }
            case 8: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | (long)byArray[n + 7] << 56;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static long leb2long(InputStream inputStream) throws IOException {
        return (long)ByteUtils.readByte(inputStream) & 0xFFL | ((long)ByteUtils.readByte(inputStream) & 0xFFL) << 8 | ((long)ByteUtils.readByte(inputStream) & 0xFFL) << 16 | ((long)ByteUtils.readByte(inputStream) & 0xFFL) << 24 | ((long)ByteUtils.readByte(inputStream) & 0xFFL) << 32 | ((long)ByteUtils.readByte(inputStream) & 0xFFL) << 40 | ((long)ByteUtils.readByte(inputStream) & 0xFFL) << 48 | (long)(ByteUtils.readByte(inputStream) << 56);
    }

    public static int beb2int(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n2) {
            case 1: {
                return byArray[n] & 0xFF;
            }
            case 2: {
                return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
            }
            case 3: {
                return (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
            }
            case 4: {
                return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static void short2leb(short s, byte[] byArray, int n) {
        byArray[n] = (byte)s;
        byArray[n + 1] = (byte)(s >> 8);
    }

    public static void short2beb(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
    }

    public static void short2leb(short s, OutputStream outputStream) throws IOException {
        outputStream.write((byte)s);
        outputStream.write((byte)(s >> 8));
    }

    public static void short2beb(short s, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(s >> 8));
        outputStream.write((byte)s);
    }

    public static void int2leb(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 3] = (byte)(n >> 24);
    }

    public static void long2beb(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static void long2leb(long l, byte[] byArray, int n) {
        byArray[n] = (byte)l;
        byArray[n + 1] = (byte)(l >> 8);
        byArray[n + 2] = (byte)(l >> 16);
        byArray[n + 3] = (byte)(l >> 24);
        byArray[n + 4] = (byte)(l >> 32);
        byArray[n + 5] = (byte)(l >> 40);
        byArray[n + 6] = (byte)(l >> 48);
        byArray[n + 7] = (byte)(l >> 56);
    }

    public static byte[] long2bytes(long l, int n) {
        byte[] byArray = new byte[8];
        byArray[7] = (byte)l;
        byArray[6] = (byte)(l >>>= 8);
        byArray[5] = (byte)(l >>>= 8);
        byArray[4] = (byte)(l >>>= 8);
        byArray[3] = (byte)(l >>>= 8);
        byArray[2] = (byte)(l >>>= 8);
        byArray[1] = (byte)(l >>>= 8);
        byArray[0] = (byte)(l >>>= 8);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 8 - n, byArray2, 0, n);
        return byArray2;
    }

    public static void int2beb(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static void int2beb(int n, OutputStream outputStream, int n2) throws IOException {
        switch (n2) {
            case 1: {
                outputStream.write((byte)n);
                break;
            }
            case 2: {
                outputStream.write((byte)(n >> 8));
                outputStream.write((byte)n);
                break;
            }
            case 3: {
                outputStream.write((byte)(n >> 16));
                outputStream.write((byte)(n >> 8));
                outputStream.write((byte)n);
                break;
            }
            case 4: {
                outputStream.write((byte)(n >> 24));
                outputStream.write((byte)(n >> 16));
                outputStream.write((byte)(n >> 8));
                outputStream.write((byte)n);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid n: " + n2);
            }
        }
    }

    public static void int2leb(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)n);
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 24));
    }

    public static void int2beb(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 24));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static byte[] int2minLeb(int n) throws IllegalArgumentException {
        if (n <= 65535) {
            if (n <= 255) {
                if (n < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)n};
            }
            return new byte[]{(byte)n, (byte)(n >> 8)};
        }
        if (n <= 0xFFFFFF) {
            return new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16)};
        }
        return new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
    }

    public static byte[] long2minLeb(long l) throws IllegalArgumentException {
        if (l <= 0xFFFFFFFFFFFFFFL) {
            if (l <= 0xFFFFFFFFFFFFL) {
                if (l <= 0xFFFFFFFFFFL) {
                    if (l <= 0xFFFFFFFFL) {
                        if (l <= 0xFFFFFFL) {
                            if (l <= 65535L) {
                                if (l <= 255L) {
                                    if (l < 0L) {
                                        throw new IllegalArgumentException();
                                    }
                                    return new byte[]{(byte)l};
                                }
                                return new byte[]{(byte)l, (byte)(l >> 8)};
                            }
                            return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16)};
                        }
                        return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24)};
                    }
                    return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32)};
                }
                return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40)};
            }
            return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40), (byte)(l >> 48)};
        }
        return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40), (byte)(l >> 48), (byte)(l >> 56)};
    }

    public static byte[] int2minBeb(int n) throws IllegalArgumentException {
        if (n <= 65535) {
            if (n <= 255) {
                if (n < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)n};
            }
            return new byte[]{(byte)(n >> 8), (byte)n};
        }
        if (n <= 0xFFFFFF) {
            return new byte[]{(byte)(n >> 16), (byte)(n >> 8), (byte)n};
        }
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    public static int ubyte2int(byte by) {
        return by & 0xFF;
    }

    public static int ushort2int(short s) {
        return s & 0xFFFF;
    }

    public static long uint2long(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        int n = Integer.MAX_VALUE;
        if (l < (long)Integer.MAX_VALUE) {
            n = Integer.MIN_VALUE;
            if (l > (long)Integer.MIN_VALUE) {
                return (int)l;
            }
        }
        return n;
    }

    public static long beb2long(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n2) {
            case 1: {
                return (long)byArray[n] & 0xFFL;
            }
            case 2: {
                return (long)byArray[n + 1] & 0xFFL | ((long)byArray[n] & 0xFFL) << 8;
            }
            case 3: {
                return (long)byArray[n + 2] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n] & 0xFFL) << 16;
            }
            case 4: {
                return (long)byArray[n + 3] & 0xFFL | ((long)byArray[n + 2] & 0xFFL) << 8 | ((long)byArray[n + 1] & 0xFFL) << 16 | ((long)byArray[n] & 0xFFL) << 24;
            }
            case 5: {
                return (long)byArray[n + 4] & 0xFFL | ((long)byArray[n + 3] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 1] & 0xFFL) << 24 | ((long)byArray[n] & 0xFFL) << 32;
            }
            case 6: {
                return (long)byArray[n + 5] & 0xFFL | ((long)byArray[n + 4] & 0xFFL) << 8 | ((long)byArray[n + 3] & 0xFFL) << 16 | ((long)byArray[n + 2] & 0xFFL) << 24 | ((long)byArray[n + 1] & 0xFFL) << 32 | ((long)byArray[n] & 0xFFL) << 40;
            }
            case 7: {
                return (long)byArray[n + 6] & 0xFFL | ((long)byArray[n + 5] & 0xFFL) << 8 | ((long)byArray[n + 4] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 2] & 0xFFL) << 32 | ((long)byArray[n + 1] & 0xFFL) << 40 | ((long)byArray[n] & 0xFFL) << 48;
            }
            case 8: {
                return (long)byArray[n + 7] & 0xFFL | ((long)byArray[n + 6] & 0xFFL) << 8 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n] & 0xFFL) << 56;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    private static int readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    private ByteUtils() {
    }

    public static byte[] smallIntToByteArray(int n) {
        if (n > 65535) {
            throw new IllegalArgumentException("value is too big");
        }
        return new byte[]{(byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
    }

    public static int byteArrayToSmallInt(byte[] byArray, int n) {
        if (byArray == null || byArray.length - n < 2) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        return ((byArray[n] & 0xFF) << 8) + (byArray[1 + n] & 0xFF);
    }

    public static byte[] smallIntToTripleByteArray(int n) {
        if (n > 0xFFFFFF) {
            throw new IllegalArgumentException("value is too big");
        }
        return new byte[]{(byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
    }

    public static int tripleByteArrayToSmallInt(byte[] byArray, int n) {
        if (byArray == null || byArray.length - n < 2) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        return ((byArray[n] & 0xFF) << 16) + ((byArray[1 + n] & 0xFF) << 8) + (byArray[2 + n] & 0xFF);
    }

    public static byte[] getByteArrayChecksum(byte[] byArray) {
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("Byte array is too long");
        }
        int n = 0;
        int n2 = byArray.length > 100 ? 16 : 1;
        for (int i = 0; i < byArray.length; i += n2) {
            n += byArray[i] & 0xFF;
        }
        return ByteUtils.smallIntToTripleByteArray(n);
    }

    public static byte[] appendByteArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static int randomInt(int n, int n2) {
        Random random = new Random(System.currentTimeMillis());
        return n + random.nextInt(n2 - n);
    }

    public static byte[] decodeHex(String string) {
        string = string.toLowerCase();
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String encodeHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = DIGITS[(0xF0 & byArray[i]) >>> 4];
            cArray[n2++] = DIGITS[0xF & byArray[i]];
        }
        return new String(cArray);
    }
}

