/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet.metadata;

import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.plugins.magnet.metadata.MetadataPeerListener;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class MetadataPeerManagerAdapter
implements PEPeerManagerAdapter {
    private final MetadataPeerListener peerListener;
    private final PeerManagerRegistration peerMangerRegistration;
    private final String externalIp;
    private final Set<String> manualIps;
    private final int localTcpPort;
    private PEPeerManager peerManager;

    public MetadataPeerManagerAdapter(MetadataPeerListener metadataPeerListener) {
        this.peerListener = metadataPeerListener;
        this.peerMangerRegistration = new PeerManagerRegistration(){

            @Override
            public void unregister() {
            }

            @Override
            public void removeLink(String string) {
            }

            @Override
            public TOTorrentFile getLink(String string) {
                return null;
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public void deactivate() {
            }

            @Override
            public void addLink(String string, TOTorrentFile tOTorrentFile) throws Exception {
            }

            @Override
            public void activate(PEPeerControl pEPeerControl) {
            }
        };
        this.externalIp = this.getExternalIp();
        this.localTcpPort = TCPNetworkManager.getSingleton().getTCPListeningPortNumber();
        this.manualIps = new HashSet<String>();
    }

    public PEPeerManager getPeerManager() {
        return this.peerManager;
    }

    public void setPeerManager(PEPeerManager pEPeerManager) {
        this.peerManager = pEPeerManager;
    }

    @Override
    public void statsRequest(PEPeer pEPeer, Map map, Map map2) {
    }

    @Override
    public void setTrackerRefreshDelayOverrides(int n) {
    }

    @Override
    public void setStateSeeding(boolean bl) {
    }

    @Override
    public void setStateFinishing() {
    }

    @Override
    public void restartDownload(boolean bl) {
    }

    @Override
    public void removePiece(PEPiece pEPiece) {
    }

    @Override
    public void removePeer(PEPeer pEPeer) {
    }

    @Override
    public void protocolBytesSent(PEPeer pEPeer, int n) {
    }

    @Override
    public void protocolBytesReceived(PEPeer pEPeer, int n) {
    }

    @Override
    public void priorityConnectionChanged(boolean bl) {
    }

    @Override
    public void permittedSendBytesUsed(int n) {
    }

    @Override
    public void permittedReceiveBytesUsed(int n) {
    }

    @Override
    public boolean isPeriodicRescanEnabled() {
        return false;
    }

    @Override
    public boolean isPeerSourceEnabled(String string) {
        return false;
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return true;
    }

    @Override
    public boolean isNATHealthy() {
        return false;
    }

    @Override
    public boolean isExtendedMessagingEnabled() {
        return true;
    }

    @Override
    public boolean hasPriorityConnection() {
        return false;
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return null;
    }

    @Override
    public String getTrackerClientExtensions() {
        return null;
    }

    @Override
    public byte[][] getSecrets(int n) {
        return null;
    }

    @Override
    public long getRandomSeed() {
        return 0L;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public int getPermittedBytesToSend() {
        return 0;
    }

    @Override
    public int getPermittedBytesToReceive() {
        return 0;
    }

    @Override
    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peerMangerRegistration;
    }

    @Override
    public int getMaxUploads() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxSeedConnections() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public LogRelation getLogRelation() {
        return null;
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public int getCryptoLevel() {
        return 0;
    }

    @Override
    public void enqueueReadRequest(PEPeer pEPeer, DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener) {
    }

    @Override
    public void discarded(PEPeer pEPeer, int n) {
    }

    @Override
    public void dataBytesSent(PEPeer pEPeer, int n) {
    }

    @Override
    public void dataBytesReceived(PEPeer pEPeer, int n) {
    }

    @Override
    public void addPiece(PEPiece pEPiece) {
    }

    @Override
    public void addPeer(PEPeer pEPeer) {
        pEPeer.addListener(this.peerListener);
        if (this.peerManager != null && pEPeer.getIp().equals(this.externalIp) && pEPeer.getPort() != this.localTcpPort && !this.manualIps.contains(pEPeer.getIp())) {
            String string = this.getPeerLocalIp(pEPeer.getPort());
            if (string == null) {
                this.refreshMappings();
                string = this.getPeerLocalIp(pEPeer.getPort());
            }
            if (string != null) {
                this.manualIps.add(string);
                this.peerManager.addPeer(string, pEPeer.getPort(), 0, false, new HashMap());
            }
        }
    }

    @Override
    public void addHTTPSeed(String string, int n) {
    }

    private String getExternalIp() {
        Utilities utilities = PluginInitializer.getDefaultInterface().getUtilities();
        InetAddress inetAddress = utilities.getPublicAddress();
        return inetAddress != null ? inetAddress.getHostAddress() : null;
    }

    private String getPeerLocalIp(int n) {
        if (n == 0) {
            return null;
        }
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        if (pluginInterface != null) {
            UPnPPluginService[] uPnPPluginServiceArray;
            UPnPPlugin uPnPPlugin = (UPnPPlugin)pluginInterface.getPlugin();
            for (UPnPPluginService uPnPPluginService : uPnPPluginServiceArray = uPnPPlugin.getServices()) {
                for (UPnPPluginService.serviceMapping serviceMapping2 : uPnPPluginService.getMappings()) {
                    if (!serviceMapping2.isTCP() || serviceMapping2.getPort() != n) continue;
                    return serviceMapping2.getInternalHost();
                }
            }
            return null;
        }
        return null;
    }

    private void refreshMappings() {
        try {
            System.out.println("Refreshig UPnP mappings");
            PluginInterface pluginInterface = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (pluginInterface != null) {
                UPnPPlugin uPnPPlugin = (UPnPPlugin)pluginInterface.getPlugin();
                uPnPPlugin.refreshMappings(true);
                Thread.sleep(10000L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

