/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.tracker;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.CopyOnWriteSet;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2TrackerListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginListener;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTrackerListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SHA1;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class BuddyPluginTracker
implements BuddyPluginListener,
DownloadManagerListener,
BuddyPluginAZ2TrackerListener,
DownloadPeerListener {
    private static final Object PEER_KEY = new Object();
    private static final Object PEER_STATS_KEY = new Object();
    public static final int BUDDY_NETWORK_IDLE = 1;
    public static final int BUDDY_NETWORK_OUTBOUND = 2;
    public static final int BUDDY_NETWORK_INBOUND = 3;
    private static final int TRACK_CHECK_PERIOD = 15000;
    private static final int TRACK_CHECK_TICKS = 1;
    private static final int PEER_CHECK_PERIOD = 60000;
    private static final int PEER_CHECK_TICKS = 6;
    private static final int PEER_RECHECK_PERIOD = 120000;
    private static final int PEER_RECHECK_TICKS = 12;
    private static final int TRACK_INTERVAL = 600000;
    private static final int SHORT_ID_SIZE = 4;
    private static final int FULL_ID_SIZE = 20;
    private static final int REQUEST_TRACKER_SUMMARY = 1;
    private static final int REPLY_TRACKER_SUMMARY = 2;
    private static final int REQUEST_TRACKER_STATUS = 3;
    private static final int REPLY_TRACKER_STATUS = 4;
    private static final int REQUEST_TRACKER_CHANGE = 5;
    private static final int REPLY_TRACKER_CHANGE = 6;
    private static final int REQUEST_TRACKER_ADD = 7;
    private static final int REPLY_TRACKER_ADD = 8;
    private static final int RETRY_SEND_MIN = 300000;
    private static final int RETRY_SEND_MAX = 3600000;
    private static final int BUDDY_NO = 0;
    private static final int BUDDY_MAYBE = 1;
    private static final int BUDDY_YES = 2;
    private BuddyPlugin plugin;
    private boolean plugin_enabled;
    private boolean tracker_enabled;
    private boolean seeding_only;
    private boolean old_plugin_enabled;
    private boolean old_tracker_enabled;
    private boolean old_seeding_only;
    private int network_status = 1;
    private Set online_buddies = new HashSet();
    private Map online_buddy_ips = new HashMap();
    private Set tracked_downloads = new HashSet();
    private int download_set_id;
    private Set last_processed_download_set;
    private int last_processed_download_set_id;
    private Map short_id_map = new HashMap();
    private Map full_id_map = new HashMap();
    private Set actively_tracking = new HashSet();
    private CopyOnWriteSet buddy_peers = new CopyOnWriteSet();
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private TimerEventPeriodic buddy_stats_timer;
    private Average buddy_receive_speed = Average.getInstance(1000, 10);
    private Average buddy_send_speed = Average.getInstance(1000, 10);

    public BuddyPluginTracker(BuddyPlugin buddyPlugin, BasicPluginConfigModel basicPluginConfigModel) {
        this.plugin = buddyPlugin;
        final BooleanParameter booleanParameter = basicPluginConfigModel.addBooleanParameter2("azbuddy.tracker.enabled", "azbuddy.tracker.enabled", true);
        this.tracker_enabled = booleanParameter.getValue();
        booleanParameter.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                BuddyPluginTracker.this.tracker_enabled = booleanParameter.getValue();
                BuddyPluginTracker.this.checkEnabledState();
            }
        });
        GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
        globalManager.addListener(new GlobalManagerAdapter(){

            @Override
            public void seedingStatusChanged(boolean bl, boolean bl2) {
                BuddyPluginTracker.this.seeding_only = bl2;
                BuddyPluginTracker.this.checkEnabledState();
            }
        }, false);
        this.seeding_only = globalManager.isPotentiallySeedingOnly();
        this.checkEnabledState();
    }

    public void initialise() {
        this.plugin_enabled = this.plugin.isEnabled();
        this.checkEnabledState();
        List<BuddyPluginBuddy> list = this.plugin.getBuddies();
        for (int i = 0; i < list.size(); ++i) {
            this.buddyAdded(list.get(i));
        }
        this.plugin.addListener(this);
        this.plugin.getAZ2Handler().addTrackerListener(this);
        this.plugin.getPluginInterface().getDownloadManager().addListener(this, true);
    }

    public void tick(int n) {
        if (n % 1 == 0) {
            this.checkTracking();
        }
        if ((n - 1) % 1 == 0) {
            this.doTracking();
        }
        if (n % 6 == 0) {
            this.checkPeers();
        }
        if (n % 12 == 0) {
            this.recheckPeers();
        }
    }

    public int getNetworkStatus() {
        return this.network_status;
    }

    public long getNetworkReceiveBytesPerSecond() {
        return this.buddy_receive_speed.getAverage();
    }

    public long getNetworkSendBytesPerSecond() {
        return this.buddy_send_speed.getAverage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTracking() {
        Download download;
        List list;
        Object object;
        if (!this.plugin_enabled || !this.tracker_enabled) {
            return;
        }
        HashMap hashMap = new HashMap();
        HashSet<Download> hashSet = new HashSet<Download>();
        Object object3 = this.online_buddies;
        synchronized (object3) {
            for (BuddyPluginBuddy buddyPluginBuddy : this.online_buddies) {
                object = this.getBuddyData(buddyPluginBuddy);
                Map map = ((buddyData)object).getDownloadsToTrack();
                if (map.size() <= 0) continue;
                Iterator iterator = map.entrySet().iterator();
                list = new ArrayList<Download>();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    download = (Download)entry.getKey();
                    boolean bl = (Boolean)entry.getValue();
                    if (bl) {
                        list.add(download);
                    }
                    hashSet.add(download);
                }
                if (list.size() <= 0) continue;
                hashMap.put(buddyPluginBuddy, list);
            }
        }
        object3 = this.actively_tracking;
        synchronized (object3) {
            for (Download download2 : hashSet) {
                if (this.actively_tracking.contains(download2)) continue;
                this.actively_tracking.add(download2);
                this.trackPeers(download2);
            }
            Iterator iterator = this.actively_tracking.iterator();
            while (iterator.hasNext()) {
                Download download3 = (Download)iterator.next();
                if (hashSet.contains(download3)) continue;
                iterator.remove();
                this.untrackPeers(download3);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)entry.getKey();
            if (!buddyPluginBuddy.isOnline(false) || (object = buddyPluginBuddy.getAdjustedIP()) == null) continue;
            int n = buddyPluginBuddy.getTCPPort();
            int n2 = buddyPluginBuddy.getUDPPort();
            list = (List)entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                Object object2;
                download = (Download)list.get(i);
                PeerManager peerManager = download.getPeerManager();
                if (peerManager == null) continue;
                Peer[] peerArray = peerManager.getPeers(((InetAddress)object).getHostAddress());
                boolean bl = false;
                for (int j = 0; j < peerArray.length; ++j) {
                    object2 = peerArray[j];
                    if (object2.getTCPListenPort() != n && object2.getUDPListenPort() != n2) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.log(download.getName() + " - peer " + ((InetAddress)object).getHostAddress() + " already connected");
                    continue;
                }
                this.log(download.getName() + " - connecting to peer " + ((InetAddress)object).getHostAddress());
                PEPeerManager pEPeerManager = PluginCoreUtils.unwrap(peerManager);
                object2 = new LightHashMap();
                object2.put(PEER_KEY, download);
                object2.put(Peer.PR_PRIORITY_CONNECTION, new Boolean(true));
                pEPeerManager.addPeer(((InetAddress)object).getHostAddress(), n, n2, true, (Map)object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTracking() {
        int n;
        int n2;
        ArrayList arrayList;
        if (!this.plugin_enabled || !this.tracker_enabled) {
            return;
        }
        Set set = this.online_buddies;
        synchronized (set) {
            arrayList = new ArrayList(this.online_buddies);
        }
        Object object = this.tracked_downloads;
        synchronized (object) {
            int n3 = n2 = this.last_processed_download_set_id != this.download_set_id ? 1 : 0;
            if (n2 != 0) {
                this.last_processed_download_set = new HashSet(this.tracked_downloads);
                this.last_processed_download_set_id = this.download_set_id;
            }
            set = this.last_processed_download_set;
            n = this.last_processed_download_set_id;
        }
        object = new HashMap();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)arrayList.get(n2);
            buddyData buddyData2 = this.getBuddyData(buddyPluginBuddy);
            buddyData2.updateLocal(set, n, (Map)object);
        }
    }

    @Override
    public void initialised(boolean bl) {
    }

    @Override
    public void buddyAdded(BuddyPluginBuddy buddyPluginBuddy) {
        this.buddyChanged(buddyPluginBuddy);
    }

    @Override
    public void buddyRemoved(BuddyPluginBuddy buddyPluginBuddy) {
        this.buddyChanged(buddyPluginBuddy);
    }

    @Override
    public void buddyChanged(BuddyPluginBuddy buddyPluginBuddy) {
        if (buddyPluginBuddy.isOnline(false)) {
            this.addBuddy(buddyPluginBuddy);
        } else {
            this.removeBuddy(buddyPluginBuddy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected buddyData getBuddyData(BuddyPluginBuddy buddyPluginBuddy) {
        Set set = this.online_buddies;
        synchronized (set) {
            buddyData buddyData2 = (buddyData)buddyPluginBuddy.getUserData(BuddyPluginTracker.class);
            if (buddyData2 == null) {
                buddyData2 = new buddyData(buddyPluginBuddy);
                buddyPluginBuddy.setUserData(BuddyPluginTracker.class, buddyData2);
            }
            return buddyData2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected buddyData addBuddy(BuddyPluginBuddy buddyPluginBuddy) {
        Set set = this.online_buddies;
        synchronized (set) {
            buddyData buddyData2;
            if (!this.online_buddies.contains(buddyPluginBuddy)) {
                this.online_buddies.add(buddyPluginBuddy);
            }
            if ((buddyData2 = this.getBuddyData(buddyPluginBuddy)).hasIPChanged()) {
                List<BuddyPluginBuddy> list;
                String string = buddyData2.getIP();
                if (string != null && (list = (ArrayList<BuddyPluginBuddy>)this.online_buddy_ips.get(string)) != null) {
                    list.remove(buddyPluginBuddy);
                    if (list.size() == 0) {
                        this.online_buddy_ips.remove(string);
                    }
                }
                buddyData2.updateIP();
                string = buddyData2.getIP();
                if (string != null) {
                    list = (List)this.online_buddy_ips.get(string);
                    if (list == null) {
                        list = new ArrayList<BuddyPluginBuddy>();
                        this.online_buddy_ips.put(string, list);
                    }
                    list.add(buddyPluginBuddy);
                }
            }
            return buddyData2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuddy(BuddyPluginBuddy buddyPluginBuddy) {
        Set set = this.online_buddies;
        synchronized (set) {
            if (this.online_buddies.contains(buddyPluginBuddy)) {
                List list;
                buddyData buddyData2 = this.getBuddyData(buddyPluginBuddy);
                this.online_buddies.remove(buddyPluginBuddy);
                String string = buddyData2.getIP();
                if (string != null && (list = (List)this.online_buddy_ips.get(string)) != null) {
                    list.remove(buddyPluginBuddy);
                    if (list.size() == 0) {
                        this.online_buddy_ips.remove(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int isBuddy(Peer peer) {
        String string = peer.getIp();
        List list = AddressUtils.getLANAddresses(string);
        Set set = this.online_buddies;
        synchronized (set) {
            int n = 0;
            String string2 = "";
            block3: for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                string2 = string2 + string3;
                List list2 = (List)this.online_buddy_ips.get(string3);
                if (list2 == null) continue;
                if (peer.getTCPListenPort() == 0 && peer.getUDPListenPort() == 0) {
                    n = 1;
                    continue;
                }
                for (int j = 0; j < list2.size(); ++j) {
                    BuddyPluginBuddy buddyPluginBuddy = (BuddyPluginBuddy)list2.get(j);
                    if (buddyPluginBuddy.getTCPPort() == peer.getTCPListenPort() && buddyPluginBuddy.getTCPPort() != 0) {
                        n = 2;
                        break block3;
                    }
                    if (buddyPluginBuddy.getUDPPort() != peer.getUDPListenPort() || buddyPluginBuddy.getUDPPort() == 0) continue;
                    n = 2;
                    break block3;
                }
            }
            return n;
        }
    }

    @Override
    public void messageLogged(String string, boolean bl) {
    }

    @Override
    public void enabledStateChanged(boolean bl) {
        this.plugin_enabled = bl;
        this.checkEnabledState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        BuddyPluginTracker buddyPluginTracker = this;
        synchronized (buddyPluginTracker) {
            return this.plugin_enabled && this.tracker_enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEnabledState() {
        boolean bl = false;
        boolean bl2 = false;
        BuddyPluginTracker buddyPluginTracker = this;
        synchronized (buddyPluginTracker) {
            boolean bl3;
            boolean bl4 = bl3 = this.old_plugin_enabled && this.old_tracker_enabled;
            if (this.plugin_enabled != this.old_plugin_enabled) {
                this.log("Plugin enabled state changed to " + this.plugin_enabled);
                this.old_plugin_enabled = this.plugin_enabled;
            }
            if (this.tracker_enabled != this.old_tracker_enabled) {
                this.log("Tracker enabled state changed to " + this.tracker_enabled);
                this.old_tracker_enabled = this.tracker_enabled;
            }
            if (this.seeding_only != this.old_seeding_only) {
                this.log("Seeding-only state changed to " + this.seeding_only);
                this.old_seeding_only = this.seeding_only;
                bl = true;
            }
            bl2 = bl3 != (this.plugin_enabled && this.tracker_enabled);
        }
        if (bl) {
            this.updateSeedingMode();
        }
        if (bl2) {
            this.fireEnabledChanged(this.isEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSeedingMode() {
        ArrayList arrayList;
        this.updateNetworkStatus();
        Set set = this.online_buddies;
        synchronized (set) {
            arrayList = new ArrayList(this.online_buddies);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            buddyData buddyData2 = this.getBuddyData((BuddyPluginBuddy)arrayList.get(i));
            if (!buddyData2.hasDownloadsInCommon()) continue;
            buddyData2.updateStatus();
        }
    }

    @Override
    public void downloadAdded(final Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        if (torrent.isPrivate()) {
            download.addTrackerListener(new DownloadTrackerListener(){

                @Override
                public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
                }

                @Override
                public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
                    if (BuddyPluginTracker.this.okToTrack(download)) {
                        BuddyPluginTracker.this.trackDownload(download);
                    } else {
                        BuddyPluginTracker.this.untrackDownload(download);
                    }
                }
            }, false);
        }
        if (this.okToTrack(download)) {
            this.trackDownload(download);
        }
        download.addListener(new DownloadListener(){

            @Override
            public void stateChanged(Download download, int n, int n2) {
                if (BuddyPluginTracker.this.okToTrack(download)) {
                    BuddyPluginTracker.this.trackDownload(download);
                } else {
                    BuddyPluginTracker.this.untrackDownload(download);
                }
            }

            @Override
            public void positionChanged(Download download, int n, int n2) {
            }
        });
    }

    @Override
    public void downloadRemoved(Download download) {
        this.untrackDownload(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackDownload(Download download) {
        Set set = this.tracked_downloads;
        synchronized (set) {
            if (this.tracked_downloads.contains(download)) {
                return;
            }
            downloadData downloadData2 = new downloadData(download);
            download.setUserData(BuddyPluginTracker.class, downloadData2);
            HashWrapper hashWrapper = downloadData2.getID();
            HashWrapper hashWrapper2 = new HashWrapper(hashWrapper.getHash(), 0, 4);
            this.full_id_map.put(hashWrapper, download);
            ArrayList<Download> arrayList = (ArrayList<Download>)this.short_id_map.get(hashWrapper2);
            if (arrayList == null) {
                arrayList = new ArrayList<Download>();
                this.short_id_map.put(hashWrapper2, arrayList);
            }
            arrayList.add(download);
            this.tracked_downloads.add(download);
            ++this.download_set_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untrackDownload(Download download) {
        Object object;
        Set set = this.tracked_downloads;
        synchronized (set) {
            if (this.tracked_downloads.remove(download)) {
                ++this.download_set_id;
                downloadData downloadData2 = (downloadData)download.getUserData(BuddyPluginTracker.class);
                download.setUserData(BuddyPluginTracker.class, null);
                Object object2 = downloadData2.getID();
                this.full_id_map.remove(object2);
                object = new HashWrapper(((HashWrapper)object2).getHash(), 0, 4);
                List list = (List)this.short_id_map.get(object);
                if (list != null) {
                    list.remove(download);
                    if (list.size() == 0) {
                        this.short_id_map.remove(object);
                    }
                }
            }
        }
        set = this.online_buddies;
        synchronized (set) {
            for (Object object2 : this.online_buddies) {
                object = this.getBuddyData((BuddyPluginBuddy)object2);
                ((buddyData)object).resetTracking(download);
            }
        }
        set = this.actively_tracking;
        synchronized (set) {
            this.actively_tracking.remove(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackPeers(Download download) {
        PeerManager peerManager = download.getPeerManager();
        if (peerManager == null) {
            Set set = this.actively_tracking;
            synchronized (set) {
                this.actively_tracking.remove(download);
            }
        } else {
            this.log("Tracking peers for " + download.getName());
            download.addPeerListener(this);
        }
    }

    @Override
    public void peerManagerAdded(Download download, PeerManager peerManager) {
        this.trackPeers(download, peerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerManagerRemoved(Download download, PeerManager peerManager) {
        Set set = this.actively_tracking;
        synchronized (set) {
            this.actively_tracking.remove(download);
        }
        download.removePeerListener(this);
    }

    protected void trackPeers(final Download download, PeerManager peerManager) {
        peerManager.addListener(new PeerManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void peerAdded(PeerManager peerManager, Peer peer) {
                Set set = BuddyPluginTracker.this.actively_tracking;
                synchronized (set) {
                    if (!BuddyPluginTracker.this.actively_tracking.contains(download)) {
                        peerManager.removeListener(this);
                        return;
                    }
                }
                BuddyPluginTracker.this.trackPeer(download, peer);
            }

            @Override
            public void peerRemoved(PeerManager peerManager, Peer peer) {
            }
        });
        Peer[] peerArray = peerManager.getPeers();
        for (int i = 0; i < peerArray.length; ++i) {
            this.trackPeer(download, peerArray[i]);
        }
    }

    protected void trackPeer(Download download, final Peer peer) {
        int n = this.isBuddy(peer);
        if (n == 2) {
            this.markBuddyPeer(download, peer);
        } else if (n == 1) {
            this.markBuddyPeer(download, peer);
            PeerListener2 peerListener2 = new PeerListener2(){

                @Override
                public void eventOccurred(PeerEvent peerEvent) {
                    if (peerEvent.getType() == 1 && (Integer)peerEvent.getData() == 30) {
                        peer.removeListener(this);
                        if (BuddyPluginTracker.this.isBuddy(peer) != 2) {
                            BuddyPluginTracker.this.unmarkBuddyPeer(peer);
                        }
                    }
                }
            };
            peer.addListener(peerListener2);
            if (peer.getState() == 30) {
                peer.removeListener(peerListener2);
                if (this.isBuddy(peer) != 2) {
                    this.unmarkBuddyPeer(peer);
                }
            }
        }
    }

    protected void untrackPeers(Download download) {
        this.log("Not tracking peers for " + download.getName());
        download.removePeerListener(this);
        PeerManager peerManager = download.getPeerManager();
        if (peerManager != null) {
            Peer[] peerArray = peerManager.getPeers();
            for (int i = 0; i < peerArray.length; ++i) {
                Peer peer = peerArray[i];
                this.unmarkBuddyPeer(peer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markBuddyPeer(Download download, final Peer peer) {
        boolean bl = false;
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            if (!this.buddy_peers.contains(peer)) {
                this.log("Adding buddy peer " + peer.getIp());
                if (this.buddy_peers.size() == 0) {
                    if (this.buddy_stats_timer == null) {
                        this.buddy_stats_timer = SimpleTimer.addPeriodicEvent("BuddyTracker:stats", 1000L, new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent timerEvent2) {
                                Iterator iterator = BuddyPluginTracker.this.buddy_peers.iterator();
                                long l = 0L;
                                long l2 = 0L;
                                while (iterator.hasNext()) {
                                    Peer peer = (Peer)iterator.next();
                                    PeerStats peerStats = peer.getStats();
                                    long l3 = peerStats.getTotalSent();
                                    long l4 = peerStats.getTotalReceived();
                                    long[] lArray = (long[])peer.getUserData(PEER_STATS_KEY);
                                    if (lArray != null) {
                                        l += l3 - lArray[0];
                                        l2 += l4 - lArray[1];
                                    }
                                    peer.setUserData(PEER_STATS_KEY, new long[]{l3, l4});
                                }
                                BuddyPluginTracker.this.buddy_receive_speed.addValue(l2);
                                BuddyPluginTracker.this.buddy_send_speed.addValue(l);
                            }
                        });
                    }
                    bl = true;
                }
                this.buddy_peers.add(peer);
                peer.setUserData(PEER_KEY, download);
                peer.setPriorityConnection(true);
                this.log(download.getName() + ": adding buddy peer " + peer.getIp());
                peer.addListener(new PeerListener2(){

                    @Override
                    public void eventOccurred(PeerEvent peerEvent) {
                        int n;
                        if (peerEvent.getType() == 1 && ((n = ((Integer)peerEvent.getData()).intValue()) == 40 || n == 50)) {
                            peer.removeListener(this);
                            BuddyPluginTracker.this.unmarkBuddyPeer(peer);
                        }
                    }
                });
            }
        }
        if (peer.getState() == 40 || peer.getState() == 50) {
            this.unmarkBuddyPeer(peer);
        }
        if (bl) {
            this.updateNetworkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmarkBuddyPeer(Peer peer) {
        boolean bl = false;
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            Download download = (Download)peer.getUserData(PEER_KEY);
            if (download == null) {
                return;
            }
            if (this.buddy_peers.remove(peer)) {
                if (this.buddy_peers.size() == 0) {
                    bl = true;
                    if (this.buddy_stats_timer != null) {
                        this.buddy_stats_timer.cancel();
                        this.buddy_stats_timer = null;
                    }
                }
                this.log(download.getName() + ": removing buddy peer " + peer.getIp());
            }
            peer.setUserData(PEER_KEY, null);
            peer.setPriorityConnection(false);
        }
        if (bl) {
            this.updateNetworkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPeers() {
        ArrayList<Peer> arrayList = new ArrayList<Peer>();
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            Iterator iterator = this.buddy_peers.iterator();
            while (iterator.hasNext()) {
                Peer peer = (Peer)iterator.next();
                if (peer.getState() != 40 && peer.getState() != 50) continue;
                arrayList.add(peer);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.unmarkBuddyPeer((Peer)arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recheckPeers() {
        Set set = this.actively_tracking;
        synchronized (set) {
            for (Download download : this.actively_tracking) {
                PeerManager peerManager = download.getPeerManager();
                if (peerManager == null) continue;
                Peer[] peerArray = peerManager.getPeers();
                for (int i = 0; i < peerArray.length; ++i) {
                    this.trackPeer(download, peerArray[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNetworkStatus() {
        int n;
        boolean bl = false;
        CopyOnWriteSet copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            if (this.buddy_peers.size() == 0) {
                n = 1;
            } else {
                int n2 = n = this.seeding_only ? 2 : 3;
            }
            if (n != this.network_status) {
                this.network_status = n;
                bl = true;
            }
        }
        if (bl) {
            this.fireStateChange(n);
        }
    }

    public void addListener(BuddyPluginTrackerListener buddyPluginTrackerListener) {
        this.listeners.add(buddyPluginTrackerListener);
    }

    public void removeListener(BuddyPluginTrackerListener buddyPluginTrackerListener) {
        this.listeners.remove(buddyPluginTrackerListener);
    }

    protected void fireStateChange(int n) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((BuddyPluginTrackerListener)iterator.next()).networkStatusChanged(this, n);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    protected void fireEnabledChanged(boolean bl) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((BuddyPluginTrackerListener)iterator.next()).enabledStateChanged(this, bl);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    protected void sendMessage(BuddyPluginBuddy buddyPluginBuddy, int n, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", new Long(n));
        hashMap.put("msg", map);
        this.plugin.getAZ2Handler().sendAZ2TrackerMessage(buddyPluginBuddy, hashMap, this);
    }

    @Override
    public Map messageReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
        buddyData buddyData2 = this.buddyAlive(buddyPluginBuddy);
        int n = ((Long)map.get("type")).intValue();
        Map map2 = (Map)map.get("msg");
        return buddyData2.receiveMessage(n, map2);
    }

    @Override
    public void messageFailed(BuddyPluginBuddy buddyPluginBuddy, Throwable throwable) {
        this.log("Failed to send message to " + buddyPluginBuddy.getName(), throwable);
        this.buddyDead(buddyPluginBuddy);
    }

    protected buddyData buddyAlive(BuddyPluginBuddy buddyPluginBuddy) {
        buddyData buddyData2 = this.addBuddy(buddyPluginBuddy);
        buddyData2.setAlive(true);
        return buddyData2;
    }

    protected void buddyDead(BuddyPluginBuddy buddyPluginBuddy) {
        buddyData buddyData2 = this.getBuddyData(buddyPluginBuddy);
        if (buddyData2 != null) {
            buddyData2.setAlive(false);
        }
    }

    protected boolean okToTrack(Download download) {
        DownloadAnnounceResult downloadAnnounceResult;
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return false;
        }
        if (torrent.isPrivate() && ((downloadAnnounceResult = download.getLastAnnounceResult()) == null || downloadAnnounceResult.getResponseType() != 1 || downloadAnnounceResult.getPeers().length < 2)) {
            return false;
        }
        int n = download.getState();
        return n != 8 && n != 6 && n != 7;
    }

    protected void log(String string) {
        this.plugin.log("Tracker: " + string);
    }

    protected void log(String string, boolean bl) {
        if (bl) {
            if (Constants.isCVSVersion()) {
                this.log(string);
            }
        } else {
            this.log(string);
        }
    }

    protected void log(String string, Throwable throwable) {
        this.plugin.log("Tracker: " + string, throwable);
    }

    private static class downloadData {
        private static final byte[] IV = new byte[]{122, 122, -83, -85, -114, -65, -51, 57, -121, 0, -92, -72, -2, 64, -94, -24};
        private HashWrapper id;

        protected downloadData(Download download) {
            Torrent torrent = download.getTorrent();
            if (torrent != null) {
                byte[] byArray = torrent.getHash();
                SHA1 sHA1 = new SHA1();
                sHA1.update(ByteBuffer.wrap(IV));
                sHA1.update(ByteBuffer.wrap(byArray));
                this.id = new HashWrapper(sHA1.digest());
            }
        }

        protected HashWrapper getID() {
            return this.id;
        }
    }

    private static class buddyDownloadData {
        private boolean local_is_complete;
        private boolean remote_is_complete;
        private long last_track;

        protected buddyDownloadData(Download download) {
            this.local_is_complete = download.isComplete(false);
        }

        protected void setLocalComplete(boolean bl) {
            this.local_is_complete = bl;
        }

        protected boolean isLocalComplete() {
            return this.local_is_complete;
        }

        protected void setRemoteComplete(boolean bl) {
            this.remote_is_complete = bl;
        }

        protected boolean isRemoteComplete() {
            return this.remote_is_complete;
        }

        protected void setTrackTime(long l) {
            this.last_track = l;
        }

        protected long getTrackTime() {
            return this.last_track;
        }

        protected void resetTrackTime() {
            this.last_track = 0L;
        }

        protected String getString() {
            return "lic=" + this.local_is_complete + ",ric=" + this.remote_is_complete + ",lt=" + this.last_track;
        }
    }

    private class buddyData {
        private BuddyPluginBuddy buddy;
        private Set downloads_sent;
        private int downloads_sent_id;
        private Map downloads_in_common;
        private boolean buddy_seeding_only;
        private int consecutive_fails;
        private long last_fail;
        private String current_ip;

        protected buddyData(BuddyPluginBuddy buddyPluginBuddy) {
            this.buddy = buddyPluginBuddy;
        }

        protected void updateIP() {
            this.current_ip = this.buddy.getAdjustedIP().getHostAddress();
            this.log("IP set to " + this.current_ip);
        }

        protected boolean hasIPChanged() {
            InetAddress inetAddress = this.buddy.getAdjustedIP();
            if (inetAddress == null && this.current_ip == null) {
                return false;
            }
            if (inetAddress == null || this.current_ip == null) {
                return true;
            }
            return !this.current_ip.equals(inetAddress.getHostAddress());
        }

        protected String getIP() {
            return this.current_ip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasDownloadsInCommon() {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                return this.downloads_in_common != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAlive(boolean bl) {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (bl) {
                    this.consecutive_fails = 0;
                    this.last_fail = 0L;
                } else {
                    ++this.consecutive_fails;
                    this.last_fail = SystemTime.getMonotonousTime();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateLocal(Set set, int n, Map map) {
            boolean bl;
            Object object;
            Object object2;
            if (this.consecutive_fails > 0) {
                long l;
                long l2 = 300000L;
                for (int i = 0; i < this.consecutive_fails - 1; ++i) {
                    if ((l2 <<= 2) <= 3600000L) continue;
                    l2 = 3600000L;
                    break;
                }
                if ((l = SystemTime.getMonotonousTime()) - this.last_fail >= l2) {
                    this.last_fail = l;
                    this.downloads_sent = null;
                    this.downloads_sent_id = 0;
                }
            }
            ArrayList<Download> arrayList = new ArrayList<Download>();
            Object object3 = this;
            synchronized (object3) {
                if (this.downloads_in_common != null) {
                    for (Map.Entry entry : this.downloads_in_common.entrySet()) {
                        object2 = (Download)entry.getKey();
                        object = (buddyDownloadData)entry.getValue();
                        boolean bl2 = object2.isComplete(false);
                        if (bl2 == ((buddyDownloadData)object).isLocalComplete()) continue;
                        ((buddyDownloadData)object).setLocalComplete(bl2);
                        arrayList.add((Download)object2);
                    }
                }
            }
            if (arrayList.size() > 0 && ((Object)(object3 = (Object)this.exportFullIDs(arrayList))[0]).length > 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
                hashMap.put("change", object3[0]);
                hashMap.put("change_s", object3[1]);
                BuddyPluginTracker.this.sendMessage(this.buddy, 5, hashMap);
            }
            if (n == this.downloads_sent_id) {
                return;
            }
            object3 = new Long((long)n << 32 | (long)this.downloads_sent_id);
            Object[] objectArray = (Object[])map.get(object3);
            boolean bl3 = bl = this.downloads_sent != null;
            if (objectArray == null) {
                ArrayList<Object> arrayList2;
                ArrayList<Download> arrayList3 = new ArrayList<Download>();
                if (this.downloads_sent == null) {
                    arrayList2 = new ArrayList(set);
                } else {
                    arrayList2 = new ArrayList<Object>();
                    for (Object object4 : set) {
                        if (!BuddyPluginTracker.this.okToTrack((Download)object4) || this.downloads_sent.contains(object4)) continue;
                        arrayList2.add(object4);
                    }
                    for (Download download : this.downloads_sent) {
                        if (set.contains(download)) continue;
                        arrayList3.add(download);
                    }
                }
                object2 = this.exportShortIDs(arrayList2);
                object = this.exportFullIDs(arrayList3)[0];
                map.put(object3, new Object[]{object2, object});
            } else {
                object2 = (byte[])objectArray[0];
                object = (byte[])objectArray[1];
            }
            this.downloads_sent = set;
            this.downloads_sent_id = n;
            if (((Object)object2).length == 0 && ((Object)object).length == 0) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (((Object)object2).length > 0) {
                hashMap.put("added", object2);
            }
            if (((Object)object).length > 0) {
                hashMap.put("removed", object);
            }
            hashMap.put("inc", new Long(bl ? 1L : 0L));
            hashMap.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
            BuddyPluginTracker.this.sendMessage(this.buddy, 1, hashMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map updateRemote(Map map) {
            List list = this.importShortIDs((byte[])map.get("added"));
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            byte[][] byArray = this.exportFullIDs(list);
            if (byArray[0].length > 0) {
                hashMap.put("added", byArray[0]);
                hashMap.put("added_s", byArray[1]);
            }
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common != null) {
                    Map map2 = this.importFullIDs((byte[])map.get("removed"), null);
                    for (Download download : map2.keySet()) {
                        if (this.downloads_in_common.remove(download) == null) continue;
                        this.log("Removed " + download.getName() + " common download", false, true);
                    }
                    if (this.downloads_in_common.size() == 0) {
                        this.downloads_in_common = null;
                    }
                }
            }
            return hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateCommonDownloads(Map map, boolean bl) {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common == null) {
                    this.downloads_in_common = new HashMap();
                } else if (!bl) {
                    Iterator iterator = this.downloads_in_common.keySet().iterator();
                    while (iterator.hasNext()) {
                        Download object = (Download)((Object)iterator.next());
                        if (map.containsKey(object)) continue;
                        this.log("Removing " + object.getName() + " from common downloads", false, true);
                        iterator.remove();
                    }
                }
                for (Map.Entry entry : map.entrySet()) {
                    boolean bl2;
                    Download download = (Download)entry.getKey();
                    buddyDownloadData buddyDownloadData2 = (buddyDownloadData)entry.getValue();
                    buddyDownloadData buddyDownloadData3 = (buddyDownloadData)this.downloads_in_common.get(download);
                    if (buddyDownloadData3 == null) {
                        this.log("Adding " + download.getName() + " to common downloads (bdd=" + buddyDownloadData2.getString() + ")", false, true);
                        this.downloads_in_common.put(download, buddyDownloadData2);
                        continue;
                    }
                    boolean bl3 = buddyDownloadData3.isRemoteComplete();
                    if (bl3 == (bl2 = buddyDownloadData2.isRemoteComplete())) continue;
                    buddyDownloadData3.setRemoteComplete(bl2);
                    this.log("Changing " + download.getName() + " common downloads (bdd=" + buddyDownloadData3.getString() + ")", false, true);
                }
                if (this.downloads_in_common.size() == 0) {
                    this.downloads_in_common = null;
                }
            }
        }

        protected void updateStatus() {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
            BuddyPluginTracker.this.sendMessage(this.buddy, 3, hashMap);
        }

        protected Map receiveMessage(int n, Map map) {
            int n2 = -1;
            HashMap hashMap = null;
            Long l = (Long)map.get("seeding");
            if (l != null) {
                boolean bl = this.buddy_seeding_only;
                boolean bl2 = this.buddy_seeding_only = l.intValue() == 1;
                if (bl != this.buddy_seeding_only) {
                    this.log("Seeding only changed to " + this.buddy_seeding_only);
                }
            }
            if (n == 1) {
                n2 = 2;
                hashMap = this.updateRemote(map);
                hashMap.put("inc", map.get("inc"));
            } else if (n == 3) {
                n2 = 4;
            } else if (n == 5) {
                n2 = 4;
                Map map2 = this.importFullIDs((byte[])map.get("changed"), (byte[])map.get("changed_s"));
                this.updateCommonDownloads(map2, true);
            } else if (n == 7) {
                n2 = 8;
                Map map3 = this.importFullIDs((byte[])map.get("added"), (byte[])map.get("added_s"));
                this.updateCommonDownloads(map3, true);
            } else if (n == 2) {
                Map map4;
                boolean bl;
                byte[] byArray = (byte[])map.get("added");
                byte[] byArray2 = (byte[])map.get("added_s");
                boolean bl3 = bl = ((Long)map.get("inc")).intValue() == 1;
                if (byArray != null && byArray2 != null && (map4 = this.importFullIDs(byArray, byArray2)).size() > 0) {
                    this.updateCommonDownloads(map4, bl);
                    byte[][] byArray3 = this.exportFullIDs(new ArrayList(map4.keySet()));
                    if (byArray3[0].length > 0) {
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        hashMap2.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
                        hashMap2.put("added", byArray3[0]);
                        hashMap2.put("added_s", byArray3[1]);
                        BuddyPluginTracker.this.sendMessage(this.buddy, 7, hashMap2);
                    }
                }
            } else if (n != 6 && n != 4 && n != 8) {
                this.log("Unrecognised type " + n);
            }
            if (n2 != -1) {
                HashMap<String, Serializable> hashMap3 = new HashMap<String, Serializable>();
                hashMap3.put("type", new Long(n2));
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1L : 0L));
                hashMap3.put("msg", hashMap);
                return hashMap3;
            }
            return null;
        }

        protected byte[] exportShortIDs(List list) {
            byte[] byArray = new byte[4 * list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Download download = (Download)list.get(i);
                downloadData downloadData2 = (downloadData)download.getUserData(BuddyPluginTracker.class);
                if (downloadData2 == null) continue;
                System.arraycopy(downloadData2.getID().getBytes(), 0, byArray, i * 4, 4);
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List importShortIDs(byte[] byArray) {
            ArrayList arrayList = new ArrayList();
            if (byArray != null) {
                Set set = BuddyPluginTracker.this.tracked_downloads;
                synchronized (set) {
                    for (int i = 0; i < byArray.length; i += 4) {
                        List list = (List)BuddyPluginTracker.this.short_id_map.get(new HashWrapper(byArray, i, 4));
                        if (list == null) continue;
                        arrayList.addAll(list);
                    }
                }
            }
            return arrayList;
        }

        protected byte[][] exportFullIDs(List list) {
            byte[] byArray = new byte[20 * list.size()];
            byte[] byArray2 = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Download download = (Download)list.get(i);
                downloadData downloadData2 = (downloadData)download.getUserData(BuddyPluginTracker.class);
                if (downloadData2 == null) continue;
                System.arraycopy(downloadData2.getID().getBytes(), 0, byArray, i * 20, 20);
                byArray2[i] = download.isComplete(false) ? (byte)1 : 0;
            }
            return new byte[][]{byArray, byArray2};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map importFullIDs(byte[] byArray, byte[] byArray2) {
            HashMap<Download, buddyDownloadData> hashMap = new HashMap<Download, buddyDownloadData>();
            if (byArray != null) {
                Set set = BuddyPluginTracker.this.tracked_downloads;
                synchronized (set) {
                    for (int i = 0; i < byArray.length; i += 20) {
                        Download download = (Download)BuddyPluginTracker.this.full_id_map.get(new HashWrapper(byArray, i, 20));
                        if (download == null) continue;
                        buddyDownloadData buddyDownloadData2 = new buddyDownloadData(download);
                        if (byArray2 != null) {
                            buddyDownloadData2.setRemoteComplete((byArray2[i / 20] & 1) != 0);
                        }
                        hashMap.put(download, buddyDownloadData2);
                    }
                }
            }
            return hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map getDownloadsToTrack() {
            HashMap<Download, Boolean> hashMap = new HashMap<Download, Boolean>();
            if (BuddyPluginTracker.this.seeding_only == this.buddy_seeding_only) {
                this.log("Not tracking, buddy and me both " + (BuddyPluginTracker.this.seeding_only ? "seeding" : "downloading"), true, false);
                return hashMap;
            }
            long l = SystemTime.getMonotonousTime();
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common == null) {
                    this.log("Not tracking, buddy has nothing in common", true, false);
                    return hashMap;
                }
                for (Map.Entry entry : this.downloads_in_common.entrySet()) {
                    Download download = (Download)entry.getKey();
                    buddyDownloadData buddyDownloadData2 = (buddyDownloadData)entry.getValue();
                    if (download.isComplete(false) && buddyDownloadData2.isRemoteComplete()) {
                        this.log(download.getName() + " - not tracking, both complete", true, true);
                        continue;
                    }
                    long l2 = buddyDownloadData2.getTrackTime();
                    if (l2 == 0L || l - l2 >= 600000L) {
                        this.log(download.getName() + " - tracking", false, true);
                        buddyDownloadData2.setTrackTime(l);
                        hashMap.put(download, new Boolean(true));
                        continue;
                    }
                    hashMap.put(download, new Boolean(false));
                }
            }
            return hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resetTracking(Download download) {
            buddyData buddyData2 = this;
            synchronized (buddyData2) {
                if (this.downloads_in_common == null) {
                    return;
                }
                buddyDownloadData buddyDownloadData2 = (buddyDownloadData)this.downloads_in_common.get(download);
                if (buddyDownloadData2 != null) {
                    buddyDownloadData2.resetTrackTime();
                }
            }
        }

        protected void log(String string) {
            BuddyPluginTracker.this.log(this.buddy.getName() + ": " + string);
        }

        protected void log(String string, boolean bl, boolean bl2) {
            BuddyPluginTracker.this.log((bl2 ? "" : this.buddy.getName() + ": ") + string, bl);
        }
    }
}

