/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.always;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class RunEverythingPlugin
implements Plugin,
DownloadManagerListener,
DownloadListener,
DownloadTrackerListener {
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private Map downloads;
    private Monitor downloads_mon;
    private Semaphore work_sem;
    private volatile boolean closing;

    public static void load(PluginInterface pluginInterface) {
        PluginManagerDefaults pluginManagerDefaults = PluginManager.getDefaults();
        pluginManagerDefaults.setDefaultPluginEnabled("Start/Stop Rules", false);
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.logger = this.plugin_interface.getLogger().getChannel("RunEverythingSeedingRules");
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
            }

            @Override
            public void closedownInitiated() {
                RunEverythingPlugin.this.closing = true;
            }

            @Override
            public void closedownComplete() {
            }
        });
        this.downloads = new HashMap();
        this.downloads_mon = this.plugin_interface.getUtilities().getMonitor();
        this.work_sem = this.plugin_interface.getUtilities().getSemaphore();
        this.plugin_interface.getDownloadManager().addListener(this);
        this.plugin_interface.getUtilities().createTimer("DownloadRules", true).addPeriodicEvent(10000L, new UTTimerEventPerformer(){

            @Override
            public void perform(UTTimerEvent uTTimerEvent) {
                RunEverythingPlugin.this.checkRules();
            }
        });
        this.plugin_interface.getUtilities().createThread("DownloadRules", new Runnable(){

            @Override
            public void run() {
                RunEverythingPlugin.this.processLoop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadAdded(Download download) {
        this.log("added: " + download.getName() + ", state = " + Download.ST_NAMES[download.getState()]);
        downloadData downloadData2 = new downloadData(download);
        try {
            this.downloads_mon.enter();
            this.downloads.put(download, downloadData2);
        }
        finally {
            this.downloads_mon.exit();
        }
        download.addListener(this);
        this.checkRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadRemoved(Download download) {
        try {
            this.downloads_mon.enter();
            this.downloads.remove(download);
        }
        finally {
            this.downloads_mon.exit();
        }
        download.removeListener(this);
        this.checkRules();
    }

    @Override
    public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
        this.checkRules();
    }

    @Override
    public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
        this.checkRules();
    }

    @Override
    public void stateChanged(Download download, int n, int n2) {
        this.log("Rules: state change for " + download.getName() + ": " + Download.ST_NAMES[n] + "->" + Download.ST_NAMES[n2]);
        this.checkRules();
    }

    @Override
    public void positionChanged(Download download, int n, int n2) {
        this.checkRules();
    }

    protected void checkRules() {
        this.work_sem.release();
    }

    protected void processLoop() {
        while (!this.closing) {
            this.work_sem.reserve();
            while (this.work_sem.reserveIfAvailable()) {
            }
            try {
                this.processSupport();
                Thread.sleep(250L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSupport() {
        if (this.closing) {
            return;
        }
        try {
            downloadData downloadData2;
            this.downloads_mon.enter();
            ArrayList arrayList = new ArrayList(this.downloads.values());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                downloadData2 = (downloadData)iterator.next();
                if (!downloadData2.ignore()) continue;
                iterator.remove();
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                downloadData2 = (downloadData)iterator.next();
                if (downloadData2.getState() != 1) continue;
                iterator.remove();
                try {
                    this.log("initialising " + downloadData2.getName());
                    downloadData2.getDownload().initialize();
                }
                catch (DownloadException downloadException) {
                    downloadException.printStackTrace();
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                downloadData2 = (downloadData)iterator.next();
                if (downloadData2.getState() != 3) continue;
                iterator.remove();
                try {
                    this.log("starting " + downloadData2.getName());
                    downloadData2.getDownload().start();
                }
                catch (DownloadException downloadException) {
                    downloadException.printStackTrace();
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                downloadData2 = (downloadData)iterator.next();
                if (downloadData2.getState() != 9 || downloadData2.isComplete()) continue;
                try {
                    iterator.remove();
                    this.log("restarting download " + downloadData2.getName());
                    downloadData2.getDownload().restart();
                }
                catch (DownloadException downloadException) {
                    downloadException.printStackTrace();
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                downloadData2 = (downloadData)iterator.next();
                if (!downloadData2.isComplete() || downloadData2.getState() != 9) continue;
                try {
                    iterator.remove();
                    this.log("restarting seed " + downloadData2.getName());
                    downloadData2.getDownload().restart();
                }
                catch (DownloadException downloadException) {
                    downloadException.printStackTrace();
                }
            }
        }
        finally {
            this.downloads_mon.exit();
        }
    }

    protected void log(String string) {
        this.logger.log(string);
    }

    protected class downloadData {
        private Download download;

        protected downloadData(Download download) {
            this.download = download;
        }

        protected Download getDownload() {
            return this.download;
        }

        protected int getState() {
            return this.download.getState();
        }

        protected String getName() {
            return this.download.getName();
        }

        protected boolean isDownloading() {
            if (this.isComplete()) {
                return false;
            }
            int n = this.download.getState();
            return n == 1 || n == 2 || n == 3 || n == 4;
        }

        protected boolean isSeeding() {
            if (!this.isComplete()) {
                return false;
            }
            int n = this.download.getState();
            return n == 1 || n == 2 || n == 3 || n == 5;
        }

        protected boolean isComplete() {
            return this.download.isComplete();
        }

        protected boolean ignore() {
            int n = this.download.getState();
            return n == 8 || n == 7 || n == 6;
        }
    }
}

