/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesFPListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;

public class StartStopRulesDefaultPlugin
implements Plugin,
COConfigurationListener,
AEDiagnosticsEvidenceGenerator {
    private static final String sStates = " WPRDS.XEQ";
    public static final int RANK_NONE = 0;
    public static final int RANK_SPRATIO = 1;
    public static final int RANK_SEEDCOUNT = 2;
    public static final int RANK_TIMED = 3;
    public static final int RANK_PEERCOUNT = 4;
    private static final int FORCE_CHECK_PERIOD = 60000;
    private static final int CHECK_FOR_GROSS_CHANGE_PERIOD = 30000;
    private static final int PROCESS_CHECK_PERIOD = 1500;
    private static final int MIN_SEEDING_STARTUP_WAIT = 20000;
    private static final int MIN_FIRST_SCRAPE_WAIT = 90000;
    private static final float IGNORE_SLOT_THRESHOLD_FACTOR = 0.9f;
    private AEMonitor this_mon = new AEMonitor("StartStopRules");
    private PluginInterface pi;
    protected PluginConfig plugin_config;
    private DownloadManager download_manager;
    protected LoggerChannel log;
    private RecalcSeedingRanksTask recalcSeedingRanksTask;
    private static Map<Download, DefaultRankCalculator> downloadDataMap = Collections.synchronizedMap(new HashMap());
    private volatile DefaultRankCalculator[] sortedArrayCache;
    private volatile boolean closingDown;
    private volatile boolean somethingChanged;
    private Set ranksToRecalc = new LightHashSet();
    private AEMonitor ranksToRecalc_mon = new AEMonitor("ranksToRecalc");
    private long startedOn;
    protected boolean bDebugLog;
    private int iRankType = -1;
    private int minSpeedForActiveSeeding;
    private int maxStalledSeeding;
    private int numPeersAsFullCopy;
    private int iFakeFullCopySeedStart;
    private int _maxActive;
    private boolean _maxActiveWhenSeedingEnabled;
    private int _maxActiveWhenSeeding;
    private int globalDownloadLimit;
    private int globalUploadLimit;
    private int globalUploadWhenSeedingLimit;
    private int maxDownloads;
    private int minDownloads;
    private boolean bAutoReposition;
    private long minTimeAlive;
    private boolean bAutoStart0Peers;
    private boolean bStopOnceBandwidthMet = false;
    private static boolean bAlreadyInitialized = false;
    private boolean bSWTUI = false;
    private CopyOnWriteList listenersFP = new CopyOnWriteList();
    public static boolean pauseChangeFlagChecker = false;
    private volatile boolean immediateProcessingScheduled = false;
    private long changeCheckCount = 0L;
    private long changeCheckTotalMS = 0L;
    private long changeCheckMaxMS = 0L;
    private long processCount = 0L;
    private long processTotalMS = 0L;
    private long processMaxMS = 0L;
    private long processLastComplete = 0L;
    private long processTotalGap = 0L;
    private long processTotalRecalcs = 0L;
    private long processTotalZeroRecalcs = 0L;
    private long processMergeCount = 0L;

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", "Start/Stop Rules");
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        if (bAlreadyInitialized) {
            System.err.println("StartStopRulesDefaultPlugin Already initialized!!");
        } else {
            bAlreadyInitialized = true;
        }
        AEDiagnostics.addEvidenceGenerator(this);
        this.startedOn = SystemTime.getCurrentTime();
        this.pi = pluginInterface;
        this.plugin_config = this.pi.getPluginconfig();
        this.plugin_config.setPluginConfigKeyPrefix("");
        this.download_manager = this.pi.getDownloadManager();
        UIManager uIManager = this.pi.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("root", "Q");
        this.setupConfigModel(basicPluginConfigModel);
        this.pi.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
            }

            @Override
            public void closedownInitiated() {
                StartStopRulesDefaultPlugin.this.closingDown = true;
                COConfigurationManager.removeListener(StartStopRulesDefaultPlugin.this);
            }

            @Override
            public void closedownComplete() {
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StartStopRulesDefaultPlugin.this.download_manager.addListener(new StartStopDMListener());
                SimpleTimer.addPeriodicEvent("StartStop:gross", 30000L, new ChangeCheckerTimerTask());
                SimpleTimer.addPeriodicEvent("StartStop:check", 1500L, new ChangeFlagCheckerTask());
            }
        };
        this.pi.getUtilities().createDelayedTask(runnable).queue();
        this.log = this.pi.getLogger().getTimeStampedChannel("StartStopRules");
        this.log.log(1, "Default StartStopRules Plugin Initialisation");
        COConfigurationManager.addListener(this);
        try {
            this.pi.getUIManager().createLoggingViewModel(this.log, true);
            this.pi.getUIManager().addUIListener(new UIManagerListener(){

                @Override
                public void UIAttached(UIInstance uIInstance) {
                }

                @Override
                public void UIDetached(UIInstance uIInstance) {
                }
            });
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        this.reloadConfigParams();
    }

    private void setupConfigModel(BasicPluginConfigModel basicPluginConfigModel) {
        String string = "ConfigView.label.seeding.";
        basicPluginConfigModel.addIntParameter2("StartStopManager_iRankType", "ConfigView.label.seeding.rankType", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iRankTypeSeedFallback", "ConfigView.label.seeding.rankType.seed.fallback", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bAutoReposition", "ConfigView.label.seeding.autoReposition", false);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinSeedingTime", "ConfigView.label.minSeedingTime", 600);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bIgnore0Peers", "ConfigView.label.seeding.ignore0Peers", true);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iIgnoreSeedCount", "ConfigView.label.ignoreSeeds", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iIgnoreRatioPeersSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iIgnoreShareRatioSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bPreferLargerSwarms", "ConfigView.label.seeding.preferLargerSwarms", true);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bAutoStart0Peers", "ConfigView.label.seeding.autoStart0Peers", false);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinPeersToBoostNoSeeds", "ConfigView.label.minPeersToBoostNoSeeds", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinSpeedForActiveDL", "ConfigView.label.minSpeedForActiveDL", 512);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinSpeedForActiveSeeding", "ConfigView.label.minSpeedForActiveSeeding", 512);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMaxStalledSeeding", "ConfigView.label.maxStalledSeeding", 5);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bDebugLog", "ConfigView.label.queue.debuglog", false);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bNewSeedsMoveTop", "ConfigView.label.queue.newseedsmovetop", true);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMaxActiveTorrentsWhenSeeding", "ConfigView.label.queue.maxactivetorrentswhenseeding", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled", "ConfigView.label.queue.maxactivetorrentswhenseeding", false);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bStopOnceBandwidthMet", "ConfigView.label.queue.stoponcebandwidthmet", true);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_Type", "ConfigView.label.seeding.firstPriority", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_ShareRatio", "ConfigView.label.seeding.firstPriority.shareRatio", 500);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_SeedingMinutes", "ConfigView.label.seeding.firstPriority.seedingMinutes", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_DLMinutes", "ConfigView.label.seeding.firstPriority.DLMinutes", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_ignoreSPRatio", "ConfigView.label.seeding.firstPriority.ignoreSPRatio", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bFirstPriority_ignore0Peer", "ConfigView.label.seeding.firstPriority.ignore0Peer", !COConfigurationManager.getStringParameter("ui", "").equals("az2"));
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_ignoreIdleHours", "ConfigView.label.seeding.firstPriority.ignoreIdleHours", 24);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iAddForSeedingDLCopyCount", "ConfigView.label.seeding.addForSeedingDLCopyCount", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iNumPeersAsFullCopy", string + "numPeersAsFullCopy", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFakeFullCopySeedStart", string + "fakeFullCopySeedStart", 1);
        basicPluginConfigModel.destroy();
    }

    public static DefaultRankCalculator getRankCalculator(Download download) {
        return downloadDataMap.get(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcAllSeedingRanks(boolean bl) {
        if (this.closingDown) {
            return;
        }
        try {
            DefaultRankCalculator[] defaultRankCalculatorArray;
            this.this_mon.enter();
            Map<Download, DefaultRankCalculator> map = downloadDataMap;
            synchronized (map) {
                defaultRankCalculatorArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
            }
            for (int i = 0; i < defaultRankCalculatorArray.length; ++i) {
                if (bl) {
                    defaultRankCalculatorArray[i].getDownloadObject().setSeedingRank(0);
                }
                defaultRankCalculatorArray[i].recalcSeedingRank();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void configurationSaved() {
        new AEThread2("reloadConfigParams", true){

            @Override
            public void run() {
                StartStopRulesDefaultPlugin.this.reloadConfigParams();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigParams() {
        try {
            this.this_mon.enter();
            int n = this.plugin_config.getIntParameter("StartStopManager_iRankType");
            this.minSpeedForActiveSeeding = this.plugin_config.getIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
            this.maxStalledSeeding = this.plugin_config.getIntParameter("StartStopManager_iMaxStalledSeeding");
            if (this.maxStalledSeeding <= 0) {
                this.maxStalledSeeding = 999;
            }
            this._maxActive = this.plugin_config.getIntParameter("max active torrents");
            this._maxActiveWhenSeedingEnabled = this.plugin_config.getBooleanParameter("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
            this._maxActiveWhenSeeding = this.plugin_config.getIntParameter("StartStopManager_iMaxActiveTorrentsWhenSeeding");
            this.minDownloads = this.plugin_config.getIntParameter("min downloads");
            this.maxDownloads = this.plugin_config.getIntParameter("max downloads");
            this.numPeersAsFullCopy = this.plugin_config.getIntParameter("StartStopManager_iNumPeersAsFullCopy");
            this.iFakeFullCopySeedStart = this.plugin_config.getIntParameter("StartStopManager_iFakeFullCopySeedStart");
            this.bAutoReposition = this.plugin_config.getBooleanParameter("StartStopManager_bAutoReposition");
            this.minTimeAlive = this.plugin_config.getIntParameter("StartStopManager_iMinSeedingTime") * 1000;
            this.bDebugLog = this.plugin_config.getBooleanParameter("StartStopManager_bDebugLog");
            this.bAutoStart0Peers = this.plugin_config.getBooleanParameter("StartStopManager_bAutoStart0Peers");
            this.globalDownloadLimit = this.plugin_config.getIntParameter("Max Download Speed KBs", 0);
            this.globalUploadLimit = this.plugin_config.getIntParameter("Max Upload Speed KBs", 0);
            this.globalUploadWhenSeedingLimit = this.plugin_config.getBooleanParameter("enable.seedingonly.upload.rate") ? this.plugin_config.getIntParameter("Max Upload Speed Seeding KBs", 0) : this.globalUploadLimit;
            this.bStopOnceBandwidthMet = this.plugin_config.getBooleanParameter("StartStopManager_bStopOnceBandwidthMet");
            boolean bl = this.plugin_config.getBooleanParameter("StartStopManager_bNewSeedsMoveTop");
            this.plugin_config.setBooleanParameter("Newly Seeding Torrents Get First Priority", bl);
            if (n != this.iRankType) {
                this.iRankType = n;
                if (this.iRankType == 3) {
                    if (this.recalcSeedingRanksTask == null) {
                        this.recalcSeedingRanksTask = new RecalcSeedingRanksTask();
                        SimpleTimer.addPeriodicEvent("StartStop:recalcSR", 1000L, this.recalcSeedingRanksTask);
                    }
                } else if (this.recalcSeedingRanksTask != null) {
                    this.recalcSeedingRanksTask.cancel();
                    this.recalcSeedingRanksTask = null;
                }
            }
            Collection<DefaultRankCalculator> collection = downloadDataMap.values();
            DefaultRankCalculator[] defaultRankCalculatorArray = collection.toArray(new DefaultRankCalculator[0]);
            for (int i = 0; i < defaultRankCalculatorArray.length; ++i) {
                defaultRankCalculatorArray[i].getDownloadObject().setSeedingRank(0);
            }
            try {
                this.ranksToRecalc_mon.enter();
                Map<Download, DefaultRankCalculator> map = downloadDataMap;
                synchronized (map) {
                    this.ranksToRecalc.addAll(collection);
                }
            }
            finally {
                this.ranksToRecalc_mon.exit();
            }
            this.requestProcessCycle(null);
            if (this.bDebugLog) {
                // empty if block
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private int calcMaxSeeders(int n) {
        int n2 = this.getMaxActive();
        if (n2 == 0) {
            return 999999;
        }
        return n2 - n;
    }

    protected int getMaxActive() {
        if (!this._maxActiveWhenSeedingEnabled) {
            return this._maxActive;
        }
        if (this.download_manager.isSeedingOnly()) {
            if (this._maxActiveWhenSeeding <= this._maxActive) {
                return this._maxActiveWhenSeeding;
            }
            Download[] downloadArray = this.download_manager.getDownloads();
            boolean bl = false;
            block0: for (int i = 0; i < downloadArray.length && !bl; ++i) {
                Download download = downloadArray[i];
                int n = download.getState();
                if (n == 4 || n == 5 || n == 7 || n == 6 || n == 8) continue;
                DiskManagerFileInfo[] diskManagerFileInfoArray = download.getDiskManagerFileInfo();
                for (int j = 0; j < diskManagerFileInfoArray.length; ++j) {
                    DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[j];
                    if (diskManagerFileInfo.isSkipped() || diskManagerFileInfo.getDownloaded() == diskManagerFileInfo.getLength()) continue;
                    bl = true;
                    continue block0;
                }
            }
            if (!bl) {
                return this._maxActiveWhenSeeding;
            }
        }
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        long l = 0L;
        try {
            Object[] objectArray;
            Object object;
            Object[] objectArray2;
            this.this_mon.enter();
            l = SystemTime.getCurrentTime();
            this.somethingChanged = false;
            try {
                this.ranksToRecalc_mon.enter();
                objectArray2 = this.ranksToRecalc.toArray();
                this.ranksToRecalc.clear();
            }
            finally {
                this.ranksToRecalc_mon.exit();
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                object = (DefaultRankCalculator)objectArray2[i];
                if (this.bDebugLog) {
                    long l2 = ((DefaultRankCalculator)object).dl.getSeedingRank();
                    ((DefaultRankCalculator)object).recalcSeedingRank();
                    String string = "recalc seeding rank.  old/new=" + l2 + "/" + ((DefaultRankCalculator)object).dl.getSeedingRank();
                    this.log.log((Object)((DefaultRankCalculator)object).dl.getTorrent(), 1, string);
                    continue;
                }
                ((DefaultRankCalculator)object).recalcSeedingRank();
            }
            this.processTotalRecalcs += (long)objectArray2.length;
            if (objectArray2.length == 0) {
                ++this.processTotalZeroRecalcs;
            }
            if (this.sortedArrayCache != null && this.sortedArrayCache.length == downloadDataMap.size()) {
                objectArray = this.sortedArrayCache;
            } else {
                object = downloadDataMap;
                synchronized (object) {
                    this.sortedArrayCache = downloadDataMap.values().toArray(new DefaultRankCalculator[downloadDataMap.size()]);
                    objectArray = this.sortedArrayCache;
                }
            }
            object = new TotalsStats((DefaultRankCalculator[])objectArray);
            String[] stringArray = null;
            if (this.bDebugLog) {
                this.log.log(1, ">>process()");
                stringArray = new String[]{"ok2Start=" + this.boolDebug(((TotalsStats)object).bOkToStartSeeding), "tFrcdCding=" + ((TotalsStats)object).forcedSeeding, "actvCDs=" + ((TotalsStats)object).activelyCDing, "tW8tingToCd=" + ((TotalsStats)object).waitingToSeed, "tDLing=" + ((TotalsStats)object).downloading, "actvDLs=" + ((TotalsStats)object).activelyDLing, "tW8tingToDL=" + ((TotalsStats)object).waitingToDL, "tCom=" + ((TotalsStats)object).complete, "tIncQd=" + ((TotalsStats)object).incompleteQueued, "mxCdrs=" + ((TotalsStats)object).maxSeeders, "tFP=" + ((TotalsStats)object).firstPriority, "maxT=" + ((TotalsStats)object).maxTorrents, "maxA=" + ((TotalsStats)object).maxActive};
            }
            Arrays.sort(objectArray);
            ProcessVars processVars = new ProcessVars();
            processVars.numWaitingOrSeeding = ((TotalsStats)object).forcedSeeding;
            processVars.numWaitingOrDLing = 0;
            processVars.higherCDtoStart = false;
            processVars.higherDLtoStart = false;
            processVars.posComplete = 0;
            processVars.stalledSeeders = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                Object object2 = objectArray[i];
                Download download = ((DefaultRankCalculator)object2).getDownloadObject();
                processVars.bStopAndQueued = false;
                ((DefaultRankCalculator)object2).sTrace = "";
                if (download.getState() == 1) {
                    try {
                        download.initialize();
                        String string = "initialize: state is waiting";
                        this.log.log((Object)download.getTorrent(), 1, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.bDebugLog && download.getState() == 1) {
                        ((DefaultRankCalculator)object2).sTrace = ((DefaultRankCalculator)object2).sTrace + "still in waiting state after initialize!\n";
                    }
                }
                if (this.bAutoReposition && this.iRankType != 0 && download.isComplete() && (((TotalsStats)object).bOkToStartSeeding || ((TotalsStats)object).firstPriority > 0)) {
                    download.setPosition(++processVars.posComplete);
                }
                if ((n = download.getState()) == 6 || n == 7 || n == 8) continue;
                if (download.isForceStart()) {
                    String string;
                    if (n == 7 || n == 9) {
                        try {
                            download.restart();
                            string = "restart: isForceStart";
                            this.log.log((Object)download.getTorrent(), 1, string);
                            ((DefaultRankCalculator)object2).sTrace = ((DefaultRankCalculator)object2).sTrace + string + "\n";
                        }
                        catch (DownloadException downloadException) {
                            // empty catch block
                        }
                        n = download.getState();
                    }
                    if (n == 3) {
                        try {
                            download.start();
                            string = "Start: isForceStart";
                            this.log.log((Object)download.getTorrent(), 1, string);
                            ((DefaultRankCalculator)object2).sTrace = ((DefaultRankCalculator)object2).sTrace + string + "\n";
                        }
                        catch (DownloadException downloadException) {
                            // empty catch block
                        }
                    }
                }
                if (!download.isComplete()) {
                    this.handleInCompleteDownload((DefaultRankCalculator)object2, processVars, (TotalsStats)object);
                    continue;
                }
                this.handleCompletedDownload((DefaultRankCalculator[])objectArray, (DefaultRankCalculator)object2, processVars, (TotalsStats)object);
            }
            if (this.bDebugLog) {
                String[] stringArray2 = new String[]{"ok2Start=" + this.boolDebug(((TotalsStats)object).bOkToStartSeeding), "tFrcdCding=" + ((TotalsStats)object).forcedSeeding, "actvCDs=" + ((TotalsStats)object).activelyCDing, "tW8tingToCd=" + ((TotalsStats)object).waitingToSeed, "tDLing=" + ((TotalsStats)object).downloading, "actvDLs=" + ((TotalsStats)object).activelyDLing, "tW8tingToDL=" + ((TotalsStats)object).waitingToDL, "tCom=" + ((TotalsStats)object).complete, "tIncQd=" + ((TotalsStats)object).incompleteQueued, "mxCdrs=" + ((TotalsStats)object).maxSeeders, "tFP=" + ((TotalsStats)object).firstPriority, "maxT=" + ((TotalsStats)object).maxTorrents, "maxA=" + ((TotalsStats)object).maxActive};
                this.printDebugChanges("<<process() ", stringArray, stringArray2, "", "", true, null);
            }
        }
        finally {
            if (l > 0L) {
                ++this.processCount;
                long l3 = SystemTime.getCurrentTime() - l;
                if (this.bDebugLog) {
                    this.log.log(1, "process() took " + l3);
                }
                this.processTotalMS += l3;
                if (l3 > this.processMaxMS) {
                    this.processMaxMS = l3;
                }
                if (this.processLastComplete > 0L) {
                    this.processTotalGap += l - this.processLastComplete;
                }
                this.processLastComplete = l;
            }
            this.immediateProcessingScheduled = false;
            this.this_mon.exit();
        }
    }

    private void handleInCompleteDownload(DefaultRankCalculator defaultRankCalculator, ProcessVars processVars, TotalsStats totalsStats) {
        int n;
        boolean bl;
        int n2;
        boolean bl2;
        boolean bl3;
        int n3;
        Download download = defaultRankCalculator.dl;
        int n4 = download.getState();
        if (download.isForceStart()) {
            if (this.bDebugLog) {
                String string = "isForceStart.. rules skipped";
                this.log.log((Object)download.getTorrent(), 1, string);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
            }
            return;
        }
        if (n4 == 2) {
            ++processVars.numWaitingOrDLing;
            if (this.bDebugLog) {
                String string = "ST_PREPARING.. rules skipped. numW8tngorDLing=" + processVars.numWaitingOrDLing;
                this.log.log((Object)download.getTorrent(), 1, string);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
            }
            return;
        }
        int n5 = 0;
        if (totalsStats.maxActive == 0) {
            n5 = this.maxDownloads;
        } else {
            n3 = 0;
            n3 = totalsStats.stalledFPSeeders + totalsStats.forcedActive + totalsStats.maxActive - totalsStats.firstPriority - totalsStats.forcedSeedingNonFP;
            int n6 = n3 <= 0 ? 0 : (n5 = this.maxDownloads - n3 <= 0 ? this.maxDownloads : n3);
        }
        if (n5 < this.minDownloads) {
            n5 = this.minDownloads;
        }
        n3 = defaultRankCalculator.getActivelyDownloading();
        if (this.bStopOnceBandwidthMet) {
            bl3 = download.getState() == 4;
            bl2 = this.globalDownloadLimit > 0 && (float)(processVars.accumulatedDownloadSpeed / 1024L) > (float)this.globalDownloadLimit * 0.9f;
            n2 = n3 != 0 || bl3 && bl2 ? 1 : 0;
            boolean bl4 = bl = n2 != 0 && n3 == 0;
            if (bl) {
                ++totalsStats.activelyDLing;
                totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
            }
        } else {
            bl2 = false;
            n2 = n3;
            bl = false;
        }
        if (this.bDebugLog) {
            String string = ">> DL state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + processVars.numWaitingOrDLing + ";maxCDrs=" + totalsStats.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totalsStats.activelyDLing + ";maxDLs=" + n5 + ";ActDLing=" + this.boolDebug(n3 != 0) + ";globDwnRchd=" + this.boolDebug(bl2) + ";hgherQd=" + this.boolDebug(processVars.higherDLtoStart) + ";isCmplt=" + this.boolDebug(download.isComplete());
            this.log.log((Object)download.getTorrent(), 1, string);
            defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
        }
        if (n4 == 4 && n2 != 0 || n4 == 3 || n4 == 1 || n4 == 2) {
            ++processVars.numWaitingOrDLing;
        }
        if (n4 == 3 || n4 == 4 || n4 == 1) {
            boolean bl5;
            bl3 = processVars.numWaitingOrDLing > n5 || processVars.numWaitingOrDLing >= n5 && processVars.higherDLtoStart;
            boolean bl6 = bl5 = n4 == 4;
            if (this.maxDownloads != 0 && bl3 && (n2 != 0 || !bl5 || bl5 && totalsStats.maxActive != 0 && n2 == 0 && totalsStats.activelyCDing + totalsStats.activelyDLing >= totalsStats.maxActive)) {
                try {
                    if (this.bDebugLog) {
                        String string = "   stopAndQueue: " + processVars.numWaitingOrDLing + " waiting or downloading, when limit is " + n5 + "(" + this.maxDownloads + ")";
                        if (processVars.higherDLtoStart) {
                            string = string + " and higher DL is starting";
                        }
                        this.log.log((Object)download.getTorrent(), 1, string);
                        defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
                    }
                    download.stopAndQueue();
                    --processVars.numWaitingOrDLing;
                    if (n4 == 4) {
                        --totalsStats.downloading;
                        if (n3 != 0 || bl) {
                            --totalsStats.activelyDLing;
                        }
                    } else {
                        --totalsStats.waitingToDL;
                    }
                    totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n4 = download.getState();
            } else if (this.bDebugLog) {
                String string = "NOT queuing: ";
                string = this.maxDownloads == 0 ? string + "maxDownloads = " + this.maxDownloads : (!bl3 ? string + "not over limit.  numWaitingOrDLing(" + processVars.numWaitingOrDLing + ") <= maxDLs(" + n5 + ")" : (n3 == 0 || bl5 ? string + "not actively downloading" : (totalsStats.maxActive == 0 ? string + "unlimited active allowed (set)" : string + "# active(" + (totalsStats.activelyCDing + totalsStats.activelyDLing) + ") < maxActive(" + totalsStats.maxActive + ")")));
                this.log.log((Object)download.getTorrent(), 1, string);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
            }
        }
        if (n4 == 3 && (this.maxDownloads == 0 || totalsStats.activelyDLing < n5)) {
            try {
                if (this.bDebugLog) {
                    String string = "   start: READY && activelyDLing (" + totalsStats.activelyDLing + ") < maxDLs (" + this.maxDownloads + ")";
                    this.log.log((Object)download.getTorrent(), 1, string);
                    defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
                }
                download.start();
                --totalsStats.waitingToDL;
                ++totalsStats.activelyDLing;
                totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n4 = download.getState();
        }
        if (n4 == 9 && (this.maxDownloads == 0 || processVars.numWaitingOrDLing < n5)) {
            try {
                if (this.bDebugLog) {
                    String string = "   restart: QUEUED && numWaitingOrDLing (" + processVars.numWaitingOrDLing + ") < maxDLS (" + n5 + ")";
                    this.log.log(1, string);
                    defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
                }
                download.restart();
                ++processVars.numWaitingOrDLing;
                ++totalsStats.waitingToDL;
                totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n4 = download.getState();
        }
        if ((n = n4) != (n4 = download.getState())) {
            if (this.bDebugLog) {
                this.log.log(1, ">> somethingChanged: state");
            }
            this.somethingChanged = true;
        }
        if (download.getSeedingRank() >= 0 && (n4 == 9 || n4 == 3 || n4 == 1 || n4 == 2)) {
            processVars.higherDLtoStart = true;
        }
        if (this.bDebugLog) {
            String string = "<< DL state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + processVars.numWaitingOrDLing + ";maxCDrs=" + totalsStats.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totalsStats.activelyDLing + ";hgherQd=" + this.boolDebug(processVars.higherDLtoStart) + ";ActDLing=" + this.boolDebug(defaultRankCalculator.getActivelyDownloading());
            this.log.log((Object)download.getTorrent(), 1, string);
            defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
        }
        if (this.bStopOnceBandwidthMet) {
            processVars.accumulatedDownloadSpeed += download.getStats().getDownloadAverage();
            processVars.accumulatedUploadSpeed += download.getStats().getUploadAverage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleCompletedDownload(DefaultRankCalculator[] var1_1, DefaultRankCalculator var2_2, ProcessVars var3_3, TotalsStats var4_4) {
        block79: {
            block80: {
                block77: {
                    block78: {
                        if (!var4_4.bOkToStartSeeding) {
                            return;
                        }
                        var5_5 = var2_2.dl;
                        var6_6 = var5_5.getState();
                        var7_7 = var6_6 == 3 || var6_6 == 5;
                        var8_8 = null;
                        var9_9 = "";
                        var10_10 = var2_2.lastModifiedScrapeResultPeers;
                        var11_11 = false;
                        if (this.bDebugLog) {
                            var11_11 = var2_2.isFirstPriority();
                            var8_8 = new String[]{"CD state=" + " WPRDS.XEQ".charAt(var6_6), "shareR=" + var5_5.getStats().getShareRatio(), "nWorCDing=" + var3_3.numWaitingOrSeeding, "nWorDLing=" + var3_3.numWaitingOrDLing, "sr=" + var5_5.getSeedingRank(), "hgherQd=" + this.boolDebug(var3_3.higherCDtoStart), "maxCDrs=" + var4_4.maxSeeders, "FP=" + this.boolDebug(var11_11), "nActCDing=" + var4_4.activelyCDing, "ActCDing=" + this.boolDebug(var2_2.getActivelySeeding()), "nSeeds=" + var2_2.lastModifiedScrapeResultSeeds, "nPeers=" + var2_2.lastModifiedScrapeResultPeers};
                        }
                        var12_12 = var2_2.lastScrapeResultOk;
                        if (!this.bAutoStart0Peers || var10_10 != 0 || !var12_12) break block77;
                        if (var6_6 == 9) {
                            try {
                                if (this.bDebugLog) {
                                    var9_9 = var9_9 + "\nrestart() 0Peers";
                                }
                                var5_5.restart();
                                ++var4_4.waitingToSeed;
                                ++var3_3.numWaitingOrSeeding;
                                var6_6 = var5_5.getState();
                                if (var6_6 == 3) {
                                    if (this.bDebugLog) {
                                        var9_9 = var9_9 + "\nstart(); 0Peers";
                                    }
                                    var5_5.start();
                                    ++var4_4.activelyCDing;
                                }
                            }
                            catch (Exception var13_14) {
                                // empty catch block
                            }
                        }
                        if (var6_6 == 3) {
                            try {
                                if (this.bDebugLog) {
                                    var9_9 = var9_9 + "\nstart(); 0Peers";
                                }
                                var5_5.start();
                                ++var4_4.activelyCDing;
                                ++var3_3.numWaitingOrSeeding;
                            }
                            catch (Exception var13_15) {
                                // empty catch block
                            }
                        }
                        if (!this.bDebugLog) break block78;
                        var13_16 = new String[]{"CD state=" + " WPRDS.XEQ".charAt(var5_5.getState()), "shareR=" + var5_5.getStats().getShareRatio(), "nWorCDing=" + var3_3.numWaitingOrSeeding, "nWorDLing=" + var3_3.numWaitingOrDLing, "sr=" + var5_5.getSeedingRank(), "hgherQd=" + this.boolDebug(var3_3.higherCDtoStart), "maxCDrs=" + var4_4.maxSeeders, "FP=" + this.boolDebug(var11_11), "nActCDing=" + var4_4.activelyCDing, "ActCDing=" + this.boolDebug(var2_2.getActivelySeeding()), "nSeeds=" + var2_2.lastModifiedScrapeResultSeeds, "nPeers=" + var2_2.lastModifiedScrapeResultPeers};
                        this.printDebugChanges("", var8_8, var13_16, var9_9, "  ", true, var2_2);
                    }
                    return;
                }
                var13_17 = var5_5.getSeedingRank();
                if (var13_17 >= -1 || var5_5.isForceStart() || var7_7 || this.bAutoStart0Peers) break block79;
                if (this.bDebugLog) {
                    var9_9 = var9_9 + "\n  Skip !forceStart";
                    var14_18 = var13_17 * -1;
                    if (var14_18 < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                        var9_9 = var9_9 + " && " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[var14_18];
                    }
                }
                if (!this.bDebugLog) break block80;
                var14_19 = new String[]{"CD state=" + " WPRDS.XEQ".charAt(var5_5.getState()), "shareR=" + var5_5.getStats().getShareRatio(), "nWorCDing=" + var3_3.numWaitingOrSeeding, "nWorDLing=" + var3_3.numWaitingOrDLing, "sr=" + var5_5.getSeedingRank(), "hgherQd=" + this.boolDebug(var3_3.higherCDtoStart), "maxCDrs=" + var4_4.maxSeeders, "FP=" + this.boolDebug(var11_11), "nActCDing=" + var4_4.activelyCDing, "ActCDing=" + this.boolDebug(var2_2.getActivelySeeding()), "nSeeds=" + var2_2.lastModifiedScrapeResultSeeds, "nPeers=" + var2_2.lastModifiedScrapeResultPeers};
                this.printDebugChanges("", var8_8, var14_19, var9_9, "  ", true, var2_2);
            }
            return;
        }
        try {
            if (var3_3.higherCDtoStart && !var5_5.isForceStart() && !this.bAutoStart0Peers && !var7_7) {
                var9_9 = var9_9 + " a torrent with a higher rank is queued or starting";
            }
            if (this.bDebugLog && this.bAutoStart0Peers && var10_10 == 0 && !var12_12 && (var6_6 == 9 || var6_6 == 3)) {
                var9_9 = var9_9 + "\n  NOT starting 0 Peer torrent because scrape isn't ok";
            }
            if (!this.bDebugLog) {
                var11_11 = var2_2.isFirstPriority();
            }
            var14_20 = var2_2.getActivelySeeding();
            if (this.bStopOnceBandwidthMet) {
                var19_21 = var5_5.getState() == 5;
                var16_22 = var4_4.maxUploadSpeed() > 0 && (float)(var3_3.accumulatedUploadSpeed / 1024L) > (float)var4_4.maxUploadSpeed() * 0.9f;
                var15_23 = this.globalDownloadLimit > 0 && (float)(var3_3.accumulatedDownloadSpeed / 1024L) > (float)this.globalDownloadLimit * 0.9f;
                var17_24 = var14_20 != false || var19_21 != false && (var16_22 != false || var15_23 != false);
                v0 = var18_25 = var17_24 != false && var14_20 == false;
                if (var18_25) {
                    ++var4_4.activelyCDing;
                }
            } else {
                var16_22 = false;
                var17_24 = var14_20;
                var15_23 = false;
                var18_25 = false;
            }
            if (var6_6 == 5 && !var14_20) {
                ++var3_3.stalledSeeders;
            }
            v1 = var19_21 = var7_7 != false && (var11_11 == false || var11_11 != false && var4_4.maxActive != 0 && var3_3.numWaitingOrSeeding >= var4_4.maxActive - this.minDownloads) && var5_5.isForceStart() == false;
            if (var19_21 && var6_6 == 5 && this.iRankType != 3) {
                var20_26 = SystemTime.getCurrentTime() - var5_5.getStats().getTimeStarted();
                v2 = var19_21 = var20_26 >= this.minTimeAlive;
                if (!var19_21 && this.bDebugLog) {
                    var9_9 = var9_9 + "\n  Torrent can't be stopped yet, timeAlive(" + var20_26 + ") < minTimeAlive(" + this.minTimeAlive + ")";
                }
            }
            if (var6_6 != 9 && (var6_6 == 3 || var6_6 == 1 || var6_6 == 2 || var6_6 == 5 && var17_24 && !var5_5.isForceStart())) {
                ++var3_3.numWaitingOrSeeding;
                if (this.bDebugLog) {
                    var9_9 = var9_9 + "\n  Torrent is waiting or seeding";
                }
            }
            if (!(var19_21 || var6_6 != 9 || var4_4.maxActive != 0 && var3_3.numWaitingOrSeeding >= var4_4.maxSeeders || var13_17 < -1 || var3_3.stalledSeeders >= this.maxStalledSeeding || var3_3.higherCDtoStart)) {
                try {
                    if (this.bDebugLog) {
                        var9_9 = var9_9 + "\n  restart: ok2Q=" + var19_21 + "; QUEUED && numWaitingOrSeeding( " + var3_3.numWaitingOrSeeding + ") < maxSeeders (" + var4_4.maxSeeders + ")";
                    }
                    var5_5.restart();
                    var19_21 = false;
                    ++var4_4.waitingToSeed;
                    ++var3_3.numWaitingOrSeeding;
                    if (this.iRankType == 3) {
                        var2_2.recalcSeedingRank();
                    }
                }
                catch (Exception var20_27) {
                    // empty catch block
                }
                var6_6 = var5_5.getState();
            } else if (this.bDebugLog && var6_6 == 9) {
                var9_9 = var9_9 + "\n  NOT restarting:";
                if (var13_17 < -1) {
                    var9_9 = var9_9 + " torrent is being ignored";
                    var20_28 = var13_17 * -1;
                    if (var20_28 < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                        var9_9 = var9_9 + ": " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[var20_28];
                    }
                } else if (var3_3.higherCDtoStart) {
                    var9_9 = var9_9 + " a torrent with a higher rank is queued or starting";
                } else {
                    if (var19_21) {
                        var9_9 = var9_9 + " no starting of okToQueue'd;";
                    }
                    var9_9 = var3_3.numWaitingOrSeeding >= var4_4.maxSeeders ? var9_9 + " at limit, numWaitingOrSeeding(" + var3_3.numWaitingOrSeeding + ") >= maxSeeders(" + var4_4.maxSeeders + ")" : (var3_3.stalledSeeders >= this.maxStalledSeeding ? var9_9 + " at limit, stalledSeeders(" + var3_3.stalledSeeders + ") >= maxStalledSeeding(" + this.maxStalledSeeding + ") " : var9_9 + "huh? qd=" + (var6_6 == 9) + "; " + var4_4.maxActive + ";" + (var3_3.numWaitingOrSeeding < var4_4.maxSeeders) + ";" + (var3_3.stalledSeeders <= this.maxStalledSeeding) + ";ignore?" + (var13_17 >= -1));
                }
            }
            var20_29 = false;
            if (var6_6 == 3 && var4_4.activelyCDing < var4_4.maxSeeders) {
                if (var13_17 >= -1 || var5_5.isForceStart()) {
                    try {
                        if (this.bDebugLog) {
                            var9_9 = var9_9 + "\n  start: READY && total activelyCDing(" + var4_4.activelyCDing + ") < maxSeeders(" + var4_4.maxSeeders + ")";
                        }
                        var5_5.start();
                        var19_21 = false;
                    }
                    catch (Exception var21_30) {
                        // empty catch block
                    }
                    var6_6 = var5_5.getState();
                    ++var4_4.activelyCDing;
                    var14_20 = true;
                    var17_24 = true;
                    ++var3_3.numWaitingOrSeeding;
                } else if (var19_21) {
                    var20_29 = true;
                }
            }
            if (var19_21 || var20_29) {
                var21_31 = var20_29;
                if (!var21_31) {
                    var22_33 = var3_3.numWaitingOrSeeding > var4_4.maxSeeders || var14_20 == false && var3_3.stalledSeeders > this.maxStalledSeeding || var3_3.numWaitingOrSeeding >= var4_4.maxSeeders && var3_3.higherCDtoStart != false;
                    var23_36 = var6_6 == 5 ? 1 : 0;
                    v3 = var21_31 = var5_5.isChecking() == false && (var22_33 != false || var13_17 < -1) && (var17_24 != false || var23_36 == 0 || var17_24 == false && var23_36 != 0);
                    if (this.bDebugLog) {
                        if (var21_31) {
                            var9_9 = var9_9 + "\n  stopAndQueue: ";
                            if (var22_33) {
                                var9_9 = var3_3.higherCDtoStart ? var9_9 + "higherQueued (it should be seeding instead of this one)" : (!var14_20 && var3_3.stalledSeeders > var4_4.maxSeeders ? var9_9 + "over stale seeds limit" : var9_9 + "over limit");
                            } else if (var13_17 < -1) {
                                var9_9 = var9_9 + "ignoreRule met";
                            }
                            var9_9 = var9_9 + " && ";
                            if (var14_20) {
                                var9_9 = var9_9 + "activelySeeding";
                            } else if (var23_36 == 0) {
                                var9_9 = var9_9 + "not SEEDING";
                            } else if (!var14_20 && var23_36 != 0) {
                                var9_9 = var9_9 + "SEEDING, but not actively";
                            }
                        }
                    } else {
                        var9_9 = var9_9 + "\n  NOT queuing: ";
                        var9_9 = var5_5.isChecking() ? var9_9 + "can't auto-queue a checking torrent" : (!var22_33 ? var9_9 + "not over limit.  numWaitingOrSeeding(" + var3_3.numWaitingOrSeeding + ") <= maxSeeders(" + var4_4.maxSeeders + ")" : var9_9 + "bActivelySeeding=" + var14_20 + ";bSeeding" + (boolean)var23_36);
                    }
                } else if (this.bDebugLog) {
                    var9_9 = var9_9 + "\n  Forcing a stop..";
                }
                if (var21_31) {
                    try {
                        if (var6_6 == 3) {
                            --var4_4.waitingToSeed;
                        }
                        var5_5.stopAndQueue();
                        var3_3.bStopAndQueued = true;
                        if (var14_20 || var18_25) {
                            --var4_4.activelyCDing;
                            var14_20 = false;
                        }
                        if (var17_24) {
                            --var3_3.numWaitingOrSeeding;
                            var17_24 = false;
                        }
                        if (var6_6 == 3) {
                            --var4_4.waitingToSeed;
                        }
                    }
                    catch (Exception var22_34) {
                        // empty catch block
                    }
                    var6_6 = var5_5.getState();
                }
            }
            if (var3_3.bStopAndQueued && this.iRankType == 3) {
                for (var21_32 = 0; var21_32 < var1_1.length; ++var21_32) {
                    var22_35 = var1_1[var21_32].getDownloadObject();
                    var23_36 = var22_35.getSeedingRank();
                    if (var23_36 <= 0 || var23_36 >= 999999) continue;
                    var22_35.setSeedingRank(var23_36 + 1);
                }
                var13_17 = 999999 - var4_4.complete;
                var5_5.setSeedingRank(var13_17);
            }
            var6_6 = var5_5.getState();
            if (var13_17 >= 0 && (var6_6 == 9 || var6_6 == 3 || var6_6 == 1 || var6_6 == 2)) {
                var3_3.higherCDtoStart = true;
            }
            ** if (!this.bDebugLog) goto lbl-1000
        }
        catch (Throwable var24_37) {
            if (this.bDebugLog) {
                var25_38 = new String[]{"CD state=" + " WPRDS.XEQ".charAt(var5_5.getState()), "shareR=" + var5_5.getStats().getShareRatio(), "nWorCDing=" + var3_3.numWaitingOrSeeding, "nWorDLing=" + var3_3.numWaitingOrDLing, "sr=" + var5_5.getSeedingRank(), "hgherQd=" + this.boolDebug(var3_3.higherCDtoStart), "maxCDrs=" + var4_4.maxSeeders, "FP=" + this.boolDebug(var11_11), "nActCDing=" + var4_4.activelyCDing, "ActCDing=" + this.boolDebug(var2_2.getActivelySeeding()), "nSeeds=" + var2_2.lastModifiedScrapeResultSeeds, "nPeers=" + var2_2.lastModifiedScrapeResultPeers};
                this.printDebugChanges("", var8_8, var25_38, var9_9, "  ", true, var2_2);
            }
            throw var24_37;
        }
lbl-1000:
        // 1 sources

        {
            var12_13 = new String[]{"CD state=" + " WPRDS.XEQ".charAt(var5_5.getState()), "shareR=" + var5_5.getStats().getShareRatio(), "nWorCDing=" + var3_3.numWaitingOrSeeding, "nWorDLing=" + var3_3.numWaitingOrDLing, "sr=" + var5_5.getSeedingRank(), "hgherQd=" + this.boolDebug(var3_3.higherCDtoStart), "maxCDrs=" + var4_4.maxSeeders, "FP=" + this.boolDebug(var11_11), "nActCDing=" + var4_4.activelyCDing, "ActCDing=" + this.boolDebug(var2_2.getActivelySeeding()), "nSeeds=" + var2_2.lastModifiedScrapeResultSeeds, "nPeers=" + var2_2.lastModifiedScrapeResultPeers};
            this.printDebugChanges("", var8_8, var12_13, var9_9, "  ", true, var2_2);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (this.bStopOnceBandwidthMet) {
            var3_3.accumulatedUploadSpeed += var5_5.getStats().getUploadAverage();
        }
    }

    private String boolDebug(boolean bl) {
        return bl ? "Y" : "N";
    }

    private void printDebugChanges(String string, String[] stringArray, String[] stringArray2, String string2, String string3, boolean bl, DefaultRankCalculator defaultRankCalculator) {
        boolean bl2 = false;
        String string4 = string;
        StringBuffer stringBuffer = new StringBuffer(120);
        StringBuffer stringBuffer2 = new StringBuffer(120);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) {
                string4 = string4 + stringArray[i] + ";";
                continue;
            }
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(";");
            stringBuffer2.append(stringArray2[i]);
            stringBuffer2.append(";");
            bl2 = true;
        }
        String string5 = (bl || bl2 ? string4 : "") + (bl2 ? "\nOld:" + stringBuffer + "\nNew:" + stringBuffer2 : "") + string2;
        if (!string5.equals("")) {
            String[] stringArray3 = string5.split("\n");
            for (int i = 0; i < stringArray3.length; ++i) {
                String string6 = string3 + (i > 0 ? "  " : "") + stringArray3[i];
                if (defaultRankCalculator == null) {
                    this.log.log(1, string6);
                    continue;
                }
                this.log.log((Object)defaultRankCalculator.dl.getTorrent(), 1, string6);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string6 + "\n";
            }
        }
    }

    public int calcPeersNoUs(Download download) {
        int n = 0;
        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
        if (downloadScrapeResult.getScrapeStartTime() > 0L && (n = downloadScrapeResult.getNonSeedCount()) > 0 && download.getState() == 4 && downloadScrapeResult.getScrapeStartTime() > download.getStats().getTimeStarted()) {
            --n;
        }
        if (n == 0) {
            DownloadActivationEvent downloadActivationEvent;
            DownloadAnnounceResult downloadAnnounceResult = download.getLastAnnounceResult();
            if (downloadAnnounceResult != null && downloadAnnounceResult.getResponseType() == 1) {
                n = downloadAnnounceResult.getNonSeedCount();
            }
            if (n == 0 && (downloadActivationEvent = download.getActivationState()) != null) {
                n = downloadActivationEvent.getActivationCount();
            }
        }
        return n;
    }

    private boolean scrapeResultOk(Download download) {
        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
        return downloadScrapeResult.getResponseType() == 1;
    }

    public int calcSeedsNoUs(Download download) {
        return this.calcSeedsNoUs(download, this.calcPeersNoUs(download));
    }

    public int calcSeedsNoUs(Download download, int n) {
        DownloadAnnounceResult downloadAnnounceResult;
        int n2 = 0;
        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
        if (downloadScrapeResult.getScrapeStartTime() > 0L) {
            long l = download.getStats().getTimeStartedSeeding();
            n2 = downloadScrapeResult.getSeedCount();
            if (n2 > 0 && l > 0L && download.getState() == 5 && downloadScrapeResult.getScrapeStartTime() > l) {
                --n2;
            }
        }
        if (n2 == 0 && (downloadAnnounceResult = download.getLastAnnounceResult()) != null && downloadAnnounceResult.getResponseType() == 1) {
            n2 = downloadAnnounceResult.getSeedCount();
        }
        if (this.numPeersAsFullCopy != 0 && n2 >= this.iFakeFullCopySeedStart) {
            n2 += n / this.numPeersAsFullCopy;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestProcessCycle(DefaultRankCalculator defaultRankCalculator) {
        if (defaultRankCalculator != null) {
            try {
                this.ranksToRecalc_mon.enter();
                this.ranksToRecalc.add(defaultRankCalculator);
            }
            finally {
                this.ranksToRecalc_mon.exit();
            }
        }
        if (this.somethingChanged) {
            ++this.processMergeCount;
        } else {
            this.somethingChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("StartStopRules Manager");
        try {
            indentWriter.indent();
            indentWriter.println("Started " + TimeFormatter.format100ths(SystemTime.getCurrentTime() - this.startedOn) + " ago");
            indentWriter.println("debugging = " + this.bDebugLog);
            indentWriter.println("downloadDataMap size = " + downloadDataMap.size());
            if (this.changeCheckCount > 0L) {
                indentWriter.println("changeCheck CPU ms: avg=" + this.changeCheckTotalMS / this.changeCheckCount + "; max = " + this.changeCheckMaxMS);
            }
            if (this.processCount > 0L) {
                indentWriter.println("# process cycles: " + this.processCount);
                indentWriter.println("process CPU ms: avg=" + this.processTotalMS / this.processCount + "; max = " + this.processMaxMS);
                if (this.processCount > 1L) {
                    indentWriter.println("process avg gap: " + this.processTotalGap / (this.processCount - 1L) + "ms");
                }
                indentWriter.println("Avg # recalcs per process cycle: " + this.processTotalRecalcs / this.processCount);
                if (this.processTotalZeroRecalcs > 0L) {
                    indentWriter.println("# process cycle with 0 recalcs: " + this.processTotalZeroRecalcs);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            indentWriter.exdent();
        }
    }

    public void addListener(StartStopRulesFPListener startStopRulesFPListener) {
        this.listenersFP.add(startStopRulesFPListener);
    }

    public void removeListener(StartStopRulesFPListener startStopRulesFPListener) {
        this.listenersFP.remove(startStopRulesFPListener);
    }

    public List getFPListeners() {
        return this.listenersFP.getList();
    }

    static /* synthetic */ DefaultRankCalculator[] access$1102(StartStopRulesDefaultPlugin startStopRulesDefaultPlugin, DefaultRankCalculator[] defaultRankCalculatorArray) {
        startStopRulesDefaultPlugin.sortedArrayCache = defaultRankCalculatorArray;
        return defaultRankCalculatorArray;
    }

    public class ProcessVars {
        int numWaitingOrSeeding;
        int numWaitingOrDLing;
        long accumulatedDownloadSpeed;
        long accumulatedUploadSpeed;
        boolean higherCDtoStart;
        boolean higherDLtoStart;
        int posComplete;
        boolean bStopAndQueued;
        int stalledSeeders;
    }

    private class TotalsStats {
        int forcedSeeding = 0;
        int forcedSeedingNonFP = 0;
        int waitingToSeed = 0;
        int waitingToDL = 0;
        int downloading = 0;
        int activelyDLing = 0;
        int activelyCDing = 0;
        int complete = 0;
        int incompleteQueued = 0;
        int firstPriority = 0;
        int stalledSeeders = 0;
        int stalledFPSeeders = 0;
        int forcedActive = 0;
        boolean bOkToStartSeeding;
        int maxSeeders;
        int maxActive;
        int maxTorrents;

        public int maxUploadSpeed() {
            return this.downloading == 0 ? StartStopRulesDefaultPlugin.this.globalUploadWhenSeedingLimit : StartStopRulesDefaultPlugin.this.globalUploadLimit;
        }

        public TotalsStats(DefaultRankCalculator[] defaultRankCalculatorArray) {
            int n;
            this.bOkToStartSeeding = StartStopRulesDefaultPlugin.this.iRankType == 0 || StartStopRulesDefaultPlugin.this.iRankType == 3 || SystemTime.getCurrentTime() - StartStopRulesDefaultPlugin.this.startedOn > 90000L;
            int n2 = 0;
            for (n = 0; n < defaultRankCalculatorArray.length; ++n) {
                Download download;
                int n3;
                DefaultRankCalculator defaultRankCalculator = defaultRankCalculatorArray[n];
                if (defaultRankCalculator == null || (n3 = (download = defaultRankCalculator.getDownloadObject()).getState()) == 8 || n3 == 7) continue;
                boolean bl = download.isComplete();
                boolean bl2 = false;
                if (!bl && download.isForceStart()) continue;
                if (bl) {
                    boolean bl3 = true;
                    if (!this.bOkToStartSeeding) {
                        bl3 = StartStopRulesDefaultPlugin.this.scrapeResultOk(download);
                        if (StartStopRulesDefaultPlugin.this.calcSeedsNoUs(download) == 0 && bl3) {
                            this.bOkToStartSeeding = true;
                        } else if (download.getSeedingRank() > 0 && (n3 == 9 || n3 == 3) && SystemTime.getCurrentTime() - StartStopRulesDefaultPlugin.this.startedOn > 20000L) {
                            this.bOkToStartSeeding = true;
                        }
                    }
                    ++this.complete;
                    if (!this.bOkToStartSeeding && bl3) {
                        ++n2;
                    }
                    if (defaultRankCalculator.isFirstPriority()) {
                        if (!this.bOkToStartSeeding) {
                            this.bOkToStartSeeding = true;
                        }
                        ++this.firstPriority;
                        bl2 = true;
                    }
                    if (defaultRankCalculator.getActivelySeeding()) {
                        if (defaultRankCalculator.isForceActive()) {
                            ++this.forcedActive;
                        }
                        ++this.activelyCDing;
                        if (download.isForceStart()) {
                            ++this.forcedSeeding;
                            if (!bl2) {
                                ++this.forcedSeedingNonFP;
                            }
                        }
                    } else if (n3 == 5) {
                        if (bl2) {
                            ++this.stalledFPSeeders;
                        }
                        ++this.stalledSeeders;
                    }
                    if (n3 != 3 && n3 != 1 && n3 != 2) continue;
                    ++this.waitingToSeed;
                    continue;
                }
                if (n3 == 4) {
                    ++this.downloading;
                    if (defaultRankCalculator.getActivelyDownloading()) {
                        ++this.activelyDLing;
                    }
                }
                if (n3 == 3 || n3 == 1 || n3 == 2) {
                    ++this.waitingToDL;
                    continue;
                }
                if (n3 != 9) continue;
                ++this.incompleteQueued;
            }
            if (!this.bOkToStartSeeding && n2 == this.complete) {
                this.bOkToStartSeeding = true;
            }
            this.maxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(this.activelyDLing + this.waitingToDL);
            this.maxActive = StartStopRulesDefaultPlugin.this.getMaxActive();
            if (this.maxActive == 0) {
                this.maxTorrents = 9999;
            } else if (this.maxUploadSpeed() == 0) {
                this.maxTorrents = this.maxActive + 4;
            } else {
                n = StartStopRulesDefaultPlugin.this.minSpeedForActiveSeeding * 2 / 1024;
                if (n < 3) {
                    n = 3;
                }
                this.maxTorrents = this.maxUploadSpeed() / n;
                if (this.maxTorrents < this.maxActive) {
                    this.maxTorrents = this.maxActive;
                }
            }
        }
    }

    private class ChangeCheckerTimerTask
    implements TimerEventPerformer {
        long lLastRunTime = 0L;

        private ChangeCheckerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(TimerEvent timerEvent2) {
            long l = 0L;
            try {
                int n;
                DefaultRankCalculator[] defaultRankCalculatorArray;
                StartStopRulesDefaultPlugin.this.this_mon.enter();
                l = SystemTime.getCurrentTime();
                if (l > this.lLastRunTime && l - this.lLastRunTime < 1000L) {
                    return;
                }
                this.lLastRunTime = l;
                Map map = downloadDataMap;
                synchronized (map) {
                    defaultRankCalculatorArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
                }
                int n2 = 0;
                int n3 = 0;
                for (n = 0; n < defaultRankCalculatorArray.length; ++n) {
                    if (defaultRankCalculatorArray[n].changeChecker()) {
                        StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculatorArray[n]);
                    }
                    if (defaultRankCalculatorArray[n].getActivelyDownloading()) {
                        ++n2;
                    }
                    if (!defaultRankCalculatorArray[n].getActivelySeeding()) continue;
                    ++n3;
                }
                n = StartStopRulesDefaultPlugin.this.calcMaxSeeders(n2);
                if (n3 > n) {
                    StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                    if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                        StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: More Seeding than limit");
                    }
                }
            }
            finally {
                if (l > 0L) {
                    StartStopRulesDefaultPlugin.this.changeCheckCount++;
                    long l2 = SystemTime.getCurrentTime() - l;
                    StartStopRulesDefaultPlugin.this.changeCheckTotalMS += l2;
                    if (l2 > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                        StartStopRulesDefaultPlugin.this.changeCheckMaxMS = l2;
                    }
                }
                StartStopRulesDefaultPlugin.this.this_mon.exit();
            }
        }
    }

    private class StartStopDMListener
    implements DownloadManagerListener {
        private DownloadTrackerListener download_tracker_listener;
        private DownloadListener download_listener;
        private DownloadActivationListener download_activation_listener;

        public StartStopDMListener() {
            this.download_tracker_listener = new StartStopDMTrackerListener();
            this.download_listener = new StartStopDownloadListener();
            this.download_activation_listener = new StartStopDownloadActivationListener();
        }

        @Override
        public void downloadAdded(Download download) {
            DefaultRankCalculator defaultRankCalculator = null;
            if (downloadDataMap.containsKey(download)) {
                defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            } else {
                defaultRankCalculator = new DefaultRankCalculator(StartStopRulesDefaultPlugin.this, download);
                StartStopRulesDefaultPlugin.access$1102(StartStopRulesDefaultPlugin.this, null);
                downloadDataMap.put(download, defaultRankCalculator);
                download.addListener(this.download_listener);
                download.addTrackerListener(this.download_tracker_listener, false);
                download.addActivationListener(this.download_activation_listener);
            }
            if (defaultRankCalculator != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadAdded, state: " + StartStopRulesDefaultPlugin.sStates.charAt(download.getState()));
                }
            }
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removeListener(this.download_listener);
            download.removeTrackerListener(this.download_tracker_listener);
            download.removeActivationListener(this.download_activation_listener);
            if (downloadDataMap.containsKey(download)) {
                StartStopRulesDefaultPlugin.access$1102(StartStopRulesDefaultPlugin.this, null);
                downloadDataMap.remove(download);
            }
            StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadRemoved");
            }
        }
    }

    private class StartStopDownloadActivationListener
    implements DownloadActivationListener {
        private StartStopDownloadActivationListener() {
        }

        @Override
        public boolean activationRequested(DownloadActivationEvent downloadActivationEvent) {
            DownloadScrapeResult downloadScrapeResult;
            int n;
            Download download = downloadActivationEvent.getDownload();
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download, 1, ">> somethingChanged: ActivationRequest");
            }
            StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
            return download.isComplete() && (n = (downloadScrapeResult = downloadActivationEvent.getDownload().getLastScrapeResult()).getNonSeedCount()) <= 0;
        }
    }

    private class StartStopDMTrackerListener
    implements DownloadTrackerListener {
        private StartStopDMTrackerListener() {
        }

        @Override
        public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
            Download download = downloadScrapeResult.getDownload();
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (downloadScrapeResult.getResponseType() == 2) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "Ignored somethingChanged: new scrapeResult (RT_ERROR)");
                }
                if (defaultRankCalculator != null) {
                    defaultRankCalculator.lastScrapeResultOk = false;
                }
                return;
            }
            if (defaultRankCalculator != null) {
                defaultRankCalculator.lastScrapeResultOk = true;
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: new scrapeResult S:" + downloadScrapeResult.getSeedCount() + ";P:" + downloadScrapeResult.getNonSeedCount());
                }
            }
        }

        @Override
        public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
        }
    }

    private class StartStopDownloadListener
    implements DownloadListener {
        private StartStopDownloadListener() {
        }

        @Override
        public void stateChanged(Download download, int n, int n2) {
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (defaultRankCalculator != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (n2 == 3 || n2 == 1) {
                    if (StartStopRulesDefaultPlugin.this.immediateProcessingScheduled) {
                        StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                    } else {
                        StartStopRulesDefaultPlugin.this.immediateProcessingScheduled = true;
                        new AEThread2("processReady", true){

                            @Override
                            public void run() {
                                StartStopRulesDefaultPlugin.this.process();
                            }
                        }.start();
                    }
                }
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)defaultRankCalculator.dl.getTorrent(), 1, "somethingChanged: stateChange from " + StartStopRulesDefaultPlugin.sStates.charAt(n) + " (" + n + ") to " + StartStopRulesDefaultPlugin.sStates.charAt(n2) + " (" + n2 + ")");
                }
            }
        }

        @Override
        public void positionChanged(Download download, int n, int n2) {
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (defaultRankCalculator != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)defaultRankCalculator.dl.getTorrent(), 1, "somethingChanged: positionChanged from " + n + " to " + n2);
                }
            }
        }
    }

    private class ChangeFlagCheckerTask
    implements TimerEventPerformer {
        final long FORCE_CHECK_CYCLES = 40L;
        long cycleNo = 0L;

        private ChangeFlagCheckerTask() {
        }

        @Override
        public void perform(TimerEvent timerEvent2) {
            if (StartStopRulesDefaultPlugin.this.closingDown || pauseChangeFlagChecker) {
                return;
            }
            ++this.cycleNo;
            if (this.cycleNo > 40L) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, ">>force process");
                }
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
            }
            if (StartStopRulesDefaultPlugin.this.somethingChanged) {
                try {
                    this.cycleNo = 0L;
                    StartStopRulesDefaultPlugin.this.process();
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
            }
        }
    }

    private class RecalcSeedingRanksTask
    implements TimerEventPerformer {
        boolean bCancel = false;

        private RecalcSeedingRanksTask() {
        }

        @Override
        public void perform(TimerEvent timerEvent2) {
            if (this.bCancel) {
                timerEvent2.cancel();
                return;
            }
            StartStopRulesDefaultPlugin.this.recalcAllSeedingRanks(false);
        }

        public void cancel() {
            this.bCancel = true;
        }
    }
}

