/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.dht;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class DHTTrackerPlugin
implements Plugin,
DownloadListener,
DownloadAttributeListener,
DownloadTrackerListener {
    private static final String PLUGIN_NAME = "Distributed Tracker";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dhttracker";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.dhttracker";
    private static final int ANNOUNCE_TIMEOUT = 120000;
    private static final int ANNOUNCE_DERIVED_TIMEOUT = 60000;
    private static final int SCRAPE_TIMEOUT = 30000;
    private static final int ANNOUNCE_MIN_DEFAULT = 120000;
    private static final int ANNOUNCE_MAX = 3600000;
    private static final int ANNOUNCE_MAX_DERIVED_ONLY = 1800000;
    private static final int INTERESTING_CHECK_PERIOD = 14400000;
    private static final int INTERESTING_INIT_RAND_OURS = 300000;
    private static final int INTERESTING_INIT_MIN_OURS = 120000;
    private static final int INTERESTING_INIT_RAND_OTHERS = 1800000;
    private static final int INTERESTING_INIT_MIN_OTHERS = 300000;
    private static final int INTERESTING_DHT_CHECK_PERIOD = 3600000;
    private static final int INTERESTING_DHT_INIT_RAND = 300000;
    private static final int INTERESTING_DHT_INIT_MIN = 120000;
    private static final int INTERESTING_AVAIL_MAX = 8;
    private static final int INTERESTING_PUB_MAX_DEFAULT = 30;
    private static final int REG_TYPE_NONE = 1;
    private static final int REG_TYPE_FULL = 2;
    private static final int REG_TYPE_DERIVED = 3;
    private static final int LIMITED_TRACK_SIZE = 16;
    private static final boolean TRACK_NORMAL_DEFAULT = true;
    private static final boolean TRACK_LIMITED_DEFAULT = true;
    public static final int NUM_WANT = 30;
    private static final long start_time = SystemTime.getCurrentTime();
    private static final Object DL_DERIVED_METRIC_KEY = new Object();
    private static final int DL_DERIVED_MIN_TRACK = 5;
    private static final int DL_DERIVED_MAX_TRACK = 20;
    private static final int DIRECT_INJECT_PEER_MAX = 5;
    private static boolean ADD_ASN_DERIVED_TARGET = true;
    private static boolean ADD_NETPOS_DERIVED_TARGETS = false;
    private static URL DEFAULT_URL;
    private PluginInterface plugin_interface;
    private BasicPluginViewModel model;
    private DHTPlugin dht;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private Map<Download, Long> interesting_downloads = new HashMap<Download, Long>();
    private int interesting_published = 0;
    private int interesting_pub_max = 30;
    private Map<Download, int[]> running_downloads = new HashMap<Download, int[]>();
    private Map<Download, RegistrationDetails> registered_downloads = new HashMap<Download, RegistrationDetails>();
    private Map<Download, Boolean> limited_online_tracking = new HashMap<Download, Boolean>();
    private Map<Download, Long> query_map = new HashMap<Download, Long>();
    private Map<Download, Integer> in_progress = new HashMap<Download, Integer>();
    private boolean track_only_decentralsed = COConfigurationManager.getBooleanParameter("dhtplugin.track.only.decentralised", false);
    private BooleanParameter track_normal_when_offline;
    private BooleanParameter track_limited_when_online;
    private long current_announce_interval = 120000L;
    private LoggerChannel log;
    private Map<Download, int[]> scrape_injection_map = new WeakHashMap<Download, int[]>();
    private Random random = new Random();
    private boolean is_running;
    private AEMonitor this_mon = new AEMonitor("DHTTrackerPlugin");
    private DHTNetworkPosition[] current_network_positions;
    private long last_net_pos_time;
    private AESemaphore initialised_sem = new AESemaphore("DHTTrackerPlugin:init");
    private boolean disable_put;

    public DHTTrackerPlugin() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable.Proxy", "Enable.SOCKS"}, new org.gudy.azureus2.core3.config.ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                boolean bl = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                boolean bl2 = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                DHTTrackerPlugin.this.disable_put = bl && bl2;
            }
        });
    }

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
        UIManager uIManager = this.plugin_interface.getUIManager();
        this.model = uIManager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        this.model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        this.track_normal_when_offline = basicPluginConfigModel.addBooleanParameter2("dhttracker.tracknormalwhenoffline", "dhttracker.tracknormalwhenoffline", true);
        this.track_limited_when_online = basicPluginConfigModel.addBooleanParameter2("dhttracker.tracklimitedwhenonline", "dhttracker.tracklimitedwhenonline", true);
        this.track_limited_when_online.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                DHTTrackerPlugin.this.configChanged();
            }
        });
        this.track_normal_when_offline.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                DHTTrackerPlugin.this.track_limited_when_online.setEnabled(DHTTrackerPlugin.this.track_normal_when_offline.getValue());
                DHTTrackerPlugin.this.configChanged();
            }
        });
        if (!this.track_normal_when_offline.getValue()) {
            this.track_limited_when_online.setEnabled(false);
        }
        this.interesting_pub_max = this.plugin_interface.getPluginconfig().getPluginIntParameter("dhttracker.presencepubmax", 30);
        this.model.getActivity().setVisible(false);
        this.model.getProgress().setVisible(false);
        this.model.getLogArea().setMaximumSize(80000);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int n, String string) {
                DHTTrackerPlugin.this.model.getLogArea().appendText(string + "\n");
            }

            @Override
            public void messageLogged(String string, Throwable throwable) {
                DHTTrackerPlugin.this.model.getLogArea().appendText(throwable.toString() + "\n");
            }
        });
        this.model.getStatus().setText(MessageText.getString("ManagerItem.initializing"));
        this.log.log("Waiting for Distributed Database initialisation");
        this.plugin_interface.addListener(new PluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializationComplete() {
                boolean bl = true;
                try {
                    PluginInterface pluginInterface = DHTTrackerPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (pluginInterface != null) {
                        DHTTrackerPlugin.this.dht = (DHTPlugin)pluginInterface.getPlugin();
                        DelayedTask delayedTask = DHTTrackerPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                            @Override
                            public void run() {
                                AEThread2 aEThread2 = new AEThread2("DHTTrackerPlugin:init", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            if (DHTTrackerPlugin.this.dht.isEnabled()) {
                                                DHTTrackerPlugin.this.log.log("DDB Available");
                                                DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.activity.status.false"));
                                                DHTTrackerPlugin.this.initialise();
                                            } else {
                                                DHTTrackerPlugin.this.log.log("DDB Disabled");
                                                DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("dht.status.disabled"));
                                                DHTTrackerPlugin.this.notRunning();
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            DHTTrackerPlugin.this.log.log("DDB Failed", throwable);
                                            DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.operations.failed"));
                                            DHTTrackerPlugin.this.notRunning();
                                        }
                                        finally {
                                            DHTTrackerPlugin.this.initialised_sem.releaseForever();
                                        }
                                    }
                                };
                                aEThread2.start();
                            }
                        });
                        delayedTask.queue();
                        bl = false;
                    } else {
                        DHTTrackerPlugin.this.log.log("DDB Plugin missing");
                        DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.operations.failed"));
                        DHTTrackerPlugin.this.notRunning();
                    }
                }
                finally {
                    if (bl) {
                        DHTTrackerPlugin.this.initialised_sem.releaseForever();
                    }
                }
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    protected void notRunning() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            @Override
            public void downloadAdded(Download download) {
                DHTTrackerPlugin.this.addDownload(download);
            }

            @Override
            public void downloadRemoved(Download download) {
                DHTTrackerPlugin.this.removeDownload(download);
            }
        });
    }

    protected void initialise() {
        this.is_running = true;
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            @Override
            public void downloadAdded(Download download) {
                DHTTrackerPlugin.this.addDownload(download);
            }

            @Override
            public void downloadRemoved(Download download) {
                DHTTrackerPlugin.this.removeDownload(download);
            }
        });
        this.plugin_interface.getUtilities().createTimer("DHT Tracker", true).addPeriodicEvent(15000L, new UTTimerEventPerformer(){
            private int ticks;

            @Override
            public void perform(UTTimerEvent uTTimerEvent) {
                ++this.ticks;
                DHTTrackerPlugin.this.processRegistrations(this.ticks % 8 == 0);
                if (this.ticks == 2 || this.ticks % 4 == 0) {
                    DHTTrackerPlugin.this.processNonRegistrations();
                }
            }
        });
    }

    public void waitUntilInitialised() {
        this.initialised_sem.reserve();
    }

    public boolean isRunning() {
        return this.is_running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownload(final Download download) {
        Object object;
        if (download.getFlag(16L)) {
            return;
        }
        if (this.track_only_decentralsed && (object = download.getTorrent()) != null && !TorrentUtils.isDecentralised(object.getAnnounceURL())) {
            return;
        }
        if (this.is_running) {
            object = download.getListAttribute(this.ta_networks);
            Torrent torrent = download.getTorrent();
            if (torrent != null && object != null) {
                int n;
                boolean bl = false;
                for (n = 0; n < ((String[])object).length; ++n) {
                    if (!object[n].equalsIgnoreCase("Public")) continue;
                    bl = true;
                    break;
                }
                if (bl && !torrent.isPrivate()) {
                    long l;
                    n = torrent.wasCreatedByUs() ? 1 : 0;
                    if (n != 0) {
                        l = download.getCreationTime() > start_time ? 0L : this.plugin_interface.getUtilities().getCurrentSystemTime() + 120000L + (long)this.random.nextInt(300000);
                    } else {
                        int n2;
                        int n3;
                        if (TorrentUtils.isDecentralised(torrent.getAnnounceURL())) {
                            n3 = 120000;
                            n2 = 300000;
                        } else {
                            n3 = 300000;
                            n2 = 1800000;
                        }
                        l = this.plugin_interface.getUtilities().getCurrentSystemTime() + (long)n3 + (long)this.random.nextInt(n2);
                    }
                    try {
                        this.this_mon.enter();
                        this.interesting_downloads.put(download, new Long(l));
                    }
                    finally {
                        this.this_mon.exit();
                    }
                }
            }
            download.addAttributeListener(this, this.ta_networks, 1);
            download.addAttributeListener(this, this.ta_peer_sources, 1);
            download.addTrackerListener(this);
            download.addListener(this);
            this.checkDownloadForRegistration(download, true);
        } else {
            object = download.getTorrent();
            if (object != null && object.isDecentralised()) {
                download.addListener(new DownloadListener(){

                    @Override
                    public void stateChanged(final Download download, int n, int n2) {
                        int n3 = download.getState();
                        if (n3 == 4 || n3 == 5) {
                            download.setAnnounceResult(new DownloadAnnounceResult(){

                                @Override
                                public Download getDownload() {
                                    return download;
                                }

                                @Override
                                public int getResponseType() {
                                    return 2;
                                }

                                @Override
                                public int getReportedPeerCount() {
                                    return 0;
                                }

                                @Override
                                public int getSeedCount() {
                                    return 0;
                                }

                                @Override
                                public int getNonSeedCount() {
                                    return 0;
                                }

                                @Override
                                public String getError() {
                                    return "Distributed Database Offline";
                                }

                                @Override
                                public URL getURL() {
                                    return download.getTorrent().getAnnounceURL();
                                }

                                @Override
                                public DownloadAnnounceResultPeer[] getPeers() {
                                    return new DownloadAnnounceResultPeer[0];
                                }

                                @Override
                                public long getTimeToWait() {
                                    return 0L;
                                }

                                @Override
                                public Map getExtensions() {
                                    return null;
                                }
                            });
                        }
                    }

                    @Override
                    public void positionChanged(Download download, int n, int n2) {
                    }
                });
                download.setScrapeResult(new DownloadScrapeResult(){

                    @Override
                    public Download getDownload() {
                        return download;
                    }

                    @Override
                    public int getResponseType() {
                        return 2;
                    }

                    @Override
                    public int getSeedCount() {
                        return -1;
                    }

                    @Override
                    public int getNonSeedCount() {
                        return -1;
                    }

                    @Override
                    public long getScrapeStartTime() {
                        return SystemTime.getCurrentTime();
                    }

                    @Override
                    public void setNextScrapeStartTime(long l) {
                    }

                    @Override
                    public long getNextScrapeStartTime() {
                        return -1L;
                    }

                    @Override
                    public String getStatus() {
                        return "Distributed Database Offline";
                    }

                    @Override
                    public URL getURL() {
                        return download.getTorrent().getAnnounceURL();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownload(Download download) {
        if (this.is_running) {
            download.removeTrackerListener(this);
            download.removeListener(this);
            try {
                this.this_mon.enter();
                this.interesting_downloads.remove(download);
                this.running_downloads.remove(download);
                this.limited_online_tracking.remove(download);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void attributeEventOccurred(Download download, TorrentAttribute torrentAttribute, int n) {
        this.checkDownloadForRegistration(download, false);
    }

    @Override
    public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
        this.checkDownloadForRegistration(downloadScrapeResult.getDownload(), false);
    }

    @Override
    public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
        this.checkDownloadForRegistration(downloadAnnounceResult.getDownload(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDownloadForRegistration(Download download, boolean bl) {
        String string;
        Object object;
        Object[] objectArray;
        int n = download.getState();
        int n2 = 1;
        Random random = new Random();
        if (n == 4 || n == 5 || download.isPaused()) {
            objectArray = download.getListAttribute(this.ta_networks);
            object = download.getTorrent();
            if (object != null && objectArray != null) {
                boolean bl2 = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].equalsIgnoreCase("Public")) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && !object.isPrivate()) {
                    if (object.isDecentralised()) {
                        n2 = 2;
                        string = "decentralised";
                    } else if (object.isDecentralisedBackupEnabled()) {
                        int n3;
                        String[] stringArray = download.getListAttribute(this.ta_peer_sources);
                        boolean bl3 = false;
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            if (!stringArray[n3].equalsIgnoreCase("DHT")) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) {
                            string = "decentralised peer source disabled";
                        } else {
                            int n4 = n3 = n == 4 || n == 5 || download.isPaused() ? 1 : 0;
                            if (n3 != 0) {
                                n2 = 3;
                            }
                            if (object.isDecentralisedBackupRequested()) {
                                n2 = 2;
                                string = "torrent requests decentralised tracking";
                            } else if (this.track_normal_when_offline.getValue()) {
                                Object object2;
                                if (n3 != 0) {
                                    object2 = download.getLastAnnounceResult();
                                    if (object2 == null || object2.getResponseType() == 2 || TorrentUtils.isDecentralised(object2.getURL())) {
                                        n2 = 2;
                                        string = "tracker unavailable (announce)";
                                    } else {
                                        string = "tracker available (announce: " + object2.getURL() + ")";
                                    }
                                } else {
                                    object2 = download.getLastScrapeResult();
                                    if (object2 == null || object2.getResponseType() == 2 || TorrentUtils.isDecentralised(object2.getURL())) {
                                        n2 = 2;
                                        string = "tracker unavailable (scrape)";
                                    } else {
                                        string = "tracker available (scrape: " + object2.getURL() + ")";
                                    }
                                }
                                if (n2 != 2 && this.track_limited_when_online.getValue()) {
                                    object2 = this.limited_online_tracking.get(download);
                                    boolean bl4 = false;
                                    if (object2 != null) {
                                        bl4 = (Boolean)object2;
                                    } else {
                                        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
                                        if (downloadScrapeResult != null && downloadScrapeResult.getResponseType() == 1) {
                                            int n5;
                                            int n6 = downloadScrapeResult.getSeedCount();
                                            int n7 = n6 + (n5 = downloadScrapeResult.getNonSeedCount());
                                            if (n7 <= 16) {
                                                bl4 = true;
                                            } else {
                                                boolean bl5 = bl4 = random.nextInt(n7) < 16;
                                            }
                                            if (bl4) {
                                                this.limited_online_tracking.put(download, new Boolean(bl4));
                                            }
                                        }
                                    }
                                    if (bl4) {
                                        n2 = 2;
                                        string = "limited online tracking";
                                    }
                                }
                            } else {
                                n2 = 2;
                                string = "peer source enabled";
                            }
                        }
                    } else {
                        string = "decentralised backup disabled for the torrent";
                    }
                } else {
                    string = "not public";
                }
            } else {
                string = "torrent is broken";
            }
            if (n2 == 3) {
                string = string.length() == 0 ? "derived" : "derived (overriding ' " + string + "')";
            }
        } else {
            string = n == 7 || n == 8 ? "not running" : (n == 9 ? "" : "");
        }
        if (string.length() > 0) {
            try {
                this.this_mon.enter();
                objectArray = this.running_downloads.get(download);
                if (n2 != 1) {
                    if (objectArray == null) {
                        this.log.log((Object)download.getTorrent(), 1, "Monitoring '" + download.getName() + "': " + string);
                        this.running_downloads.put(download, new int[]{n2, 0, 0, 0});
                        this.query_map.put(download, new Long(SystemTime.getCurrentTime()));
                    } else {
                        object = (int)objectArray[0];
                        if ((Integer)object == 3 && n2 == 2) {
                            objectArray[0] = (String)n2;
                        }
                    }
                } else if (objectArray != null) {
                    this.log.log((Object)download.getTorrent(), 1, "Not monitoring '" + download.getName() + "': " + string);
                    this.running_downloads.remove(download);
                    this.interesting_downloads.put(download, new Long(this.plugin_interface.getUtilities().getCurrentSystemTime() + 300000L));
                } else if (bl) {
                    this.log.log((Object)download.getTorrent(), 1, "Not monitoring '" + download.getName() + "': " + string);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRegistrations(boolean bl) {
        Object n6;
        ArrayList<Download> arrayList;
        int n;
        int n2;
        Object object2;
        int n3 = this.plugin_interface.getPluginconfig().getIntParameter("TCP.Listen.Port");
        String string = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
        if (!string.equals("")) {
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (n3 == 0) {
            this.log.log("TCP port=0, registration not performed");
            return;
        }
        String string2 = COConfigurationManager.getStringParameter("Override Ip", "");
        String string3 = null;
        if (string2.length() > 0) {
            object2 = new StringTokenizer(string2, ";");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                String string4;
                String string5 = ((StringTokenizer)object2).nextToken().trim();
                if (string5.length() <= 0 || (string4 = AENetworkClassifier.categoriseAddress(string5)) != "Public") continue;
                string3 = string5;
                break;
            }
        }
        if (string3 != null) {
            try {
                string3 = PRHelpers.DNSToIPAddress(string3);
            }
            catch (UnknownHostException unknownHostException) {
                this.log.log("    Can't resolve IP override '" + string3 + "'");
                string3 = null;
            }
        }
        object2 = string3 == null ? "" : string3 + ":";
        object2 = (String)object2 + n3;
        if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE) {
            object2 = (String)object2 + ";C";
        }
        if ((n2 = this.plugin_interface.getPluginconfig().getIntParameter("UDP.Listen.Port")) != (n = this.dht.getLocalAddress().getAddress().getPort())) {
            object2 = (String)object2 + ";" + n2;
        }
        putDetails putDetails2 = new putDetails((String)object2, string3, n3, n2);
        try {
            this.this_mon.enter();
            arrayList = new ArrayList<Download>(this.running_downloads.keySet());
        }
        finally {
            this.this_mon.exit();
        }
        long l = SystemTime.getCurrentTime();
        if (bl) {
            int by;
            Object download;
            Iterator<Download> iterator2 = arrayList.iterator();
            ArrayList<Object[]> iterator3 = new ArrayList<Object[]>();
            while (iterator2.hasNext()) {
                download = iterator2.next();
                by = 1;
                try {
                    this.this_mon.enter();
                    n6 = this.running_downloads.get(download);
                    if (n6 != null) {
                        by = n6[0];
                    }
                }
                finally {
                    this.this_mon.exit();
                }
                if (by == 1) continue;
                long l2 = this.getDerivedTrackMetric((Download)download);
                iterator3.add(new Object[]{download, new Long(l2)});
            }
            Collections.sort(iterator3, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] objectArray, Object[] objectArray2) {
                    long l = (Long)objectArray2[1] - (Long)objectArray[1];
                    if (l < 0L) {
                        return -1;
                    }
                    if (l > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            download = iterator3.iterator();
            by = 0;
            while (download.hasNext()) {
                n6 = (Object[])download.next();
                Download l5 = (Download)n6[0];
                long l3 = (Long)n6[1];
                if (l3 > 0L && ++by > 5) {
                    l3 = by <= 20 ? l3 * (long)(20 - by) / 15L : 0L;
                }
                if (l3 > 0L) {
                    l5.setUserData(DL_DERIVED_METRIC_KEY, new Long(l3));
                    continue;
                }
                l5.setUserData(DL_DERIVED_METRIC_KEY, null);
            }
        }
        for (Download download : arrayList) {
            int n4 = 1;
            try {
                this.this_mon.enter();
                int[] l4 = this.running_downloads.get(download);
                if (l4 != null) {
                    n4 = l4[0];
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (n4 == 1) continue;
            byte by = this.isComplete(download) ? (byte)2 : 1;
            n6 = this.registered_downloads.get(download);
            boolean bl2 = false;
            if (n6 == null) {
                this.log.log("Registering download '" + download.getName() + "' as " + (by == 2 ? "Seeding" : "Downloading"));
                n6 = new RegistrationDetails(download, n4, putDetails2, by);
                this.registered_downloads.put(download, (RegistrationDetails)n6);
                bl2 = true;
            } else {
                boolean bl3 = false;
                if (bl) {
                    bl3 = ((RegistrationDetails)n6).updateTargets(download, n4);
                }
                if (bl3 || ((RegistrationDetails)n6).getFlags() != by || !((RegistrationDetails)n6).getPutDetails().sameAs(putDetails2)) {
                    this.log.log((n6 == null ? "Registering" : "Re-registering") + " download '" + download.getName() + "' as " + (by == 2 ? "Seeding" : "Downloading"));
                    ((RegistrationDetails)n6).update(putDetails2, by);
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            try {
                this.this_mon.enter();
                this.query_map.put(download, new Long(l));
            }
            finally {
                this.this_mon.exit();
            }
            this.trackerPut(download, (RegistrationDetails)n6);
        }
        Iterator<Map.Entry<Download, RegistrationDetails>> iterator = this.registered_downloads.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl4;
            Map.Entry<Download, RegistrationDetails> entry = iterator.next();
            Download download = entry.getKey();
            try {
                this.this_mon.enter();
                bl4 = !this.running_downloads.containsKey(download);
            }
            finally {
                this.this_mon.exit();
            }
            if (!bl4) continue;
            this.log.log((Object)download.getTorrent(), 1, "Unregistering download '" + download.getName() + "'");
            iterator.remove();
            try {
                this.this_mon.enter();
                this.query_map.remove(download);
            }
            finally {
                this.this_mon.exit();
            }
            this.trackerRemove(download, entry.getValue());
        }
        for (Download download : arrayList) {
            RegistrationDetails registrationDetails;
            boolean bl5;
            Long l4;
            try {
                this.this_mon.enter();
                l4 = this.query_map.get(download);
            }
            finally {
                this.this_mon.exit();
            }
            if (l4 == null || l < l4) continue;
            int n5 = 1;
            try {
                this.this_mon.enter();
                this.query_map.remove(download);
                int[] nArray = this.running_downloads.get(download);
                if (nArray != null) {
                    n5 = nArray[0];
                }
            }
            finally {
                this.this_mon.exit();
            }
            long l5 = SystemTime.getCurrentTime();
            PeerManager peerManager = download.getPeerManager();
            boolean bl6 = bl5 = this.isActive(download) || n5 == 1;
            if (bl5) {
                this.log.log((Object)download.getTorrent(), 1, "Deferring announce for '" + download.getName() + "' as activity outstanding");
            }
            if ((registrationDetails = this.registered_downloads.get(download)) == null) {
                Debug.out("Inconsistent, registration should be non-null");
                continue;
            }
            boolean bl7 = false;
            if (peerManager != null && !bl5) {
                int n7 = peerManager.getStats().getConnectedLeechers() + peerManager.getStats().getConnectedSeeds();
                boolean bl8 = bl7 = n7 >= 30;
            }
            if (!bl5) {
                boolean bl9 = bl5 = this.trackerGet(download, registrationDetails, bl7) == 0;
            }
            if (!bl5) continue;
            try {
                this.this_mon.enter();
                if (!this.running_downloads.containsKey(download)) continue;
                this.query_map.put(download, new Long(l5 + 120000L));
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected long getDerivedTrackMetric(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return -100L;
        }
        if (torrent.getSize() < 0xA00000L) {
            return -99L;
        }
        DownloadAnnounceResult downloadAnnounceResult = download.getLastAnnounceResult();
        if (downloadAnnounceResult == null || downloadAnnounceResult.getResponseType() != 1) {
            return -98L;
        }
        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
        if (downloadScrapeResult == null || downloadScrapeResult.getResponseType() != 1) {
            return -97L;
        }
        int n = downloadScrapeResult.getNonSeedCount();
        int n2 = n;
        if (n2 >= 2000) {
            return 100L;
        }
        if (n2 <= 200) {
            return 0L;
        }
        return (n2 - 200) / 4;
    }

    protected void trackerPut(final Download download, RegistrationDetails registrationDetails) {
        final long l = SystemTime.getCurrentTime();
        trackerTarget[] trackerTargetArray = registrationDetails.getTargets(true);
        byte by = registrationDetails.getFlags();
        for (int i = 0; i < trackerTargetArray.length; ++i) {
            final trackerTarget trackerTarget2 = trackerTargetArray[i];
            String string = registrationDetails.getPutDetails().getEncoded();
            byte[] byArray = string.getBytes();
            DHTPluginValue dHTPluginValue = this.dht.getLocalValue(trackerTarget2.getHash());
            if (dHTPluginValue != null && dHTPluginValue.getFlags() == by && Arrays.equals(dHTPluginValue.getValue(), byArray)) continue;
            if (this.disable_put) {
                if (trackerTarget2.getType() != 2) continue;
                this.log.log((Object)download.getTorrent(), 1, "Registration of '" + download.getName() + "'" + trackerTarget2.getDesc() + " skipped as disabled due to use of SOCKS proxy");
                continue;
            }
            this.dht.put(trackerTarget2.getHash(), "Tracker registration of '" + download.getName() + "'" + trackerTarget2.getDesc() + " -> " + string, byArray, by, false, new DHTPluginOperationListener(){

                @Override
                public void diversified() {
                }

                @Override
                public void starts(byte[] byArray) {
                }

                @Override
                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                @Override
                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                @Override
                public void complete(byte[] byArray, boolean bl) {
                    if (trackerTarget2.getType() == 2) {
                        DHTTrackerPlugin.this.log.log((Object)download.getTorrent(), 1, "Registration of '" + download.getName() + "'" + trackerTarget2.getDesc() + " completed (elapsed=" + (SystemTime.getCurrentTime() - l) + ")");
                    }
                }
            });
        }
    }

    protected int trackerGet(final Download download, final RegistrationDetails registrationDetails, final boolean bl) {
        final long l = SystemTime.getCurrentTime();
        final Torrent torrent = download.getTorrent();
        final URL uRL = torrent.isDecentralised() ? torrent.getAnnounceURL() : DEFAULT_URL;
        trackerTarget[] trackerTargetArray = registrationDetails.getTargets(false);
        final long[] lArray = new long[]{0L};
        int n = 0;
        for (int i = 0; i < trackerTargetArray.length; ++i) {
            final trackerTarget trackerTarget2 = trackerTargetArray[i];
            if (trackerTarget2.getType() == 2 && bl) continue;
            this.increaseActive(download);
            ++n;
            this.dht.get(trackerTarget2.getHash(), "Tracker announce for '" + download.getName() + "'" + trackerTarget2.getDesc(), this.isComplete(download) ? (byte)2 : 1, 30, trackerTarget2.getType() == 2 ? 120000L : 60000L, false, false, new DHTPluginOperationListener(){
                List<String> addresses = new ArrayList<String>();
                List<Integer> ports = new ArrayList<Integer>();
                List<Integer> udp_ports = new ArrayList<Integer>();
                List<Boolean> is_seeds = new ArrayList<Boolean>();
                List<String> flags = new ArrayList<String>();
                int seed_count;
                int leecher_count;
                boolean complete;

                @Override
                public void diversified() {
                }

                @Override
                public void starts(byte[] byArray) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    13 var3_3 = this;
                    synchronized (var3_3) {
                        block14: {
                            if (this.complete) {
                                return;
                            }
                            try {
                                String string;
                                String[] stringArray = new String(dHTPluginValue.getValue()).split(";");
                                String string2 = stringArray[0].trim();
                                int n = string2.indexOf(58);
                                String string3 = null;
                                if (n == -1) {
                                    string = string2;
                                } else {
                                    string3 = string2.substring(0, n);
                                    string = string2.substring(n + 1);
                                }
                                int n2 = Integer.parseInt(string);
                                if (n2 <= 0 || n2 >= 65536) break block14;
                                String string4 = null;
                                int n3 = -1;
                                try {
                                    for (int i = 1; i < stringArray.length; ++i) {
                                        String string5 = stringArray[i].trim();
                                        if (string5.length() <= 0) continue;
                                        if (Character.isDigit(string5.charAt(0))) {
                                            n3 = Integer.parseInt(string5);
                                            if (n3 > 0 && n3 < 65536) continue;
                                            n3 = -1;
                                            continue;
                                        }
                                        string4 = string5;
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                this.addresses.add(string3 == null ? dHTPluginContact.getAddress().getAddress().getHostAddress() : string3);
                                this.ports.add(new Integer(n2));
                                this.udp_ports.add(new Integer(n3 == -1 ? dHTPluginContact.getAddress().getPort() : n3));
                                this.flags.add(string4);
                                if ((dHTPluginValue.getFlags() & 1) == 1) {
                                    ++this.leecher_count;
                                    this.is_seeds.add(new Boolean(false));
                                } else {
                                    this.is_seeds.add(new Boolean(true));
                                    ++this.seed_count;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] byArray, boolean bl5) {
                    int[] nArray;
                    Object object;
                    PeerManager peerManager;
                    int n;
                    Object object2;
                    13 var3_3 = this;
                    synchronized (var3_3) {
                        if (this.complete) {
                            return;
                        }
                        this.complete = true;
                    }
                    if (trackerTarget2.getType() == 2 || trackerTarget2.getType() == 3 && this.seed_count + this.leecher_count > 1) {
                        DHTTrackerPlugin.this.log.log((Object)download.getTorrent(), 1, "Get of '" + download.getName() + "'" + trackerTarget2.getDesc() + " completed (elapsed=" + (SystemTime.getCurrentTime() - l) + "), addresses=" + this.addresses.size() + ", seeds=" + this.seed_count + ", leechers=" + this.leecher_count);
                    }
                    DHTTrackerPlugin.this.decreaseActive(download);
                    int n2 = this.addresses.size();
                    ArrayList<1> arrayList = new ArrayList<1>();
                    int n3 = 4;
                    int n4 = DHTTrackerPlugin.this.query_map.size();
                    int n5 = Math.max(120000, n4 / n3 * 60 * 1000);
                    int n6 = bl ? 1800000 : 3600000;
                    n5 = Math.min(n5, n6);
                    DHTTrackerPlugin.this.current_announce_interval = n5;
                    final long l4 = n5 + n2 * (n6 - n5) / 30;
                    int n7 = download.getState();
                    boolean bl2 = n7 == 5;
                    try {
                        DHTTrackerPlugin.this.this_mon.enter();
                        object2 = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                        if (object2 != null) {
                            Long l2;
                            boolean bl3 = trackerTarget2.getType() == 2;
                            n = bl2 ? this.leecher_count : this.seed_count + this.leecher_count;
                            object2[1] = bl3 ? this.seed_count : Math.max((int)object2[1], this.seed_count);
                            object2[2] = bl3 ? this.leecher_count : Math.max((int)object2[2], this.leecher_count);
                            object2[3] = bl3 ? n : Math.max((int)object2[3], n);
                            long l3 = SystemTime.getCurrentTime() + l4;
                            if (l3 > lArray[0] && ((l2 = (Long)DHTTrackerPlugin.this.query_map.get(download)) == null || l2 == lArray[0])) {
                                lArray[0] = l3;
                                DHTTrackerPlugin.this.query_map.put(download, new Long(l3));
                            }
                        }
                    }
                    finally {
                        DHTTrackerPlugin.this.this_mon.exit();
                    }
                    object2 = registrationDetails.getPutDetails();
                    String string = ((putDetails)object2).getIPOverride();
                    if (string == null) {
                        string = DHTTrackerPlugin.this.dht.getLocalAddress().getAddress().getAddress().getHostAddress();
                    }
                    for (n = 0; n < this.addresses.size(); ++n) {
                        String string2;
                        if (bl2 && this.is_seeds.get(n).booleanValue() || (string2 = this.addresses.get(n)).equals(string) && this.ports.get(n).intValue() == ((putDetails)object2).getTCPPort() && this.udp_ports.get(n).intValue() == ((putDetails)object2).getUDPPort()) continue;
                        final int n8 = n;
                        arrayList.add(new DownloadAnnounceResultPeer(){

                            @Override
                            public String getSource() {
                                return "DHT";
                            }

                            @Override
                            public String getAddress() {
                                return addresses.get(n8);
                            }

                            @Override
                            public int getPort() {
                                return ports.get(n8);
                            }

                            @Override
                            public int getUDPPort() {
                                return udp_ports.get(n8);
                            }

                            @Override
                            public byte[] getPeerID() {
                                return null;
                            }

                            @Override
                            public short getProtocol() {
                                String string = flags.get(n8);
                                int n = string != null && string.indexOf("C") != -1 ? 2 : 1;
                                return (short)n;
                            }
                        });
                    }
                    if (trackerTarget2.getType() == 3 && arrayList.size() > 0 && (peerManager = download.getPeerManager()) != null) {
                        ArrayList arrayList2 = new ArrayList(arrayList);
                        Random random = new Random();
                        for (int i = 0; i < 5 && arrayList2.size() > 0; ++i) {
                            DownloadAnnounceResultPeer downloadAnnounceResultPeer = (DownloadAnnounceResultPeer)arrayList2.remove(random.nextInt(arrayList2.size()));
                            DHTTrackerPlugin.this.log.log("    Injecting derived peer " + downloadAnnounceResultPeer.getAddress() + " into " + download.getName());
                            object = new HashMap();
                            object.put(Peer.PR_PRIORITY_CONNECTION, new Boolean(true));
                            peerManager.addPeer(downloadAnnounceResultPeer.getAddress(), downloadAnnounceResultPeer.getPort(), downloadAnnounceResultPeer.getUDPPort(), downloadAnnounceResultPeer.getProtocol() == 2, (Map<Object, Object>)object);
                        }
                    }
                    if (n7 == 4 || n7 == 5) {
                        final DownloadAnnounceResultPeer[] downloadAnnounceResultPeerArray = new DownloadAnnounceResultPeer[arrayList.size()];
                        arrayList.toArray(downloadAnnounceResultPeerArray);
                        download.setAnnounceResult(new DownloadAnnounceResult(){

                            @Override
                            public Download getDownload() {
                                return download;
                            }

                            @Override
                            public int getResponseType() {
                                return 1;
                            }

                            @Override
                            public int getReportedPeerCount() {
                                return downloadAnnounceResultPeerArray.length;
                            }

                            @Override
                            public int getSeedCount() {
                                return seed_count;
                            }

                            @Override
                            public int getNonSeedCount() {
                                return leecher_count;
                            }

                            @Override
                            public String getError() {
                                return null;
                            }

                            @Override
                            public URL getURL() {
                                return uRL;
                            }

                            @Override
                            public DownloadAnnounceResultPeer[] getPeers() {
                                return downloadAnnounceResultPeerArray;
                            }

                            @Override
                            public long getTimeToWait() {
                                return l4 / 1000L;
                            }

                            @Override
                            public Map getExtensions() {
                                return null;
                            }
                        });
                    }
                    boolean bl4 = this.leecher_count > 0;
                    DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
                    if (downloadScrapeResult != null && downloadScrapeResult.getResponseType() != 2 && (nArray = (int[])DHTTrackerPlugin.this.scrape_injection_map.get(download)) != null && nArray[0] == downloadScrapeResult.getSeedCount() && nArray[1] == downloadScrapeResult.getNonSeedCount()) {
                        bl4 = true;
                    }
                    if (torrent.isDecentralised() || bl4) {
                        int n9;
                        PeerManager peerManager2 = download.getPeerManager();
                        int n10 = 0;
                        int n11 = 0;
                        if (peerManager2 != null) {
                            object = peerManager2.getPeers();
                            for (n9 = 0; n9 < ((Peer[])object).length; ++n9) {
                                Peer peer = object[n9];
                                if (peer.getPercentDoneInThousandNotation() == 1000) {
                                    ++n10;
                                    continue;
                                }
                                ++n11;
                            }
                        }
                        final int n12 = Math.max(this.seed_count, n10);
                        n9 = Math.max(this.leecher_count, n11);
                        DHTTrackerPlugin.this.scrape_injection_map.put(download, new int[]{n12, n9});
                        download.setScrapeResult(new DownloadScrapeResult(){

                            @Override
                            public Download getDownload() {
                                return download;
                            }

                            @Override
                            public int getResponseType() {
                                return 1;
                            }

                            @Override
                            public int getSeedCount() {
                                return n12;
                            }

                            @Override
                            public int getNonSeedCount() {
                                return n9;
                            }

                            @Override
                            public long getScrapeStartTime() {
                                return l;
                            }

                            @Override
                            public void setNextScrapeStartTime(long l) {
                            }

                            @Override
                            public long getNextScrapeStartTime() {
                                return SystemTime.getCurrentTime() + l4;
                            }

                            @Override
                            public String getStatus() {
                                return "OK";
                            }

                            @Override
                            public URL getURL() {
                                return uRL;
                            }
                        });
                    }
                }
            });
        }
        return n;
    }

    protected boolean isComplete(Download download) {
        PEPeerManager pEPeerManager;
        PeerManager peerManager;
        if (Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE) {
            return true;
        }
        boolean bl = download.isComplete();
        if (bl && (peerManager = download.getPeerManager()) != null && (pEPeerManager = PluginCoreUtils.unwrap(peerManager)) != null && pEPeerManager.getHiddenBytes() > 0L) {
            bl = false;
        }
        return bl;
    }

    protected void trackerRemove(final Download download, RegistrationDetails registrationDetails) {
        final long l = SystemTime.getCurrentTime();
        trackerTarget[] trackerTargetArray = registrationDetails.getTargets(true);
        for (int i = 0; i < trackerTargetArray.length; ++i) {
            final trackerTarget trackerTarget2 = trackerTargetArray[i];
            if (!this.dht.hasLocalKey(trackerTarget2.getHash())) continue;
            this.increaseActive(download);
            this.dht.remove(trackerTarget2.getHash(), "Tracker deregistration of '" + download.getName() + "' " + trackerTarget2.getDesc(), new DHTPluginOperationListener(){

                @Override
                public void diversified() {
                }

                @Override
                public void starts(byte[] byArray) {
                }

                @Override
                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                @Override
                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                @Override
                public void complete(byte[] byArray, boolean bl) {
                    if (trackerTarget2.getType() == 2) {
                        DHTTrackerPlugin.this.log.log((Object)download.getTorrent(), 1, "Unregistration of '" + download.getName() + "' " + trackerTarget2.getDesc() + " completed (elapsed=" + (SystemTime.getCurrentTime() - l) + ")");
                    }
                    DHTTrackerPlugin.this.decreaseActive(download);
                }
            });
        }
    }

    protected void trackerRemove(final Download download, final trackerTarget trackerTarget2) {
        final long l = SystemTime.getCurrentTime();
        if (this.dht.hasLocalKey(trackerTarget2.getHash())) {
            this.increaseActive(download);
            this.dht.remove(trackerTarget2.getHash(), "Tracker deregistration of '" + download.getName() + "' " + trackerTarget2.getDesc(), new DHTPluginOperationListener(){

                @Override
                public void diversified() {
                }

                @Override
                public void starts(byte[] byArray) {
                }

                @Override
                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                @Override
                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                @Override
                public void complete(byte[] byArray, boolean bl) {
                    if (trackerTarget2.getType() == 2) {
                        DHTTrackerPlugin.this.log.log((Object)download.getTorrent(), 1, "Unregistration of '" + download.getName() + "' " + trackerTarget2.getDesc() + " completed (elapsed=" + (SystemTime.getCurrentTime() - l) + ")");
                    }
                    DHTTrackerPlugin.this.decreaseActive(download);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNonRegistrations() {
        Iterator<Download> iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        long l = -1L;
        long l2 = this.plugin_interface.getUtilities().getCurrentSystemTime();
        ArrayList<Download> arrayList = new ArrayList<Download>();
        try {
            this.this_mon.enter();
            object3 = this.interesting_downloads.keySet().iterator();
            while (object3.hasNext() && object4 == null) {
                Download download = object3.next();
                object2 = download.getTorrent();
                if (object2 == null || (object = this.running_downloads.get(download)) != null && object[0] != 3) continue;
                arrayList.add(download);
            }
        }
        finally {
            this.this_mon.exit();
        }
        object3 = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (Download)arrayList.get(i);
            object3.put(object2, object2.getLastScrapeResult());
        }
        try {
            this.this_mon.enter();
            iterator = this.interesting_downloads.keySet().iterator();
            while (iterator.hasNext() && object4 == null) {
                long l3;
                DownloadScrapeResult downloadScrapeResult;
                boolean bl;
                int[] nArray;
                object2 = iterator.next();
                object = object2.getTorrent();
                if (object == null || (nArray = this.running_downloads.get(object2)) != null && nArray[0] != 3 || !(bl = object.wasCreatedByUs()) && (this.interesting_pub_max > 0 && this.interesting_published > this.interesting_pub_max || (downloadScrapeResult = (DownloadScrapeResult)object3.get(object2)) == null || downloadScrapeResult.getSeedCount() + downloadScrapeResult.getNonSeedCount() > 30)) continue;
                long l4 = this.interesting_downloads.get(object2);
                long l5 = l3 = TorrentUtils.isDecentralised(object.getAnnounceURL()) ? 3600000L : 14400000L;
                if (l4 <= l2) {
                    object4 = object2;
                    l = l2 + l3;
                    this.interesting_downloads.put((Download)object2, new Long(l));
                    continue;
                }
                if (l4 - l2 <= l3) continue;
                this.interesting_downloads.put((Download)object2, new Long(l2 + l4 % l3));
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (object4 != null) {
            iterator = object4;
            if (this.dht.isDiversified(object4.getTorrent().getHash())) {
                try {
                    this.this_mon.enter();
                    this.interesting_downloads.remove(iterator);
                }
                finally {
                    this.this_mon.exit();
                }
            } else {
                long l6 = l2;
                long l7 = l;
                this.dht.get(object4.getTorrent().getHash(), "Presence query for '" + object4.getName() + "'", (byte)0, 8, 120000L, false, false, new DHTPluginOperationListener((Download)((Object)iterator), l6, l7){
                    private boolean diversified;
                    private int leechers = 0;
                    private int seeds = 0;
                    final /* synthetic */ Download val$f_ready_download;
                    final /* synthetic */ long val$start;
                    final /* synthetic */ long val$f_next_check;
                    {
                        this.val$f_ready_download = download;
                        this.val$start = l;
                        this.val$f_next_check = l2;
                    }

                    @Override
                    public void diversified() {
                        this.diversified = true;
                    }

                    @Override
                    public void starts(byte[] byArray) {
                    }

                    @Override
                    public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                        if ((dHTPluginValue.getFlags() & 1) == 1) {
                            ++this.leechers;
                        } else {
                            ++this.seeds;
                        }
                    }

                    @Override
                    public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void complete(byte[] byArray, boolean bl) {
                        int n = this.leechers + this.seeds;
                        DHTTrackerPlugin.this.log.log((Object)this.val$f_ready_download.getTorrent(), 1, "Presence query for '" + this.val$f_ready_download.getName() + "': availability=" + (n == 8 ? "8+" : n + "") + ",div=" + this.diversified + " (elapsed=" + (SystemTime.getCurrentTime() - this.val$start) + ")");
                        if (this.diversified) {
                            try {
                                DHTTrackerPlugin.this.this_mon.enter();
                                DHTTrackerPlugin.this.interesting_downloads.remove(this.val$f_ready_download);
                            }
                            finally {
                                DHTTrackerPlugin.this.this_mon.exit();
                            }
                        }
                        if (n < 8) {
                            try {
                                DHTTrackerPlugin.this.this_mon.enter();
                                DHTTrackerPlugin.this.interesting_downloads.remove(this.val$f_ready_download);
                            }
                            finally {
                                DHTTrackerPlugin.this.this_mon.exit();
                            }
                            DHTTrackerPlugin.this.interesting_published++;
                            if (!DHTTrackerPlugin.this.disable_put) {
                                DHTTrackerPlugin.this.dht.put(this.val$f_ready_download.getTorrent().getHash(), "Presence store '" + this.val$f_ready_download.getName() + "'", "0".getBytes(), (byte)0, new DHTPluginOperationListener(){

                                    @Override
                                    public void diversified() {
                                    }

                                    @Override
                                    public void starts(byte[] byArray) {
                                    }

                                    @Override
                                    public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                                    }

                                    @Override
                                    public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                                    }

                                    @Override
                                    public void complete(byte[] byArray, boolean bl) {
                                    }
                                });
                            }
                        }
                        try {
                            DHTTrackerPlugin.this.this_mon.enter();
                            int[] nArray = (int[])DHTTrackerPlugin.this.running_downloads.get(this.val$f_ready_download);
                            if (nArray != null) {
                                nArray[1] = this.seeds;
                                nArray[2] = this.leechers;
                            }
                        }
                        finally {
                            DHTTrackerPlugin.this.this_mon.exit();
                        }
                        this.val$f_ready_download.setScrapeResult(new DownloadScrapeResult(){

                            @Override
                            public Download getDownload() {
                                return null;
                            }

                            @Override
                            public int getResponseType() {
                                return 1;
                            }

                            @Override
                            public int getSeedCount() {
                                return seeds;
                            }

                            @Override
                            public int getNonSeedCount() {
                                return leechers;
                            }

                            @Override
                            public long getScrapeStartTime() {
                                return SystemTime.getCurrentTime();
                            }

                            @Override
                            public void setNextScrapeStartTime(long l) {
                            }

                            @Override
                            public long getNextScrapeStartTime() {
                                return val$f_next_check;
                            }

                            @Override
                            public String getStatus() {
                                return "OK";
                            }

                            @Override
                            public URL getURL() {
                                return val$f_ready_download.getTorrent().getAnnounceURL();
                            }
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(Download download, int n, int n2) {
        int n3 = download.getState();
        try {
            this.this_mon.enter();
            if ((n3 == 4 || n3 == 5 || n3 == 9) && this.running_downloads.containsKey(download)) {
                this.query_map.put(download, new Long(SystemTime.getCurrentTime()));
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (!download.isPaused()) {
            this.checkDownloadForRegistration(download, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceAll() {
        this.log.log("Announce-all requested");
        Long l = new Long(SystemTime.getCurrentTime());
        try {
            this.this_mon.enter();
            for (Map.Entry<Download, Long> entry : this.query_map.entrySet()) {
                entry.setValue(l);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void positionChanged(Download download, int n, int n2) {
    }

    protected void configChanged() {
        Download[] downloadArray = this.plugin_interface.getDownloadManager().getDownloads();
        for (int i = 0; i < downloadArray.length; ++i) {
            this.checkDownloadForRegistration(downloadArray[i], false);
        }
    }

    public DownloadScrapeResult scrape(byte[] byArray) {
        final int[] nArray = new int[]{0};
        final int[] nArray2 = new int[]{0};
        final AESemaphore aESemaphore = new AESemaphore("DHTTrackerPlugin:scrape");
        this.dht.get(byArray, "Scrape for '" + ByteFormatter.nicePrint(byArray) + "'", (byte)1, 30, 30000L, false, false, new DHTPluginOperationListener(){

            @Override
            public void diversified() {
            }

            @Override
            public void starts(byte[] byArray) {
            }

            @Override
            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                if ((dHTPluginValue.getFlags() & 1) == 1) {
                    nArray2[0] = nArray2[0] + 1;
                } else {
                    nArray[0] = nArray[0] + 1;
                }
            }

            @Override
            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            }

            @Override
            public void complete(byte[] byArray, boolean bl) {
                aESemaphore.release();
            }
        });
        aESemaphore.reserve();
        return new DownloadScrapeResult(){

            @Override
            public Download getDownload() {
                return null;
            }

            @Override
            public int getResponseType() {
                return 1;
            }

            @Override
            public int getSeedCount() {
                return nArray[0];
            }

            @Override
            public int getNonSeedCount() {
                return nArray2[0];
            }

            @Override
            public long getScrapeStartTime() {
                return 0L;
            }

            @Override
            public void setNextScrapeStartTime(long l) {
            }

            @Override
            public long getNextScrapeStartTime() {
                return 0L;
            }

            @Override
            public String getStatus() {
                return "OK";
            }

            @Override
            public URL getURL() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseActive(Download download) {
        try {
            this.this_mon.enter();
            Integer n = this.in_progress.get(download);
            int n2 = n == null ? 0 : n;
            this.in_progress.put(download, new Integer(n2 + 1));
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseActive(Download download) {
        try {
            this.this_mon.enter();
            Integer n = this.in_progress.get(download);
            if (n == null) {
                Debug.out("active count inconsistent");
            } else {
                int n2 = n - 1;
                if (n2 == 0) {
                    this.in_progress.remove(download);
                } else {
                    this.in_progress.put(download, new Integer(n2));
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(Download download) {
        try {
            this.this_mon.enter();
            boolean bl = this.in_progress.get(download) != null;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected DHTNetworkPosition[] getNetworkPositions() {
        DHTNetworkPosition[] dHTNetworkPositionArray = this.current_network_positions;
        long l = SystemTime.getMonotonousTime();
        if (dHTNetworkPositionArray == null || l - this.last_net_pos_time > 1800000L) {
            this.current_network_positions = DHTNetworkPositionManager.getLocalPositions();
            dHTNetworkPositionArray = this.current_network_positions;
            this.last_net_pos_time = l;
        }
        return dHTNetworkPositionArray;
    }

    public TrackerPeerSource getTrackerPeerSource(final Download download) {
        return new TrackerPeerSourceAdapter(){
            private long last_fixup;
            private boolean updating;
            private int status = 0;
            private long next_time = -1L;
            private int[] run_data;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fixup() {
                long l = SystemTime.getMonotonousTime();
                if (l - this.last_fixup > 5000L) {
                    Object object;
                    try {
                        DHTTrackerPlugin.this.this_mon.enter();
                        this.updating = false;
                        this.next_time = -1L;
                        this.run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                        if (this.run_data != null) {
                            if (DHTTrackerPlugin.this.in_progress.containsKey(download)) {
                                this.updating = true;
                            }
                            this.status = DHTTrackerPlugin.this.initialised_sem.isReleasedForever() ? 5 : 2;
                            object = (Long)DHTTrackerPlugin.this.query_map.get(download);
                            if (object != null) {
                                this.next_time = (Long)object;
                            }
                        } else {
                            this.status = DHTTrackerPlugin.this.interesting_downloads.containsKey(download) ? 2 : 1;
                        }
                    }
                    finally {
                        DHTTrackerPlugin.this.this_mon.exit();
                    }
                    object = download.getListAttribute(DHTTrackerPlugin.this.ta_peer_sources);
                    boolean bl = false;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (!((String)object[i]).equalsIgnoreCase("DHT")) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.status = 1;
                    }
                    this.last_fixup = l;
                }
            }

            @Override
            public int getType() {
                return 3;
            }

            @Override
            public String getName() {
                return "DHT: " + DHTTrackerPlugin.this.model.getStatus().getText();
            }

            @Override
            public int getStatus() {
                this.fixup();
                return this.status;
            }

            @Override
            public int getSeedCount() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[1];
            }

            @Override
            public int getLeecherCount() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[2];
            }

            @Override
            public int getPeers() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[3];
            }

            @Override
            public int getSecondsToUpdate() {
                this.fixup();
                if (this.next_time < 0L) {
                    return -1;
                }
                return (int)((this.next_time - SystemTime.getCurrentTime()) / 1000L);
            }

            @Override
            public int getInterval() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return (int)(DHTTrackerPlugin.this.current_announce_interval / 1000L);
            }

            @Override
            public int getMinInterval() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return 120;
            }

            @Override
            public boolean isUpdating() {
                return this.updating;
            }
        };
    }

    public static List<Object[]> getVivaldiTargets(byte[] byArray, double[] dArray) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + (i == 0 ? "" : ",") + dArray[i];
        }
        TriangleSlicer triangleSlicer = new TriangleSlicer(25);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        int[] nArray = triangleSlicer.findVertices(d, d2);
        int[] nArray2 = triangleSlicer.findVertices(d3, d4);
        for (int i = 0; i < nArray.length; i += 2) {
            int n = nArray[i];
            int n2 = nArray[i + 1];
            double d5 = DHTTrackerPlugin.getDistance(d, d2, n, n2);
            for (int j = 0; j < nArray2.length; j += 2) {
                int n3 = nArray2[j];
                int n4 = nArray2[j + 1];
                double d6 = DHTTrackerPlugin.getDistance(d3, d4, n3, n4);
                double d7 = DHTTrackerPlugin.getDistance(d5, 0.0, 0.0, d6);
                String string2 = "azderived:vivaldi:";
                String string3 = n + "." + n2 + "." + n3 + "." + n4;
                string2 = string2 + string3;
                try {
                    byte[] byArray2 = string2.getBytes("UTF-8");
                    byte[] byArray3 = new byte[byArray.length + byArray2.length];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                    arrayList.add(new Object[]{new Integer((int)d7), new trackerTarget(byArray3, 3, "Vivaldi: " + string3)});
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        Collections.sort(arrayList, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] objectArray, Object[] objectArray2) {
                int n = (Integer)objectArray[0];
                int n2 = (Integer)objectArray2[0];
                return n - n2;
            }
        });
        return arrayList;
    }

    protected static double getDistance(double d, double d2, double d3, double d4) {
        return Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
    }

    static {
        try {
            DEFAULT_URL = new URL("dht:");
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public static class TriangleSlicer {
        int width;
        private double w;
        private double w2;
        private double h;
        private double tan60;

        public TriangleSlicer(int n) {
            this.width = n;
            this.w = n;
            this.w2 = this.w / 2.0;
            this.h = Math.cos(0.5235987755982988) * this.w;
            this.tan60 = Math.tan(1.0471975511965976);
        }

        public int[] findVertices(double d, double d2) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            boolean bl;
            int n = (int)Math.floor(d2 / this.h);
            int n2 = (int)Math.floor(d / this.w2);
            if ((n2 + n) % 2 == 0) {
                if (d2 - this.h * (double)n > (d - this.w2 * (double)n2) * this.tan60) {
                    bl = false;
                    d8 = this.w2 * (double)(n2 - 1);
                    d7 = this.h * (double)(n + 1);
                } else {
                    bl = true;
                    d8 = this.w2 * (double)n2;
                    d7 = this.h * (double)n;
                }
            } else if (d2 - this.h * (double)n > (this.w2 - (d - this.w2 * (double)n2)) * this.tan60) {
                bl = false;
                d8 = this.w2 * (double)n2;
                d7 = this.h * (double)(n + 1);
            } else {
                bl = true;
                d8 = this.w2 * (double)(n2 - 1);
                d7 = this.h * (double)n;
            }
            if (bl) {
                d6 = d8 + this.w;
                d5 = d7;
                d4 = d8 + this.w2;
                d3 = d7 + this.h;
            } else {
                d6 = d8 + this.w;
                d5 = d7;
                d4 = d8 + this.w2;
                d3 = d7 - this.h;
            }
            int[] nArray = new int[]{(int)d8, (int)d7, (int)d6, (int)d5, (int)d4, (int)d3};
            return nArray;
        }
    }

    public static class trackerTarget {
        private String desc;
        private byte[] hash;
        private int type;

        protected trackerTarget(byte[] byArray, int n, String string) {
            this.hash = byArray;
            this.type = n;
            this.desc = string;
        }

        public int getType() {
            return this.type;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public String getDesc() {
            if (this.type != 2) {
                return " (" + this.desc + ")";
            }
            return "";
        }
    }

    protected static class putDetails {
        private String encoded;
        private String ip_override;
        private int tcp_port;
        private int udp_port;

        private putDetails(String string, String string2, int n, int n2) {
            this.encoded = string;
            this.ip_override = string2;
            this.tcp_port = n;
            this.udp_port = n2;
        }

        protected String getEncoded() {
            return this.encoded;
        }

        protected String getIPOverride() {
            return this.ip_override;
        }

        protected int getTCPPort() {
            return this.tcp_port;
        }

        protected int getUDPPort() {
            return this.udp_port;
        }

        protected boolean sameAs(putDetails putDetails2) {
            return this.getEncoded().equals(putDetails2.getEncoded());
        }
    }

    protected class RegistrationDetails {
        private static final int DERIVED_ACTIVE_MIN_MILLIS = 0x6DDD00;
        private putDetails put_details;
        private byte flags;
        private trackerTarget[] put_targets;
        private List<trackerTarget> not_put_targets;
        private long derived_active_start = -1L;
        private long previous_metric;

        protected RegistrationDetails(Download download, int n, putDetails putDetails2, byte by) {
            this.put_details = putDetails2;
            this.flags = by;
            this.getTrackerTargets(download, n);
        }

        protected void update(putDetails putDetails2, byte by) {
            this.put_details = putDetails2;
            this.flags = by;
        }

        protected boolean updateTargets(Download download, int n) {
            int n2;
            byte[] byArray;
            int n3;
            int n4;
            trackerTarget[] trackerTargetArray = this.put_targets;
            this.getTrackerTargets(download, n);
            for (n4 = 0; n4 < trackerTargetArray.length; ++n4) {
                n3 = 0;
                byArray = trackerTargetArray[n4].getHash();
                for (n2 = 0; n2 < this.put_targets.length; ++n2) {
                    if (!Arrays.equals(this.put_targets[n2].getHash(), byArray)) continue;
                    n3 = 1;
                    break;
                }
                if (n3 != 0) continue;
                DHTTrackerPlugin.this.trackerRemove(download, trackerTargetArray[n4]);
            }
            n4 = 0;
            for (n3 = 0; n3 < this.put_targets.length; ++n3) {
                byArray = this.put_targets[n3].getHash();
                n2 = 0;
                for (int i = 0; i < trackerTargetArray.length; ++i) {
                    if (!Arrays.equals(trackerTargetArray[i].getHash(), byArray)) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) continue;
                n4 = 1;
            }
            return n4 != 0;
        }

        protected putDetails getPutDetails() {
            return this.put_details;
        }

        protected byte getFlags() {
            return this.flags;
        }

        protected trackerTarget[] getTargets(boolean bl) {
            if (bl || this.not_put_targets == null) {
                return this.put_targets;
            }
            ArrayList<trackerTarget> arrayList = new ArrayList<trackerTarget>(Arrays.asList(this.put_targets));
            for (int i = 0; i < this.not_put_targets.size() && i < 2; ++i) {
                trackerTarget trackerTarget2 = this.not_put_targets.remove(0);
                this.not_put_targets.add(trackerTarget2);
                arrayList.add(trackerTarget2);
            }
            return arrayList.toArray(new trackerTarget[arrayList.size()]);
        }

        protected void getTrackerTargets(Download download, int n) {
            Object object;
            byte[] byArray = download.getTorrent().getHash();
            ArrayList<trackerTarget> arrayList = new ArrayList<trackerTarget>();
            if (n == 2) {
                arrayList.add(new trackerTarget(byArray, 2, ""));
            }
            if (ADD_ASN_DERIVED_TARGET) {
                NetworkAdminASN networkAdminASN = NetworkAdmin.getSingleton().getCurrentASN();
                String string = networkAdminASN.getAS();
                String string2 = networkAdminASN.getASName();
                if (string.length() > 0 && string2.length() > 0) {
                    object = "azderived:asn:" + string;
                    try {
                        byte[] byArray2 = ((String)object).getBytes("UTF-8");
                        byte[] byArray3 = new byte[byArray.length + byArray2.length];
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                        arrayList.add(new trackerTarget(byArray3, 3, string2 + "/" + string));
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            if (ADD_NETPOS_DERIVED_TARGETS) {
                boolean bl;
                boolean bl2;
                long l = SystemTime.getMonotonousTime();
                object = (Long)download.getUserData(DL_DERIVED_METRIC_KEY);
                boolean bl3 = bl2 = object != null;
                if (this.derived_active_start >= 0L && l - this.derived_active_start <= 0x6DDD00L) {
                    bl = true;
                    if (object == null) {
                        object = new Long(this.previous_metric);
                    }
                } else if (bl2) {
                    bl = true;
                } else {
                    this.derived_active_start = -1L;
                    bl = false;
                }
                boolean bl4 = false;
                if (bl2) {
                    bl4 = this.derived_active_start == -1L;
                    this.derived_active_start = l;
                }
                ArrayList<trackerTarget> arrayList2 = null;
                if (bl) {
                    this.previous_metric = (Long)object;
                    try {
                        DHTNetworkPosition[] dHTNetworkPositionArray = DHTTrackerPlugin.this.getNetworkPositions();
                        for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
                            DHTNetworkPosition dHTNetworkPosition = dHTNetworkPositionArray[i];
                            if (dHTNetworkPosition.getPositionType() != 5 || !dHTNetworkPosition.isValid()) continue;
                            List<Object[]> list = DHTTrackerPlugin.getVivaldiTargets(byArray, dHTNetworkPosition.getLocation());
                            int n2 = ((Long)object).intValue() * list.size() / 100;
                            for (int j = 0; j < list.size(); ++j) {
                                Object[] objectArray = list.get(j);
                                trackerTarget trackerTarget2 = (trackerTarget)objectArray[1];
                                if (j < n2) {
                                    arrayList.add(trackerTarget2);
                                    continue;
                                }
                                if (arrayList2 == null) {
                                    arrayList2 = new ArrayList<trackerTarget>();
                                }
                                arrayList2.add(trackerTarget2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                this.not_put_targets = arrayList2;
            }
            this.put_targets = arrayList.toArray(new trackerTarget[arrayList.size()]);
        }
    }
}

