/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.console;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.Debug;

public class MakeTorrent
implements TOTorrentProgressListener {
    private boolean verbose;
    private static final String[] validKeys = new String[]{"comment", "announce-list", "target", "force_piece_size_pow2", "verbose"};

    @Override
    public void reportCurrentTask(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    @Override
    public void reportProgress(int n) {
        if (this.verbose) {
            System.out.print("\r" + n + "%    ");
        }
    }

    public MakeTorrent(String string, URL uRL, Map map) {
        String string2;
        Object object;
        File file = new File(string);
        String string3 = (String)map.get("target");
        if (string3 == null) {
            string3 = string + ".torrent";
        }
        File file2 = new File(string3);
        if (map.get("verbose") != null) {
            this.verbose = true;
        }
        TOTorrent tOTorrent = null;
        String string4 = (String)map.get("force_piece_size_pow2");
        if (string4 != null) {
            try {
                long l = 1L << Integer.parseInt(string4);
                object = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, uRL, l);
                object.addListener(this);
                tOTorrent = object.create();
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                return;
            }
        }
        try {
            TOTorrentCreator tOTorrentCreator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, uRL);
            tOTorrentCreator.addListener(this);
            tOTorrent = tOTorrentCreator.create();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return;
        }
        String string5 = (String)map.get("comment");
        if (string5 != null) {
            tOTorrent.setComment(string5);
        }
        if ((string2 = (String)map.get("announce-list")) != null) {
            object = new StringTokenizer(string2, "|");
            ArrayList arrayList = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string6 = ((StringTokenizer)object).nextToken();
                arrayList2.add(string6);
            }
            arrayList.add(arrayList2);
            tOTorrent.setAdditionalListProperty("announce-list", arrayList);
        }
        try {
            tOTorrent.serialiseToBEncodedFile(file2);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            MakeTorrent.usage();
            SESecurityManager.exitVM(0);
        }
        HashMap hashMap = new HashMap();
        for (int i = 2; i < stringArray.length; ++i) {
            boolean bl = MakeTorrent.parseParameter(stringArray[i], hashMap);
            if (bl) continue;
            SESecurityManager.exitVM(-1);
        }
        File file = new File(stringArray[1]);
        if (!file.exists()) {
            System.out.println(stringArray[1] + " is not a valid file / directory");
            SESecurityManager.exitVM(-1);
        }
        URL uRL = null;
        try {
            uRL = new URL(stringArray[0]);
        }
        catch (Exception exception) {
            System.out.println(stringArray[0] + " is not a valid url");
            SESecurityManager.exitVM(-1);
        }
        new MakeTorrent(stringArray[1], uRL, hashMap);
    }

    public static void usage() {
        System.out.println("Usage :");
        System.out.println("MakeTorrent <trackerurl> <file|dir> [options]");
        System.out.println("Options :");
        System.out.println("--comment=<comment>            Adds a comment to the torrent");
        System.out.println("--force_piece_size_pow2=<pow2> Specifies the piece size to use");
        System.out.println("--target=<target file>         Specifies a target torrent file");
        System.out.println("--verbose                      Verbose");
        System.out.println("--announce-list=url1[|url2|...] Use a list of trackers");
    }

    public static boolean parseParameter(String string, Map map) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("--v") || string.equalsIgnoreCase("--verbose")) {
            map.put("verbose", new Integer(1));
        }
        if (string.startsWith("--")) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(2), "=");
                String string2 = stringTokenizer.nextToken();
                String string3 = "";
                String string4 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + string4 + stringTokenizer.nextElement();
                    string4 = "=";
                }
                boolean bl = false;
                for (int i = 0; i < validKeys.length; ++i) {
                    if (!validKeys[i].equalsIgnoreCase(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    System.out.println("Invalid parameter : " + string2);
                    return false;
                }
                map.put(string2, string3);
                return true;
            }
            catch (Exception exception) {
                System.out.println("Cannot parse " + string);
                return false;
            }
        }
        System.out.println("Cannot parse " + string);
        return false;
    }
}

