/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.selectedcontent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.util.PlayUtils;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class SelectedContentV3
implements ISelectedContent {
    private final SelectedContent content;
    private boolean isPlatformContent;
    private boolean canPlay;
    private String thumbURL;
    private byte[] imageBytes;
    private DownloadUrlInfo downloadInfo;

    public SelectedContentV3(SelectedContent selectedContent) {
        this.content = selectedContent;
        this.setDownloadManager(selectedContent.getDownloadManager());
    }

    public SelectedContentV3() {
        this.content = new SelectedContent();
    }

    public SelectedContentV3(String string, String string2, boolean bl, boolean bl2) {
        this.isPlatformContent = bl;
        this.canPlay = bl2;
        this.content = new SelectedContent(string, string2);
    }

    public SelectedContentV3(DownloadManager downloadManager) throws Exception {
        this.content = new SelectedContent();
        this.setDownloadManager(downloadManager);
    }

    @Override
    public String getDisplayName() {
        return this.content.getDisplayName();
    }

    @Override
    public DownloadManager getDownloadManager() {
        return this.content.getDownloadManager();
    }

    @Override
    public int getFileIndex() {
        return this.content.getFileIndex();
    }

    @Override
    public TOTorrent getTorrent() {
        return this.content.getTorrent();
    }

    @Override
    public String getHash() {
        return this.content.getHash();
    }

    @Override
    public void setDisplayName(String string) {
        this.content.setDisplayName(string);
    }

    @Override
    public void setDownloadManager(DownloadManager downloadManager) {
        this.content.setDownloadManager(downloadManager);
        if (downloadManager != null) {
            this.setTorrent(downloadManager.getTorrent());
            this.setDisplayName(PlatformTorrentUtils.getContentTitle2(downloadManager));
        }
    }

    @Override
    public void setTorrent(TOTorrent tOTorrent) {
        this.content.setTorrent(tOTorrent);
        if (tOTorrent != null) {
            try {
                this.setHash(tOTorrent.getHashWrapper().toBase32String());
            }
            catch (Exception exception) {
                this.setHash(null);
            }
            this.setPlatformContent(PlatformTorrentUtils.isContent(tOTorrent, true));
            this.setDisplayName(PlatformTorrentUtils.getContentTitle(tOTorrent));
            this.setCanPlay(PlayUtils.canUseEMP(tOTorrent, -1));
            this.setImageBytes(PlatformTorrentUtils.getContentThumbnail(tOTorrent));
        }
    }

    @Override
    public void setHash(String string) {
        this.content.setHash(string);
    }

    public void setHash(String string, boolean bl) {
        this.content.setHash(string);
        this.setPlatformContent(bl);
    }

    public boolean isPlatformContent() {
        return this.isPlatformContent;
    }

    public void setPlatformContent(boolean bl) {
        this.isPlatformContent = bl;
    }

    public boolean canPlay() {
        return this.canPlay;
    }

    public void setCanPlay(boolean bl) {
        this.canPlay = bl;
    }

    public String getThumbURL() {
        return this.thumbURL;
    }

    public void setThumbURL(String string) {
        this.thumbURL = string;
    }

    public void setImageBytes(byte[] byArray) {
        this.imageBytes = byArray;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    @Override
    public DownloadUrlInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    @Override
    public void setDownloadInfo(DownloadUrlInfo downloadUrlInfo) {
        this.downloadInfo = downloadUrlInfo;
    }
}

