/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.upnp.impl;

import com.aelitis.net.natpmp.NatPMPDevice;
import com.aelitis.net.natpmp.upnp.impl.NatPMPImpl;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.UPnPStateVariable;
import com.aelitis.net.upnp.services.UPnPSpecificService;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionListener;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ThreadPool;

public class NatPMPUPnPRootDeviceImpl
implements UPnPRootDevice {
    private UPnP upnp;
    private NatPMPDevice nat_device;
    private String USN = "natpmp";
    private URL location;
    private UPnPDevice device;
    private UPnPService[] services;
    private ThreadPool thread_pool;

    public NatPMPUPnPRootDeviceImpl(UPnP uPnP, NatPMPDevice natPMPDevice) throws Exception {
        this.upnp = uPnP;
        this.nat_device = natPMPDevice;
        this.location = new URL("http://undefined/");
        this.device = new NatPMPUPnPDevice();
        this.services = new UPnPService[]{new NatPMPUPnPWANConnection()};
        this.thread_pool = new ThreadPool("NatPMPUPnP", 1, true);
    }

    @Override
    public UPnP getUPnP() {
        return this.upnp;
    }

    @Override
    public String getUSN() {
        return this.USN;
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.nat_device.getLocalAddress();
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return this.nat_device.getNetworkInterface();
    }

    @Override
    public String getInfo() {
        return "Nat-PMP";
    }

    @Override
    public UPnPDevice getDevice() {
        return this.device;
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    @Override
    public Map getDiscoveryCache() {
        return null;
    }

    @Override
    public void addListener(UPnPRootDeviceListener uPnPRootDeviceListener) {
    }

    @Override
    public void removeListener(UPnPRootDeviceListener uPnPRootDeviceListener) {
    }

    protected class NatPMPUPnPWANConnection
    implements UPnPWANConnection,
    UPnPService {
        private NatPMPImpl nat_impl;

        protected NatPMPUPnPWANConnection() throws UPnPException {
            this.nat_impl = new NatPMPImpl(NatPMPUPnPRootDeviceImpl.this.nat_device);
        }

        @Override
        public UPnPDevice getDevice() {
            return NatPMPUPnPRootDeviceImpl.this.device;
        }

        @Override
        public String getServiceType() {
            return "urn:schemas-upnp-org:service:WANIPConnection:1";
        }

        @Override
        public String getConnectionType() {
            return "IP";
        }

        @Override
        public URL getControlURL() throws UPnPException {
            return null;
        }

        @Override
        public boolean isConnectable() {
            return true;
        }

        @Override
        public UPnPAction[] getActions() throws UPnPException {
            return new UPnPAction[0];
        }

        @Override
        public UPnPAction getAction(String string) throws UPnPException {
            return null;
        }

        @Override
        public UPnPStateVariable[] getStateVariables() throws UPnPException {
            return new UPnPStateVariable[0];
        }

        @Override
        public UPnPStateVariable getStateVariable(String string) throws UPnPException {
            return null;
        }

        @Override
        public UPnPSpecificService getSpecificService() {
            return this;
        }

        @Override
        public UPnPService getGenericService() {
            return this;
        }

        @Override
        public boolean getDirectInvocations() {
            return true;
        }

        @Override
        public void setDirectInvocations(boolean bl) {
        }

        @Override
        public void addPortMapping(final boolean bl, final int n, final String string) throws UPnPException {
            NatPMPUPnPRootDeviceImpl.this.thread_pool.run(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        NatPMPUPnPWANConnection.this.nat_impl.addPortMapping(bl, n, string);
                    }
                    catch (UPnPException uPnPException) {
                        uPnPException.printStackTrace();
                    }
                }
            });
        }

        @Override
        public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
            return this.nat_impl.getPortMappings();
        }

        @Override
        public void deletePortMapping(final boolean bl, final int n) throws UPnPException {
            NatPMPUPnPRootDeviceImpl.this.thread_pool.run(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        NatPMPUPnPWANConnection.this.nat_impl.deletePortMapping(bl, n);
                    }
                    catch (UPnPException uPnPException) {
                        uPnPException.printStackTrace();
                    }
                }
            });
        }

        @Override
        public String[] getStatusInfo() throws UPnPException {
            return this.nat_impl.getStatusInfo();
        }

        @Override
        public String getExternalIPAddress() throws UPnPException {
            return this.nat_impl.getExternalIPAddress();
        }

        @Override
        public void periodicallyRecheckMappings(boolean bl) {
        }

        @Override
        public int getCapabilities() {
            return -1;
        }

        @Override
        public void addListener(UPnPWANConnectionListener uPnPWANConnectionListener) {
        }

        @Override
        public void removeListener(UPnPWANConnectionListener uPnPWANConnectionListener) {
        }
    }

    protected class NatPMPUPnPDevice
    implements UPnPDevice {
        protected NatPMPUPnPDevice() {
        }

        @Override
        public String getDeviceType() {
            return "NatPMP";
        }

        @Override
        public String getFriendlyName() {
            return "NatPMP";
        }

        @Override
        public String getManufacturer() {
            return "";
        }

        @Override
        public String getManufacturerURL() {
            return "";
        }

        @Override
        public String getModelDescription() {
            return "";
        }

        @Override
        public String getModelName() {
            return "";
        }

        @Override
        public String getModelNumber() {
            return "";
        }

        @Override
        public String getModelURL() {
            return "";
        }

        @Override
        public String getPresentation() {
            return "";
        }

        @Override
        public UPnPDevice[] getSubDevices() {
            return new UPnPDevice[0];
        }

        @Override
        public UPnPService[] getServices() {
            return NatPMPUPnPRootDeviceImpl.this.services;
        }

        @Override
        public UPnPRootDevice getRootDevice() {
            return NatPMPUPnPRootDeviceImpl.this;
        }
    }
}

