/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerAllocationScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoSetImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper {
    private static final int DM_FREE_PIECELIST_TIMEOUT = 120000;
    private static final LogIDs LOGID = LogIDs.DISK;
    private static DiskAccessController disk_access_controller;
    private static boolean reorder_storage_mode;
    private static int reorder_storage_mode_min_mb;
    private static DiskManagerRecheckScheduler recheck_scheduler;
    private static DiskManagerAllocationScheduler allocation_scheduler;
    private static ThreadPool start_pool;
    private boolean used = false;
    private boolean started = false;
    private AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private boolean stopping;
    private int state_set_via_method;
    protected String errorMessage = "";
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceMap piece_map_use_accessor;
    private long piece_map_use_accessor_time;
    private DiskManagerFileInfoImpl[] files;
    private DiskManagerFileInfoSet fileset;
    protected DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private boolean checking_enabled = true;
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_PRIOCHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_ACCESS_MODE_CHANGED = 4;
    protected static ListenerManager<DiskManagerListener> listeners_aggregator;
    private ListenerManager<DiskManagerListener> listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

        @Override
        public void dispatch(DiskManagerListener diskManagerListener, int n, Object object) {
            listeners_aggregator.dispatch(diskManagerListener, n, object);
        }
    });
    private AEMonitor start_stop_mon = new AEMonitor("DiskManager:startStop");
    private AEMonitor file_piece_mon = new AEMonitor("DiskManager:filePiece");

    public static DiskAccessController getDefaultDiskAccessController() {
        return disk_access_controller;
    }

    public DiskManagerImpl(TOTorrent tOTorrent, DownloadManager downloadManager) {
        this.torrent = tOTorrent;
        this.download_manager = downloadManager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        if (this.torrent == null) {
            this.errorMessage = "Torrent not available";
            this.setState(10);
            return;
        }
        LocaleUtilDecoder localeUtilDecoder = null;
        try {
            localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            this.errorMessage = TorrentUtils.exceptionToText(tOTorrentException);
            this.setState(10);
            return;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.errorMessage = "Initialisation failed - " + Debug.getNestedExceptionMessage(throwable);
            this.setState(10);
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(localeUtilDecoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.errorMessage = "Failed to build piece map - " + Debug.getNestedExceptionMessage(throwable);
            this.setState(10);
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        for (int i = 0; i < this.nbPieces; ++i) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i, i == this.nbPieces - 1 ? this.lastPieceLength : this.pieceLength);
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                return;
            }
            this.started = true;
            this.starting = true;
            start_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    boolean bl;
                    try {
                        try {
                            DiskManagerImpl.this.start_stop_mon.enter();
                            if (DiskManagerImpl.this.stopping) {
                                throw new Exception("Stopped during startup");
                            }
                        }
                        finally {
                            DiskManagerImpl.this.start_stop_mon.exit();
                        }
                        DiskManagerImpl.this.startSupport();
                    }
                    catch (Throwable throwable) {
                        DiskManagerImpl.this.errorMessage = Debug.getNestedExceptionMessage(throwable) + " (start)";
                        Debug.printStackTrace(throwable);
                        DiskManagerImpl.this.setState(10);
                    }
                    finally {
                        DiskManagerImpl.this.started_sem.release();
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        bl = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                    }
                    finally {
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    if (bl) {
                        DiskManagerImpl.this.stop(false);
                    }
                }
            });
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void startSupport() {
        Object object;
        boolean bl = false;
        if (this.download_manager.isPersistent()) {
            object = DownloadManagerMoveHandler.getRelatedDirs(this.download_manager);
            for (int i = 0; i < ((File[])object).length; ++i) {
                String string = object[i].getAbsolutePath();
                if (!this.filesExist(string)) continue;
                bl = true;
                this.alreadyMoved = true;
                this.download_manager.setTorrentSaveDir(string);
                break;
            }
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        if (!this.alreadyMoved && !this.download_manager.isDataAlreadyAllocated()) {
            if (!bl) {
                bl = this.filesExist();
            }
            if (!bl && (object = DownloadManagerMoveHandler.onInitialisation(this.download_manager)) != null) {
                if (object.download_location != null || object.download_name != null) {
                    File file = object.download_location;
                    if (file == null) {
                        file = this.download_manager.getAbsoluteSaveLocation().getParentFile();
                    }
                    if (object.download_name == null) {
                        this.download_manager.setTorrentSaveDir(file.getAbsolutePath());
                    } else {
                        this.download_manager.setTorrentSaveDir(file.getAbsolutePath(), object.download_name);
                    }
                }
                if (object.torrent_location != null || object.torrent_name != null) {
                    try {
                        this.download_manager.setTorrentFile(object.torrent_location, object.torrent_name);
                    }
                    catch (DownloadManagerException downloadManagerException) {
                        Debug.printStackTrace(downloadManagerException);
                    }
                }
            }
        }
        int n = this.allocateFiles();
        if (this.getState() == 10) {
            return;
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(3);
        this.resume_handler.start();
        if (this.checking_enabled) {
            if (n == 0) {
                this.resume_handler.checkAllPieces(false);
                if (this.getRemainingExcludingDND() == 0L) {
                    this.checkFreePieceList(true);
                }
            } else if (n != this.files.length) {
                this.resume_handler.checkAllPieces(true);
            }
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop(boolean bl) {
        try {
            this.start_stop_mon.enter();
            if (!this.started) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.starting) {
                this.stopping = true;
                this.checker.stop();
                this.writer.stop();
                this.reader.stop();
                this.resume_handler.stop(bl);
                this.saveState(false);
                boolean bl3 = true;
                return bl3;
            }
            this.started = false;
            this.stopping = false;
        }
        finally {
            this.start_stop_mon.exit();
        }
        this.started_sem.reserve();
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop(bl);
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    if (this.files[i] == null) continue;
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable throwable) {
                    this.setFailed("File close fails: " + Debug.getNestedExceptionMessage(throwable));
                }
            }
        }
        if (this.getState() == 4) {
            try {
                this.saveResumeData(false);
            }
            catch (Exception exception) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(exception));
            }
        }
        this.saveState();
        this.listeners.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStopped() {
        try {
            this.start_stop_mon.enter();
            boolean bl = !this.started && !this.starting && !this.stopping;
            return bl;
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    @Override
    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(String string) {
        if (!this.torrent.isSimpleTorrent()) {
            string = string + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        DMPieceMapperFile[] dMPieceMapperFileArray = this.piece_mapper.getFiles();
        String[] stringArray = this.getStorageTypes();
        for (int i = 0; i < dMPieceMapperFileArray.length; ++i) {
            DMPieceMapperFile dMPieceMapperFile = dMPieceMapperFileArray[i];
            File file = dMPieceMapperFile.getDataFile();
            long l = dMPieceMapperFile.getLength();
            DiskManagerFileInfoImpl diskManagerFileInfoImpl = dMPieceMapperFile.getFileInfo();
            boolean bl = false;
            try {
                if (diskManagerFileInfoImpl == null) {
                    int n = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[i]);
                    diskManagerFileInfoImpl = new DiskManagerFileInfoImpl(this, new File(string + file.toString()), i, dMPieceMapperFile.getTorrentFile(), n);
                    bl = true;
                }
                try {
                    CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
                    File file2 = diskManagerFileInfoImpl.getFile(true);
                    if (!cacheFile.exists()) {
                        File file3;
                        File file4 = file2;
                        while (!file4.exists() && (file3 = file4.getParentFile()) != null) {
                            if (file3.exists()) {
                                this.errorMessage = file3.isDirectory() ? file4.toString() + " not found." : file3.toString() + " is not a directory.";
                                boolean bl2 = false;
                                return bl2;
                            }
                            file4 = file3;
                        }
                        this.errorMessage = file2.toString() + " not found.";
                        boolean bl3 = false;
                        return bl3;
                    }
                    long l2 = diskManagerFileInfoImpl.getCacheFile().getLength();
                    if (l2 <= l) continue;
                    if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                        diskManagerFileInfoImpl.setAccessMode(2);
                        diskManagerFileInfoImpl.getCacheFile().setLength(l);
                        Debug.out("Existing data file length too large [" + l2 + ">" + l + "]: " + file2.getAbsolutePath() + ", truncating");
                        continue;
                    }
                    this.errorMessage = "Existing data file length too large [" + l2 + ">" + l + "]: " + file2.getAbsolutePath();
                    boolean bl4 = false;
                    return bl4;
                }
                finally {
                    if (bl) {
                        diskManagerFileInfoImpl.getCacheFile().close();
                    }
                }
            }
            catch (Throwable throwable) {
                this.errorMessage = Debug.getNestedExceptionMessage(throwable) + " (filesExist:" + file.toString() + ")";
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateFiles() {
        HashSet<String> hashSet = new HashSet<String>();
        DMPieceMapperFile[] dMPieceMapperFileArray = this.piece_mapper.getFiles();
        DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray = new DiskManagerFileInfoImpl[dMPieceMapperFileArray.length];
        try {
            int n;
            allocation_scheduler.register(this);
            this.setState(2);
            this.allocated = 0L;
            int n2 = 0;
            String string = this.download_manager.getAbsoluteSaveLocation().getParent();
            if (!this.torrent.isSimpleTorrent()) {
                string = string + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
            }
            string = string + File.separator;
            String[] stringArray = this.getStorageTypes();
            String string2 = this.download_manager.getDownloadState().getAttribute("incompfilesuffix");
            for (n = 0; n < dMPieceMapperFileArray.length; ++n) {
                boolean bl;
                int n3;
                File file;
                DiskManagerFileInfoImpl diskManagerFileInfoImpl;
                long l;
                block60: {
                    block59: {
                        long l2;
                        boolean bl2;
                        block58: {
                            int n4;
                            int n5;
                            if (this.stopping) {
                                this.errorMessage = "File allocation interrupted - download is stopping";
                                this.setState(10);
                                int n6 = -1;
                                return n6;
                            }
                            DMPieceMapperFile dMPieceMapperFile = dMPieceMapperFileArray[n];
                            l = dMPieceMapperFile.getLength();
                            File file2 = dMPieceMapperFile.getDataFile();
                            try {
                                int n7 = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[n]);
                                diskManagerFileInfoImplArray[n] = diskManagerFileInfoImpl = new DiskManagerFileInfoImpl(this, new File(string + file2.toString()), n, dMPieceMapperFile.getTorrentFile(), n7);
                                dMPieceMapperFile.setFileInfo(diskManagerFileInfoImpl);
                            }
                            catch (CacheFileManagerException cacheFileManagerException) {
                                this.errorMessage = Debug.getNestedExceptionMessage(cacheFileManagerException) + " (allocateFiles:" + file2.toString() + ")";
                                this.setState(10);
                                int n8 = -1;
                                allocation_scheduler.unregister(this);
                                if (this.files == null) {
                                    for (int i = 0; i < diskManagerFileInfoImplArray.length; ++i) {
                                        if (diskManagerFileInfoImplArray[i] == null) continue;
                                        try {
                                            diskManagerFileInfoImplArray[i].getCacheFile().close();
                                            continue;
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                }
                                return n8;
                            }
                            CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
                            file = diskManagerFileInfoImpl.getFile(true);
                            String string3 = file.getAbsolutePath();
                            if (Constants.isWindows) {
                                string3 = string3.toLowerCase();
                            }
                            if (hashSet.contains(string3)) {
                                this.errorMessage = "File occurs more than once in download: " + file.toString();
                                this.setState(10);
                                int n9 = -1;
                                return n9;
                            }
                            hashSet.add(string3);
                            String string4 = file.getName();
                            if (string2 != null && string4.endsWith(string2)) {
                                string4 = string4.substring(0, string4.length() - string2.length());
                            }
                            if ((n5 = string4.lastIndexOf(".")) == -1) {
                                n5 = 0;
                            }
                            diskManagerFileInfoImpl.setExtension(string4.substring(n5));
                            String string5 = COConfigurationManager.getStringParameter("priorityExtensions", "");
                            if (!string5.equals("")) {
                                n4 = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                                StringTokenizer stringTokenizer = new StringTokenizer(string5, ";");
                                while (stringTokenizer.hasMoreTokens()) {
                                    String string6 = stringTokenizer.nextToken();
                                    if (!(string6 = string6.trim()).startsWith(".")) {
                                        string6 = "." + string6;
                                    }
                                    if ((n3 = n4 != 0 ? diskManagerFileInfoImpl.getExtension().equalsIgnoreCase(string6) : diskManagerFileInfoImpl.getExtension().equals(string6)) == 0) continue;
                                    diskManagerFileInfoImpl.setPriority(1);
                                }
                            }
                            diskManagerFileInfoImpl.setDownloaded(0L);
                            n4 = cacheFile.getStorageType();
                            bl2 = n4 == 2 || n4 == 4;
                            boolean bl3 = bl = !bl2 || RDResumeHandler.fileMustExist(this.download_manager, diskManagerFileInfoImpl);
                            if (!bl && cacheFile.exists()) {
                                file.delete();
                            }
                            if (!cacheFile.exists()) break block60;
                            try {
                                l2 = diskManagerFileInfoImpl.getCacheFile().getLength();
                                if (l2 <= l) break block58;
                                if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                                    diskManagerFileInfoImpl.setAccessMode(2);
                                    cacheFile.setLength(l);
                                    diskManagerFileInfoImpl.setAccessMode(1);
                                    Debug.out("Existing data file length too large [" + l2 + ">" + l + "]: " + file.getAbsolutePath() + ", truncating");
                                    break block59;
                                }
                                this.errorMessage = "Existing data file length too large [" + l2 + ">" + l + "]: " + file.getAbsolutePath();
                                this.setState(10);
                                int n10 = -1;
                                return n10;
                            }
                            catch (Throwable throwable) {
                                this.fileAllocFailed(file, l, false, throwable);
                                this.setState(10);
                                int n11 = -1;
                                return n11;
                            }
                        }
                        if (l2 < l && !bl2 && !this.allocateFile(diskManagerFileInfoImpl, file, l2, l)) {
                            int n12 = -1;
                            return n12;
                        }
                    }
                    this.allocated += l;
                    continue;
                }
                if (!bl) continue;
                if (this.download_manager.isDataAlreadyAllocated()) {
                    this.errorMessage = "Data file missing: " + file.getAbsolutePath();
                    this.setState(10);
                    n3 = -1;
                    return n3;
                }
                if (!this.allocateFile(diskManagerFileInfoImpl, file, -1L, l)) {
                    n3 = -1;
                    return n3;
                }
                ++n2;
            }
            this.files = diskManagerFileInfoImplArray;
            this.fileset = new DiskManagerFileInfoSetImpl(this.files, this);
            this.loadFilePriorities();
            this.download_manager.setDataAlreadyAllocated(true);
            n = n2;
            return n;
        }
        finally {
            allocation_scheduler.unregister(this);
            if (this.files == null) {
                for (int i = 0; i < diskManagerFileInfoImplArray.length; ++i) {
                    if (diskManagerFileInfoImplArray[i] == null) continue;
                    try {
                        diskManagerFileInfoImplArray[i].getCacheFile().close();
                        continue;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private boolean allocateFile(DiskManagerFileInfoImpl diskManagerFileInfoImpl, File file, long l, long l2) throws Throwable {
        while (this.started && !allocation_scheduler.getPermission(this)) {
        }
        if (!this.started) {
            return false;
        }
        diskManagerFileInfoImpl.setAccessMode(2);
        if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
            if (l < 0L) {
                diskManagerFileInfoImpl.getCacheFile().setLength(0L);
            }
        } else if (l2 > 0L && COConfigurationManager.getBooleanParameter("XFS Allocation")) {
            Object object;
            long l3;
            long l4;
            diskManagerFileInfoImpl.getCacheFile().setLength(l2);
            if (l > 0L) {
                l4 = l;
                l3 = l2 - l;
            } else {
                l4 = 0L;
                l3 = l2;
            }
            String[] stringArray = new String[]{"/usr/sbin/xfs_io", "-c", "resvsp " + l4 + " " + l3, file.getAbsolutePath()};
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            try {
                object = Runtime.getRuntime().exec(stringArray);
                int n = ((Process)object).getErrorStream().read(byArray);
                while (n > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    n = ((Process)object).getErrorStream().read(byArray);
                }
                byteArrayOutputStream.close();
                ((Process)object).waitFor();
            }
            catch (IOException iOException) {
                String string = MessageText.getString("xfs.allocation.xfs_io.not.found", new String[]{iOException.getMessage()});
                Logger.log(new LogAlert((Object)this, false, 3, string));
            }
            if (byteArrayOutputStream.size() > 0) {
                object = byteArrayOutputStream.toString().trim();
                if (((String)object).endsWith("is not on an XFS filesystem")) {
                    Logger.log(new LogEvent(this, LogIDs.DISK, "XFS file allocation impossible because \"" + file.getAbsolutePath() + "\" is not on an XFS filesystem. Original error reported by xfs_io : \"" + (String)object + "\""));
                } else {
                    throw new Exception((String)object);
                }
            }
            this.allocated += l2;
        } else {
            if (COConfigurationManager.getBooleanParameter("Zero New")) {
                boolean bl = false;
                try {
                    bl = this.writer.zeroFile(diskManagerFileInfoImpl, l2);
                }
                catch (Throwable throwable) {
                    this.fileAllocFailed(file, l2, l == -1L, throwable);
                    throw throwable;
                }
                finally {
                    if (!bl) {
                        try {
                            diskManagerFileInfoImpl.getCacheFile().close();
                            diskManagerFileInfoImpl.getCacheFile().delete();
                        }
                        catch (Throwable throwable) {}
                        this.setState(10);
                    }
                }
            }
            diskManagerFileInfoImpl.getCacheFile().setLength(l2);
            this.allocated += l2;
        }
        diskManagerFileInfoImpl.setAccessMode(1);
        return true;
    }

    private void fileAllocFailed(File file, long l, boolean bl, Throwable throwable) {
        this.errorMessage = Debug.getNestedExceptionMessage(throwable) + " (allocateFiles " + (bl ? "new" : "existing") + ":" + file.toString() + ")";
        if (this.errorMessage.indexOf("not enough space") != -1) {
            this.errorMessage = l >= 0x100000000L ? MessageText.getString("DiskManager.error.nospace_fat32") : MessageText.getString("DiskManager.error.nospace");
        }
    }

    @Override
    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    @Override
    public void enqueueReadRequest(DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener) {
        this.reader.readBlock(diskManagerReadRequest, diskManagerReadRequestListener);
    }

    @Override
    public boolean hasOutstandingReadRequestForPiece(int n) {
        return this.reader.hasOutstandingReadRequestForPiece(n);
    }

    @Override
    public int getNbPieces() {
        return this.nbPieces;
    }

    @Override
    public int getPercentDone() {
        return this.percentDone;
    }

    @Override
    public void setPercentDone(int n) {
        this.percentDone = n;
    }

    @Override
    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRemainingExcludingDND() {
        long l;
        DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray;
        if (this.skipped_file_set_changed && (diskManagerFileInfoImplArray = this.files) != null) {
            this.skipped_file_set_changed = false;
            try {
                this.file_piece_mon.enter();
                this.skipped_file_set_size = 0L;
                this.skipped_but_downloaded = 0L;
                for (int i = 0; i < diskManagerFileInfoImplArray.length; ++i) {
                    DiskManagerFileInfoImpl diskManagerFileInfoImpl = diskManagerFileInfoImplArray[i];
                    if (!diskManagerFileInfoImpl.isSkipped()) continue;
                    this.skipped_file_set_size += diskManagerFileInfoImpl.getLength();
                    this.skipped_but_downloaded += diskManagerFileInfoImpl.getDownloaded();
                }
            }
            finally {
                this.file_piece_mon.exit();
            }
        }
        if ((l = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded)) < 0L) {
            l = 0L;
        }
        return l;
    }

    @Override
    public long getAllocated() {
        return this.allocated;
    }

    @Override
    public void setAllocated(long l) {
        this.allocated = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPieceDone(DiskManagerPieceImpl diskManagerPieceImpl, boolean bl) {
        block16: {
            int n = diskManagerPieceImpl.getPieceNumber();
            int n2 = diskManagerPieceImpl.getLength();
            try {
                this.file_piece_mon.enter();
                if (diskManagerPieceImpl.isDone() == bl) break block16;
                diskManagerPieceImpl.setDoneSupport(bl);
                this.remaining = bl ? (this.remaining -= (long)n2) : (this.remaining += (long)n2);
                DMPieceList dMPieceList = this.getPieceList(n);
                for (int i = 0; i < dMPieceList.size(); ++i) {
                    long l;
                    DMPieceMapEntry dMPieceMapEntry = dMPieceList.get(i);
                    DiskManagerFileInfoImpl diskManagerFileInfoImpl = dMPieceMapEntry.getFile();
                    long l2 = diskManagerFileInfoImpl.getLength();
                    long l3 = l = diskManagerFileInfoImpl.getDownloaded();
                    l = bl ? (l += (long)dMPieceMapEntry.getLength()) : (l -= (long)dMPieceMapEntry.getLength());
                    if (l < 0L) {
                        Debug.out("piece map entry length negative");
                        l = 0L;
                    } else if (l > l2) {
                        Debug.out("piece map entry length too large");
                        l = l2;
                    }
                    if (diskManagerFileInfoImpl.isSkipped()) {
                        this.skipped_but_downloaded += l - l3;
                    }
                    diskManagerFileInfoImpl.setDownloaded(l);
                    if (l != l2) continue;
                    try {
                        try {
                            String string;
                            File file;
                            File file2;
                            DownloadManagerState downloadManagerState = this.download_manager.getDownloadState();
                            String string2 = downloadManagerState.getAttribute("incompfilesuffix");
                            if (string2 == null || string2.length() <= 0 || (file2 = downloadManagerState.getFileLink(file = diskManagerFileInfoImpl.getFile(false))) == null || !(string = file2.getName()).endsWith(string2) || string.length() <= string2.length()) continue;
                            String string3 = string.substring(0, string.length() - string2.length());
                            File file3 = new File(file2.getParentFile(), string3);
                            if (file3.exists()) continue;
                            diskManagerFileInfoImpl.renameFile(string3, false);
                            if (file.equals(file3)) {
                                downloadManagerState.setFileLink(file, null);
                                continue;
                            }
                            downloadManagerState.setFileLink(file, file3);
                            continue;
                        }
                        finally {
                            if (diskManagerFileInfoImpl.getAccessMode() == 2) {
                                diskManagerFileInfoImpl.setAccessMode(1);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.setFailed("Disk access error - " + Debug.getNestedExceptionMessage(throwable));
                        Debug.printStackTrace(throwable);
                    }
                }
                if (this.getState() == 4) {
                    this.listeners.dispatch(3, diskManagerPieceImpl);
                }
            }
            finally {
                this.file_piece_mon.exit();
            }
        }
    }

    @Override
    public void accessModeChanged(DiskManagerFileInfoImpl diskManagerFileInfoImpl, int n, int n2) {
        this.listeners.dispatch(4, new Object[]{diskManagerFileInfoImpl, new Integer(n), new Integer(n2)});
    }

    @Override
    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    @Override
    public DiskManagerPiece getPiece(int n) {
        return this.pieces[n];
    }

    @Override
    public int getPieceLength() {
        return this.pieceLength;
    }

    @Override
    public int getPieceLength(int n) {
        if (n == this.nbPieces - 1) {
            return this.lastPieceLength;
        }
        return this.pieceLength;
    }

    @Override
    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    @Override
    public int getState() {
        return this.state_set_via_method;
    }

    protected void setState(int n) {
        if (this.state_set_via_method == 10) {
            if (n != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + n);
            }
            return;
        }
        if (this.state_set_via_method != n) {
            int[] nArray = new int[]{this.state_set_via_method, n};
            this.state_set_via_method = n;
            this.listeners.dispatch(1, nArray);
        }
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public DiskManagerFileInfoSet getFileSet() {
        return this.fileset;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setFailed(final String string) {
        new AEThread("DiskManager:setFailed"){

            @Override
            public void runSupport() {
                DiskManagerImpl.this.errorMessage = string;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
            }
        }.start();
    }

    @Override
    public void setFailed(final DiskManagerFileInfo diskManagerFileInfo, final String string) {
        new AEThread("DiskManager:setFailed"){

            @Override
            public void runSupport() {
                DiskManagerImpl.this.errorMessage = string;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, diskManagerFileInfo);
            }
        }.start();
    }

    @Override
    public int getCacheMode() {
        return 1;
    }

    @Override
    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[]{0L, 0L};
        }
        return this.reader.getStats();
    }

    @Override
    public DMPieceMap getPieceMap() {
        DMPieceMap dMPieceMap = this.piece_map_use_accessor;
        if (dMPieceMap == null) {
            this.piece_map_use_accessor = dMPieceMap = this.piece_mapper.getPieceMap();
        }
        this.piece_map_use_accessor_time = SystemTime.getCurrentTime();
        return dMPieceMap;
    }

    @Override
    public DMPieceList getPieceList(int n) {
        DMPieceMap dMPieceMap = this.getPieceMap();
        return dMPieceMap.getPieceList(n);
    }

    public void checkFreePieceList(boolean bl) {
        if (this.piece_map_use_accessor == null) {
            return;
        }
        long l = SystemTime.getCurrentTime();
        if (!bl) {
            if (l < this.piece_map_use_accessor_time) {
                this.piece_map_use_accessor_time = l;
                return;
            }
            if (l - this.piece_map_use_accessor_time < 120000L) {
                return;
            }
        }
        this.piece_map_use_accessor = null;
    }

    @Override
    public byte[] getPieceHash(int n) throws TOTorrentException {
        return this.torrent.getPieces()[n];
    }

    @Override
    public DiskManagerReadRequest createReadRequest(int n, int n2, int n3) {
        return this.reader.createReadRequest(n, n2, n3);
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int n, Object object) {
        return this.checker.createCheckRequest(n, object);
    }

    @Override
    public boolean hasOutstandingCheckRequestForPiece(int n) {
        return this.checker.hasOutstandingCheckRequestForPiece(n);
    }

    @Override
    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        this.checker.enqueueCompleteRecheckRequest(diskManagerCheckRequest, diskManagerCheckRequestListener);
    }

    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        this.checker.enqueueCheckRequest(diskManagerCheckRequest, diskManagerCheckRequestListener);
    }

    @Override
    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    @Override
    public void setPieceCheckingEnabled(boolean bl) {
        this.checking_enabled = bl;
        this.checker.setCheckingEnabled(bl);
    }

    @Override
    public DirectByteBuffer readBlock(int n, int n2, int n3) {
        return this.reader.readBlock(n, n2, n3);
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int n, int n2, DirectByteBuffer directByteBuffer, Object object) {
        return this.writer.createWriteRequest(n, n2, directByteBuffer, object);
    }

    @Override
    public void enqueueWriteRequest(DiskManagerWriteRequest diskManagerWriteRequest, DiskManagerWriteRequestListener diskManagerWriteRequestListener) {
        this.writer.writeBlock(diskManagerWriteRequest, diskManagerWriteRequestListener);
    }

    @Override
    public boolean hasOutstandingWriteRequestForPiece(int n) {
        return this.writer.hasOutstandingWriteRequestForPiece(n);
    }

    @Override
    public boolean checkBlockConsistencyForWrite(String string, int n, int n2, DirectByteBuffer directByteBuffer) {
        if (n < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " pieceNumber=" + n + " < 0"));
            }
            return false;
        }
        if (n >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " pieceNumber=" + n + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int n3 = this.pieceLength;
        if (n == this.nbPieces - 1) {
            n3 = this.lastPieceLength;
        }
        if (n2 < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " offset=" + n2 + " < 0"));
            }
            return false;
        }
        if (n2 > n3) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " offset=" + n2 + " > length=" + n3));
            }
            return false;
        }
        int n4 = directByteBuffer.remaining((byte)8);
        if (n4 <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " size=" + n4 + " <= 0"));
            }
            return false;
        }
        if (n2 + n4 > n3) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " offset=" + n2 + " + size=" + n4 + " > length=" + n3));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkBlockConsistencyForRead(String string, boolean bl, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, string, bl, n, n2, n3);
    }

    @Override
    public boolean checkBlockConsistencyForHint(String string, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, string, n, n2, n3);
    }

    @Override
    public void saveResumeData(boolean bl) throws Exception {
        this.resume_handler.saveResumeData(bl);
    }

    @Override
    public void downloadEnded() {
        this.moveDownloadFilesWhenEndedOrRemoved(false, true);
    }

    @Override
    public void downloadRemoved() {
        this.moveDownloadFilesWhenEndedOrRemoved(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDownloadFilesWhenEndedOrRemoved(boolean bl, boolean bl2) {
        try {
            SaveLocationChange saveLocationChange;
            boolean bl3;
            this.start_stop_mon.enter();
            boolean bl4 = bl3 = !bl;
            if (bl3) {
                if (this.alreadyMoved) {
                    boolean bl5 = false;
                    return bl5;
                }
                this.alreadyMoved = true;
            }
            if (bl) {
                saveLocationChange = DownloadManagerMoveHandler.onRemoval(this.download_manager);
            } else {
                DownloadManagerMoveHandler.onCompletion(this.download_manager, new DownloadManagerMoveHandler.MoveCallback(){

                    @Override
                    public void perform(SaveLocationChange saveLocationChange) {
                        DiskManagerImpl.this.moveFiles(saveLocationChange, true);
                    }
                });
                saveLocationChange = null;
            }
            if (saveLocationChange != null) {
                this.moveFiles(saveLocationChange, true);
            }
            boolean bl6 = true;
            return bl6;
        }
        finally {
            this.start_stop_mon.exit();
            if (!bl) {
                try {
                    this.saveResumeData(false);
                }
                catch (Throwable throwable) {
                    this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(throwable));
                }
            }
        }
    }

    @Override
    public void moveDataFiles(File file, String string) {
        SaveLocationChange saveLocationChange = new SaveLocationChange();
        saveLocationChange.download_location = file;
        saveLocationChange.download_name = string;
        this.moveFiles(saveLocationChange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFiles(SaveLocationChange saveLocationChange, boolean bl) {
        boolean bl2 = false;
        if (saveLocationChange.hasDownloadChange()) {
            bl2 = !this.isFileDestinationIsItself(saveLocationChange);
        }
        try {
            this.start_stop_mon.enter();
            boolean bl3 = true;
            if (bl2) {
                bl3 = this.moveDataFiles0(saveLocationChange, bl);
            }
            if (saveLocationChange.hasTorrentChange() && bl3) {
                this.moveTorrentFile(saveLocationChange);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void logMoveFileError(String string, String string2) {
        Logger.log(new LogEvent((Object)this, LOGID, 3, string2));
        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{string, string2});
    }

    private boolean isFileDestinationIsItself(SaveLocationChange saveLocationChange) {
        File file = this.download_manager.getAbsoluteSaveLocation();
        File file2 = saveLocationChange.normaliseDownloadLocation(file);
        try {
            file = file.getCanonicalFile();
            file2 = file2.getCanonicalFile();
            if (file.equals(file2)) {
                return true;
            }
            if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(file2, file)) {
                String string = "Target is sub-directory of files";
                this.logMoveFileError(file2.toString(), string);
                return true;
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        return false;
    }

    private boolean moveDataFiles0(SaveLocationChange saveLocationChange, boolean bl) throws Exception {
        String string;
        File file;
        int n;
        File file2 = saveLocationChange.download_location;
        if (file2 == null) {
            file2 = this.download_manager.getAbsoluteSaveLocation().getParentFile();
        }
        String string2 = file2.toString();
        String string3 = saveLocationChange.download_name;
        if (this.files == null) {
            return false;
        }
        if (this.isFileDestinationIsItself(saveLocationChange)) {
            return false;
        }
        boolean bl2 = this.download_manager.getTorrent().isSimpleTorrent();
        File file3 = this.download_manager.getAbsoluteSaveLocation();
        String string4 = file3.getParentFile().getCanonicalFile().getPath();
        File[] fileArray = new File[this.files.length];
        File[] fileArray2 = new File[this.files.length];
        boolean[] blArray = new boolean[this.files.length];
        for (n = 0; n < this.files.length; ++n) {
            File file4;
            file = this.files[n].getFile(false);
            File file5 = FMFileManagerFactory.getSingleton().getFileLink(this.torrent, file);
            if (!file5.equals(file)) {
                if (bl2) {
                    if (file5.getParentFile().getCanonicalPath().equals(file3.getParentFile().getCanonicalPath())) {
                        file = file5;
                    } else {
                        blArray[n] = true;
                    }
                } else if (file5.getCanonicalPath().startsWith(file3.getCanonicalPath())) {
                    file = file5;
                } else {
                    blArray[n] = true;
                }
            }
            fileArray2[n] = file;
            string = file.getCanonicalFile().getParent();
            if (!string.startsWith(string4)) {
                this.logMoveFileError(string2, "Could not determine relative path for file - " + string);
                throw new IOException("relative path assertion failed: move_from_dir=\"" + string4 + "\", old_parent_path=\"" + string + "\"");
            }
            String string5 = string.substring(string4.length());
            if (string5.startsWith(File.separator)) {
                string5 = string5.substring(1);
            }
            if (string3 == null) {
                file4 = new File(new File(string2, string5), file.getName());
            } else if (bl2) {
                file4 = new File(new File(string2, string5), string3);
            } else {
                String string6;
                int n2 = string5.indexOf(File.separator);
                if (n2 == -1) {
                    string6 = string3;
                } else {
                    String string7 = string5.substring(n2);
                    String string8 = string5.substring(0, n2);
                    string6 = string3 + string7;
                    boolean bl3 = string8.equals(file3.getName());
                    if (!bl3) {
                        Debug.out("Assertion check for renaming file in multi-name torrent " + (bl3 ? "passed" : "failed") + "\n" + "  Old parent path: " + string + "\n" + "  Subpath: " + string5 + "\n" + "  Sub-subpath: " + string7 + "\n" + "  Expected old name: " + string8 + "\n" + "  Torrent pre-move name: " + file3.getName() + "\n" + "  New torrent name: " + string3 + "\n" + "  Old file: " + file + "\n" + "  Linked file: " + file5 + "\n" + "\n" + "  Move-to-dir: " + string2 + "\n" + "  New path: " + string6 + "\n" + "  Old file [name]: " + file.getName() + "\n");
                    }
                }
                file4 = new File(new File(string2, string6), file.getName());
            }
            fileArray[n] = file4;
            if (blArray[n]) continue;
            if (file4.exists()) {
                String string9 = "" + file5.getName() + " already exists in MoveTo destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, string9));
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefileexists"), new String[]{file.getName()});
                Debug.out(string9);
                return false;
            }
            FileUtil.mkdirs(file4.getParentFile());
        }
        for (n = 0; n < this.files.length; ++n) {
            file = fileArray[n];
            try {
                this.files[n].moveFile(file, blArray[n]);
                if (!bl) continue;
                this.files[n].setAccessMode(1);
                continue;
            }
            catch (CacheFileManagerException cacheFileManagerException) {
                string = "Failed to move " + fileArray2[n].toString() + " to destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, string));
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{fileArray2[n].toString(), Debug.getNestedExceptionMessage(cacheFileManagerException)});
                for (int i = 0; i < n; ++i) {
                    try {
                        this.files[i].moveFile(fileArray2[i], blArray[i]);
                        continue;
                    }
                    catch (CacheFileManagerException cacheFileManagerException2) {
                        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilerecoveryfails"), new String[]{fileArray2[i].toString(), Debug.getNestedExceptionMessage(cacheFileManagerException2)});
                    }
                }
                return false;
            }
        }
        if (file3.isDirectory()) {
            TorrentUtils.recursiveEmptyDirDelete(file3, false);
        }
        if (string3 == null) {
            this.download_manager.setTorrentSaveDir(string2);
        } else {
            this.download_manager.setTorrentSaveDir(string2, string3);
        }
        return true;
    }

    private void moveTorrentFile(SaveLocationChange saveLocationChange) {
        if (!saveLocationChange.hasTorrentChange()) {
            return;
        }
        File file = new File(this.download_manager.getTorrentFileName());
        File file2 = saveLocationChange.normaliseTorrentLocation(file);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 1, "Torrent file '" + file.getPath() + "' has been deleted, move operation ignored"));
            }
            return;
        }
        try {
            this.download_manager.setTorrentFile(saveLocationChange.torrent_location, saveLocationChange.torrent_name);
        }
        catch (DownloadManagerException downloadManagerException) {
            String string = "Failed to move " + file.toString() + " to " + file2.toString();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, string));
            }
            Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{file.toString(), file2.toString()});
            Debug.out(string);
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void addListener(DiskManagerListener diskManagerListener) {
        this.listeners.addListener(diskManagerListener);
        int[] nArray = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(diskManagerListener, 1, nArray);
    }

    @Override
    public void removeListener(DiskManagerListener diskManagerListener) {
        this.listeners.removeListener(diskManagerListener);
    }

    @Override
    public boolean hasListener(DiskManagerListener diskManagerListener) {
        return this.listeners.hasListener(diskManagerListener);
    }

    public static void deleteDataFiles(TOTorrent tOTorrent, String string, String string2, boolean bl) {
        block8: {
            if (tOTorrent == null || string2 == null) {
                return;
            }
            try {
                if (tOTorrent.isSimpleTorrent()) {
                    File file = new File(string, string2);
                    file = FMFileManagerFactory.getSingleton().getFileLink(tOTorrent, file.getCanonicalFile());
                    FileUtil.deleteWithRecycle(file, bl);
                    break block8;
                }
                PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
                if (Constants.isOSX && string2.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !bl && platformManager.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    try {
                        String string3 = string + File.separatorChar + string2 + File.separatorChar;
                        if (DiskManagerImpl.countFiles(new File(string3)) == DiskManagerImpl.countDataFiles(tOTorrent, string, string2)) {
                            platformManager.performRecoverableFileDelete(string3);
                            break block8;
                        }
                        DiskManagerImpl.deleteDataFileContents(tOTorrent, string, string2, bl);
                    }
                    catch (PlatformManagerException platformManagerException) {
                        DiskManagerImpl.deleteDataFileContents(tOTorrent, string, string2, bl);
                    }
                    break block8;
                }
                DiskManagerImpl.deleteDataFileContents(tOTorrent, string, string2, bl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    private static int countFiles(File file) {
        if (file.isFile()) {
            return 1;
        }
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                n += DiskManagerImpl.countFiles(fileArray[i]);
            }
        }
        return n;
    }

    private static int countDataFiles(TOTorrent tOTorrent, String string, String string2) {
        try {
            int n = 0;
            LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(tOTorrent);
            TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            for (int i = 0; i < tOTorrentFileArray.length; ++i) {
                Object object;
                byte[][] byArray = tOTorrentFileArray[i].getPathComponents();
                String string3 = string + File.separator + string2 + File.separator;
                for (int j = 0; j < byArray.length; ++j) {
                    object = localeUtilDecoder.decodeString(byArray[j]);
                    object = FileUtil.convertOSSpecificChars((String)object, j != byArray.length - 1);
                    string3 = string3 + (j == 0 ? "" : File.separator) + (String)object;
                }
                File file = new File(string3).getCanonicalFile();
                object = FMFileManagerFactory.getSingleton().getFileLink(tOTorrent, file);
                boolean bl = false;
                if (object != file && !((File)object).getCanonicalPath().startsWith(new File(string).getCanonicalPath())) {
                    bl = true;
                }
                if (bl || !file.exists() || file.isDirectory()) continue;
                ++n;
            }
            return n;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent tOTorrent, String string, String string2, boolean bl) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(tOTorrent);
        TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
        String string3 = string + File.separator + string2 + File.separator;
        boolean bl2 = COConfigurationManager.getBooleanParameter("File.delete.include_files_outside_save_dir");
        for (int i = 0; i < tOTorrentFileArray.length; ++i) {
            boolean bl3;
            Object object;
            byte[][] byArray = tOTorrentFileArray[i].getPathComponents();
            String string4 = string3;
            for (int j = 0; j < byArray.length; ++j) {
                try {
                    object = localeUtilDecoder.decodeString(byArray[j]);
                    object = FileUtil.convertOSSpecificChars((String)object, j != byArray.length - 1);
                    string4 = string4 + (j == 0 ? "" : File.separator) + (String)object;
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.out("file - unsupported encoding!!!!");
                }
            }
            Object object2 = new File(string4);
            object = FMFileManagerFactory.getSingleton().getFileLink(tOTorrent, (File)object2);
            if (object == object2) {
                bl3 = true;
            } else {
                try {
                    if (bl2 || ((File)object).getCanonicalPath().startsWith(new File(string3).getCanonicalPath())) {
                        object2 = object;
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    bl3 = false;
                }
            }
            if (!bl3 || !((File)object2).exists() || ((File)object2).isDirectory()) continue;
            try {
                FileUtil.deleteWithRecycle((File)object2, bl);
                continue;
            }
            catch (Exception exception) {
                Debug.out(exception.toString());
            }
        }
        TorrentUtils.recursiveEmptyDirDelete(new File(string, string2));
    }

    @Override
    public void skippedFileSetChanged(DiskManagerFileInfo diskManagerFileInfo) {
        this.skipped_file_set_changed = true;
        this.listeners.dispatch(2, diskManagerFileInfo);
    }

    @Override
    public void priorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
        this.listeners.dispatch(2, diskManagerFileInfo);
    }

    private void loadFilePriorities() {
        DiskManagerUtil.loadFilePriorities(this.download_manager, this.fileset);
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager downloadManager, DiskManagerFileInfo[] diskManagerFileInfoArray) {
        if (diskManagerFileInfoArray == null) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(diskManagerFileInfoArray.length);
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
            if (diskManagerFileInfo == null) {
                return;
            }
            boolean bl = diskManagerFileInfo.isSkipped();
            int n = diskManagerFileInfo.getPriority();
            int n2 = -1;
            if (bl) {
                n2 = 0;
            } else if (n > 0) {
                n2 = n;
            }
            arrayList.add(i, Long.valueOf(n2));
        }
        downloadManager.setData("file_priorities", arrayList);
    }

    protected static void storeFileDownloaded(DownloadManager downloadManager, DiskManagerFileInfo[] diskManagerFileInfoArray, boolean bl) {
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        HashMap hashMap = new HashMap();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        hashMap.put("downloaded", arrayList);
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            arrayList.add(new Long(diskManagerFileInfoArray[i].getDownloaded()));
        }
        downloadManagerState.setMapAttribute("filedownloaded", hashMap);
        if (bl) {
            downloadManagerState.save();
        }
    }

    @Override
    public void saveState() {
        this.saveState(true);
    }

    protected void saveState(boolean bl) {
        if (this.files != null) {
            DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files, bl);
            this.storeFilePriorities();
        }
        this.checkFreePieceList(false);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    @Override
    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    @Override
    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    @Override
    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    @Override
    public String getStorageType(int n) {
        return DiskManagerImpl.getStorageType(this.download_manager, n);
    }

    public static String[] getStorageTypes(DownloadManager downloadManager) {
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        String[] stringArray = downloadManagerState.getListAttribute("storetypes");
        if (stringArray.length == 0) {
            TOTorrentFile[] tOTorrentFileArray = downloadManager.getTorrent().getFiles();
            stringArray = new String[downloadManager.getTorrent().getFiles().length];
            if (reorder_storage_mode) {
                int n = downloadManagerState.getIntAttribute("reordermb");
                if (n < 0) {
                    n = reorder_storage_mode_min_mb;
                    downloadManagerState.setIntAttribute("reordermb", n);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = tOTorrentFileArray[i].getLength() / 0x100000L >= (long)n ? "R" : "L";
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "L";
                }
            }
            downloadManagerState.setListAttribute("storetypes", stringArray);
        }
        return stringArray;
    }

    public static String getStorageType(DownloadManager downloadManager, int n) {
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        String string = downloadManagerState.getListAttribute("storetypes", n);
        if (string != null) {
            return string;
        }
        return DiskManagerImpl.getStorageTypes(downloadManager)[n];
    }

    public static void setFileLinks(DownloadManager downloadManager, CaseSensitiveFileMap caseSensitiveFileMap) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(downloadManager.getTorrent(), caseSensitiveFileMap);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    @Override
    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    @Override
    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    @Override
    public boolean isInteresting(int n) {
        return this.pieces[n].isInteresting();
    }

    @Override
    public boolean isDone(int n) {
        return this.pieces[n].isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("Disk Manager");
        try {
            indentWriter.indent();
            indentWriter.println("percent_done=" + this.percentDone + ",allocated=" + this.allocated + ",remaining=" + this.remaining);
            indentWriter.println("skipped_file_set_size=" + this.skipped_file_set_size + ",skipped_but_downloaded=" + this.skipped_but_downloaded);
            indentWriter.println("already_moved=" + this.alreadyMoved);
        }
        finally {
            indentWriter.exdent();
        }
    }

    static {
        int n = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int n2 = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int n3 = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int n4 = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create("core", n, n2, n3, n4);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + n + "/" + n2 + "/" + n3 + "/" + n4));
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable reorder storage mode", "Reorder storage mode min MB"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                reorder_storage_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                reorder_storage_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
            }
        });
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        start_pool = new ThreadPool("DiskManager:start", 64, true);
        start_pool.setThreadPriority(1);
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

            @Override
            public void dispatch(DiskManagerListener diskManagerListener, int n, Object object) {
                if (n == 1) {
                    int[] nArray = (int[])object;
                    diskManagerListener.stateChanged(nArray[0], nArray[1]);
                } else if (n == 2) {
                    diskManagerListener.filePriorityChanged((DiskManagerFileInfo)object);
                } else if (n == 3) {
                    diskManagerListener.pieceDoneChanged((DiskManagerPiece)object);
                } else if (n == 4) {
                    Object[] objectArray = (Object[])object;
                    diskManagerListener.fileAccessModeChanged((DiskManagerFileInfo)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2]);
                }
            }
        });
    }
}

