/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecemapper.impl;

import java.util.List;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.PieceMapEntryImpl;

public class PieceListImpl
implements DMPieceList {
    private final PieceMapEntryImpl[] pieces;
    private final int[] cumulativeLengths;

    public static PieceListImpl convert(List list) {
        return new PieceListImpl(list.toArray(new PieceMapEntryImpl[list.size()]));
    }

    protected PieceListImpl(PieceMapEntryImpl[] pieceMapEntryImplArray) {
        this.pieces = pieceMapEntryImplArray;
        this.cumulativeLengths = new int[this.pieces.length];
        this.initializeCumulativeLengths();
    }

    private void initializeCumulativeLengths() {
        int n = 0;
        for (int i = 0; i < this.pieces.length; ++i) {
            this.cumulativeLengths[i] = n += this.pieces[i].getLength();
        }
    }

    @Override
    public int size() {
        return this.pieces.length;
    }

    @Override
    public DMPieceMapEntry get(int n) {
        return this.pieces[n];
    }

    @Override
    public int getCumulativeLengthToPiece(int n) {
        return this.cumulativeLengths[n];
    }
}

