/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.IntegratedResourceBundle;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;

public class MessageText {
    public static final Locale LOCALE_ENGLISH = Constants.LOCALE_ENGLISH;
    public static final Locale LOCALE_DEFAULT;
    private static Locale LOCALE_CURRENT;
    private static final String BUNDLE_NAME = "org.gudy.azureus2.internat.MessagesBundle";
    private static Map pluginLocalizationPaths;
    private static Collection pluginResourceBundles;
    private static IntegratedResourceBundle RESOURCE_BUNDLE;
    private static Set platform_specific_keys;
    private static final Pattern PAT_PARAM_ALPHA;
    private static int bundle_fail_count;
    private static List listeners;
    private static IntegratedResourceBundle DEFAULT_BUNDLE;

    public static void loadBundle() {
        MessageText.loadBundle(false);
    }

    public static void loadBundle(boolean bl) {
        Locale locale = MessageText.getCurrentLocale();
        String string = COConfigurationManager.getStringParameter("locale");
        String[] stringArray = string.split("_", 3);
        Locale locale2 = stringArray.length > 0 && stringArray[0].length() == 2 ? (stringArray.length == 3 ? new Locale(stringArray[0], stringArray[1], stringArray[2]) : (stringArray.length == 2 && stringArray[1].length() == 2 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0]))) : (stringArray.length == 3 && stringArray[0].length() == 0 && stringArray[2].length() > 0 ? new Locale(stringArray[0], stringArray[1], stringArray[2]) : Locale.getDefault());
        MessageText.changeLocale(locale2, bl);
        COConfigurationManager.setParameter("locale.set.complete.count", COConfigurationManager.getIntParameter("locale.set.complete.count") + 1);
        Locale locale3 = MessageText.getCurrentLocale();
        if (!locale.equals(locale3) || bl) {
            for (int i = 0; i < listeners.size(); ++i) {
                try {
                    ((MessageTextListener)listeners.get(i)).localeChanged(locale, locale3);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public static void addListener(MessageTextListener messageTextListener) {
        listeners.add(messageTextListener);
    }

    public static void addAndFireListener(MessageTextListener messageTextListener) {
        listeners.add(messageTextListener);
        messageTextListener.localeChanged(MessageText.getCurrentLocale(), MessageText.getCurrentLocale());
    }

    public static void removeListener(MessageTextListener messageTextListener) {
        listeners.remove(messageTextListener);
    }

    static ResourceBundle getResourceBundle(String string, Locale locale, ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (Throwable throwable) {
            if (++bundle_fail_count == 1) {
                throwable.printStackTrace();
                Logger.log(new LogAlert(true, 3, "Failed to load resource bundle. One possible cause is that you have installed " + Constants.APP_NAME + " into a directory " + "with a '!' in it. If so, please remove the '!'."));
            }
            return new ResourceBundle(){

                @Override
                public Locale getLocale() {
                    return LOCALE_DEFAULT;
                }

                @Override
                protected Object handleGetObject(String string) {
                    return null;
                }

                public Enumeration getKeys() {
                    return new Vector().elements();
                }
            };
        }
    }

    private static void setResourceBundle(IntegratedResourceBundle integratedResourceBundle) {
        RESOURCE_BUNDLE = integratedResourceBundle;
        Iterator iterator = RESOURCE_BUNDLE.getKeysLight();
        String string = MessageText.getPlatformSuffix();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.endsWith(string)) continue;
            hashSet.add(string2);
        }
        platform_specific_keys = hashSet;
    }

    public static boolean keyExists(String string) {
        try {
            MessageText.getResourceBundleString(string);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public static boolean keyExistsForDefaultLocale(String string) {
        try {
            DEFAULT_BUNDLE.getString(string);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public static String getString(String string, String string2) {
        if (string == null) {
            return "";
        }
        String string3 = string + MessageText.getPlatformSuffix();
        if (!platform_specific_keys.contains(string3)) {
            string3 = string;
        }
        try {
            return MessageText.getResourceBundleString(string3);
        }
        catch (MissingResourceException missingResourceException) {
            return MessageText.getPlatformNeutralString(string, string2);
        }
    }

    public static String getString(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string + MessageText.getPlatformSuffix();
        if (!platform_specific_keys.contains(string2)) {
            string2 = string;
        }
        try {
            return MessageText.getResourceBundleString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return MessageText.getPlatformNeutralString(string);
        }
    }

    public static String getPlatformNeutralString(String string) {
        try {
            return MessageText.getResourceBundleString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (string.startsWith("!") && string.endsWith("!")) {
                return string.substring(1, string.length() - 1);
            }
            return '!' + string + '!';
        }
    }

    public static String getPlatformNeutralString(String string, String string2) {
        try {
            return MessageText.getResourceBundleString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private static String getResourceBundleString(String string) {
        if (string == null) {
            return "";
        }
        String string2 = RESOURCE_BUNDLE.getString(string);
        return MessageText.expandValue(string2);
    }

    public static String expandValue(String string) {
        if (string != null && string.indexOf(125) > 0) {
            Matcher matcher = PAT_PARAM_ALPHA.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(1);
                try {
                    String string3 = MessageText.getResourceBundleString(string2);
                    if (string3 == null) continue;
                    string = string.replaceAll("\\Q{" + string2 + "}\\E", string3);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        return string;
    }

    private static String getPlatformSuffix() {
        if (Constants.isOSX) {
            return "._mac";
        }
        if (Constants.isLinux) {
            return "._linux";
        }
        if (Constants.isUnix) {
            return "._unix";
        }
        if (Constants.isFreeBSD) {
            return "._freebsd";
        }
        if (Constants.isSolaris) {
            return "._solaris";
        }
        if (Constants.isWindows) {
            return "._windows";
        }
        return "._unknown";
    }

    public static String getStringForSentence(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(string2);
            string2 = " ";
            String string3 = stringTokenizer.nextToken();
            int n = string3.length();
            int n2 = string3.lastIndexOf(".");
            if (n2 == -1 || n2 + 1 == n) {
                stringBuffer.append(string3);
                continue;
            }
            String string4 = MessageText.getString(string3);
            if (string4.equals("!" + string3 + "!")) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public static String getString(String string, String[] stringArray) {
        String string2 = MessageText.getString(string);
        if (stringArray == null) {
            return string2;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = "%" + (i + 1);
            String string4 = stringArray[i];
            string2 = MessageText.replaceStrings(string2, string3, string4);
        }
        return string2;
    }

    protected static String replaceStrings(String string, String string2, String string3) {
        int n = 0;
        String string4 = "";
        while (n < string.length()) {
            int n2 = string.indexOf(string2, n);
            if (n2 == -1) {
                string4 = string4 + string.substring(n);
                break;
            }
            string4 = string4 + string.substring(n, n2) + string3;
            n = n2 + string2.length();
        }
        return string4;
    }

    public static String getDefaultLocaleString(String string) {
        try {
            return DEFAULT_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (string.startsWith("!") && string.endsWith("!")) {
                return string.substring(1, string.length() - 1);
            }
            return '!' + string + '!';
        }
    }

    public static Locale getCurrentLocale() {
        return LOCALE_DEFAULT.equals(LOCALE_CURRENT) ? LOCALE_ENGLISH : LOCALE_CURRENT;
    }

    public static boolean isCurrentLocale(Locale locale) {
        return LOCALE_ENGLISH.equals(locale) ? LOCALE_CURRENT.equals(LOCALE_DEFAULT) : LOCALE_CURRENT.equals(locale);
    }

    public static Locale[] getLocales(boolean bl) {
        Locale[] localeArray;
        String[] stringArray;
        Serializable serializable;
        String[] stringArray2;
        Object object;
        Serializable serializable2;
        String string = BUNDLE_NAME.replace('.', '/');
        final String string2 = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
        String string3 = MessageText.class.getClassLoader().getResource(string.concat(".properties")).toExternalForm();
        String[] stringArray3 = null;
        if (string3.startsWith("jar:file:")) {
            serializable2 = FileUtil.getJarFileFromURL(string3);
            if (serializable2 != null) {
                try {
                    object = new JarFile((File)serializable2);
                    stringArray2 = ((JarFile)object).entries();
                    serializable = new ArrayList(250);
                    while (stringArray2.hasMoreElements()) {
                        stringArray = (String[])stringArray2.nextElement();
                        if (!stringArray.getName().startsWith(string) || !stringArray.getName().endsWith(".properties")) continue;
                        ((ArrayList)serializable).add(stringArray.getName().substring(string.length() - string2.length()));
                    }
                    stringArray3 = ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
            }
        } else {
            serializable2 = new File(URI.create(string3)).getParentFile();
            stringArray3 = ((File)serializable2).list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.startsWith(string2) && string.endsWith(".properties");
                }
            });
        }
        serializable2 = new HashSet();
        object = new File(SystemProperties.getUserPath());
        stringArray2 = ((File)object).list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(string2) && string.endsWith(".properties");
            }
        });
        if (stringArray2 != null) {
            ((AbstractCollection)((Object)serializable2)).addAll(Arrays.asList(stringArray2));
        }
        if ((stringArray = ((File)(serializable = new File(SystemProperties.getApplicationPath()))).list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(string2) && string.endsWith(".properties");
            }
        })) != null) {
            ((AbstractCollection)((Object)serializable2)).addAll(Arrays.asList(stringArray));
        }
        ((AbstractCollection)((Object)serializable2)).addAll(Arrays.asList(stringArray3));
        ArrayList<Locale> arrayList = new ArrayList<Locale>(((HashSet)serializable2).size());
        arrayList.add(LOCALE_ENGLISH);
        Iterator iterator = ((HashSet)serializable2).iterator();
        while (iterator.hasNext()) {
            localeArray = (Locale[])iterator.next();
            if (string2.length() + 1 >= localeArray.length() - ".properties".length()) continue;
            String string4 = localeArray.substring(string2.length() + 1, localeArray.length() - ".properties".length());
            String[] stringArray4 = string4.split("_", 3);
            if (stringArray4.length > 0 && stringArray4[0].length() == 2) {
                if (stringArray4.length == 3) {
                    arrayList.add(new Locale(stringArray4[0], stringArray4[1], stringArray4[2]));
                    continue;
                }
                if (stringArray4.length == 2 && stringArray4[1].length() == 2) {
                    arrayList.add(new Locale(stringArray4[0], stringArray4[1]));
                    continue;
                }
                arrayList.add(new Locale(stringArray4[0]));
                continue;
            }
            if (stringArray4.length != 3 || stringArray4[0].length() != 0 || stringArray4[2].length() <= 0) continue;
            arrayList.add(new Locale(stringArray4[0], stringArray4[1], stringArray4[2]));
        }
        localeArray = new Locale[arrayList.size()];
        arrayList.toArray(localeArray);
        if (bl) {
            try {
                Arrays.sort(localeArray, new Comparator(){

                    public final int compare(Object object, Object object2) {
                        return ((Locale)object).getDisplayName((Locale)object).compareToIgnoreCase(((Locale)object2).getDisplayName((Locale)object2));
                    }
                });
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return localeArray;
    }

    public static boolean changeLocale(Locale locale) {
        return MessageText.changeLocale(locale, false);
    }

    private static boolean changeLocale(Locale locale, boolean bl) {
        Locale.setDefault(locale);
        if (!MessageText.isCurrentLocale(locale) || bl) {
            Object object;
            ResourceBundle resourceBundle;
            block12: {
                Locale.setDefault(LOCALE_DEFAULT);
                resourceBundle = null;
                String string = BUNDLE_NAME.replace('.', '/');
                String string2 = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
                if (locale.equals(LOCALE_ENGLISH)) {
                    locale = LOCALE_DEFAULT;
                }
                try {
                    object = new File(SystemProperties.getUserPath());
                    File file = new File(SystemProperties.getApplicationPath());
                    ClassLoader classLoader = MessageText.class.getClassLoader();
                    URL uRL = classLoader.getResource(string + ".properties");
                    if (uRL == null) {
                        return false;
                    }
                    String string3 = uRL.toString();
                    string3 = string3.substring(0, string3.length() - string2.length() - ".properties".length());
                    URL uRL2 = new URL(string3);
                    URL[] uRLArray = new URL[]{((File)object).toURL(), file.toURL(), uRL2};
                    resourceBundle = MessageText.getResourceBundle("MessagesBundle", locale, new URLClassLoader(uRLArray));
                    if (resourceBundle.getLocale().getLanguage().equals(locale.getLanguage()) || locale.getCountry().equals("")) break block12;
                    Locale locale2 = resourceBundle.getLocale();
                    System.out.println("changeLocale: " + (locale2.toString().equals("") ? "*Default Language*" : locale2.getDisplayLanguage()) + " != " + locale.getDisplayName() + ". Searching without country..");
                    Locale locale3 = new Locale(locale.getLanguage());
                    resourceBundle = MessageText.getResourceBundle("MessagesBundle", locale3, new URLClassLoader(uRLArray));
                    if (resourceBundle != null && resourceBundle.getLocale().getLanguage().equals(locale3.getLanguage())) break block12;
                    System.out.println("changeLocale: Searching for language " + locale.getDisplayLanguage() + " in *any* country..");
                    Locale[] localeArray = MessageText.getLocales(false);
                    for (int i = 0; i < localeArray.length; ++i) {
                        if (localeArray[i].getLanguage() != locale.getLanguage()) continue;
                        resourceBundle = MessageText.getResourceBundle("MessagesBundle", localeArray[i], new URLClassLoader(uRLArray));
                        break;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    System.out.println("changeLocale: no resource bundle for " + locale);
                    Debug.printStackTrace(missingResourceException);
                    return false;
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
            }
            if (resourceBundle != null) {
                if (!locale.equals(LOCALE_DEFAULT) && !resourceBundle.getLocale().equals(locale)) {
                    object = resourceBundle.getLocale().getDisplayName();
                    if (object == null || ((String)object).trim().equals("")) {
                        object = "English (default)";
                    }
                    System.out.println("changeLocale: no message properties for Locale '" + locale.getDisplayName() + "' (" + locale + "), using '" + (String)object + "'");
                    if (resourceBundle.getLocale().equals(RESOURCE_BUNDLE.getLocale())) {
                        return false;
                    }
                }
                Locale.setDefault((locale = resourceBundle.getLocale()).equals(LOCALE_DEFAULT) ? LOCALE_ENGLISH : locale);
                LOCALE_CURRENT = locale;
                MessageText.setResourceBundle(new IntegratedResourceBundle(resourceBundle, pluginLocalizationPaths, 3200));
                if (locale.equals(LOCALE_DEFAULT)) {
                    DEFAULT_BUNDLE = RESOURCE_BUNDLE;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean integratePluginMessages(String string, ClassLoader classLoader) {
        boolean bl = false;
        if (string != null && string.length() != 0) {
            Map map = pluginLocalizationPaths;
            synchronized (map) {
                pluginLocalizationPaths.put(string, classLoader);
            }
            RESOURCE_BUNDLE.addPluginBundle(string, classLoader);
            MessageText.setResourceBundle(RESOURCE_BUNDLE);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean integratePluginMessages(ResourceBundle resourceBundle) {
        Collection collection = pluginResourceBundles;
        synchronized (collection) {
            pluginResourceBundles.add(resourceBundle);
        }
        RESOURCE_BUNDLE.addResourceMessages(resourceBundle);
        MessageText.setResourceBundle(RESOURCE_BUNDLE);
        return true;
    }

    public static String resolveLocalizationKey(String string) {
        if (null == string) {
            return null;
        }
        if ("az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"))) {
            String string2 = null;
            string2 = false == string.startsWith("v3.") ? "v3." + string : string;
            if (MessageText.keyExists(string2)) {
                return string2;
            }
        }
        return string;
    }

    public static String resolveAcceleratorKey(String string) {
        if (null == string) {
            return null;
        }
        if ("az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"))) {
            String string2 = null;
            string2 = false == string.startsWith("v3.") ? "v3." + string : string;
            if (MessageText.keyExists(string2 + ".keybinding")) {
                return string2;
            }
        }
        return string;
    }

    static {
        LOCALE_CURRENT = LOCALE_DEFAULT = new Locale("", "");
        pluginLocalizationPaths = new HashMap();
        pluginResourceBundles = new ArrayList();
        platform_specific_keys = new HashSet();
        PAT_PARAM_ALPHA = Pattern.compile("\\{([^0-9].+?)\\}");
        bundle_fail_count = 0;
        listeners = new ArrayList();
        MessageText.setResourceBundle(new IntegratedResourceBundle(MessageText.getResourceBundle(BUNDLE_NAME, LOCALE_DEFAULT, MessageText.class.getClassLoader()), pluginLocalizationPaths, 4000));
        DEFAULT_BUNDLE = RESOURCE_BUNDLE;
    }

    public static interface MessageTextListener {
        public void localeChanged(Locale var1, Locale var2);
    }
}

