/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.impl;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.StatsWriterPeriodic;
import org.gudy.azureus2.core3.stats.impl.StatsWriterImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class StatsWriterPeriodicImpl
implements StatsWriterPeriodic,
COConfigurationListener,
TimerEventPerformer {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static StatsWriterPeriodicImpl singleton;
    private boolean started;
    private long last_write_time = 0L;
    private AzureusCore core;
    private TimerEventPeriodic event;
    private boolean config_enabled;
    private int config_period;
    private String config_dir;
    private String config_file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized StatsWriterPeriodic create(AzureusCore azureusCore) {
        Class<StatsWriterPeriodicImpl> clazz = StatsWriterPeriodicImpl.class;
        synchronized (StatsWriterPeriodicImpl.class) {
            if (singleton == null) {
                singleton = new StatsWriterPeriodicImpl(azureusCore);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    protected StatsWriterPeriodicImpl(AzureusCore azureusCore) {
        this.core = azureusCore;
    }

    @Override
    public void perform(TimerEvent timerEvent2) {
        this.update();
    }

    protected void update() {
        try {
            this.writeStats();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected synchronized void readConfigValues() {
        this.config_enabled = COConfigurationManager.getBooleanParameter("Stats Enable");
        this.config_period = COConfigurationManager.getIntParameter("Stats Period");
        this.config_dir = COConfigurationManager.getStringParameter("Stats Dir");
        this.config_file = COConfigurationManager.getStringParameter("Stats File");
        if (this.config_enabled) {
            long l = 1000 * (this.config_period < 30000 ? this.config_period : 30000);
            if (this.event != null && this.event.getFrequency() != l) {
                this.event.cancel();
                this.event = null;
            }
            if (this.event == null) {
                this.event = SimpleTimer.addPeriodicEvent("StatsWriter", l, this);
            }
        } else if (this.event != null) {
            this.event.cancel();
            this.event = null;
        }
    }

    protected void writeStats() {
        if (!this.config_enabled) {
            return;
        }
        int n = this.config_period;
        long l = SystemTime.getMonotonousTime() / 1000L;
        if (l - this.last_write_time < (long)(n - 1)) {
            return;
        }
        this.last_write_time = l;
        try {
            String string;
            String string2;
            String string3 = this.config_dir;
            string3 = string3.trim();
            if (string3.length() == 0) {
                string3 = File.separator;
            }
            if (!(string2 = string3).endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if ((string = this.config_file).trim().length() == 0) {
                string = "Azureus_Stats.xml";
            }
            string2 = string2 + string;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stats Logged to '" + string2 + "'"));
            }
            new StatsWriterImpl(this.core).write(string2);
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LOGID, "Stats Logging fails", throwable));
        }
    }

    @Override
    public void configurationSaved() {
        this.readConfigValues();
        this.writeStats();
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        COConfigurationManager.addListener(this);
        this.configurationSaved();
    }

    @Override
    public void stop() {
        COConfigurationManager.removeListener(this);
        if (this.event != null) {
            this.event.cancel();
        }
    }
}

