/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;

public class TRTrackerServerTorrentStatsImpl
implements TRTrackerServerTorrentStats {
    private TRTrackerServerTorrentImpl torrent;
    private long announce_count;
    private long scrape_count;
    private long completed_count;
    private long uploaded;
    private long downloaded;
    private long left;
    private long biased_uploaded;
    private long biased_downloaded;
    private long bytes_in;
    private long bytes_out;

    protected TRTrackerServerTorrentStatsImpl(TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl) {
        this.torrent = tRTrackerServerTorrentImpl;
    }

    protected void addAnnounce(long l, long l2, long l3, boolean bl) {
        ++this.announce_count;
        this.uploaded += l < 0L ? 0L : l;
        this.downloaded += l2 < 0L ? 0L : l2;
        this.left += l3;
        if (this.left < 0L) {
            this.left = 0L;
        }
        if (bl) {
            this.biased_uploaded += l < 0L ? 0L : l;
            this.biased_downloaded += l2 < 0L ? 0L : l2;
        }
    }

    protected void removeLeft(long l) {
        this.left -= l;
        if (this.left < 0L) {
            this.left = 0L;
        }
    }

    @Override
    public long getAnnounceCount() {
        return this.announce_count;
    }

    protected void addScrape() {
        ++this.scrape_count;
    }

    @Override
    public long getScrapeCount() {
        return this.scrape_count;
    }

    protected void addCompleted() {
        ++this.completed_count;
    }

    @Override
    public long getCompletedCount() {
        return this.completed_count;
    }

    @Override
    public long getUploaded() {
        return this.uploaded;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getBiasedUploaded() {
        return this.biased_uploaded;
    }

    @Override
    public long getBiasedDownloaded() {
        return this.biased_downloaded;
    }

    @Override
    public long getAmountLeft() {
        return this.left;
    }

    protected void addXferStats(int n, int n2) {
        this.bytes_in += (long)n;
        this.bytes_out += (long)n2;
    }

    @Override
    public long getBytesIn() {
        return this.bytes_in;
    }

    @Override
    public long getBytesOut() {
        return this.bytes_out;
    }

    @Override
    public int getSeedCount() {
        return this.torrent.getSeedCount();
    }

    @Override
    public int getLeecherCount() {
        return this.torrent.getLeecherCount();
    }

    @Override
    public int getQueuedCount() {
        return this.torrent.getQueuedCount();
    }

    @Override
    public int getBadNATPeerCount() {
        return this.torrent.getBadNATPeerCount();
    }

    @Override
    public String getString() {
        return "an=" + this.announce_count + ",sc=" + this.scrape_count + ",co=" + this.completed_count + ",le=" + this.getLeecherCount() + ",se=" + this.getSeedCount() + ",q=" + this.getQueuedCount() + ",bi=" + this.bytes_in + ",bo=" + this.bytes_out;
    }
}

