/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.AEThreadMonitor;
import com.aelitis.azureus.core.util.Java15Utils;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class AEDiagnostics {
    public static final boolean ALWAYS_PASS_HASH_CHECKS = false;
    public static final boolean USE_DUMMY_FILE_DATA = false;
    public static final boolean CHECK_DUMMY_FILE_DATA = false;
    public static final boolean DEBUG_MONITOR_SEM_USAGE = false;
    public static final boolean DEBUG_THREADS = true;
    public static final boolean TRACE_DIRECT_BYTE_BUFFERS = false;
    public static final boolean TRACE_DBB_POOL_USAGE = false;
    public static final boolean PRINT_DBB_POOL_USAGE = false;
    public static final boolean TRACE_TCP_TRANSPORT_STATS = false;
    public static final boolean TRACE_CONNECTION_DROPS = false;
    private static final int MAX_FILE_SIZE;
    private static final String CONFIG_KEY = "diagnostics.tidy_close";
    private static File debug_dir;
    private static File debug_save_dir;
    private static boolean started_up;
    private static boolean startup_complete;
    private static boolean enable_pending_writes;
    private static Map<String, AEDiagnosticsLogger> loggers;
    protected static boolean logging_enabled;
    protected static boolean loggers_enabled;
    private static List<AEDiagnosticsEvidenceGenerator> evidence_generators;
    private static final String[][] bad_dlls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startup(boolean bl) {
        if (started_up) {
            return;
        }
        started_up = true;
        enable_pending_writes = bl;
        try {
            boolean bl2 = System.getProperty("transitory.startup", "0").equals("1");
            if (bl2) {
                loggers_enabled = false;
                return;
            }
            debug_dir = FileUtil.getUserFile("logs");
            debug_save_dir = new File(debug_dir, "save");
            COConfigurationManager.addAndFireParameterListeners(new String[]{"Logger.Enabled", "Logger.DebugFiles.Enabled"}, new ParameterListener(){

                @Override
                public void parameterChanged(String string) {
                    logging_enabled = COConfigurationManager.getBooleanParameter("Logger.Enabled");
                    boolean bl = loggers_enabled = logging_enabled && COConfigurationManager.getBooleanParameter("Logger.DebugFiles.Enabled");
                    if (!loggers_enabled) {
                        loggers_enabled = Constants.IS_CVS_VERSION || COConfigurationManager.getBooleanParameter("Logger.DebugFiles.Enabled.Force");
                    }
                }
            });
            boolean bl3 = COConfigurationManager.getBooleanParameter(CONFIG_KEY);
            new AEThread2("asyncify", true){

                @Override
                public void run() {
                    SimpleTimer.addEvent("AEDiagnostics:logCleaner", SystemTime.getCurrentTime() + 60000L + (long)((int)(Math.random() * 15000.0)), new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent timerEvent2) {
                            AEDiagnostics.cleanOldLogs();
                        }
                    });
                }
            }.start();
            if (debug_dir.exists()) {
                long l = SystemTime.getCurrentTime();
                File[] fileArray = debug_dir.listFiles();
                if (fileArray != null) {
                    boolean bl4 = false;
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        if (file.isDirectory() || bl3) continue;
                        if (!bl4) {
                            debug_save_dir.mkdir();
                        }
                        bl4 = true;
                        FileUtil.copyFile(file, new File(debug_save_dir, l + "_" + file.getName()));
                    }
                    if (bl4) {
                        Logger.logTextResource(new LogAlert(false, 1, "diagnostics.log_found"), new String[]{debug_save_dir.toString()});
                    }
                }
            } else {
                debug_dir.mkdir();
            }
            AEThreadMonitor.initialise();
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof NoClassDefFoundError)) {
                Debug.printStackTrace(throwable);
            }
        }
        finally {
            startup_complete = true;
        }
    }

    public static void dumpThreads() {
        Java15Utils.dumpThreads();
    }

    protected static void cleanOldLogs() {
        try {
            long l = SystemTime.getCurrentTime();
            File[] fileArray = debug_save_dir.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    long l2;
                    File file = fileArray[i];
                    if (file.isDirectory() || l - (l2 = file.lastModified()) <= 864000000L) continue;
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isStartupComplete() {
        return startup_complete;
    }

    public static File getLogDir() {
        AEDiagnostics.startup(false);
        return debug_dir;
    }

    public static synchronized void flushPendingLogs() {
        for (AEDiagnosticsLogger aEDiagnosticsLogger : loggers.values()) {
            aEDiagnosticsLogger.writePending();
        }
        enable_pending_writes = false;
    }

    public static synchronized AEDiagnosticsLogger getLogger(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = loggers.get(string);
        if (aEDiagnosticsLogger == null) {
            AEDiagnostics.startup(false);
            aEDiagnosticsLogger = new AEDiagnosticsLogger(debug_dir, string, MAX_FILE_SIZE, !enable_pending_writes);
            loggers.put(string, aEDiagnosticsLogger);
        }
        return aEDiagnosticsLogger;
    }

    public static void logWithStack(String string, String string2) {
        AEDiagnostics.log(string, string2 + ": " + Debug.getCompressedStackTrace());
    }

    public static void log(String string, String string2) {
        AEDiagnostics.getLogger(string).log(string2);
    }

    public static void markDirty() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, false);
            COConfigurationManager.save();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public static boolean isDirty() {
        return !COConfigurationManager.getBooleanParameter(CONFIG_KEY);
    }

    public static void markClean() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, true);
            COConfigurationManager.save();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public static void checkDumpsAndNatives() {
        try {
            File file;
            Object object;
            Object object2;
            PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
            if (platformManager.getPlatformType() == 1 && platformManager.hasCapability(PlatformManagerCapabilities.TestNativeAvailability)) {
                for (int i = 0; i < bad_dlls.length; ++i) {
                    object2 = bad_dlls[i][0];
                    object = bad_dlls[i][1];
                    if (((String)object).equalsIgnoreCase("n") || COConfigurationManager.getBooleanParameter("platform.win32.dll_found." + (String)object2, false)) continue;
                    try {
                        if (!platformManager.testNativeAvailability((String)object2 + ".dll")) continue;
                        COConfigurationManager.setParameter("platform.win32.dll_found." + (String)object2, true);
                        String string = MessageText.getString("platform.win32.baddll." + (String)object2);
                        Logger.logTextResource(new LogAlert(true, 1, "platform.win32.baddll.info"), new String[]{(String)object2 + ".dll", string});
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            if ((file = new File(SystemProperties.getApplicationPath())).canRead()) {
                long l;
                object2 = file.listFiles();
                object = null;
                long l2 = 0L;
                long l3 = SystemTime.getCurrentTime();
                long l4 = l3 - 604800000L;
                for (int i = 0; i < ((File[])object2).length; ++i) {
                    long l5;
                    File file2 = object2[i];
                    String string = file2.getName();
                    if (!string.startsWith("hs_err_pid") || (l5 = file2.lastModified()) <= l2 || l5 <= l4) continue;
                    object = file2;
                    l2 = l5;
                }
                if (object != null && (l = COConfigurationManager.getLongParameter("diagnostics.dump.lasttime", 0L)) < l2) {
                    COConfigurationManager.setParameter("diagnostics.dump.lasttime", l2);
                    AEDiagnostics.analyseDump((File)object);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void analyseDump(File file) {
        System.out.println("Analysing " + file);
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            try {
                String string;
                String string2;
                Object object;
                boolean bl = false;
                String[] stringArray = new String[bad_dlls.length];
                for (int i = 0; i < bad_dlls.length; ++i) {
                    object = bad_dlls[i][0];
                    stringArray[i] = ((String)object + ".dll").toUpperCase();
                }
                String string3 = "AxShlex";
                object = new ArrayList();
                while ((string2 = lineNumberReader.readLine()) != null) {
                    if ((string2 = string2.toUpperCase()).indexOf("EXCEPTION_FLT") != -1) {
                        bl = true;
                        continue;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = stringArray[i];
                        if (string2.indexOf(string) == -1) continue;
                        String string4 = bad_dlls[i][0];
                        if (string4.equals(string3)) {
                            if (!bl) continue;
                            object.add(string4);
                            continue;
                        }
                        object.add(string4);
                    }
                }
                for (int i = 0; i < object.size(); ++i) {
                    String string5 = (String)object.get(i);
                    string = MessageText.getString("platform.win32.baddll." + string5);
                    Logger.logTextResource(new LogAlert(true, 1, "platform.win32.baddll.info"), new String[]{string5 + ".dll", string});
                }
            }
            finally {
                lineNumberReader.close();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvidenceGenerator(AEDiagnosticsEvidenceGenerator aEDiagnosticsEvidenceGenerator) {
        List<AEDiagnosticsEvidenceGenerator> list = evidence_generators;
        synchronized (list) {
            evidence_generators.add(aEDiagnosticsEvidenceGenerator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateEvidence(PrintWriter printWriter) {
        IndentWriter indentWriter = new IndentWriter(printWriter);
        Object object = evidence_generators;
        synchronized (object) {
            for (int i = 0; i < evidence_generators.size(); ++i) {
                try {
                    evidence_generators.get(i).generate(indentWriter);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(printWriter);
                }
            }
        }
        indentWriter.println("Memory");
        try {
            indentWriter.indent();
            object = Runtime.getRuntime();
            indentWriter.println("max=" + ((Runtime)object).maxMemory() + ",total=" + ((Runtime)object).totalMemory() + ",free=" + ((Runtime)object).freeMemory());
        }
        finally {
            indentWriter.exdent();
        }
    }

    static {
        int n = 262144;
        try {
            String string = System.getProperty("diag.logsize", null);
            if (string != null) {
                n = string.toLowerCase().endsWith("m") ? Integer.parseInt(string.substring(0, string.length() - 1)) * 1024 * 1024 : Integer.parseInt(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MAX_FILE_SIZE = n;
        loggers = new HashMap<String, AEDiagnosticsLogger>();
        evidence_generators = new ArrayList<AEDiagnosticsEvidenceGenerator>();
        bad_dlls = new String[][]{{"niphk", "y"}, {"nvappfilter", "y"}, {"netdog", "y"}, {"vlsp", "y"}, {"imon", "y"}, {"sarah", "y"}, {"MxAVLsp", "y"}, {"mclsp", "y"}, {"radhslib", "y"}, {"winsflt", "y"}, {"nl_lsp", "y"}, {"AxShlex", "y"}, {"iFW_Xfilter", "y"}, {"gapsp", "y"}, {"WSOCKHK", "n"}};
    }
}

